# gnuplot file, template generated automatically with
# /Users/gsalam/scripts/gptemplate.py lumis.gp

set term pdfcairo enhanced font 'Helvetica,12' lw 1.5 size 8cm,8cm
set lt 1 pt 4 ps 0.6 lw 1.5 lc rgb '#f00000'
set lt 2 pt 5 ps 0.6 lw 1.5 lc rgb '#00c000'
set lt 3 pt 6 ps 0.6 lw 1.5 lc rgb '#0000e0'
set lt 4 pt 7 ps 0.6 lw 1.5 lc rgb '#ff8000'
set lt 5 pt 8 ps 0.6 lw 1.5 lc rgb '#5070ff'
set lt 11 pt 4 ps 0.6 lw 1.5 lc rgb '#50f00000'
set lt 12 pt 5 ps 0.6 lw 1.5 lc rgb '#5000c000'
set lt 13 pt 6 ps 0.6 lw 1.5 lc rgb '#500000e0'
set lt 14 pt 7 ps 0.6 lw 1.5 lc rgb '#50ff8000'
set lt 15 pt 8 ps 0.6 lw 1.5 lc rgb '#505070ff'
set key spacing 1.3 width -4
set macros
set output 'lumis-LUX17.pdf'


pdf='LUXqed17_plus_PDF4LHC15_nnlo_100'
pdfdisplay='{/*0.7 LUXqed17\_plus\_PDF4LHC15\_nnlo\_100}'
file(rtsTeV,chan)=sprintf("lumis/lumi-LUXqed17_plus_PDF4LHC15_nnlo_100-rts%d-%s.dat",rtsTeV*1.0,chan)

band='u ($1/1000.0):($2-$3):($2+$3)'
line='u ($1/1000.0):($2)'

band1e2='u ($1/1000.0):(1e2*($2-$3)):(1e2*($2+$3))'
line1e2='u ($1/1000.0):(1e2*$2)'

band1e3='u ($1/1000.0):(1e3*($2-$3)):(1e3*($2+$3))'
line1e3='u ($1/1000.0):(1e3*$2)'

band1e4='u ($1/1000.0):(1e4*($2-$3)):(1e4*($2+$3))'
line1e4='u ($1/1000.0):(1e4*$2)'

relband='u ($1/1000.0):(-$3/$2):(+$3/$2)'
relline='u ($1/1000.0):(0)'
rellnhi='u ($1/1000.0):(-$3/$2)'
rellnlo='u ($1/1000.0):(+$3/$2)'
qqbr='Σ_i q_i ^{/*1.5 @–}q_i

set grid lt 1 lc rgb '#e0000000' lw 0.5

do for [rts in "13000 28000 100000"] {
#rts=13000
set origin 0,0
set size 1,1
set yrange [3e-6:1e3*rts/13000]
set log

set ylabel 'partonic luminosity' offset -1

set xlabel 'm [TeV]'
set xtics add (0.2, 0.5, 2, 5, 20, 50)
set format y '10^{%T}'
set ytics 10
set ytics add ('0.1' 0.1, '1' 1, '10' 10)

set lmargin at screen 0.18

set xrange [0.1:rts*0.5/1000]
set label 1 sprintf('√s = %.0f TeV', rts*1.0/1000) at graph 0.06,0.13
set label 2 pdfdisplay at graph 0.06,0.07
plot file(rts,'g1xg2') @band w filledcurves lt 12 t 'gg', '' @line w l lt 2 t '',\
     file(rts,'qqbar') @band w filledcurves lt 13 t qqbr,  '' @line w l lt 3 t '',\
     file(rts,'y1xy2') @band1e2 w filledcurves lt 11 t '10^2 × γγ', '' @line1e2 w l lt 1 t ''



#     file(rts,'y1xy2') @band w filledcurves lt 11 t 'γγ', '' @line w l lt 1 t '',\


     
set multiplot
set origin 0.0,0.4; set size 1.0,0.6
set bmargin 0
set xtics tc rgb '#ff000000'
set xlabel tc rgb '#ff000000'
replot

# now the relative bands
set bmargin -1
set origin 0.0,0.0; set size 1.0,0.4
set format y '%g'
unset log y
set ytics 0.05
set mytics 2
set xtics  tc rgb '#00000000'
set xlabel tc rgb '#00000000'
set ylabel 'rel. uncertainty' offset 1
unset label 1
unset label 2
set yrange [-0.12:0.12]

plot file(rts,'g1xg2') @relband w filledcurves lt 12 t '', '' @relline w l lt 2 t '',\
     file(rts,'qqbar') @relband w filledcurves lt 13 t '', '' @relline w l lt 3 t '',\
     file(rts,'y1xy2') @relband w filledcurves lt 11 t '', '' @relline w l lt 1 t '',\
     file(rts,'g1xg2') @rellnhi w l lt 12 lw 1.0 t '', '' @rellnlo w l lt 12 lw 1.0 t '',\
     file(rts,'qqbar') @rellnhi w l lt 13 lw 1.0 t '', '' @rellnlo w l lt 13 lw 1.0 t '',\
     file(rts,'y1xy2') @rellnhi w l lt 11 lw 1.0 t '', '' @rellnlo w l lt 11 lw 1.0 t '',\

     
unset multiplot     

}
set output

