#!/bin/bash
# run this from top-level directory (main-code) directory

outdir=figs-LUXqed17/contribution-breakdown

# --read-x-values ../Paolo/xvalues-ymax14-dy01.dat
# --1mx-stretch 5 --dy 0.2 -n 95
exec="sem -j4 ./main_gaussian"
xValues="--1mx-stretch 5 --dy 0.2 -n 95"
commonOpts=" --pdf PDF4LHC15_nnlo_100 --imem 0 $xValues --inelastic-param LHAPDF_Hermes_ALLM_CLAS --rescale-R-twist4 0 --rescale-R 1 --LHAPDF-transition-Q2 9 --elastic-param A1_world_pol_spline --msbar_via_hoppet_new"


for Q2 in 10000 250000
do

    # $exec --mu2_true $Q2 --out $outdir/out-$Q2-1.dat $commonOpts \
    #       --Q2min-inel-override 0 --Q2max-inel-override 1e300 \
    #       --elastic-electric-rescale 1 --elastic-magnetic-rescale 0 \
    #       --rescale-resonance 0 --rescale-non-resonance 0
    # 
    # $exec --mu2_true $Q2 --out $outdir/out-$Q2-2.dat $commonOpts \
    #       --Q2min-inel-override 0 --Q2max-inel-override 1e300 \
    #       --elastic-electric-rescale 1 --elastic-magnetic-rescale 1 \
    #       --rescale-resonance 0 --rescale-non-resonance 0
    # 
    # $exec --mu2_true $Q2 --out $outdir/out-$Q2-3.dat $commonOpts \
    #       --Q2min-inel-override 0 --Q2max-inel-override 1e300 \
    #       --elastic-electric-rescale 1 --elastic-magnetic-rescale 1 \
    #       --rescale-resonance 1 --rescale-non-resonance 0
    # 
    # $exec --mu2_true $Q2 --out $outdir/out-$Q2-4.dat $commonOpts \
    #       --Q2min-inel-override 0 --Q2max-inel-override 9.0 \
    #       --elastic-electric-rescale 1 --elastic-magnetic-rescale 1 \
    #       --rescale-resonance 1 --rescale-non-resonance 1
    # 
    # $exec --mu2_true $Q2 --out $outdir/out-$Q2-5.dat $commonOpts \
    #       --Q2min-inel-override 0 --Q2max-inel-override 1e300 \
    #       --elastic-electric-rescale 1 --elastic-magnetic-rescale 1 \
    #       --rescale-resonance 1 --rescale-non-resonance 1
    # 
    # $exec --mu2_true $Q2 --out $outdir/out-$Q2-6.dat $commonOpts \
    #       --Q2min-inel-override 0 --Q2max-inel-override 1.0 \
    #       --elastic-electric-rescale 1 --elastic-magnetic-rescale 1 \
    #       --rescale-resonance 1 --rescale-non-resonance 1
    
    for mult in 0.25 4.0
    do            
        mu2M=`python -c 'print int('$Q2'*'$mult')'`
        
        $exec --mu2_true $Q2 --mu2_M $mu2M  --out $outdir/out-$Q2-full-mu2M$mu2M.dat $commonOpts \
              --Q2min-inel-override 0 --Q2max-inel-override 1e300 \
              --elastic-electric-rescale 1 --elastic-magnetic-rescale 1 \
              --rescale-resonance 1 --rescale-non-resonance 1
    done

done
