# gnuplot file

set term pdfcairo enhanced color size 7cm,4.5cm font 'Helvetica,9'

set output "LUXqed17-uncert-bands.pdf"

#set log x

load 'xaxis.gp'
#zeta_of_x(x)=x
#set log x

set yrange [0:0.05]
set ytics 0.01

#set ytics ("0.95" 0.95 0,"0.97" 0.97 0, "0.99" 0.99 0,"0" 1 0,"0.01" 1.01 0,"0.02" 1.02 0,"0.03" 1.03 0, "0.04" 1.04 0, "0.05" 1.05 0)

set label  1 '{/:Bold PDF}' at graph 0.1,0.15 front textcolor rgb "#ffffff"
set label  2 '{/:Bold HO}' at graph 0.23,0.20 front textcolor rgb "#ffffff"
set label  3 '{/:Bold R}' at graph 0.6,0.34 front textcolor rgb "#ffffff"
set label  4 '{/:Bold E}' at graph 0.82,0.25 front textcolor rgb "#ffffff"
set label  5 '{/:Bold RES}' at graph 0.925,0.5 front textcolor rgb "#ffffff"
set label  6 '{/:Bold T}' at graph 0.94,0.02 front textcolor rgb "#ffffff"
set label  7 '{/:Bold M}' at graph 0.83,0.04 front textcolor rgb "#ffffff"
set label 100 'LUXqed17, {/Symbol m} = 100 GeV' at graph 0.22,0.45

set key at graph 0.67,0.98

set grid noxtics noytics front
set ylabel '{/Symbol d} f_{{/Symbol g}/p} / f_{{/Symbol g}/p}'

transform="| ../scripts/monotonic-x.py | sed 's/# Columns://'"
file='< cat LUXqed17-uncert-bands.dat '.transform

#print file
#exit
# order in file must be maintained...
# '+T +M +RES +EFT +EUN +PDF +HO +R'


plot file u (zeta_of_x($1)):(column('+R'  )/$2):(column('+HO' )/$2) w filledcurves fc rgb "orange"  t 'uncertainties on R (R)',\
     ''   u (zeta_of_x($1)):(column('+HO' )/$2):(column('+PDF')/$2) w filledcurves fc rgb "#008800" t 'higher orders (HO)',\
     ''   u (zeta_of_x($1)):(column('+PDF')/$2):(column('+EUN')/$2) w filledcurves fc rgb "#b0b0b0" t 'pdf errors (PDF)',\
     ''   u (zeta_of_x($1)):(column('+EUN')/$2):(column('+RES')/$2) w filledcurves fc rgb "#ff0000" t 'error on elastic component (E)',\
     ''   u (zeta_of_x($1)):(column('+RES')/$2):(column('+M'  )/$2) w filledcurves fc rgb "#00c0d0" t 'error on resonance region (RES)',\
     ''   u (zeta_of_x($1)):(column('+M'  )/$2):(column('+T'  )/$2) w filledcurves fc rgb "#aa0000" t 'matching PDF and fits (M)',\
     ''   u (zeta_of_x($1)):(column('+T'  )/$2):(             0/$2) w filledcurves fc rgb "#bbbb00" t 'twist 4 correction to R in PDF (T)',\
     ''   u (zeta_of_x($1)):(column('total')/$2) w l lw 3 lc rgb '#000000' t 'sum in quadrature'

# this one shows the split of the two classes of elastic error
set label  4 '{/:Bold EUN}'  at graph 0.75,0.34 front textcolor rgb "#ffffff"
set label 14 '{/:Bold EFIT}' at graph 0.80,0.25 front textcolor rgb "#ffffff"
plot file u (zeta_of_x($1)):(column('+R'  )/$2):(column('+HO' )/$2) w filledcurves fc rgb "orange"  t 'uncertainties on R (R)',\
     ''   u (zeta_of_x($1)):(column('+HO' )/$2):(column('+PDF')/$2) w filledcurves fc rgb "#008800" t 'higher orders (HO)',\
     ''   u (zeta_of_x($1)):(column('+PDF')/$2):(column('+EUN')/$2) w filledcurves fc rgb "#b0b0b0" t 'pdf errors (PDF)',\
     ''   u (zeta_of_x($1)):(column('+EUN')/$2):(column('+EFT')/$2) w filledcurves fc rgb "#d00000" t 'elastic unpolarised fit (EUN)',\
     ''   u (zeta_of_x($1)):(column('+EFT')/$2):(column('+RES')/$2) w filledcurves fc rgb "#ff4040" t 'error on elastic fit (EFIT)',\
     ''   u (zeta_of_x($1)):(column('+RES')/$2):(column('+M'  )/$2) w filledcurves fc rgb "#00c0d0" t 'error on resonance region (RES)',\
     ''   u (zeta_of_x($1)):(column('+M'  )/$2):(column('+T'  )/$2) w filledcurves fc rgb "#aa0000" t 'matching PDF and fits (M)',\
     ''   u (zeta_of_x($1)):(column('+T'  )/$2):(             0/$2) w filledcurves fc rgb "#bbbb00" t 'twist 4 correction to R in PDF (T)',\
     ''   u (zeta_of_x($1)):(column('total')/$2) w l lw 3 lc rgb '#000000' t 'sum in quadrature'

