# gnuplot file


set rmargin at screen 0.83
set term pdfcairo enhanced size 9cm,7cm
set output 'F2-plane.pdf'

set pm3d
unset surface

mpsq=0.938**2
W2(x,Q2)=mpsq+Q2*(1-x)/x
Q2fn(x,W2val)=(W2val-mpsq)*x/(1-x)
max(a,b)=a>b?a:b
min(a,b)=a<b?a:b

#xmin='1e-3'
#xmax='0.99'
xmin='0.5e-5'
xmax='1.0'

Q2min='0.1'
Q2max='200.0'

set yrange [log(Q2min):log(Q2max)]
set xrange [log(xmin):log(xmax)]
#set view 0,0

#set xrange [0:1.0]
#set yrange [0:2]
#set xtics ()
#for
#set palette rgbformulae -30,-7,-32
#set palette rgbformulae -1,-2,-3
set palette model RGB
#set palette defined (0 1 1 1, 1 1 0.2 0,  2 0.8 0.8 0, 3 0 0.8 0, 4 0 1 1, 5 0 0 1, 6 0 0 0)
set palette defined (0 1 1 1, 1 1 0.2 0,  2 0.95 0.95 0, 3 0 0.8 0, 4 0 1 1, 5 0 0 1, 6 0 0 0)
#set palette defined (0 1 1 1, 0.1 .8 .8 .8, 1 1 0.2 0,  2 0.95 0.95 0, 3 0 0.8 0, 4 0 1 1, 5 0 0 1, 6 0 0 0)

set grid front


set xlabel 'x_{bj}'
set ylabel 'Q^2 [GeV^2]'
set cblabel 'F_2{/*0.5  }(x_{bj},Q^2)' rotate by 270 offset 0.9

set cbrange [0:6]

# put log x,y tics by hand because image cannot handle log scales
set xtics ()
do for [i=-5:5] {
  set xtics add (sprintf("%g",10**i) log(10**i))
  do for [j=2:9] {
    set xtics add (sprintf("%g",j*10**i) log(j*10**i) 1)
}
}
set xtics add ("10^{-5}" log(1e-5))
set xtics add ("10^{-4}" log(1e-4))
set xtics add ("10^{-3}" log(1e-3))
set xtics add ("10^{-2}" log(1e-2))
set ytics ()
do for [i=-5:5] {
  set ytics add (sprintf("%g",10**i) log(10**i))
  do for [j=2:9] {
    set ytics add (sprintf("%g",j*10**i) log(j*10**i) 1)
}
}

grey='#808080'
       
#command='../run-tests --nx 200 --nQ2 200 --gen-x-Q2-plane --xmin '.xmin.' --xmax '.xmax.' --Q2min '.Q2min.' --Q2max '.Q2max.' --inelastic-param LHAPDF_Hermes_ALLM_CLAS --pdf PDF4LHC15_nnlo_100 --out LHAPDF_Hermes_ALLM_CLAS+PDF4LHC15_nnlo_100.dat'
# regenerate the file, just in case we've changed the x and Q^2 limits
#system(command)

set label 1 '{/*0.9 Q^2 = 9 GeV^2}' at log(0.05),log(12.0) center front tc rgb grey
set label 2 '{/*0.9 W^2 = 4 GeV^2}' at log(0.23),log(2.0) center front rotate by 65 tc rgb grey

set label 10 'high-Q^2 continuum' at log(0.003),log(40) center front
set label 11 'low-Q^2 continuum' at log(0.003),log(2) center front
set label 12 'resonances' at log(0.22),log(0.15) center front rotate by 0

set label 20 '{/*1.3 F_2{/*0.5  }(x_{bj},Q^2)}' at graph 0.03,0.08 front

set samples 1000
#print command
plot 'LHAPDF_Hermes_ALLM_CLAS+PDF4LHC15_nnlo_100.dat' u (log($1)):(log($2)):3 with image t '',\
     log(Q2fn(exp(x),4.0)) w l lw 2 lc rgb grey t '',\
     log(max(9.0,Q2fn(exp(x),4.0))) w l lw 2 lc rgb grey t ''
     
set cblabel 'F_L{/*0.5  }(x_{bj},Q^2)'
set label 20 '{/*1.3 F_L{/*0.5  }(x_{bj},Q^2)}'
plot 'LHAPDF_Hermes_ALLM_CLAS+PDF4LHC15_nnlo_100.dat' u (log($1)):(log($2)):4 with image t '',\
     log(Q2fn(exp(x),4.0))          w l lw 2 lc rgb grey t '',\
     log(max(9.0,Q2fn(exp(x),4.0))) w l lw 2 lc rgb grey t ''
     

# set view 0,0
# set pm3d
# set log x
# set log y
# splot '<../run-tests --gen-x-Q2-plane --inelastic-param Hermes_ALLM_CLAS --Q2max 5' u 1:2:3

set output
