# gnuplot file


set rmargin at screen 0.8
set term pdfcairo enhanced size 9cm,7cm
set output 'F2-plane-linQ2.pdf'

set pm3d
unset surface



#xmin='1e-3'
#xmax='0.99'
xmin='0.5e-5'
xmax='0.99'

Q2min='0.0'
Q2max='0.6'


#set view 0,0

#set xrange [0:1.0]
#set yrange [0:2]
#set xtics ()
#for
#set palette rgbformulae -30,-7,-32
#set palette rgbformulae -1,-2,-3
set palette model RGB
set palette defined (0 1 1 1, 1 1 0.2 0,  2 0.95 0.95 0, 3 0 0.8 0, 4 0 1 1, 5 0 0 1, 6 0 0 0)

set grid front

mpr=0.938
min(a,b)=a<b?a:b
max(a,b)=a>b?a:b

Q2loIntegrand(xph,xbj)=xph**2*mpr**2/max(xph**2,1-xph/xbj)


set label 1 '{/*1.5 F_2{/*0.5  }(x_{bj},Q^2) / Q^2}' at graph 0.06,0.9 front
set xlabel 'x_{bj}'
set ylabel 'Q^2 [GeV^2]'
set cblabel 'F_2{/*0.5  }(x_{bj},Q^2) / Q^2 [GeV^{-2}]' rotate by 270 offset 0.7

set cbrange [0:3.5]

# put log x,y tics by hand because image cannot handle log scales
set xtics ()
do for [i=-5:5] {
  set xtics add (sprintf("%g",10**i) log(10**i))
  do for [j=2:9] {
    set xtics add (sprintf("%g",j*10**i) log(j*10**i) 1)
}
}
# manually fix these
set xtics add ("10^{-5}" log(1e-5))
set xtics add ("10^{-4}" log(1e-4))
set xtics add ("10^{-3}" log(1e-3))
set xtics add ("10^{-2}" log(1e-2))

set yrange [1.0*Q2min:1.0*Q2max]

command='../run-tests --nx 400 --nQ2 600 --linQ2 --gen-x-Q2-plane --xmin '.xmin.' --xmax '.xmax.' --Q2min '.Q2min.' --Q2max '.Q2max.' --inelastic-param Hermes_ALLM_CLAS'
print command
plot '../validation-files-LUXqed17/F2L-plane-linQ2.dat' u (log($1)):($2):($3/$2) with image t ''
#plot '<'.command u (log($1)):($2):($3/$2) with image t ''


#,\
#     Q2loIntegrand(0.1,exp(x)) w l lc rgb 'black' lw 2 t '',\
#     Q2loIntegrand(0.01,exp(x)) w l lc rgb 'black' lw 2 t '',\
#     Q2loIntegrand(0.001,exp(x)) w l lc rgb 'black' lw 2 t ''



set output 'FL-plane-linQ2.pdf'
set label 1 '{/*1.5 F_L{/*0.5  }(x_{bj},Q^2) / Q^2}'
set cblabel 'F_L{/*0.5  }(x_{bj},Q^2) / Q^2 [GeV^{-2}]' rotate by 270
plot ''          u (log($1)):($2):($4/$2) with image t '',\

# set view 0,0
# set pm3d
# set log x
# set log y
# splot '<../run-tests --gen-x-Q2-plane --inelastic-param Hermes_ALLM_CLAS --Q2max 5' u 1:2:3

set output
