#!/bin/bash
# script to generate the files used by a number of the plots in the
# LongVersion (LUXqed17) paper

thisdir=$0

# normally this is the same directory that this script is in!
# By specifying it explicitly, we can run the script from
# any subdirectory of main-code.
dir=../validation-files-LUXqed17

function startfile {
    outfile=$1
    echo "For $2, creating $1"
    rm -f $outfile; touch $outfile
    echo "# File generated automatically by" $0 for $2  >> $outfile
    echo "# on "`date`                                  >> $outfile
    echo "# from directory " `pwd` ", by running"       >> $outfile
}

#----------------------------------------------------------------------
forplot=F2-plane-linQ2.gp
outfile=$dir/F2L-plane-linQ2.dat
startfile $outfile $forplot
command1="../run-tests --nx 400 --nQ2 600 --linQ2 --gen-x-Q2-plane --xmin 0.5e-5 --xmax 0.99 --Q2min 0.0 --Q2max 0.6 --inelastic-param Hermes_ALLM_CLAS"
#command2="../scripts/reduce-prec.py"
#echo "# $command1 | $command2" >> $outfile
#$command1 | $command2 >> $outfile
$command1 >> $outfile


#----------------------------------------------------------------------
forplot=check-low-Q2-paper.gp
for Q2 in 1e-5 0.5 3 20
do
    for inelparam in Hermes_ALLM_CLAS CLAS Hermes_ALLM Christy_Bosted_pure
    do
        outfile=$dir/inelparam-$inelparam-Q2-$Q2.dat
        startfile $outfile $forplot
        ../run-tests --inelastic-param $inelparam --write-sigmas --write-W2-Q2 --nx 5000 --xmin 1e-10 --gen-x-at-Q2 $Q2 >> $outfile
    done
done

#----------------------------------------------------------------------
forplot=R-v-Q2.gp             
for W2 in 100 10 3 1.4
do
    outfile=$dir/inel-param-Hermes_ALLM_CLAS-W2-$W2.dat
    startfile $outfile $forplot
    ../run-tests --inelastic-param Hermes_ALLM_CLAS  --rescale-R-twist4 5.5 --nx 300 --gen-Q2-at-W2 $W2 >> $outfile
done

#----------------------------------------------------------------------
forplot=R-low-Q2-v-W2.gp
for inelparam in Hermes_ALLM_CLAS Christy_Bosted
do
    outfile=$dir/inel-param-$inelparam-Q2-1.75.dat
    startfile $outfile $forplot
    ../run-tests --inelastic-param $inelparam --gen-x-at-Q2 1.75 --nx 300 --xmin 0.01 --xmax 0.9  >> $outfile
done


#----------------------------------------------------------------------
forplot=resonance-v-clas-paper.gp
for Q2 in 0.225 1.525 2.625 4.225
do
    for param in CLAS Christy_Bosted
    do
        outfile=$dir/$param-Q2-$Q2.dat
        startfile $outfile $forplot
        
        command1="../scripts/mergeidx.pl -f ../data/CLAS-hep-ph-0301204-transformed.dat Q2...$Q2 "
        command2=" ../run-tests --read-x-Q --inelastic-param $param"
        echo "# $command1 | $command2" >> $outfile
        $command1 | $command2          >> $outfile
    done
done
