#!/usr/bin/env python
######## 
### calcFF.py
### Produces central values and errors on form factors for input Q^2.
### Author: Gabriel Lee, leeg@uchicago.edu
### Last modified 2016.09.12.
########

import sys # for user options from command line
from math import *
import numpy as np
mup = 2.792847356 # anomalous magnetic moment

# Input.
Q2start = float(sys.argv[1]) # if logarithmic, 10**(Q2start) GeV^2 is first Q2 point, otherwise Q2start in GeV^2.
Q2end = float(sys.argv[2]) # as above, with end of Q2 range.
Q2step = float(sys.argv[3]) # if logarithmic, 10**(Q2start+Q2step), otherwise Q2step in GeV^2
try: # 1 for logarithmic steps in Q2, linear steps otherwise.
    Q2opt = int(sys.argv[4])
except:
    Q2opt = 0
try: # choose input for fit data, default is Mainz.
    if sys.argv[5] == 'w': 
        fitdata = open('fitfile_world.dat', 'r').readlines()
    else:
        fitdata = open('fitfile_mainz.dat', 'r').readlines()
except:
    fitdata = open('fitfile_mainz.dat', 'r').readlines()
try: # output filename
    outfile = sys.argv[6]
except:
    outfile = 'out.dat'

# Read fit information from input file.
[Q2max, tcut, t0] = [float(fitdata[0].split()[i]) for i in range(0,3)]
[rE, drE, rM, drM] = [float(fitdata[1].split()[i]) for i in range(0,4)]
gecoef_fit = [float(x) for x in fitdata[2].lstrip('[').rstrip(']\n').split(',')]
gmcoef_fit = [float(x) for x in fitdata[3].lstrip('[').rstrip(']\n').split(',')]
kmax = len(gecoef_fit)-1
nmax = kmax-4
cov = []
for k in range(2*nmax):
    covrow = [float(x) for x in fitdata[4+k].lstrip('[').rstrip(']\n').split(',')]
    cov.append(covrow)
temp = fitdata[4+2*nmax].replace('[','').replace(']]','').split('],')
sumrules = []
for k in range(5):
    sumrules.append([float(x) for x in temp[k].split(',')])

# Kinematics.
Q2 = np.arange(Q2start, Q2end, Q2step)
Q2 = np.append(Q2, Q2end)
if Q2opt == 1: # logarithmic steps
    Q2 = 10**Q2
z0 = (1-sqrt(1-t0/tcut))/(1+sqrt(1-t0/tcut))
zQ2 = (np.sqrt(tcut+Q2)-sqrt(tcut-t0))/(np.sqrt(tcut+Q2)+sqrt(tcut-t0))

# Compute FF values and errors.
GEQ2, GMQ2 = [], []
dGEQ2, dGMQ2 = [], []
for z in zQ2:
    GEQ2.append(np.array([gecoef_fit[i]*z**i for i in range(len(gecoef_fit))]).sum())
    GMQ2.append(np.array([gmcoef_fit[i]*z**i for i in range(len(gmcoef_fit))]).sum())
    dGE, dGM = 0, 0
    sr = np.array([ np.array([sumrules[0][l+1]*np.array([k-j for j in range(l)]).prod() for l in range(0,4)]).sum() + np.array([z**(kmax-n)*(sumrules[4-n][0]*z0**k + np.array([sumrules[4-n][l+1]*np.array([k-j for j in range(l)]).prod() for l in range(0,4)]).sum()) for n in reversed(range(0,4))]).sum() for k in range(1,nmax+1)])
    for k in range(nmax):
        for l in range(nmax):
            dGE += cov[k][l]*(z**(k+1)- sumrules[0][0]*z0**(k+1) - sr[k])*(z**(l+1)- sumrules[0][0]*z0**(l+1) - sr[l])
            dGM += cov[nmax+k][nmax+l]*(z**(k+1) - sumrules[0][0]*z0**(k+1) - sr[k])*(z**(l+1)- sumrules[0][0]*z0**(l+1) - sr[l])
    dGE = sqrt(dGE)
    dGM = sqrt(dGM)
    dGEQ2.append(dGE)
    dGMQ2.append(dGM)
GEQ2 = np.array(GEQ2)
dGEQ2 = np.array(dGEQ2)
GMQ2 = np.array(GMQ2)
dGMQ2 = np.array(dGMQ2)
GEGMrat = (mup*GEQ2)/(GMQ2)
dGEGMrat = GEGMrat*np.sqrt((dGEQ2/GEQ2)**2+(dGMQ2/GMQ2)**2)

# Write output.
of = open(outfile, 'w')
for i in range(len(Q2)):
    print >> of, Q2[i], zQ2[i], GEQ2[i], dGEQ2[i], GMQ2[i], dGMQ2[i], GEGMrat[i], dGEGMrat[i]
    print Q2[i], zQ2[i], GEQ2[i], dGEQ2[i], GMQ2[i], dGMQ2[i], GEGMrat[i], dGEGMrat[i]
of.close()
