# gnuplot file

set term pdfcairo enhanced lw 1.5 size 8cm,7cm
set output 'R-v-Q2.pdf'
set sty dat lines

set bars small
mpsq=0.938**2
W2(x,Q2)=mpsq+Q2*(1-x)/x

set xrange [0:1.5]
set yrange [0:0.49]
set ytics 0.1
set mytics 5

set key spacing 1.5

gen(W2)='../validation-files-LUXqed17/inel-param-Hermes_ALLM_CLAS-W2-'.W2.'.dat'

set ylabel 'R_{L/T}'
set xlabel 'Q^2 [GeV^2]'

set label 1 'R_{1998}, extended to low Q^2' at graph 0.05,0.92 tc rgb '#808080'

set key bottom

set lt  1 lw 2 lc rgb '#003030e0'
#set lt 11 lw 2 lc rgb '#803030e0'
set lt  2 lw 2 lc rgb '#00ff0000'
set lt  3 lw 2 lc rgb '#00c000'
set lt  4 lw 2 lc rgb '#000000'

plot gen('100')  u 2:6 t 'W^2 = 100 GeV^2',\
     gen('10' )  u 2:6 t 'W^2 = 10 GeV^2',\
     gen('3'  )  u 2:6 t 'W^2 = 3 GeV^2',\
     gen('1.4')  u 2:6 t 'W^2 = 1.4 GeV^2'
     
     
     

set output

