reset
set terminal pdfcairo font ",16" size 9cm,9cm
set output 'resonance-v-clas-paper.pdf'

mpsq=0.880

datac="lc rgb '#80303030'"
fitcl="lc rgb '#0000ff'"
fitcb="lc rgb '#ff0000'"

set key bottom spacing 1.5
#set label 'F_2(x,Q^2)' at screen 0.1,0.6 rotate by 90
set ylabel 'F_2(x_{bj},Q^2)' offset 1.5
set xlabel 'W^2 [GeV^2]'
set log y
set yrange [0.004:0.7]
#set xtics ( "1" 1 0, "2" 2, "3" 3, "4" 4)
set xtics add (1.5, 2, 2.5, 3, 4)
set log x
set xrange [1:5]
#set label "(data step 0.05 GeV^2)" at screen 0.55,0.53

m='<../scripts/mergeidx.pl -f ../data/CLAS-hep-ph-0301204-transformed.dat '
data(Q2)=m.'Q2...'.Q2
CLASparam(Q2)="../validation-files-LUXqed17/CLAS-Q2-".Q2.".dat"
CBparam(Q2)  ="../validation-files-LUXqed17/Christy_Bosted-Q2-".Q2.".dat"
#='|../run-tests --read-x-Q --inelastic-param CLAS'
#CBparam  ='|../run-tests --read-x-Q --inelastic-param Christy_Bosted'

W2(x,Q2)=mpsq+Q2*(1-x)/x

set bars 0.0

#print m.'Q2...0.225'
#print m.'Q2...0.225'.CLASparam

ps=0.3

set label 1 '{/*0.7 Q^2 = 0.225 GeV^2' at 1.55,0.5
set label 2 '{/*0.7 Q^2 = 1.525 GeV^2' at 4.75,0.4  right
set label 3 '{/*0.7 Q^2 = 2.625 GeV^2' at 4.75,0.13 right
set label 4 '{/*0.7 Q^2 = 4.225 GeV^2' at 2.20,0.03
#set label "Q^2=0.225," at screen 0.53,0.55
#set label "1.225, 2.225," at screen 0.5,0.5
#set label "3.225, 4.225 GeV^2" at screen 0.45,0.45


plot data     ('0.225') u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  'CLAS data',\
     CLASparam('0.225') u (W2($1,$2   )):3                     w l @fitcl t             'CLAS fit',\
     CBparam  ('0.225') u (W2($1,$2   )):3                     w l @fitcb t             'CB fit',\
     data     ('1.525') u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  '',\
     CLASparam('1.525') u (W2($1,$2   )):3                     w l @fitcl t             '',\
     CBparam  ('1.525') u (W2($1,$2   )):3                     w l @fitcb t             '',\
     data     ('2.625') u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  '',\
     CLASparam('2.625') u (W2($1,$2   )):3                     w l @fitcl t             '',\
     CBparam  ('2.625') u (W2($1,$2   )):3                     w l @fitcb t             '',\
     data     ('4.225') u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  '',\
     CLASparam('4.225') u (W2($1,$2   )):3                     w l @fitcl t             '',\
     CBparam  ('4.225') u (W2($1,$2   )):3                     w l @fitcb t             '',\




#      m.'Q2...1.525'           u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  '',\
#      m.'Q2...1.525'.CLASparam u (W2($1,$2   )):3                     w l @fitcl t             '',\
#      m.'Q2...1.525'.CBparam   u (W2($1,$2   )):3                     w l @fitcb t             '',\
#      m.'Q2...2.625'           u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  '',\
#      m.'Q2...2.625'.CLASparam u (W2($1,$2   )):3                     w l @fitcl t             '',\
#      m.'Q2...2.625'.CBparam   u (W2($1,$2   )):3                     w l @fitcb t             '',\
#      m.'Q2...4.225'           u (W2($1,$2**2)):3:(sqrt($4**2+$5**2)) w error @datac ps ps  t  '',\
#      m.'Q2...4.225'.CLASparam u (W2($1,$2   )):3                     w l @fitcl t             '',\
#      m.'Q2...4.225'.CBparam   u (W2($1,$2   )):3                     w l @fitcb t             '',\
     

# Plot '../data/CLAS-hep-ph-0301204-transformed.dat' index 0 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t 'CLAS F_2',\
#      '<../run-tests --read-x-Q --inelastic-param CLAS < ../data/CLAS-hep-ph-0301204-transformed.dat' index 0 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t 'CLAS fit',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 20 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param CLAS < ../data/CLAS-hep-ph-0301204-transformed.dat' index 20 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t '',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 40 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param CLAS < ../data/CLAS-hep-ph-0301204-transformed.dat' index 40 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t '',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 60 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param CLAS < ../data/CLAS-hep-ph-0301204-transformed.dat' index 60 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t '',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 80 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param CLAS < ../data/CLAS-hep-ph-0301204-transformed.dat' index 80 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t ''
# 
# plot '../data/CLAS-hep-ph-0301204-transformed.dat' index 0 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t 'CLAS F_2',\
#      '<../run-tests --read-x-Q --inelastic-param Christy_Bosted < ../data/CLAS-hep-ph-0301204-transformed.dat' index 0 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t 'Christy-Bosted fit',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 20 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param Christy_Bosted < ../data/CLAS-hep-ph-0301204-transformed.dat' index 20 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t '',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 40 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param Christy_Bosted < ../data/CLAS-hep-ph-0301204-transformed.dat' index 40 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t '',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 60 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param Christy_Bosted < ../data/CLAS-hep-ph-0301204-transformed.dat' index 60 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t '',\
#      '../data/CLAS-hep-ph-0301204-transformed.dat' index 80 u (mpsq+$2**2*(1-$1)/$1):($3):(sqrt($4**2+$5**2)) w error @datac ps 0.3 t '',\
#      '<../run-tests --read-x-Q --inelastic-param Christy_Bosted < ../data/CLAS-hep-ph-0301204-transformed.dat' index 80 u (mpsq+$2*(1-$1)/$1):($3) w l @fitcl t ''
#      

 set output
     
