# gnuplot file, template generated automatically with
# /Users/gsalam/scripts/gptemplate.py elastic-breakdown.gp

set term pdfcairo enhanced font 'Helvetica,12' lw 1.5 size 8cm,6.5cm
set lt 1 pt 4 ps 0.6 lw 1.0 lc rgb '#f00000'
set lt 2 pt 5 ps 0.6 lw 1.5 lc rgb '#00c000'
set lt 3 pt 6 ps 0.6 lw 1.5 lc rgb '#0000e0'
set lt 4 pt 7 ps 0.6 lw 1.5 lc rgb '#ff8000'
set lt 5 pt 8 ps 0.6 lw 1.5 lc rgb '#5070ff'
set key spacing 1.3

set output 'elastic-breakdown.pdf'

elec(Q2)=sprintf("elastic-scale-breakdown/elastic-elec1-magn0-Q2maxElastic%s.dat",Q2)
magn(Q2)=sprintf("elastic-scale-breakdown/elastic-elec0-magn1-Q2maxElastic%s.dat",Q2)

load "xaxis.gp"
rescale(x)=1e3/(1.0-x)**4/(1.0+log(1.0/x))
set ytics 1.0
set mytics 5

set ylabel 'xf_{γ/p}・10^3/(1-x)^4/(1+log(1/x))'

set label 100 'A1 form factor' at graph 0.05,0.4
set label 101 'μ = 100 GeV' at graph 0.05,0.34
set label 201 'Red: Q^2 < 0.2, 0.4, …, 1 GeV^2' at graph 0.95,0.9 right tc lt 1
set label 202 'Blue: all Q^2' at graph 0.95,0.84 right tc lt 3

set label 301 'G_E' at zeta_of_x(3e-4),2.8
set label 302 'G_M' at zeta_of_x(3e-4),0.3

Q2list="0.2 0.4 0.6 0.8 1.0"
set yrange [0:4]

plot for [Q2 in Q2list] elec(Q2) u (zeta_of_x($1)):($3*rescale($1))  w l lt 1 t '',\
     elec("1e9") u (zeta_of_x($1)):($3*rescale($1))  w l lt 3 t '',\
     for [Q2 in Q2list] magn(Q2) u (zeta_of_x($1)):($3*rescale($1))  w l lt 1 t '',\
     magn("1e9") u (zeta_of_x($1)):($3*rescale($1))  w l lt 3 t '',\

set label 100 'dipole form factor' at graph 0.05,0.4
elec(Q2)=sprintf("elastic-scale-breakdown/elastic-dipole-elec1-magn0-Q2maxElastic%s.dat",Q2)
magn(Q2)=sprintf("elastic-scale-breakdown/elastic-dipole-elec0-magn1-Q2maxElastic%s.dat",Q2)
replot

set output

