# 

set term pdfcairo enhanced color size 7.5cm,5cm



#set border 10


ymin=0 ; ymax=13.5
set yrange [ymin:ymax]
set mytics 4
#xmin=0.00001
#xmax=0.6
#set xrange [xmin:xmax]
#set log x

set ylabel 'xf_{{/Symbol g}/p}(x,{/Symbol m}^2)\ {/Symbol \267}\ 10^3 x^{0.4}/(1-x)^{4.5}' offset 2
set xlabel 'x' offset 0,1

set grid noxtics noytics front

set rmargin 1.0

set xtics add (0.5)

load 'xaxis.gp'
#reset upper bound
set xrange [zeta_of_x(1e-5):zeta_of_x(0.9)]


set label  101 '{/*0.9 elastic electric}' at graph 0.35,0.1  front
set label  102 '{/*0.9 elastic}'  at graph 0.8,0.24 front
set label  103 '{/*0.9 magnetic}'  at graph 0.8,0.18 front
set label  104 '{/*0.9 resonances}'  at graph 0.53,0.30 rotate by 4 front
set label  105 '{/*0.9 continuum data}'  at graph 0.44,0.38 rotate by 5 front
set label  106 '{/*0.9 PDFs}'  at graph 0.45,0.6 front
set label  107 '{/*0.9:Bold Q = 1 GeV}'  at graph 0.12,0.06 rotate by 9 front textcolor rgb "#ffffff"
set label  108 '{/*0.9 without {MS} conversion}'  at graph 0.6,0.93 front textcolor rgb '#0a7ff5' 
#set label  109 '\_\_' at graph 0.725, 1.015 font "Symbol,16" textcolor rgb '#0a7ff5'

set label  101 '{/*0.9 elastic electric}'        at zeta_of_x(3e-3),1.0  front
set label  102 '{/*0.9 elastic}'                 at zeta_of_x(0.4),2.4 front
set label  103 '{/*0.9 magnetic}'                at zeta_of_x(0.4),1.6 front
set label  104 '{/*0.9 resonances}'              at zeta_of_x(4e-2),3.0 rotate by 4 front
set label  105 '{/*0.9 continuum data}'          at zeta_of_x(1e-2),3.7 rotate by 6 front
set label  106 '{/*0.9 PDFs}'                    at zeta_of_x(1e-2),6 front
set label  107 '{/*0.9:Bold Q = 1 GeV}'          at zeta_of_x(7e-5),0.7 rotate by 9 front textcolor rgb "#ffffff"
#set label  108 '{/*0.9 LO result, μ_Μ = μ}'      at zeta_of_x(9e-2),9.8 front textcolor rgb '#0a7ff5' 
#set label  109 '\_\_'                            at zeta_of_x(0.725, 1.015 font "Symbol,16" textcolor rgb '#0a7ff5'


ALLMmax=10
min(x,y)=x<y?x:y
rescale(x)=1000*(x**0.4)/((1-x)**4.5)

thinblk='w l lc rgb "#303030" lw 0.5'
set macros

#---- start work ---------------------------------------------------------
set output 'contribs.pdf'
do for [mu2 in "10000 250000"] {
#mu2=10000
set label  108 '{/*0.9 LO result, μ_Μ = μ}' at zeta_of_x(9e-2),9.8 front textcolor rgb '#0a7ff5' 
set label 100 'LUXqed17, {/Symbol m} ='.sprintf('%4.0f',sqrt(mu2)).' GeV' at graph 0.03,0.9  front textcolor rgb "#ff0000"

base=' contribution-breakdown/out-'.mu2.'-'
files='<paste '.base.'1.dat'.base.'2.dat'.base.'3.dat'.base.'4.dat'.base.'5.dat'.base.'6.dat'

plot files using (zeta_of_x($1)):(0):(($3+$4)*rescale($1)) w filledcurves fc rgb '#ff0000' t '',\
     files using (zeta_of_x($1)):(($3+$4)*rescale($1)):(($9+$10)*rescale($1)) w filledcurves fc rgb '#80ff0000' t '',\
     files using (zeta_of_x($1)):(($9+$10)*rescale($1)):(($18-$17)*rescale($1)) w filledcurves fc rgb '#00c0d0' t '',\
     files using (zeta_of_x($1)):(($18-$17)*rescale($1)):(($24-$23)*rescale($1)) w filledcurves fc rgb '#ffc050' t '',\
     files using (zeta_of_x($1)):(($24-$23)*rescale($1)):(($30)*rescale($1)) w filledcurves fc rgb '#b0b0b0' t '',\
     files using (zeta_of_x($1)):(($30-$29)*rescale($1)) w l dt 2 lw 2 lc rgb '#0a7ff5' t '',\
     files using (zeta_of_x($1)):(($36-$35)*rescale($1)) w l lw 3 lc rgb '#ffffff' t '',\

mu2Mhi=sprintf('%d',mu2*4)
mu2Mlo=sprintf('%d',mu2*0.25)
set label  108 '{/*0.9 LO result, μ_Μ = 2μ}'
files='<paste '.base.'1.dat'.base.'2.dat'.base.'3.dat'.base.'4.dat'.base.'full-mu2M'.mu2Mhi.'.dat'.base.'6.dat'
replot
set label  108 '{/*0.9 LO result, μ_Μ = 0.5μ}'
files='<paste '.base.'1.dat'.base.'2.dat'.base.'3.dat'.base.'4.dat'.base.'full-mu2M'.mu2Mlo.'.dat'.base.'6.dat'
replot

files='<paste '.base.'1.dat'.base.'2.dat'.base.'3.dat'.base.'4.dat'.base.'5.dat'.base.'6.dat'.\
     base.'full-mu2M'.mu2Mhi.'.dat'.base.'full-mu2M'.mu2Mlo.'.dat'

set label  118 '{/*0.9 LO result, μ_Μ = 2μ}'   at zeta_of_x(9e-2),9.8 front textcolor rgb '#041ff5' 
set label  108 '{/*0.9 LO result, μ_Μ = 0.5μ}' at zeta_of_x(9e-2),6.8+0.2*log(mu2/1e4) front textcolor rgb '#0a7ff5' rotate by 3

plot files using (zeta_of_x($1)):(0):(($3+$4)*rescale($1)) w filledcurves fc rgb '#ff0000' t '',\
     files using (zeta_of_x($1)):(($3+$4)*rescale($1)):(($9+$10)*rescale($1)) w filledcurves fc rgb '#80ff0000' t '',\
     files using (zeta_of_x($1)):(($9+$10)*rescale($1)):(($18-$17)*rescale($1)) w filledcurves fc rgb '#00c0d0' t '',\
     files using (zeta_of_x($1)):(($18-$17)*rescale($1)):(($24-$23)*rescale($1)) w filledcurves fc rgb '#ffc050' t '',\
     files using (zeta_of_x($1)):(($24-$23)*rescale($1)):(($30)*rescale($1)) w filledcurves fc rgb '#b0b0b0' t '',\
     files using (zeta_of_x($1)):(($42-$41)*rescale($1)) w l dt 2 lw 2 lc rgb '#041ff5' t '',\
     files using (zeta_of_x($1)):(($48-$47)*rescale($1)) w l dt 2 lw 2 lc rgb '#0a7ff5' t '',\
     files using (zeta_of_x($1)):(($36-$35)*rescale($1)) w l lw 3 lc rgb '#ffffff' t '',\

unset label 118
}
     
#     'LUXqed_plus_PDF4LHC15_nnlo_100-mu2-10000.0.dat' u 1:($2*rescale($1)) w l lt 1 lw 0.5 lc rgb 'black' t ''

# plot files using 1:(0):($6/($30-$29)) w filledcurves fc rgb '#8000c0d0' t '',\
#      files using 1: ($6/($30-$29)):($12/($30-$29)) w filledcurves fc rgb '#80ffc050' t '',\
#      files using 1:($12/($30-$29)):(($18-$17)/($30-$29)) w filledcurves fc rgb '#80b0b0b0' t '',\
#      files using 1:(($18-$17)/($30-$29)):(($24-$23)/($30-$29)) w filledcurves fc rgb '#8000aa00' t '',\
#      files using 1:(($24-$23)/($30-$29)):(1) w filledcurves fc rgb '#80ff0000' t '',\
#      files using 1:(($36-$35)/($30-$29)) w l lw 3 lc rgb '#ffffff' t ''

set output

