set term pdfcairo enhanced size 9cm,6cm
set output 'quark-qed-on-photon.pdf' 
set macros

load 'xaxis.gp'
set xrange [zeta_of_x(1e-5):zeta_of_x(0.9)]

set lt 3 pt 6 ps 0.6 lw 1.5 lc rgb '#0000e0'

Q100='Q100.dat'
dir='../lhapdf-configs/LUXqed17_plus_PDF4LHC15_nnlo_100/'
masters='../masters-LUXqed17_PDF4LHC15_nnlo_100/'

set key left Left reverse opaque spacing 1.3 box width 2

set label 101 'photon'      at graph 0.1,0.13
set label 100 'μ = 100 GeV' at graph 0.1,0.06

origcol='rgb "#f0b000"'

set grid lt 1 lc rgb '#e0000000' lw 0.5 front

set ylabel '{/*0.8 ratio to LUXqed17\_plus\_PDF4LHC15\_nnlo\_100}'
set yrange [0.97:1.03]
plot dir.Q100 u (zeta_of_x($1)):($4/$2):($5/$2) w filledcurves fc @origcol t '{/*0.9 LUXqed17\_plus\_PDF4LHC15\_nnlo\_100}',\
     dir.Q100 u (zeta_of_x($1)):(1) w l lw 2 lc rgb '#c05000' t '',\
     '<./mergeidx.pl Columns -f LUXqed17_photon_on_orig_grid.dat -f ../masters-LUXqed17_PDF4LHC15_nnlo_100/LUXqed17_PDF4LHC15_nnlo_100-mu2-10000.dat | ../scripts/monotonic-x.py' u (zeta_of_x($1)):($8/$2) w l lt 3 lw 3 t '{/*0.9 without QED in quark evolution}'

set output
