# gnuplot file
# some variables must be set when this is called
#   - Q
#   - ierr (1 if we have errors, 1 otherwise)

#----------------------------------------------------------------------
Q=100
ierr=1
pdfin='PDF4LHC15_nnlo_100'
pdfout='LUXqed17_plus_PDF4LHC15_nnlo_100'
options=''

#----------------------------------------------------------------------
set term pdfcairo enhanced size 10cm,7cm
set output 'comparisons-LUX17-others.pdf' 
set macros

set lt 2 pt 5 ps 0.6 lw 1.5 lc rgb '#0000e0'
set lt 3 pt 6 ps 0.6 lw 1.5 lc rgb '#00c000'

load '../elastic-component-plots/xaxis.gp'
col(flav)=2+(flav+6)
ncol=col(11)
# column number in pdf.py output; here photon is -6; other flavours
# go from -5..5; ir=0 (no errors) or 1 (with errors)
# 
colpdfE(flav,extra,ir)=(2+(flav+6)*(1+ir*3)+extra*ir)
colpdf(flav,ir)=colpdfE(flav,0,ir)
ncolpdf(ir)=colpdfE(5,3,ir)

# gives the pair as a function of the original flavour index (flav, in
# hoppet numbering) and the order (iflav) in the file obtained
# via LHAPDF
pair(flav,iflav)=sprintf('(abs($%d/$%d-1))',col(flav),ncol+colpdf(iflav,0))
pairUp=pair(2,2)
pairGluon=pair(0,0)
pairPhoton=pair(8,-6)
pairStrange=pair(3,3)
print pairUp

# numbering for a single flavour of a pair (from two files), where the first
# file has an uncertainty and the second one doesn't
nflav=4
ENncol=1 + 4*nflav
# single flavour, possibly with its error
snglE (iflav,extra)=sprintf('(rescaleF($%d/$%d-1))', colpdfE(iflav,extra,1), colpdf(iflav,1))
# pair, where second one may (ierr=1) or may not (ierr=0) have an error
mult=ierr*3+1
pairEE(iflav,extra)=sprintf('(rescaleF($%d/$%d-1))',ncolpdf(1)+colpdfE(iflav,extra,ierr), colpdf(iflav,1))


set label 10 sprintf('μ = %g GeV',Q) at graph 0.05, 0.95 front
set label 11 'FLAVOUR' at graph 0.05,0.89 noenhanced front
#set label 12 'based on = '.pdfin  at graph 0.05,0.83 noenhanced front
#set label 13 'options = '.options  at graph 0.05,0.77  front

dir='../lhapdf-configs/LUXqed17_plus_PDF4LHC15_nnlo_100/'
m='<./mergeidx.pl Columns '
# for validation against hoppet result
filesV=m.' -f '.dir.'validation-native.dat -f '.dir.'validation-lhapdf.dat '

# for comparison to other results
fileNew=' -f '.dir.'Q100.dat '
fileOrg=' -f '.dir.'origQ100.dat '
filePv1Stored=' -f ../lhapdf-configs/LUXqed_plus_PDF4LHC15_nnlo_100/Q100.dat '
fileThrd=' -f ../lhapdf-configs/LUXqed17_muMatch6_plus_PDF4LHC15_nnlo_100/Q100.dat '
#
weightFn(x)= 1e3 * x**0.4 /(1-x)**4.5


set xrange [zeta_of_x(1e-5):zeta_of_x(0.9)]
set grid lt 1 lc rgb '#e0000000' lw 0.5

# now the normalised photon
origcol='rgb "#f0b000"'
set key spacing 1.3 bottom opaque box height 0.5 width 1.5

set format y '%g'
set ylabel 'xf_{{/Symbol g}/p}(x) * 1000 x^{0.4} (1-x)^{-4.5}'


# then the other flavours (maybe including uncertainties?)
set grid front
unset ylabel
set yrange [-0.05:0.05]

rescaleF(f)=f/(1+(abs(f)/0.05)**0.8)
set ytics (0)
do for [iy = -30:30] {
  set ytics add (rescaleF(iy*0.01) 1)
}
do for [y in "0.01 0.02 0.05 0.1 0.2 0.3"] {
   set ytics add (y rescaleF(y*1.0))
   set ytics add ("-".y rescaleF(-y*1.0))
}
do for [y in "0.005 0.015"] {
   set ytics add (rescaleF(+y*1.0) 1)
   set ytics add (rescaleF(-y*1.0) 1)
}
set yrange [rescaleF(-0.3):rescaleF(0.3)]

set ylabel 'ratio to LUXqed\_plus\_PDF4LHC15\_nnlo\_100'
origName='LUXqed\_plus\_PDF4LHC15\_nnlo\_100'
thisName='LUXqed17\_plus\_PDF4LHC15\_nnlo\_100'
ThrdName='LUXqed17[...] μ_{match} = 6 GeV'
basefile = filePv1Stored
iflav=-6
#set title 'ratio of photon relative that in paper v1 (both via LHAPDF files)'
set label 11 'photon'
load '../validation-plots/lhapdf-validation-oneflav.gp'

set ylabel 'ratio to PDF4LHC15\_nnlo\_100'
origName='PDF4LHC15\_nnlo\_100'
basefile = fileOrg
iflav=0
set label 11 'gluon'
#set title 'ratio of gluon to that in base (non-QED) set'
load '../validation-plots/lhapdf-validation-oneflav.gp'
load '../validation-plots/lhapdf-validation-oneflav-3curves.gp'

#set yrange [-0.3:0.3]; set ytics 0.05; set mytics 5
#replot

iflav=2
#set title 'ratio of up quark to that in base (non-QED) set'
set label 11 'up quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'
load '../validation-plots/lhapdf-validation-oneflav-3curves.gp'

iflav=-2
set label 11 'up anti-quark'
#set title 'ratio of ubar to that in base (non-QED) set'
load '../validation-plots/lhapdf-validation-oneflav.gp'

iflav=1
#set title 'ratio of down quark to that in base (non-QED) set'
set label 11 'down quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'

iflav=-1
#set title 'ratio of dbar to that in base (non-QED) set'
set label 11 'down anti-quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'

iflav=3
#set yrange [-0.3:0.3]; set ytics 0.05; set mytics 5
#set title 'ratio of strange quark to that in base (non-QED) set'
set label 11 'strange quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'

iflav=-3
#set yrange [-0.3:0.3]; set ytics 0.05; set mytics 5
#set title 'ratio of sbar to that in base (non-QED) set'
set label 11 'strange anti-quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'

iflav=4
#set yrange [-0.3:0.3]; set ytics 0.05; set mytics 5
#set title 'ratio of charm quark to that in base (non-QED) set'
set label 11 'charm quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'

iflav=5
#set yrange [-0.3:0.3]; set ytics 0.05; set mytics 5
#set title 'ratio of bottom quark to that in base (non-QED) set'
set label 11 'bottom quark'
load '../validation-plots/lhapdf-validation-oneflav.gp'


# sEup=snglE(2,2)
# sEdn=snglE(2,3)
# pEE=pairEE(2,0)
# pEEup=pairEE(2,2)
# pEEdn=pairEE(2,3)
# set yrange [-0.05:0.05]
# print m.fileOrg.fileNew
# print pEE, pEEup, pEEdn
# plot m.fileOrg.fileNew \
#         u (zeta_of_x($1)):(@sEup):(@sEdn) w filledcurves t 'original PDF',\
#      '' u (zeta_of_x($1)):(@pEE)   w l lw 2 lt 2 t 'new',\
#      '' u (zeta_of_x($1)):(@pEEup) w l lw 3 dt 2 lt 2 t '',\
#      '' u (zeta_of_x($1)):(@pEEdn) w l lw 3 dt 2 lt 2 t '',\
     

set output
