# gnuplot file, template generated automatically with
# /Users/gsalam/scripts/gptemplate.py scale-dep.gp

set term pdfcairo enhanced font 'Helvetica,12' lw 2.0 size 9cm,6.5cm
set lt 1 pt 4 ps 0.6 lw 1.5 lc rgb '#f00000'
set lt 2 pt 5 ps 0.6 lw 1.5 lc rgb '#00c000'
set lt 3 pt 6 ps 0.6 lw 1.5 lc rgb '#0000e0'
set lt 4 pt 7 ps 0.6 lw 1.5 lc rgb '#ff8000'
set lt 5 pt 8 ps 0.6 lw 1.5 lc rgb '#5070ff'

set lt 11 pt 4 ps 0.6 lw 1.5 lc rgb '#80f00000'
set lt 12 pt 5 ps 0.6 lw 1.5 lc rgb '#8000c000'
set lt 13 pt 6 ps 0.6 lw 1.5 lc rgb '#800000e0'
set lt 14 pt 7 ps 0.6 lw 1.5 lc rgb '#80ff8000'
set lt 15 pt 8 ps 0.6 lw 1.5 lc rgb '#805070ff'
set key spacing 1.3
set key at graph 0.93,0.93
#set key box

load './xaxis.gp'

min2(a,b)=a<b?a:b
min3(a,b,c)=min2(min2(a,b),c)
min4(a,b,c,d)=min2(min3(a,b,c),d)
min5(a,b,c,d,e)=min2(min4(a,b,c,d),e)

max2(a,b)=a>b?a:b
max3(a,b,c)=max2(max2(a,b),c)
max4(a,b,c,d)=max2(max3(a,b,c),d)
max5(a,b,c,d,e)=max2(max4(a,b,c,d),e)

file(tag,scale)=' -f '.tag.'_muMS100_muPF'.sprintf("%03d ",scale)
files(tag)='<./mergeidx.pl Columns '.file('gavin_NLO',100).file(tag,100).file(tag, 50).file(tag,200)

cols='$12,$18,$24'
LOcl='$9+$10,$15+$16,$21+$22'


set grid front lt 1 lc rgb '#c0808080' lw 0.5
set macros


print files('gavin_NLO')
#

set output 'scale-dep.pdf'

set lmargin at screen 0.17
set bmargin at screen 0.14
set tmargin at screen 0.88

set yrange [0.985:1.035]
set ytics 0.01
set mytics 2
set grid

set ylabel 'ratio to NLO with M^2(z) = {/Symbol m}^2 / (1-z)' offset 0.5

set label 1 '0.5μ < μ_{/*0.8 M} < 2μ' at graph 0.06,0.91 front
set label 2 'μ = 100 GeV'             at graph 0.06,0.82 front

print '<./mergeidx.pl Columns '.file('gavin_NLO',100).' -f ../errorVariations/default-imem-1.dat'

set title 'photon PDF scale dependence with M^2(z) = {/Symbol m}_@{/*0.8 M}^2 / (1-z)'
plot files('gavin_NLO')  u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 12 t 'NLO',\
     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  2 t '',\
     files('gavin_NNLO') u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 13 t 'NNLO',\
     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  3 t '',\
     '<./mergeidx.pl Columns -f gavin_NLO_muMS100_muPF100  -f orig_NLO_muMS100_muPF100' u (zeta_of_x($1)):($12/$6) w l lt 1 t 'FSF-NLO',\
     '<./mergeidx.pl Columns -f gavin_NLO_muMS100_muPF100_finex  -f ../errorVariations/default.dat | ../scripts/monotonic-x.py' u (zeta_of_x($1)):($12/$6) w l lt 4 dt 4 t 'FSF-NLO (PRL)',\

#     '<./mergeidx.pl Columns -f gavin_NLO_muMS100_muPF100.sml -f gavin_NLO_muMS100_add_theory_uncert.sml' u (zeta_of_x($1)):($12/$6) w p lt 3 ps 0.2 lc rgb '#000000' t 'theory uncertainty check'

# variant where title is not visible (for stacking in paper)
textcol='#ff000000'; set title tc rgb textcol;
replot
textcol='#00000000'; set title tc rgb textcol; 


set title 'photon PDF scale dependence with M^2(z) = {/Symbol m}_@{/*0.8 M}^2'
plot files('gavin_NLO_muAsUpLim')  u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 12 t 'NLO',\
     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  2 t '',\
     files('gavin_NNLO_muAsUpLim') u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 13 t 'NNLO',\
     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  3 t '',\
     '<./mergeidx.pl Columns -f gavin_NLO_muMS100_muPF100  -f orig_NLO_mu2upper_muMS100_muPF100' u (zeta_of_x($1)):($12/$6) w l lt 1 t 'FSF-NLO',\
     '<./mergeidx.pl Columns -f gavin_NLO_muMS100_muPF100_finex  -f ../errorVariations/default-mu2asup.dat | ../scripts/monotonic-x.py' u (zeta_of_x($1)):($12/$6) w l lt 4 dt 4 t 'FSF-NLO (PRL)',\

# variant where title is not visible (for stacking in paper)
textcol='#ff000000'; set title tc rgb textcol;
replot
textcol='#00000000'; set title tc rgb textcol; 

set yrange [0.7:1.3]
set ytics 0.1
set title 'photon PDF scale dependence with M^2(z) = {/Symbol m}_@{/*0.8 M}^2 / (1-z)'
plot files('gavin_NLO')  u (zeta_of_x($1)):(min3(@LOcl)/$6):(max3(@LOcl)/$6) w filledcurves lt 11 t 'LO',\
     ''                  u (zeta_of_x($1)):(($9+$10)/$6)                     w l            lt  1 t '',\
     files('gavin_NLO')  u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 12 t 'NLO',\
     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  2 t '',\


#     files('gavin_NNLO') u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 13 t 'NNLO',\
#     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  3 t '',\


     
# variant where x axis info is not visible (for stacking paper)
textcol='#ff000000'; set xlabel tc rgb textcol; set xtics tc rgb textcol
replot
textcol='#00000000'; set xlabel tc rgb textcol; set xtics tc rgb textcol
     

set title 'photon PDF scale dependence with M^2(z) = {/Symbol m}_@{/*0.8 M}^2'
plot files('gavin_NLO_muAsUpLim')  u (zeta_of_x($1)):(min3(@LOcl)/$6):(max3(@LOcl)/$6) w filledcurves lt 11 t 'LO',\
     ''                  u (zeta_of_x($1)):(($9+$10)/$6)                          w l            lt  1 t '',\
     files('gavin_NLO_muAsUpLim')  u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 12 t 'NLO',\
     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  2 t '',\


#     files('gavin_NNLO_muAsUpLim') u (zeta_of_x($1)):(min3(@cols)/$6):(max3(@cols)/$6) w filledcurves lt 13 t 'NNLO',\
#     ''                  u (zeta_of_x($1)):($12/$6)                          w l            lt  3 t '',\
     
# variant where x axis info is not visible (for stacking paper)
textcol='#ff000000'; set xlabel tc rgb textcol; set xtics tc rgb textcol
replot
textcol='#00000000'; set xlabel tc rgb textcol; set xtics tc rgb textcol

set output

