reset
set terminal pdfcairo enhance size 9cm,6.0cm lw 1.5
set output 'check-low-Q2-paper.pdf'



set xlabel 'W^2 [GeV^2]'
run='<../run-tests --write-sigmas --write-W2-Q2 --nx 5000 --xmin 1e-10 '

mpsq=0.938**2
W2(x,Q2)=mpsq+Q2*(1-x)/x

stretch(W2)=1/W2**0.3

W2max=1e4
set xrange  [stretch(1.0):stretch(W2max)]
set xtics ()
do for [ix=0:10] {
  set xtics add ((ix<3?sprintf("%g",10**ix):sprintf("10^{%d}",ix)) stretch(10**ix))
  do for [jx=2:9] {  set xtics add ("" stretch(jx*10**ix) 1)}

}
set xtics add ("3" stretch(3.0),"4" stretch(4.0))

set lmargin at screen 0.2

set x2range [stretch(1.0):stretch(W2max)]

set xtics nomirror
set grid
set yrange [0:1.8]
set mytics 2
set ylabel '{/Symbol s}_{T+L} [GeV^{-2}]'

file(Q2,inelparam)="../validation-files-LUXqed17/inelparam-".inelparam."-Q2-".Q2.".dat"

#do for [Q2val in "1e-5 0.5 1.0 3.0 10.0 15.0 20.0 25.0"] {
do for [Q2val in "1e-5 0.5 3 20"] {
#Q2val="1e-5"

set key spacing 1.4

set lt 1 lw 3.0 dt 1 lc rgb 'black'
set lt 2 lw 1.0 dt 1 lc rgb '#ff2020'
set lt 3 lw 1.5 dt 2 lc rgb '#40a0ff'
set lt 4 lw 0.9 dt 4 lc rgb '#00c000'

set yrange [:1.5]
if (Q2val > 0.9) {set yrange [:0.5]}
if (Q2val > 1.6) {set yrange [:0.1]}
if (Q2val > 9.0) {set yrange [:0.1]}
if (Q2val > 19.) {set yrange [:0.02]}

gen='--gen-x-at-Q2 '.Q2val

if (Q2val == '1e-5') {Q2str = "10^{-5}"}
else                 {Q2str = Q2val}
set label 1 'Q^2 = '.Q2str.' GeV^2' at graph 0.03,0.9


set x2label 'x_{bj}'
set x2tics ()
do for [ix=-9:0] {
  if (ix>-9) {set x2tics add ((ix>-2?sprintf("%g",10**ix):sprintf("10^{%d}",ix)) stretch(W2(10**ix,Q2val)))}
  if (ix<0) {do for [jx=2:9] {  set x2tics add ("" stretch(W2(jx*10**ix,Q2val)) 1)}}
}
set x2tics add ("0.5" stretch(W2(0.5,Q2val)))

plot file(Q2val, 'Hermes_ALLM_CLAS'   ) u (stretch($1)):5 w l t 'GD11-P + CLAS',\
     file(Q2val, 'CLAS'               ) u (stretch($1)):5 w l t 'CLAS',\
     file(Q2val, 'Hermes_ALLM'        ) u (stretch($1)):5 w l t 'GD11-P',\
     file(Q2val, 'Christy_Bosted_pure') u (stretch($1)):5 w l t 'Christy-Bosted',\
     

#     ,\
#     run.gen.' --inelastic-param Hermes_ALLM_CB'    u 1:5 w l lc 1 dt 2 t 'Hermes ALLM + Christy-Bosted'
     
}
set output
