############# Historical GHG Emissions #########################


##д룬֤ڴ
options(java.parameters='-Xms8g')
gc()###ڴ治ʱһ
memory.limit(1024000)


##Ҫʹõİ
library(RJDBC)
library(xlsx)
library(data.table)
library(ggplot2)
library(reshape2)      
library(do)
library(stringr)
library(RColorBrewer)
library(plyr)

################################################## һ׼ ####################################################################
setwd("XXX")##·
RG=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "Regions")##30
Data_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "FAOSTAT")##ͽݵ
Data=melt(Data_W,id=c("Region","Product","Item"),variable.name = "Year",value.name = "Value")#ԭʼΪ

Flows_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName ='Flows')##
Flows=melt(Flows_W,id=c("Region","Flow","Input","Output"),variable.name = "Year",value.name = "Value")#ԭʼΪ

ELC_CI_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "Elc_CI")##30ҵŷϵ
ELC_CI=melt(ELC_CI_W,id=c("Region"),variable.name = "Year",value.name = "CI")#ԭʼΪ
write.xlsx(ELC_CI,file="OUT/Elc_CI.xlsx",sheetName="Elc_CI",append=TRUE)#

Product_P=subset(Data,(Product=="Mechanical wood pulp"|Product=="Chemical wood pulp"|
                         Product=="Pulp from fibres other than wood"|Product=="Recycled pulp"|
                         Product=="Newsprint"|Product=="Printing and writing papers"|
                         Product=="Household and sanitary papers"|Product=="Packaging paper and paperboard"|
                         Product=="Other paper and paperboard")&Item=="Production")##ȡƷݣҪ

################################################## и׶εԴ̼ŷź ##################################################
########################################### һֲͲɷ׶ΡLULCC̼ŷ ###############################################
########################################### 1. ľĲɳ̼ŷ ######################################################
##òֻڿԴExcelм㣬㷽online methodSI
CE_df_W=read.xlsx("INPUT/ForestCarbon/ForestCarbon_Info.xlsx",sheetName = "CE_df")##ǵõλ
CE_df_W=CE_df_W[(1:31),1:60]
names(CE_df_W)=c("Region",1961:2019)#
CE_df=melt(CE_df_W,id=c("Region"),variable.name = "Year",value.name = "Value")#ԭʼΪ
CE_df=CE_df[order(CE_df$Region),]##Regionһ
write.xlsx(CE_df,file="OUT/CarbonEmission.xlsx",sheetName="CE_df",append=TRUE)#


########################################### ԭռ׶Ρܺļ̼ŷ #######################
########################################### 1. ľռ ###########################################
########################################### 1.1 ľռܺ ###########################################
PW=subset(Data,Product=="Pulpwood"&Item=="Production")#ľ
E_wh=PW[,1:4]
E_wh$Value=PW$Value*0.54*(0.13+0.55)#ľռܺģλGJ0.54ton/m3ľĵܶȣĹʹľĵƽܶȣ֡
E_wh=E_wh[,-3]
E_wh=E_wh[order(E_wh$Region),]
write.xlsx(E_wh,file="OUT/CarbonEmission.xlsx",sheetName="E_wh",append=TRUE)#

########################################### 1.2 ľռ̼ŷ ###########################################

CE_wh=matrix(0,1770,3)
for (n in 1:30){
  PW_n=subset(Data,Region==RG[n,2]&Product=="Pulpwood")
  ELC_CI_n=subset(ELC_CI,Region==RG[n,2])
  CE_wh[(59*n-58):(59*n),1]=RG[n,2]
  CE_wh[(59*n-58):(59*n),2]=1961:2019
  CE_wh[(59*n-58):(59*n),3]=PW_n$Value*0.54*0.13*74066.7/1000+PW_n$Value*0.54*0.55*ELC_CI_n$CI/1000#ľռ̼ŷţλkg
}
CE_wh=data.frame(CE_wh)#תݿܼ
names(CE_wh)=c("Region","Year","Value")#
CE_wh=CE_wh[order(CE_wh$Region),]
write.xlsx(CE_wh,file="OUT/CarbonEmission.xlsx",sheetName="CE_wh",append=TRUE)#

########################################### 2. ľռ ###########################################
########################################### 2.1 ľռܺ ###########################################
NW_P=subset(Data,Product=="Pulp from fibres other than wood"&Item=="Production")##
E_nwh=NW_P[,1:4]
E_nwh$Value=(NW_P$Value)*0.3142#ľԭռܺģλGJ
E_nwh=E_nwh[,-3]
E_nwh=E_nwh[order(E_nwh$Region),]
write.xlsx(E_nwh,file="OUT/CarbonEmission.xlsx",sheetName="E_nwh",append=TRUE)#

########################################### 2.2 ľռ̼ŷ ###########################################
CE_nwh=NW_P[,1:4]
CE_nwh$Value=(NW_P$Value)*23.3#ľԭռ̼ţλkg CO223.3kg CO2/t ľǰĵλľռ̼ŷš
CE_nwh=CE_nwh[order(CE_nwh$Region), ]
CE_nwh=CE_nwh[,-3]
write.xlsx(CE_nwh,file="OUT/CarbonEmission.xlsx",sheetName="CE_nwh",append=TRUE)#

########################################### 3. ֽռ ###########################################
########################################### 3.1 ֽռܺ ###########################################
RP_P=subset(Data,Item=="Production"&Product=="Paper for recycling")
E_rpc=RP_P[,1:4]
E_rpc$Value=RP_P$Value*(0.0314+0.0702)#ֽռܺ,GJ
E_rpc=E_rpc[,-3]
E_rpc=E_rpc[order(E_rpc$Region),]
write.xlsx(E_rpc,file="OUT/CarbonEmission.xlsx",sheetName="E_rpc",append=TRUE)#

########################################### 3.2 ֽռ̼ŷ ###########################################
CE_rpc=matrix(0,1770,3)
for (n in 1:30){
  RP_n=subset(Data,Region==RG[n,2]&Product=="Paper for recycling"&Item=="Production")
  ELC_CI_n=subset(ELC_CI,Region==RG[n,2])
  CE_rpc[(59*n-58):(59*n),1]=RG[n,2]
  CE_rpc[(59*n-58):(59*n),2]=1961:2019
  CE_rpc[(59*n-58):(59*n),3]=RP_n$Value*0.0314*74.0667+RP_n$Value*0.0702*ELC_CI_n$CI/1000#ֽռ̼ŷţλkg
}
CE_rpc=data.frame(CE_rpc)#תݿܼ
names(CE_rpc)=c("Region","Year","Value")#
write.xlsx(CE_rpc,file="OUT/CarbonEmission.xlsx",sheetName="CE_rpc",append=TRUE)#

########################################### 4. ԭռ ###########################################
########################################### 4.1 ԭռܺ ###########################################
E_he=E_wh[,1:4]
E_he$Value=E_wh$Value+E_nwh$Value+E_rpc$Value
write.xlsx(E_he,file="OUT/CarbonEmission.xlsx",sheetName="E_he",append=TRUE)#

########################################### 4.2 ԭռ̼ ###########################################
CE_he=CE_wh[,1:2]
CE_he$Value=as.numeric(CE_wh$Value)+CE_nwh$Value+as.numeric(CE_rpc$Value)#ԭռܹ̼ŷ
write.xlsx(CE_he,file="OUT/CarbonEmission.xlsx",sheetName="CE_he",append=TRUE)#

########################################### ѧƷ׶Ρܺļ̼ŷ ###########################################
########################################### 1. ѧƷ׶ܺ ###########################################
Chem=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "Chem")
Chem=subset(Chem,Region!="World")
E_chem=Chem[,1:4]
E_chem$Value=Product_P$Value*Chem$SEC#ֽֽҩƷͶԴģGJ
E_chem=E_chem[,-3]
write.xlsx(E_chem,file="OUT/CarbonEmission.xlsx",sheetName="E_chem",append=TRUE)#

########################################### 2. Ʒϲ ###########################################
E_chem_W=dcast(E_chem,Region+Year~Product,value.var = "Value")
E_chem_W$SUM=rowSums(E_chem_W[,3:11])
E_chem_P=E_chem_W[,-(3:11)]
write.xlsx(E_chem_P,file="OUT/CarbonEmission.xlsx",sheetName="E_chem_P",append=TRUE)#

########################################### 3. ̼ŷ ###########################################
CE_chem=Chem[,1:4]
CE_chem$Value=Product_P$Value*Chem$CI#ֽֽҩƷͶ̼ŷ,kg
CE_chem=CE_chem[,-3]
write.xlsx(CE_chem,file="OUT/CarbonEmission.xlsx",sheetName="CE_chem",append=TRUE)#

########################################### ģˮ̼ŷ ###########################################
Product_P=Product_P[order(Product_P$Region), ]
Product_P=Product_P[order(Product_P$Year), ]
COD_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "WtTrt_COD")
COD=melt(COD_W,id=c("Region","Year"),variable.name = "Product",value.name = "Value")#ԭʼΪ
COD=subset(COD,Region!="World")
COD=COD[order(COD$Region), ]
COD=COD[order(COD$Year), ]
Removal_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "WtTrt_Removal")
Removal=melt(Removal_W,id=c("Region","Year"),variable.name = "Product",value.name = "Value")
Removal=subset(Removal,Region!="World")
Removal=Removal[order(Removal$Region), ]
Removal=Removal[order(Removal$Year), ]
MCF_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "WtTrt_MCF")
MCF=melt(MCF_W,id=c("Region","Year"),variable.name = "Product",value.name = "Value")
MCF=subset(MCF,Region!="World")
MCF=MCF[order(MCF$Region), ]
MCF=MCF[order(MCF$Year), ]
########################################### 1. ŷŵеļ ###########################################
########################################### 1.1 ŷŵе ###########################################
CE_wttrt=COD[,1:3]##ŷŵ̼
CE_wttrt$Value=Product_P$Value*COD$Value*Removal$Value*MCF$Value*0.25*25#25תΪCO2λkg
write.xlsx(CE_wttrt,file="OUT/CarbonEmission.xlsx",sheetName="CE_wttrt",append=TRUE)#

########################################### 1.2 ƽŷŵеļ飨kg CO2-eq ###########################################
CE_wttrt_Pulp=subset(CE_wttrt,(Product=="Mechanical.wood.pulp"|Product=="Chemical.wood.pulp"|
                                 Product=="Pulp.from.fibres.other.than.wood"|Product=="Recovered.fibre.pulp"))#ֽž
CE_wttrt_Pulp_W=dcast(CE_wttrt_Pulp,Region+Year~Product,value.var = "Value")
CE_wttrt_Pulp_W$Value=rowSums(CE_wttrt_Pulp_W[,3:6])
CE_wttrt_Pulp_SUM=CE_wttrt_Pulp_W[,-(3:6)]
write.xlsx(CE_wttrt_Pulp_SUM,file="OUT/CarbonEmission.xlsx",sheetName="CE_wttrt_Pulp",append=TRUE)#

########################################### 1.3 ֽŷŵеļ ###########################################
CE_wttrt_Paper=subset(CE_wttrt,(Product=="Newsprint"|Product=="Printing.and.writing.papers"|
                                  Product=="Household.and.sanitary.papers"|Product=="Packaging.paper.and.paperboard"|
                                  Product=="Other.paper.and.paperboard"))#
CE_wttrt_Paper_W=dcast(CE_wttrt_Paper,Region+Year~Product,value.var = "Value")
CE_wttrt_Paper_W$Value=rowSums(CE_wttrt_Paper_W[,3:7])
CE_wttrt_Paper_SUM=CE_wttrt_Paper_W[,-(3:7)]
write.xlsx(CE_wttrt_Paper_SUM,file="OUT/CarbonEmission.xlsx",sheetName="CE_wttrt_Paper",append=TRUE)#

########################################### 2. ŷŵˮе̼(kg CO2-eq) ###########################################
########################################### 2.1 ŷŵˮе̼(kg CO2-eq) ###########################################
CE_wttrt_ToNature=COD[,1:3]
CE_wttrt_ToNature$Value=((Product_P$Value*COD$Value-19.385)*(1/1.8646)-CE_wttrt$Value*12/(25*16))*44/12#λkg CO2
CE_wttrt_ToNature[CE_wttrt_ToNature<0]=0##滻ֵΪķطʧ
##ֻжʵָù
for (n in 1:1770){
  if(CE_wttrt_ToNature$Value[n]<0){
    CE_wttrt_ToNature$Value[n]=0
  }else{
    CE_wttrt_ToNature$Value[n]=CE_wttrt_ToNature$Value[n]
  }
}##ɹ

write.xlsx(CE_wttrt_ToNature,file="OUT/CarbonEmission.xlsx",sheetName="CE_wttrt_ToNature",append=TRUE)#

########################################### 2.2 ƽŷŵˮе̼(kg CO2-eq) ###########################################
CE_wttrt_ToNature_Pulp=subset(CE_wttrt_ToNature,(Product=="Mechanical.wood.pulp"|Product=="Chemical.wood.pulp"|
                                 Product=="Pulp.from.fibres.other.than.wood"|Product=="Recovered.fibre.pulp"))#ֽž
CE_wttrt_ToNature_Pulp_W=dcast(CE_wttrt_ToNature_Pulp,Region+Year~Product,value.var = "Value")
CE_wttrt_ToNature_Pulp_W$Value=rowSums(CE_wttrt_ToNature_Pulp_W[,3:6])
CE_wttrt_ToNature_Pulp_SUM=CE_wttrt_ToNature_Pulp_W[,-(3:6)]
write.xlsx(CE_wttrt_ToNature_Pulp_SUM,file="OUT/CarbonEmission.xlsx",sheetName="CE_wttrt_ToNature_Pulp",append=TRUE)#

########################################### 2.3 ֽŷŵˮе̼(kg CO2-eq) ###########################################
CE_wttrt_ToNature_Paper=subset(CE_wttrt_ToNature,(Product=="Newsprint"|Product=="Printing.and.writing.papers"|
                                  Product=="Household.and.sanitary.papers"|Product=="Packaging.paper.and.paperboard"|
                                  Product=="Other.paper.and.paperboard"))#ֽž
CE_wttrt_ToNature_Paper_W=dcast(CE_wttrt_ToNature_Paper,Region+Year~Product,value.var = "Value")
CE_wttrt_ToNature_Paper_W$Value=rowSums(CE_wttrt_ToNature_Paper_W[,3:7])
CE_wttrt_ToNature_Paper_SUM=CE_wttrt_ToNature_Paper_W[,-(3:7)]
write.xlsx(CE_wttrt_ToNature_Paper_SUM,file="OUT/CarbonEmission.xlsx",sheetName="CE_wttrt_ToNature_Paper",append=TRUE)#

########################### 壩ʹúͻչ̵̼̼ŷ #########################
########################## 0. ۳ʲֵ #########################
F14=subset(Flows,Flow=="F14")
F14=F14[order(F14$Region), ]
F15=subset(Flows,Flow=="F15")
F15=F15[order(F15$Region), ]
F16=subset(Flows,Flow=="F16")
F16=F16[order(F16$Region), ]
F17=subset(Flows,Flow=="F17")
F17=F17[order(F17$Region), ]
F18=subset(Flows,Flow=="F18")
F18=F18[order(F18$Region), ]
F19=subset(Flows,Flow=="F19")
F19=F19[order(F19$Region), ]
F21=subset(Flows,Flow=="F21")
F21=F21[order(F21$Region), ]
F22=subset(Flows,Flow=="F22")
F22=F22[order(F22$Region), ]
F23=subset(Flows,Flow=="F23")
F23=F23[order(F23$Region), ]
F24=subset(Flows,Flow=="F24")
F24=F24[order(F24$Region), ]
F25=subset(Flows,Flow=="F25")
F25=F25[order(F25$Region), ]
##5ֽƷľ
F38=subset(Flows,Flow=="F38")##NP
F38=F38[order(F38$Region), ]
F39=subset(Flows,Flow=="F39")##PW
F39=F39[order(F39$Region), ]
F40=subset(Flows,Flow=="F40")##HS
F40=F40[order(F40$Region), ]
F41=subset(Flows,Flow=="F41")##PP
F41=F41[order(F41$Region), ]
F42=subset(Flows,Flow=="F42")##OP
F42=F42[order(F42$Region), ]

MBP_AM=read.xlsx("INPUT/PaperMFA/PaperMFA_China.xlsx",sheetName = "MBP_AM")#MBP_AMƽ,
AM=MBP_AM[1:20,3:61]#AMֽ,ǽʹõڰУдֽеķʱ

##ֽƷеʲ
F21_Bio=F15[,1:5]
F21_Bio$Flow="F21_Bio"
F21_Bio$Value=(F15$Value+F38$Value)*0.9
F22_Bio=F16[,1:5]
F22_Bio$Flow="F22_Bio"
F22_Bio$Value=(F16$Value+F39$Value)*(1-as.numeric(AM[8,]))
F23_Bio=F17[,1:5]
F23_Bio$Flow="F23_Bio"
F23_Bio$Value=(F17$Value+F40$Value)*1
F24_Bio=F18[,1:5]
F24_Bio$Flow="F24_Bio"
F24_Bio$Value=(F18$Value+F41$Value)*0.9
F25_Bio=F19[,1:5]
F25_Bio$Flow="F25_Bio"
F25_Bio$Value=(F19$Value+F42$Value)*0.9
  

TPC_Bio=F14[,1:5]
TPC_Bio$Flow="TPC_Bio"
TPC_Bio$Input="Papermaking"
TPC_Bio$Output="Paper and paperboard"
TPC_Bio$Value=F21_Bio$Value+F22_Bio$Value+F23_Bio$Value+F24_Bio$Value+F25_Bio$Value

##ֽֽƽԭͶе
F4=subset(Flows,Flow=="F4")
F4=F4[order(F4$Region), ]
F4_Bio=F4[,1:5]
F4_Bio$Flow="F4_Bio"
F4_Bio$Value=F4$Value*(1-(F21$Value*0.1+F22$Value*as.numeric(AM[8,])+F23$Value*0+F24$Value*0.1+F25$Value*0.1)/
                          (F21$Value+F22$Value+F23$Value+F24$Value+F25$Value))

F43=subset(Flows,Flow=="F43")
F43=F43[order(F43$Region), ]

##ֽе
PFR=F4##PFRָPaPer for Recycling
PFR$Value=F4$Value-F43$Value##ȥڵõF27
PFR_Bio=PFR
PFR_Bio$Flow="PFR_Bio"
PFR_Bio$Value=PFR$Value*(1-(F21$Value*0.1+F22$Value*as.numeric(AM[8,])+F23$Value*0+F24$Value*0.1+F25$Value*0.1)/
                           (F21$Value+F22$Value+F23$Value+F24$Value+F25$Value))##еķʱ뵱ѵֽƷеķʱľֵһ


F9=subset(Flows,Flow=="F9")
F9=F9[order(F9$Region), ]
F10=subset(Flows,Flow=="F10")
F10=F10[order(F10$Region), ]
F11=subset(Flows,Flow=="F11")
F11=F11[order(F11$Region), ]
F12=subset(Flows,Flow=="F12")
F12=F12[order(F12$Region), ]
F13=subset(Flows,Flow=="F13")
F13=F13[order(F13$Region), ]
F26=subset(Flows,Flow=="F26")
F26=F26[order(F26$Region), ]
F27=subset(Flows,Flow=="F27")
F27=F27[order(F27$Region), ]
F28=subset(Flows,Flow=="F28")
F28=F28[order(F28$Region), ]
F29=subset(Flows,Flow=="F29")
F29=F29[order(F29$Region), ]
F30=subset(Flows,Flow=="F30")
F30=F30[order(F30$Region), ]
F31=subset(Flows,Flow=="F31")
F31=F31[order(F31$Region), ]


F15_Bio=F15[,1:5]
F15_Bio$Flow="F15_Bio"
F15_Bio$Value=F15$Value*0.9
F16_Bio=F16[,1:5]
F16_Bio$Flow="F16_Bio"
F16_Bio$Value=F16$Value*(1-as.numeric(AM[8,]))
F17_Bio=F17[,1:5]
F17_Bio$Flow="F17_Bio"
F17_Bio$Value=F17$Value*1
F18_Bio=F18[,1:5]
F18_Bio$Flow="F18_Bio"
F18_Bio$Value=F18$Value*0.9
F19_Bio=F19[,1:5]
F19_Bio$Flow="F19_Bio"
F19_Bio$Value=F19$Value*0.9

F20=subset(Flows,Flow=="F20")
F20=F20[order(F20$Region), ]
F20_Bio=F20[,1:5]
F20_Bio$Flow="F20_Bio"
F20_Bio$Value=(F11$Value+F12$Value+F13$Value)-CE_wttrt_Paper_SUM$Value*12/(25*16*0.45*1000)-
  CE_wttrt_ToNature_Paper_SUM$Value*12/(44*0.45*1000)-
  (F15_Bio$Value+F16_Bio$Value+F17_Bio$Value+F18_Bio$Value+F19_Bio$Value)
  #Papermaking to Paper for recycling

F26_Bio=F26[,1:5]
F26_Bio$Flow="F26_Bio"
F26_Bio$Value=0
F27_Bio=F27[,1:5]
F27_Bio$Flow="F27_Bio"
F27_Bio$Value=0
F28_Bio=F28[,1:5]
F28_Bio$Flow="F28_Bio"
F28_Bio$Value=0
F29_Bio=F29[,1:5]
F29_Bio$Flow="F29_Bio"
F29_Bio$Value=0
F30_Bio=F30[,1:5]
F30_Bio$Flow="F30_Bio"
F30_Bio$Value=0
F31_Bio=F31[,1:5]
F31_Bio$Flow="F31_Bio"
F31_Bio$Value=0


for (n in 1:30){
  MBP_YR=read.xlsx(paste("INPUT/PaperMFA/PaperMFA_",RG[n,2],".xlsx",sep = "",collapse = NULL),sheetName = "MBP_YR")
  YR=MBP_YR[1:10,2:60]#YRǲʱĲ
  F26_Bio$Value[(59*n-58):(59*n)]=TPC_Bio$Value[(59*n-58):(59*n)]*0.09#Use to Stock
  F27_Bio$Value[(59*n-58):(59*n)]=PFR_Bio$Value[(59*n-58):(59*n)]#Use to Paper for recycling
  F28_Bio$Value[(59*n-58):(59*n)]=(TPC_Bio$Value[(59*n-58):(59*n)]+F20_Bio$Value[(59*n-58):(59*n)]-F26_Bio$Value[(59*n-58):(59*n)]-F27_Bio$Value[(59*n-58):(59*n)])*as.numeric(YR[8,])#Use to Incineration
  F29_Bio$Value[(59*n-58):(59*n)]=(TPC_Bio$Value[(59*n-58):(59*n)]+F20_Bio$Value[(59*n-58):(59*n)]-F26_Bio$Value[(59*n-58):(59*n)]-F27_Bio$Value[(59*n-58):(59*n)])*as.numeric(YR[6,])#Use to Energy recovery
  F30_Bio$Value[(59*n-58):(59*n)]=(TPC_Bio$Value[(59*n-58):(59*n)]+F20_Bio$Value[(59*n-58):(59*n)]-F26_Bio$Value[(59*n-58):(59*n)]-F27_Bio$Value[(59*n-58):(59*n)])*as.numeric(YR[7,])#Use to Non-energy recovery
  F31_Bio$Value[(59*n-58):(59*n)]=TPC_Bio$Value[(59*n-58):(59*n)]+F20_Bio$Value[(59*n-58):(59*n)]-F26_Bio$Value[(59*n-58):(59*n)]-F27_Bio$Value[(59*n-58):(59*n)]-
    F28_Bio$Value[(59*n-58):(59*n)]-F29_Bio$Value[(59*n-58):(59*n)]-F30_Bio$Value[(59*n-58):(59*n)]#Use to Landfill
}

Flows_Bio=rbind(F4_Bio,F15_Bio,F16_Bio,F17_Bio,F18_Bio,F19_Bio,F20_Bio,F21_Bio,F22_Bio,F23_Bio,F24_Bio,F25_Bio,F26_Bio,
               F27_Bio,F28_Bio,F29_Bio,F30_Bio,F31_Bio)
Flows_Bio_W=dcast(Flows_Bio,Region+Flow+Input+Output~Year,value.var = "Value")
Flows_Bio_W[Flows_Bio_W<0]=0
Flows_Bio_W[is.na(Flows_Bio_W)]=0
write.xlsx(Flows_Bio_W,file="OUT/Flows.xlsx",sheetName="Flows_Bio",append=TRUE)#

########################### 1. Ʒ #########################
########################### 1.1 ֽƷ #########################
Product_NI=subset(Data,(Product=="Mechanical wood pulp"|Product=="Chemical wood pulp"|
                          Product=="Pulp from fibres other than wood"|Product=="Recycled pulp"|
                          Product=="Newsprint"|Product=="Printing and writing papers"|
                          Product=="Household and sanitary papers"|Product=="Packaging paper and paperboard"|
                          Product=="Other paper and paperboard")&Item=="Net import"&Region!="World")#ֽž
Product_C=Product_P[,1:4]
Product_C$Value=Product_P$Value+Product_NI$Value#=+
Product_C$Item="Consumption"
Paper_C=subset(Product_C,Product=="Newsprint"|Product=="Printing and writing papers"|
                 Product=="Household and sanitary papers"|Product=="Packaging paper and paperboard"|
                 Product=="Other paper and paperboard")
Paper_C=Paper_C[,-3]
Paper_C_W=dcast(Paper_C,Region+Year~Product,value.var = "Value")
write.xlsx(Paper_C_W,file="OUT/Product_Data.xlsx",sheetName="Paper_C_W",append=TRUE)#

########################## 1.2 ֽƷ ###########################################
Pulp_C=subset(Product_C,Product=="Mechanical wood pulp"|Product=="Chemical wood pulp"|
                Product=="Pulp from fibres other than wood"|Product=="Recycled pulp")
Pulp_C=Pulp_C[,-3]
Pulp_C_W=dcast(Pulp_C,Region+Year~Product,value.var = "Value")
write.xlsx(Pulp_C_W,file="OUT/Product_Data.xlsx",sheetName="Pulp_C_W",append=TRUE)#

######################### 1.3 ƷγɲƷ̼㣨ѡCS_ps_Bio_SUM#############
##Ʒֲ̼Ʒ
##ų˷ʲ
Paper_C_Bio=rbind(F21_Bio,F22_Bio,F23_Bio,F24_Bio,F25_Bio)
Paper_C_Bio=Paper_C_Bio[,-(2:3)]
names(Paper_C_Bio)=c("Region","Product","Year","Value")
Paper_C_Bio$Year=1961:2019
CS_ps_Bio=Paper_C_Bio[,1:3]
CS_ps_Bio$Value=Paper_C_Bio$Value*0.09*0.45*44*1000/12#λΪkg CO2
write.xlsx(CS_ps_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CS_ps_Bio",append=TRUE)#
##Ʒ̼
#####ų˷########
CS_ps_Bio_W=dcast(CS_ps_Bio,Region+Year~Product,value.var = "Value")
CS_ps_Bio_SUM=CS_ps_Bio_W[,1:2]
CS_ps_Bio_SUM$Value=rowSums(CS_ps_Bio_W[,3:7])
write.xlsx(CS_ps_Bio_SUM,file="OUT/CarbonEmission.xlsx",sheetName="CS_ps_Bio_SUM",append=TRUE)#


########################## 2.ȼղ̼ŷţѡCE_inc_Bio̼#########################
################ų˷###########
CE_inc_Bio=matrix(0,1770,3)
for (n in 1:30){
  CE_inc_Bio[(59*n-58):(59*n),1]=RG[n,2]
  CE_inc_Bio[(59*n-58):(59*n),2]=1961:2019
  CE_inc_Bio[(59*n-58):(59*n),3]=F28_Bio$Value[(59*n-58):(59*n)]*0.45*1000*44/12#յλΪkg.
}
CE_inc_Bio=data.frame(CE_inc_Bio)#תݿܼ
names(CE_inc_Bio)=c("Region","Year","Value")#
write.xlsx(CE_inc_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CE_inc_Bio",append=TRUE)#

##########################3.Դ###################
################### 3.1 Դղֵ̼ŷţѡCE_er_mw_Bio̼#########################
###########ų˷############
CE_er_mw_Bio=matrix(0,1770,3)
for (n in 1:30){
  CE_er_mw_Bio[(59*n-58):(59*n),1]=RG[n,2]
  CE_er_mw_Bio[(59*n-58):(59*n),2]=1961:2019
  CE_er_mw_Bio[(59*n-58):(59*n),3]=F29_Bio$Value[(59*n-58):(59*n)]*0.45*1000*44/12#յλΪkg
}
CE_er_mw_Bio=data.frame(CE_er_mw_Bio)#תݿܼ
names(CE_er_mw_Bio)=c("Region","Year","Value")#
write.xlsx(CE_er_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CE_er_mw_Bio",append=TRUE)#

########################## 3.2 յԴѡE_er_mw#########################
E_er_mw=matrix(0,1770,3)
for (n in 1:30){
  F29=subset(Flows,Region==RG[n,2]&Flow=="F29")
  ELC_CI_n=subset(ELC_CI,Region==RG[n,2])
  E_er_mw[(59*n-58):(59*n),1]=RG[n,2]
  E_er_mw[(59*n-58):(59*n),2]=1961:2019
  F29[is.na(F29)]=0
  E_er_mw[(59*n-58):(59*n),3]=F29$Value*13#յλGJ
}
E_er_mw=data.frame(E_er_mw)#תݿܼ
names(E_er_mw)=c("Region","Year","Value")#
write.xlsx(E_er_mw,file="OUT/CarbonEmission.xlsx",sheetName="E_er_mw",append=TRUE)


########################## 3.3 Դձ̼ŷšѡAE_er_mw#########################
AE_er_mw=matrix(0,1829,3)
for (n in 1:30){
  F29=subset(Flows,Region==RG[n,2]&Flow=="F29")
  ELC_CI_n=subset(ELC_CI,Region==RG[n,2])
  AE_er_mw[(59*n-58):(59*n),1]=RG[n,2]
  AE_er_mw[(59*n-58):(59*n),2]=1961:2019
  AE_er_mw[(59*n-58):(59*n),3]=F29$Value*0.013*0.25*ELC_CI_n$CI#յλΪkg CO2
}
AE_er_mw=data.frame(AE_er_mw)#תݿܼ
names(AE_er_mw)=c("Region","Year","Value")#
write.xlsx(AE_er_mw,file="OUT/CarbonEmission.xlsx",sheetName="AE_er_mw",append=TRUE)#

##########################4.#########################
######################4.0 ͷCO2ѡCO2_lf_mw_Bio̼#############################################
CO2_lf_mw_Bio=matrix(0,1770,3)
CO2_lf_mw_Bio_n=matrix(0,59,1)
for (n in 1:30){
  Landfill_P=F31_Bio$Value[(59*n-58):(59*n)]
  t=seq(1961,2019,1)
  for (i in 2:59) {
    j=1:i
    CO2_lf_mw_Bio_n[i,1]=sum((1-exp(-0.05))*Landfill_P[j]*0.7*0.45*0.5*0.5*
                              (44/12)*exp(-0.05*(t[i]-t[j])))*1000#λΪkg
  }
  CO2_lf_mw_Bio[(59*n-58):(59*n),1]=RG[n,2]
  CO2_lf_mw_Bio[(59*n-58):(59*n),2]=1961:2019
  CO2_lf_mw_Bio[(59*n-58):(59*n),3]=CO2_lf_mw_Bio_n
}
CO2_lf_mw_Bio=data.frame(CO2_lf_mw_Bio)#תݿܼ
names(CO2_lf_mw_Bio)=c("Region","Year","Value")#
write.xlsx(CO2_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CO2_lf_mw_Bio",append=TRUE)#

###################### 4.1 ͷCH4ѡCE_lf_mw_Bio̼ŷţ̼#############################################
###########ų˷############
CE_lf_mw_Bio=matrix(0,1770,3)
CE_lf_mw_Bio_n=matrix(0,59,1)
for (n in 1:30){
  Landfill_P=F31_Bio$Value[(59*n-58):(59*n)]
  t=seq(1961,2019,1)
  for (i in 2:59) {
    j=1:i
    CE_lf_mw_Bio_n[i,1]=sum((1-exp(-0.05))*Landfill_P[j]*0.7*0.45*0.5*0.5*
                              (16/12)*exp(-0.05*(t[i]-t[j]))*
                              (1-0.25)*(1-0.05))*25*1000#λΪkg
  }
  CE_lf_mw_Bio[(59*n-58):(59*n),1]=RG[n,2]
  CE_lf_mw_Bio[(59*n-58):(59*n),2]=1961:2019
  CE_lf_mw_Bio[(59*n-58):(59*n),3]=CE_lf_mw_Bio_n
}
CE_lf_mw_Bio=data.frame(CE_lf_mw_Bio)#תݿܼ
names(CE_lf_mw_Bio)=c("Region","Year","Value")#
write.xlsx(CE_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CE_lf_mw_Bio",append=TRUE)#

########################### 4.2 CH4ռ #########################
########################### 4.2.1 CH4ռȼ̼ŷţѡCECP_lf_mw_Bio̼#########################
########ų˷###########
CECP_lf_mw_Bio=CE_lf_mw_Bio[,1:2]
CECP_lf_mw_Bio$Value=as.numeric(CE_lf_mw_Bio$Value)*0.25*44/(25*(1-0.25)*(1-0.05)*16)#յλΪkg CH4
write.xlsx(CECP_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CECP_lf_mw_Bio",append=TRUE)#

########################## 4.2.2 CH4ռӦGJѡE_lf_mw_Bio#########################
#####ų˷########
E_lf_mw_Bio=CECP_lf_mw_Bio[1:2]
E_lf_mw_Bio$Value=as.numeric(CE_lf_mw_Bio$Value)*0.25/(25*(1-0.25)*(1-0.05))*0.048*1000*0.35#ļ鵥λΪkg, ȻֵΪ0.048TJ/tonòҪתλΪGJ
write.xlsx(E_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="E_lf_mw_Bio",append=TRUE)#

#######################4.2.3CH4ռŷţѡAE_lf_mw_Bio#########################
########ų˷###########
AE_lf_mw_Bio=CE_lf_mw_Bio[1:2]
ELC_CI=subset(ELC_CI,Region!="World")
AE_lf_mw_Bio$Value=as.numeric(CE_lf_mw_Bio$Value)*0.25/(25*(1-0.25)*(1-0.05))*0.048*0.35*ELC_CI$CI/1000#CCP_lfλΪkg, ȻֵΪ0.048TJ/tonЧ0.35ELC_CIλΪkg CO2/TJλΪkg
write.xlsx(AE_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="AE_lf_mw_Bio",append=TRUE)#


##########################4.3 ݳCO2CESC_lf_mw_Bio#####################################################
########ų˷##########
CESC_lf_mw_Bio=CE_lf_mw_Bio[,1:2]
CESC_lf_mw_Bio$Value=(as.numeric(CE_lf_mw_Bio$Value)/25)*(0.05/(1-0.05))*44/16#յλΪkg
write.xlsx(CESC_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CESC_lf_mw_Bio",append=TRUE)#

################4.4 ̼㡪ѡCS_lf_mw_Bio######
########ʹÿinflowͷųȥĲ֣Outflowõ############
##1961֮ǰĴΪ0֮ǰ
########ų˷###########
CS_lf_mw_Bio=matrix(0,1770,3)
for (n in 1:30){
  CS_lf_mw_Bio[(59*n-58):(59*n),1]=RG[n,2]
  CS_lf_mw_Bio[(59*n-58):(59*n),2]=1961:2019
  F31_Bio[is.na(F31_Bio)]=0
  CS_lf_mw_Bio[(59*n-58):(59*n),3]=(F31_Bio$Value[(59*n-58):(59*n)]*0.45*1000-as.numeric(CO2_lf_mw_Bio$Value[(59*n-58):(59*n)])*12/44-
    as.numeric(CE_lf_mw_Bio$Value[(59*n-58):(59*n)])*12/(25*16)-CECP_lf_mw_Bio$Value[(59*n-58):(59*n)]*12/44-
    CESC_lf_mw_Bio$Value[(59*n-58):(59*n)]*12/44)*44/12#յλΪkg
}
CS_lf_mw_Bio=data.frame(CS_lf_mw_Bio)#תݿܼ
names(CS_lf_mw_Bio)=c("Region","Year","Value")#
write.xlsx(CS_lf_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CS_lf_mw_Bio",append=TRUE)#

############ 5. Դ̼################
##ų
CS_ner_mw_Bio=matrix(0,1770,3)
for (n in 1:30){
  CS_ner_mw_Bio[(59*n-58):(59*n),1]=RG[n,2]
  CS_ner_mw_Bio[(59*n-58):(59*n),2]=1961:2019
  F30_Bio[is.na(F30_Bio)]=0
  CS_ner_mw_Bio[(59*n-58):(59*n),3]=F30_Bio$Value[(59*n-58):(59*n)]*0.45*1000*44/12#յλΪkg CO2
}
CS_ner_mw_Bio=data.frame(CS_ner_mw_Bio)#תݿܼ
names(CS_ner_mw_Bio)=c("Region","Year","Value")#
write.xlsx(CS_ner_mw_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CS_ner_mw_Bio",append=TRUE)#


###################### ȥ ###################
########################## 1.ҵԴ#########################
########################## 1.1ҵԴղֵ̼ŷţCE_er_iw#########################
##Ͳ
CE_er_iw=matrix(0,1770,3)
for (n in 1:30){
  F32=subset(Flows,Region==RG[n,2]&Flow=="F32")
  CE_er_iw[(59*n-58):(59*n),1]=RG[n,2]
  CE_er_iw[(59*n-58):(59*n),2]=1961:2019
  CE_er_iw[(59*n-58):(59*n),3]=F32$Value*1000*0.45*44/12#յλΪkgCO2
}
CE_er_iw=data.frame(CE_er_iw)#תݿܼ
names(CE_er_iw)=c("Region","Year","Value")#
CE_er_iw[CE_er_iw<0]=0
write.xlsx(CE_er_iw,file="OUT/CarbonEmission.xlsx",sheetName="CE_er_iw",append=TRUE)


########################## 1.2 ҵյԴѡE_er_iw#########################
##ͲʣѾ۳ʣȫˣ
E_er_iw=matrix(0,1770,3)
for (n in 1:30){
  F32=subset(Flows,Region==RG[n,2]&Flow=="F32")
  ELC_CI_n=subset(ELC_CI,Region==RG[n,2])
  E_er_iw[(59*n-58):(59*n),1]=RG[n,2]
  E_er_iw[(59*n-58):(59*n),2]=1961:2019
  F32[is.na(F32)]=0
  E_er_iw[(59*n-58):(59*n),3]=F32$Value*1000*0.0156#յλGJ.Ͳľһ
}
E_er_iw=data.frame(E_er_iw)#תݿܼ
names(E_er_iw)=c("Region","Year","Value")#
E_er_iw[E_er_iw<0]=0
write.xlsx(E_er_iw,file="OUT/CarbonEmission.xlsx",sheetName="E_er_iw",append=TRUE)

########################## 1.3 ҵԴձ̼ŷţѡAE_er_iw#########################
##Ͳ
AE_er_iw=matrix(0,1770,3)
for (n in 1:30){
  F32=subset(Flows,Region==RG[n,2]&Flow=="F32")
  ELC_CI_n=subset(ELC_CI,Region==RG[n,2])
  AE_er_iw[(59*n-58):(59*n),1]=RG[n,2]
  AE_er_iw[(59*n-58):(59*n),2]=1961:2019
  AE_er_iw[(59*n-58):(59*n),3]=F32$Value*1000*0.0156*0.25*ELC_CI_n$CI/1000#յλΪkg CO2
}
AE_er_iw=data.frame(AE_er_iw)#תݿܼ
names(AE_er_iw)=c("Region","Year","Value")#
AE_er_iw[AE_er_iw<0]=0
write.xlsx(AE_er_iw,file="OUT/CarbonEmission.xlsx",sheetName="AE_er_iw",append=TRUE)#

################################ ߣ̼ܺŷ ####################################################
################################ 1. ֱܺ(¶ϣ*) #########################################
Product_P_E=dcast(Product_P,Region+Year~Product,value.var = "Value")
Product_P_E$Printing=Product_P_E$Newsprint+Product_P_E$`Printing and writing papers`+Product_P_E$`Packaging paper and paperboard`*0.17
Product_P_E=melt(Product_P_E,id=c("Region","Year"),variable.name = "Product",value.name = "Value")#ԭʼΪ
Product_P_E=Product_P_E[order(Product_P_E$Product), ]
Product_P_E=Product_P_E[order(Product_P_E$Region), ]
Product_P_E$Year=1961:2019
Product_P_E=Product_P_E[order(Product_P_E$Year), ]
Product_P_W=dcast(Product_P_E,Region+Year~Product,value.var = "Value")
write.xlsx(Product_P_W,file="OUT/Product_Data.xlsx",sheetName="Product_P_W",append=TRUE)#һ


SEC_prd_W=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "Production_SEC")
SEC_prd_W=SEC_prd_W[,1:12]
SEC_prd=melt(SEC_prd_W,id=c("Region","Year"),variable.name = "Product",value.name = "Value")#ԭʼΪ
SEC_prd=SEC_prd[order(SEC_prd$Region), ]
SEC_prd=SEC_prd[order(SEC_prd$Year), ]
SEC_prd=subset(SEC_prd,Region!="World")
E_prd=SEC_prd[,1:3]
E_prd$Value=Product_P_E$Value*SEC_prd$Value/1000000000#λΪGJ
write.xlsx(E_prd,file="OUT/CarbonEmission.xlsx",sheetName="E_prd",append=TRUE)#E_prd׶δвƷṹֱܺ

############################################### 2. ֱܵܺ ##############################################################
E_prd_W=dcast(E_prd,Region+Year~Product,value.var = "Value")
E_prd_W$Total=E_prd_W$Chemical.wood.pulp+E_prd_W$Household.and.sanitary.papers+E_prd_W$Mechanical.wood.pulp+
  E_prd_W$Newsprint+E_prd_W$Other.paper.and.paperboard+E_prd_W$Packaging.paper.and.paperboard+
  E_prd_W$Printing.and.writing.papers+E_prd_W$Pulp.from.fibres.other.than.wood+E_prd_W$Recycled.pulp+E_prd_W$Printing
E_prd_P=E_prd_W[,-(3:12)]
names(E_prd_P)=c("Region","Year","Value")
write.xlsx(E_prd_P,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_P",append=TRUE)#E_prd_P׶ֱܵܺ

############################################# 3. Դ #####################################################################
##############IEAԴṹõԴVSͨʧʺ͹ҵԴõԴ########
############################################# 3.1 IEAԴṹõԴ(Դ)Դ͵ĳܺĵܺĻܵõ #####
E_prd_Pri_IEA=read.xlsx(file="INPUT/Energy structure and emissions.xlsx",sheetName="TCV1960")
E_prd_Pri_IEA=subset(E_prd_Pri_IEA,Region!="World")
E_prd_Pri_Bio_IEA=E_prd_Pri_IEA[,1:2]
E_prd_Pri_Bio_IEA$Value=rowSums(E_prd_Pri_IEA[,28:36])
E_prd_Pri_Bio_IEA$Value=E_prd_Pri_Bio_IEA$Value*1000
write.xlsx(E_prd_Pri_Bio_IEA,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Pri_Bio_IEA",append=TRUE)#E_prd_BioWstIEAԴṹõʹܣ

############################################ 3.2 ͨʧʺ͹ҵԴõԴ(Դ) ##################################
F1=subset(Flows,Flow=="F1")
F1=F1[order(F1$Region), ]
F2=subset(Flows,Flow=="F2")
F2=F2[order(F2$Region), ]
F3=subset(Flows,Flow=="F3")                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
F3=F3[order(F3$Region), ]
Wood=F1[,-(2:4)]
Wood=Wood[,-3]
Wood$Value=F1$Value+F2$Value
Otherfibre=F3[,-(2:4)]
Otherfibre=Otherfibre[,-3]
Otherfibre$Value=F3$Value
E_er_iw=read.xlsx(file="OUT/CarbonEmission.xlsx",sheetName="E_er_iw")#빤Դ
E_er_iw_EW=subset(E_er_iw,Region!=0)
E_prd_BioWst_estm=E_er_iw_EW[,2:3]
E_prd_BioWst_estm$Value=Wood$Value*0.056*15.6/(1-0.056)+Otherfibre$Value*0.056*14.7/(1-0.056)+as.numeric(E_er_iw_EW$Value)#estmβ׺ֵֵ;0.056ʧʣ15.6GJ/t
##ľı߽Ϲ
E_prd_BioWst_estm$WoodE=Wood$Value*0.056*15.6/(1-0.056)+Otherfibre$Value*0.056*14.7/(1-0.056)#14.7GJ/TonйԴͳԴ۱úοϵֽոѵľֵ
E_prd_BioWst_estm$iwer=as.numeric(E_er_iw_EW$Value)
write.xlsx(E_prd_BioWst_estm,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Pri_BioWst_estm",append=TRUE)#E_prd_BioWst_estmǹԴӦ

########################################### 3.3 ʳԴĶԱ ############################################
##E_prd_Bio_CmprIEAʹԼʹ
E_prd_Bio_Cmpr=E_prd_BioWst_estm[,1:2]
E_prd_Bio_Cmpr$IEA=E_prd_Pri_Bio_IEA$Value
E_prd_Bio_Cmpr$Estm=E_prd_BioWst_estm$Value
E_prd_Bio_Cmpr_L=melt(E_prd_Bio_Cmpr,id=c("Year","Region"),variable.name = "Item",value.name = "Value")
write.xlsx(E_prd_Bio_Cmpr_L,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Bio_Cmpr",append=TRUE)
##
E_prd_Bio_Cmpr=read.xlsx(file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Bio_Cmpr")
##ͼ
p=ggplot(subset(E_prd_Bio_Cmpr,Region!="World"), mapping = aes(x = Year, y = Value/1000000, group=Item,colour=Item)) + geom_line(size=0.8,aes())+
  theme_bw() + theme(panel.grid = element_blank())+
  theme(text=element_text(family='calibri'),
        plot.title=element_text(size=10,hjust=0.5,face="bold"),
        axis.text.x=element_text(size=8,face="bold"),
        axis.text.y=element_text(size=7,face="bold"))+
  theme( strip.background.x = element_rect(
    color="black", fill="#bbbbbb", size=0.5, linetype="solid"
  ),
  strip.background.y = element_rect(
    color="black", fill="green", size=0.5, linetype="solid"
  ),
  panel.border = element_rect(color = 'black'))+
  theme(panel.spacing.x = unit(0.5, "cm"),
        panel.spacing.y = unit(0.2, "cm"))+
  theme(
    strip.text.x = element_text(
      size = 8, color = "black", face = "bold.italic"
    ), # x᷽ͣ
    strip.text.y = element_text(
      size = 8, color = "red", face = "bold.italic"
    ) # y᷽ͣ
  )+
  labs(text=element_text(family='calibri'),y="Bio-Energy consumption: PJ",x='Year',title='Bio-Energy Consumption Comparison',colour="Bio-Energy consumption")+
  facet_wrap(~Region,ncol=5,scales = "free")+
  scale_x_discrete(breaks=seq(1960, 2020, 20))
p
ggsave(p, file="OUT/Plot/EnergyConsumption/BioEComp.jpeg", width=12, height=8)

############################################### 4. Դͽṹֱܺ ###################################################
E_prd_Bio=E_prd_Pri_Bio_IEA
E_prd_Bio$Value=E_prd_BioWst_estm$Value*0.85
E_prd_ExBio=E_prd_Bio
E_prd_ExBio$Value=E_prd_P$Value-E_prd_Bio$Value
E_prd_ExBio[E_prd_ExBio<0]
ES_ExBio=read.xlsx("INPUT/Energy structure and emissions.xlsx",sheetName = "TCV1960_%_EB")#ES_ExBioǻIEAݼġȥԴֱܺĵԴṹǵ˹ҵԴѽṹݲϵ
E_prd_ExBio_ES=E_prd_Bio
E_prd_ExBio_ES[,3:32]=E_prd_ExBio$Value*ES_ExBio[,3:32]
E_prd_ES=E_prd_ExBio_ES
E_prd_ES$Wood=E_prd_BioWst_estm$WoodE*0.85
E_prd_ES$Black.liquid=E_prd_BioWst_estm$iwer*0.85
write.xlsx(E_prd_ES,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_ES",append=TRUE)#E_prd_ESǷԴͽṹֱܺ

############################################### 5. Դͽṹĳܺ ######################################
ETF=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "ETF")#ETFǷԴ͵תЧ
ETF=subset(ETF,Region!="World")
E_prd_ES_Pri=E_prd_ES[,3:32]/ETF[,3:32]
E_prd_ES_Pri=cbind(E_prd_ES[,1:2],E_prd_ES_Pri)#ݺ͹
write.xlsx(E_prd_ES_Pri,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_ES_Pri",append=TRUE)#E_prd_ES_PriǷԴͽṹĳܺ


############################################## 6. ܵĳܺ #################################
E_prd_Pri=E_prd_ES_Pri[,1:2]
E_prd_Pri$Value=rowSums(E_prd_ES_Pri[,3:32])
write.xlsx(E_prd_Pri,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Pri",append=TRUE)#E_prd_PriIEAԴṹõܳܺ

#################################### 7. һ񣬽̵ܳܺİʺͷʷֿ#######################
##ñCarbonEmissionйһsheetΪE_prd_BioOrNot_AllEstm
E_prd_BioOrNot_AllEstm=E_prd_BioWst_estm[,1:2]
E_prd_BioOrNot_AllEstm$E_prd_Bio=E_prd_BioWst_estm$Value
E_prd_BioOrNot_AllEstm$E_prd_ExBio=E_prd_Pri$Value-E_prd_BioOrNot_AllEstm$E_prd_Bio
write.xlsx(E_prd_BioOrNot_AllEstm,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_BioOrNot_AllEstm_Pri",append=TRUE)

############################# 8. 䵽ƷϣǷ ##############################
############################# 8.1 ÿֲƷԴĽṹ #####################################
##ѳܺĺͺ̼ŷ䵽ÿֲƷӦÿֲƷԴĵĽṹȥ䣬Ӧñ
E_prd=read.xlsx(file="OUT/CarbonEmission.xlsx",sheetName="E_prd")
E_prd=E_prd[,-1]#ȥûõ
E_prd_W=dcast(E_prd,Region+Year~Product,value.var = "Value")
E_prd_W$SUM=rowSums(E_prd_W[,3:12])
E_prd_PS=cbind(E_prd_W[,1:2],E_prd_W[,3:12]/E_prd_W$SUM)##E_prd_PSΪԴİղƷı
write.xlsx(E_prd_PS,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_PS%",append=TRUE)#ñ

############################# 8.2 ֲƷṹͷǷܵĳܺ ######################################
##ȰղƷܺģֲƷṹĳܺ
E_prd_PS=read.xlsx(file="OUT/CarbonEmission.xlsx",sheetName="E_prd_PS%")#ñ
E_prd_PS=E_prd_PS[,-1]#ȥ
E_prd_Pri_PS=E_prd_Pri$Value*E_prd_PS[,3:12]
E_prd_Pri_PS=cbind(E_prd_Pri[,1:2],E_prd_Pri_PS)
write.xlsx(E_prd_Pri_PS,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Pri_PS",append=TRUE)#E_prd_Pri_PSǷֲƷṹĳܺ
##CarbonEmissionйΪE_prd_Pri_PS_BioOrNotsheetȴE_prd_BioOrNot_AllEstmнE_prd_BioE_prd_ExBioճE_prd_Pri_PS_BioOrNotMN
##CWPNWPPR̳ܺı
E_prd_Pri_PS_pct=E_prd_Pri_PS
E_prd_Pri_PS_pct[,3:12]=E_prd_Pri_PS[,3:12]/
  (rowSums(E_prd_Pri_PS[,3:12])-E_prd_Pri_PS$Chemical.wood.pulp-E_prd_Pri_PS$Printing-
     E_prd_Pri_PS$Pulp.from.fibres.other.than.wood)
E_prd_Pri_PS_pct$Chemical.wood.pulp=0
E_prd_Pri_PS_pct$Printing=0
E_prd_Pri_PS_pct$Pulp.from.fibres.other.than.wood=0
E_prd_Pri_PS_pct[is.na(E_prd_Pri_PS_pct)]=0
##ȷCWP_BioNWP_Bio,Ȼܷ̣Ҫԭ
##ٵʹСڻѧƽܺĵ85%ʱܺİֻѧƽܺıַ
##ڵʹܴڻѧƽܺĵ85%ʱֻѧƽ85%Դƽָ
E_prd_Pri_PS_BioOrNot=E_prd_Pri_PS_pct[,1:2]
E_prd_BioOrNot_AllEstm$E_prd_Bio[is.na(E_prd_BioOrNot_AllEstm$E_prd_Bio)]=0
E_prd_Pri_PS[is.na(E_prd_Pri_PS)]=0
for (n in 1:1770){
  if(E_prd_BioOrNot_AllEstm$E_prd_Bio[n]-(E_prd_Pri_PS$Chemical.wood.pulp[n]+E_prd_Pri_PS$Pulp.from.fibres.other.than.wood[n])*0.85<0){
    E_prd_Pri_PS_BioOrNot$CWP_Bio[n]=E_prd_BioOrNot_AllEstm$E_prd_Bio[n]*E_prd_Pri_PS$Chemical.wood.pulp[n]/
      (E_prd_Pri_PS$Chemical.wood.pulp[n]+E_prd_Pri_PS$Pulp.from.fibres.other.than.wood[n])
    E_prd_Pri_PS_BioOrNot$NWP_Bio[n]=E_prd_BioOrNot_AllEstm$E_prd_Bio[n]*E_prd_Pri_PS$Pulp.from.fibres.other.than.wood[n]/
      (E_prd_Pri_PS$Chemical.wood.pulp[n]+E_prd_Pri_PS$Pulp.from.fibres.other.than.wood[n])
  }else{
    E_prd_Pri_PS_BioOrNot$CWP_Bio[n]=E_prd_Pri_PS$Chemical.wood.pulp[n]*0.85
    E_prd_Pri_PS_BioOrNot$NWP_Bio[n]=E_prd_Pri_PS$Pulp.from.fibres.other.than.wood[n]*0.85
  }
}
E_prd_Pri_PS_BioOrNot$HS_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Household.and.sanitary.papers
E_prd_Pri_PS_BioOrNot$MP_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Mechanical.wood.pulp
E_prd_Pri_PS_BioOrNot$NP_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Newsprint
E_prd_Pri_PS_BioOrNot$OP_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Other.paper.and.paperboard
E_prd_Pri_PS_BioOrNot$PP_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Packaging.paper.and.paperboard
E_prd_Pri_PS_BioOrNot$PR_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Printing
E_prd_Pri_PS_BioOrNot$PW_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Printing.and.writing.papers
E_prd_Pri_PS_BioOrNot$RP_Bio=(E_prd_BioOrNot_AllEstm$E_prd_Bio-E_prd_Pri_PS_BioOrNot$CWP_Bio-E_prd_Pri_PS_BioOrNot$NWP_Bio)*E_prd_Pri_PS_pct$Recycled.pulp
##
E_prd_Pri_PS_BioOrNot$CWP_ExBio=E_prd_Pri_PS$Chemical.wood.pulp-E_prd_Pri_PS_BioOrNot$CWP_Bio
E_prd_Pri_PS_BioOrNot$NWP_ExBio=E_prd_Pri_PS$Pulp.from.fibres.other.than.wood-E_prd_Pri_PS_BioOrNot$NWP_Bio
E_prd_Pri_PS_BioOrNot$HS_ExBio=E_prd_Pri_PS$Household.and.sanitary.papers-E_prd_Pri_PS_BioOrNot$HS_Bio
E_prd_Pri_PS_BioOrNot$MP_ExBio=E_prd_Pri_PS$Mechanical.wood.pulp-E_prd_Pri_PS_BioOrNot$MP_Bio
E_prd_Pri_PS_BioOrNot$NP_ExBio=E_prd_Pri_PS$Newsprint-E_prd_Pri_PS_BioOrNot$NP_Bio
E_prd_Pri_PS_BioOrNot$OP_ExBio=E_prd_Pri_PS$Other.paper.and.paperboard-E_prd_Pri_PS_BioOrNot$OP_Bio
E_prd_Pri_PS_BioOrNot$PP_ExBio=E_prd_Pri_PS$Packaging.paper.and.paperboard-E_prd_Pri_PS_BioOrNot$PP_Bio
E_prd_Pri_PS_BioOrNot$PR_ExBio=E_prd_Pri_PS$Printing-E_prd_Pri_PS_BioOrNot$PR_Bio
E_prd_Pri_PS_BioOrNot$PW_ExBio=E_prd_Pri_PS$Printing.and.writing.papers-E_prd_Pri_PS_BioOrNot$PW_Bio
E_prd_Pri_PS_BioOrNot$RP_ExBio=E_prd_Pri_PS$Recycled.pulp-E_prd_Pri_PS_BioOrNot$RP_Bio
write.xlsx(E_prd_Pri_PS_BioOrNot,file="OUT/CarbonEmission.xlsx",sheetName="E_prd_Pri_PS_BioOrNot",append=TRUE)
############################# 9. ̡̼(¶) ####################################################
##Դ̼
CC=read.xlsx("INPUT/Global Paper_Info.xlsx",sheetName = "CO2_Con")
CC=subset(CC,Region!="World")
##Դ̼ŷ
CE_prd=E_prd_ES_Pri[,3:32]*CC[,3:32]/1000#λkg CO2
CE_prd=cbind(E_prd_ES_Pri[,1:2],CE_prd)
names(CE_prd)=c(colnames(E_prd_ES_Pri))##һ䲻Ҳԣԭȷ
CE_prd$SUM=rowSums(CE_prd[,3:32])#
CE_prd$Bio=rowSums(CE_prd[,28:29])#Դ̼ŷţҵȼϣ
CE_prd$ExBio=CE_prd$SUM-CE_prd$Bio#ʯԴ̼ŷ
write.xlsx(CE_prd,file="OUT/CarbonEmission.xlsx",sheetName="CE_prd",append=TRUE)#Դṹ̼ŷţڳܺģ

##½ʺͷ̼ŷֱ
CE_prd_SUM=CE_prd[,1:2]
CE_prd_SUM$Value=CE_prd$SUM
write.xlsx(CE_prd_SUM,file="OUT/CarbonEmission.xlsx",sheetName="CE_prd_SUM",append=TRUE)#ŷֵ

CE_prd_Bio=CE_prd[,1:2]
CE_prd_Bio$Value=CE_prd$Bio
write.xlsx(CE_prd_Bio,file="OUT/CarbonEmission.xlsx",sheetName="CE_prd_Bio",append=TRUE)#Դŷ

CE_prd_ExBio=CE_prd[,1:2]
CE_prd_ExBio$Value=CE_prd$ExBio
write.xlsx(CE_prd_ExBio,file="OUT/CarbonEmission.xlsx",sheetName="CE_prd_ExBio",append=TRUE)#Դŷ

##˵
##ԴֻӦѧƽͷľĻѧƽƽֽԴڻʯԴ
##ǣCarbonEmissionйһsheetΪE_prd_Pri_PS_BioOrNotֲƷԴṹ
##һΪCE_prd_PS_BioOrNotsheetżֲƷԴṹԴ̼ŷ
E_prd_Pri_PS_BioOrNot=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = "E_prd_Pri_PS_BioOrNot")
E_prd_Pri_PS_BioOrNot=E_prd_Pri_PS_BioOrNot[,-1]
CE_prd_PS_BioOrNot=E_prd_Pri_PS_BioOrNot
CE_prd_Bio=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = "CE_prd_Bio")
CE_prd_Bio=CE_prd_Bio[,-1]
CE_prd_ExBio=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = "CE_prd_ExBio")
CE_prd_ExBio=CE_prd_ExBio[,-1]
CE_prd_PS_BioOrNot[,3:12]=CE_prd_Bio$Value*E_prd_Pri_PS_BioOrNot[,3:12]/rowSums(E_prd_Pri_PS_BioOrNot[,3:12])
CE_prd_PS_BioOrNot[,13:22]=CE_prd_ExBio$Value*E_prd_Pri_PS_BioOrNot[,13:22]/rowSums(E_prd_Pri_PS_BioOrNot[,13:22])
CE_prd_PS_BioOrNot[,23:32]=CE_prd_PS_BioOrNot[,3:12]+CE_prd_PS_BioOrNot[,13:22]
CE_prd_PS_BioOrNot[is.na(CE_prd_PS_BioOrNot)]=0
write.xlsx(CE_prd_PS_BioOrNot,file="OUT/CarbonEmission.xlsx",sheetName="CE_prd_PS_BioOrNot",append=TRUE)#Դŷ
##עñ23:32Уֶ޸һ¡


############################## ˣﴦ #######################
############################## 0. Ƚ⣺߽Դ ############
############################## 0.1 ߽ϲ̼ ############
E_prd_Pri_BioWst_estm=read.xlsx("OUT/CarbonEmission.xlsx",sheetName="E_prd_Pri_BioWst_estm")
CE_WoodE=E_prd_Pri_BioWst_estm
CE_WoodE=CE_WoodE[,-1]
CE_WoodE=CE_WoodE[,-(3:6)]
CE_prd_Bio=read.xlsx("OUT/CarbonEmission.xlsx",sheetName="CE_prd_Bio")
CE_er_iw=CE_prd$Black.liquid
CE_WoodE$Value=CE_prd$Wood
write.xlsx(CE_WoodE,file="OUT/CarbonEmission.xlsx",sheetName="CE_WoodE",append=TRUE)

############################## 0.2 ߽ϻյԴ#########################
E_WoodE=CE_WoodE
E_WoodE=E_WoodE[,-3]
E_WoodE$Value=CE_WoodE$Value*(12*0.0147)/(0.45*44)##߽ϵλֵΪ0.0147
write.xlsx(E_WoodE,file="OUT/CarbonEmission.xlsx",sheetName="E_WoodE",append=TRUE)
##ѾڱϵͳˣԸԴ̼ŷŲټս

############################## 0.3 ߽Դձ̼ŷ#########################
###Ͳ
ELC_CI=ELC_CI[order(ELC_CI$Region), ]
ELC_CI=subset(ELC_CI,Region!="World")
AE_WoodE=E_WoodE
AE_WoodE=AE_WoodE[,-3]
AE_WoodE$Value=E_WoodE$Value*0.25*ELC_CI$CI/1000##0.25ת
write.xlsx(AE_WoodE,file="OUT/CarbonEmission.xlsx",sheetName="AE_WoodE",append=TRUE)#
##ѾڱϵͳˣԸԴ̼ŷŲټսչʾҵ߶Դĺô

############################## ͼǰ׼ ###################################################
##############################һֲƷĽ׶Σתݣ #####################
##reshape2еdcastݳת
TN1=c( "CE_chem","CE_wttrt","CS_ps_Bio","E_chem")
for (i in 1:4){
  data0=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = TN1[i])
  data0$Value=as.numeric(data0$Value)
  data_P=dcast(data0,Region+Year~Product,value.var = "Value")
  NC=ncol(data_P)
  data_PA=data_P[,3:NC]
  data_T=data_P[,1:2]
  data_T$Value=apply(data_PA,1,sum)
  write.xlsx(data_T,file="OUT/CarbonEmission.xlsx",sheetName=paste(TN1[i],"_P",sep = "",collapse = NULL),append=TRUE)
}

############################## ܺı ##########################################
#ڹ±֮ǰȷһ
E_prd_Pri=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = "E_prd_Pri")
E_prd_Pri=E_prd_Pri[,-1]
TN2=c("E_chem_P","E_he","E_nwh", "E_rpc","E_wh","E_prd_Pri")
Energy=matrix(0,1770,6)
Energy=data.frame(Energy)
Energy[,1:2]=E_prd_Pri[,1:2]
    for (i in 1:6){
      Energy_i=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = TN2[i])
      Energy_i=subset(Energy_i,Region!="World")
      Energy_i=Energy_i[order(Energy_i$Region), ]
      Energy[,i+2]=as.numeric(Energy_i$Value)
    }
names(Energy)=c("Region","Year","E_chem_P","E_he","E_nwh", "E_rpc","E_wh","E_prd_Pri")
write.xlsx(Energy,file="OUT/EnergySheet.xlsx",sheetName="EnergySheet")

############################## ̼ŷ ###################################################
############################## 1. ̼ŷź̼洢 ###################################################
TN2=c("CS_ps_Bio_SUM", "CS_lf_mw_Bio","CS_ner_mw_Bio",
      "AE_er_mw","AE_lf_mw_Bio","AE_er_iw","AE_WoodE",
      "CE_df","CE_wh","CE_nwh","CE_rpc","CE_chem_P","CE_wttrt_Pulp","CE_wttrt_Paper","CE_wttrt_ToNature_Pulp","CE_wttrt_ToNature_Paper",
      "CE_prd_ExBio","CE_prd_Bio",
      "CE_inc_Bio","CE_er_mw_Bio", "CO2_lf_mw_Bio","CE_lf_mw_Bio","CECP_lf_mw_Bio","CESC_lf_mw_Bio",
      "CE_er_iw","CE_WoodE")
CE_prd=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = "CE_prd")
Carbon=matrix(0,1770,28)
Carbon=data.frame(Carbon)
Carbon[,1:2]=CE_prd[,2:3]

for (i in 1:7){
  Carbon_i=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = TN2[i])
  Carbon_i=Carbon_i[order(Carbon_i$Region), ]
  Carbon_i=subset(Carbon_i,Region!="World"&Region!=0)
  Carbon[,i+2]=-as.numeric(Carbon_i$Value)
}

for (i in 8:26){
  Carbon_i=read.xlsx("OUT/CarbonEmission.xlsx",sheetName = TN2[i])
  Carbon_i=Carbon_i[order(Carbon_i$Region), ]
  Carbon_i=subset(Carbon_i,Region!="World"&Region!=0)
  Carbon[,i+2]=as.numeric(Carbon_i$Value)
}
names(Carbon)=c("Year","Region","CS_ps_Bio_SUM", "CS_lf_mw_Bio","CS_ner_mw_Bio",
                "AE_er_mw","AE_lf_mw_Bio","AE_er_iw","AE_WoodE",
                "CE_df","CE_wh","CE_nwh","CE_rpc","CE_chem_P","CE_wttrt_Pulp","CE_wttrt_Paper","CE_wttrt_ToNature_Pulp","CE_wttrt_ToNature_Paper",
                "CE_prd_ExBio","CE_prd_Bio",
                "CE_inc_Bio","CE_er_mw_Bio", "CO2_lf_mw_Bio","CE_lf_mw_Bio","CECP_lf_mw_Bio","CESC_lf_mw_Bio",
                "CE_er_iw","CE_WoodE")
Carbon[is.na(Carbon)]=0##˹1992ǰȱʧֵΪ0
write.xlsx(Carbon,file="OUT/CarbonSheet_BioCarbonNeutral.xlsx",sheetName="CarbonSheet")

############################## 2. طࡢͼǰ׼ȴԴ̼ŷΪ̼  ###################################################
##ݷ󣬶̼̼Դط
CarbonSheet=read.xlsx(file="OUT/CarbonSheet_BioCarbonNeutral.xlsx",sheetName="CarbonSheet")
CarbonSheet=CarbonSheet[,-1]##ѵһûõȥ
Carbon_ReCls= CarbonSheet[,1:2]##ǰе
##ÿһ
Carbon_ReCls$CS_ps=CarbonSheet$CS_ps_Bio_SUM
Carbon_ReCls$CS_lf=CarbonSheet$CS_lf_mw_Bio
Carbon_ReCls$CS_ner=CarbonSheet$CS_ner_mw_Bio-CarbonSheet$CE_wttrt_ToNature_Pulp-CarbonSheet$CE_wttrt_ToNature_Paper
Carbon_ReCls$AE_er=CarbonSheet$AE_er_mw
Carbon_ReCls$AE_lf=CarbonSheet$AE_lf_mw_Bio
Carbon_ReCls$CE_df=CarbonSheet$CE_df
Carbon_ReCls$CE_he=CarbonSheet$CE_wh+CarbonSheet$CE_nwh+CarbonSheet$CE_rpc
Carbon_ReCls$CE_chem=CarbonSheet$CE_chem_P
Carbon_ReCls$CE_wttrt=CarbonSheet$CE_wttrt_Pulp+CarbonSheet$CE_wttrt_Paper
Carbon_ReCls$CE_prd_EXBio=CarbonSheet$CE_prd_ExBio
Carbon_ReCls$CE_inc=CarbonSheet$CE_inc_Bio
Carbon_ReCls$CE_er=CarbonSheet$CE_er_mw_Bio+CarbonSheet$CE_er_iw+CarbonSheet$CE_WoodE
Carbon_ReCls$CE_lf=CarbonSheet$CE_lf_mw_Bio
Carbon_ReCls$CECP_lf=CarbonSheet$CECP_lf_mw_Bio
Carbon_ReCls$CESC_lf=CarbonSheet$CO2_lf_mw_Bio+CarbonSheet$CESC_lf_mw_Bio
##Уֱ̼㡢̼ź;̼
Carbon_ReCls$CS=rowSums(Carbon_ReCls[,3:7])/10^9##CEʾCarbon Sink or Carbon Stock
Carbon_ReCls$CE=(Carbon_ReCls$CE_df+Carbon_ReCls$CE_he+Carbon_ReCls$CE_chem+Carbon_ReCls$CE_wttrt+
  Carbon_ReCls$CE_prd_EXBio+Carbon_ReCls$CE_lf)/10^9##CEʾCarbon Emission
Carbon_ReCls$NCE=Carbon_ReCls$CE+Carbon_ReCls$CS##NCEʾNet Carbon Emission
Carbon_ReCls[is.na(Carbon_ReCls)]=0##ȱʧֵ滻Ϊ0

Carbon_ReCls_YearSum=matrix(0,30,ncol(Carbon_ReCls))
for (n in 1:30){
  Carbon_ReCls_YearSum[n,1]="1961_2019"
  Carbon_ReCls_YearSum[n,2]=RG[n,2]
  Carbon_ReCls_YearSum[n,3:ncol(Carbon_ReCls)]=as.numeric(unlist(colSums(Carbon_ReCls[(59*n-58):(59*n),3:ncol(Carbon_ReCls)])))
}
Carbon_ReCls_YearSum=data.frame(Carbon_ReCls_YearSum)##תݿ
names(Carbon_ReCls_YearSum)=colnames(Carbon_ReCls)
Carbon_ReCls=rbind(Carbon_ReCls,Carbon_ReCls_YearSum)##ۻӽȥ
Carbon_ReCls[,3:ncol(Carbon_ReCls)]=as.numeric(unlist(Carbon_ReCls[,3:ncol(Carbon_ReCls)]))
##
write.xlsx(Carbon_ReCls,file="OUT/CarbonSheet_BioCarbonNeutral.xlsx",sheetName="Carbon_ReCls",append = TRUE)##

