function varargout = videoSelectionDialog(varargin)
% VIDEOSELECTIONDIALOG MATLAB code for videoSelectionDialog.fig
%      VIDEOSELECTIONDIALOG, by itself, creates a new VIDEOSELECTIONDIALOG or raises the existing
%      singleton*.
%
%      H = VIDEOSELECTIONDIALOG returns the handle to a new VIDEOSELECTIONDIALOG or the handle to
%      the existing singleton*.
%
%      VIDEOSELECTIONDIALOG('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VIDEOSELECTIONDIALOG.M with the given input arguments.
%
%      VIDEOSELECTIONDIALOG('Property','Value',...) creates a new VIDEOSELECTIONDIALOG or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before videoSelectionDialog_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to videoSelectionDialog_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help videoSelectionDialog

% Last Modified by GUIDE v2.5 13-Nov-2015 13:58:32

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @videoSelectionDialog_OpeningFcn, ...
                   'gui_OutputFcn',  @videoSelectionDialog_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before videoSelectionDialog is made visible.
function videoSelectionDialog_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to videoSelectionDialog (see VARARGIN)

% Choose default command line output for videoSelectionDialog
handles.output = hObject;
handles.selection = 'folder';
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes videoSelectionDialog wait for user response (see UIRESUME)
%uiwait(hObject);


% --- Outputs from this function are returned to the command line.
function varargout = videoSelectionDialog_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
uiwait;
% Get default command line output from handles structure
try %this statement is necessary if figure is destroyed , then output argument will be empty by default
    handles = guidata(hObject);
    varargout{1} = handles.file;
    varargout{2} = handles.selection;
    close(gcf); % close the gui if OK is pressed
catch
    varargout{1} = [];
end


% --- Executes on button press in selectvideo.
function selectvideo_Callback(hObject, eventdata, handles)
% hObject    handle to selectvideo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch handles.selection
    case 'folder'
        file = uigetdir;
    case 'video'
        [fileName,filePath] = uigetfile({'*.avi;*.mp4;*.mov',...
            'Video Files (*.avi;*.mp4;*.mov';
            '*.*',  'All Files (*.*)'}, ...
            'Pick a video file');
        file = [filePath fileName];
    case 'tiff'
        [fileName,filePath] = uigetfile({'*.tif;*.tiff'}, ...
            'Pick a multipage tif');
        file = [filePath fileName];
        
end
handles.file = file;
guidata(hObject, handles);
uiresume;




% --- Executes when selected object is changed in uipanel1.
function uipanel1_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanel1 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
switch get(eventdata.NewValue,'Tag') % Get Tag of selected object.
    case 'folder'
        set(handles.selectvideo,'String','Select Folder');
        handles.selection = 'folder';
    case 'video'
        set(handles.selectvideo,'String','Select Video');
        handles.selection = 'video';
    case 'tiff'
        set(handles.selectvideo,'String','Select Tiff');
        handles.selection = 'tiff';
end
guidata(hObject, handles);


% --- Executes on button press in folder.
function folder_Callback(hObject, eventdata, handles)
% hObject    handle to folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of folder
