% simple script to stabilize constantly changing brightness
% LW 2021


function CaOut = stabilizeCaBrightness(CaIn)
[nBox, nFrames] = size(CaIn);

%%% do by region
% CaOut = zeros(nBox, nFrames);
% 
% for ibox = 1:nBox
%     p = polyfit(1:nFrames,CaIn(ibox,:),1);
%     meanLine = polyval(p,1:nFrames);
%     meanLine = meanLine - min(meanLine);
%     CaOut(ibox,:) = CaIn(ibox,:) - meanLine;
% end

% do for whole frame
CaMean = mean(CaIn);
p = polyfit(1:nFrames,CaMean,1);
meanLine = polyval(p,1:nFrames);
meanLine = meanLine - min(meanLine);
CaOut = CaIn - meanLine;