% runme_batch.m
% allows batch running of analysis to optimize box size
% Louis Woodhams 03/2020

% Choose vector of Box sizes here
% boxVector = round(logspace(log10(3),log10(256),20));
boxVector = 15:2:95;

% get rid of pesky waitbars
F = findall(0,'type','figure','tag','TMWWaitbar');
delete(F);
% ---------------------------
% load the file to process
% ---------------------------
[file,inputType] = videoSelectionDialog;
% file = input('Name of array to process? : ');
% show = input('Show Results? (yes/no)[no]','s');
show = 'no';
% unwarp = input('Run virtual Blebbistatin? (yes/no)[no]','s');
unwarp = 'no';



% ---------------------------
% initialize the video
% ---------------------------
getFrameTimes = false;

% file = array2rgb(file); % convert to rgb
% inputType = 'mat'; % we are giving the program an array
% inputType = 'tif';
video = initializeVideo(inputType,getFrameTimes,file);

count = 1;
for bxSize = boxVector
% ---------------------------
% set options for processing the video
% ---------------------------
% bxSize = 53;    % size of mesh boxes
ARP = 0.90;     % Analysis Region Percentage
options = setLKoptions('WarpType'                           ,'affine2d',    ...
    'ImageProcessing.InterpolantWarnings',false,         ...
    'CameraCalibration'                  ,'off',         ...
    'Meshing.mode'                       ,'centerBoxes', ...
    'Meshing.AnalysisRegionPrecentage'   , [ARP ARP],    ...
    'Meshing.boxSize'                    , [bxSize bxSize],      ...
    'Meshing.spacing'                    , [bxSize bxSize],      ...
    'ImageProcessing.FrameResize.Ratio'  , 1,            ...
    'ImageProcessing.Filter.Function'    , @(x)adapthisteq(x));

% ---------------------------
% process the data
% ---------------------------
[mechanics,stats,preComp] = lkInverseCompositional(video,options);
nPix = bxSize^2*numel(stats(2).imageError);
myStats(count) = getStatsDDE(stats,nPix);
count = count+1;
end

%% 
iterations = horzcat(myStats.mIter);
convergence = horzcat(myStats.mConverged);
imageErr = horzcat(myStats.mImageErr);
imageErr = log10(imageErr);
imageErr = imageErr/max(imageErr);

figure(1)
subplot(3,1,1)
plot(boxVector, convergence,'.-')
ylabel('convergence fraction')
grid
subplot(3,1,2)
plot(boxVector, iterations,'.-')
ylabel('# iterations avg.')
grid
subplot (3,1,3)
plot(boxVector, imageErr)
ylabel('image error')
xlabel('box size (pix)')
ylabel('avg. image error')
grid
