% Virtual Blebbistatin / lkmechanics main file
% Software based on work by John Boyle
% This software is provided for educational use only. Please see LICENSE.md
% for terms of use.
%
% When using these tools, please cite the article which describes the
% method (http://rsif.royalsocietypublishing.org/content/11/100/20140685)
% and the NIH/NSF grant U01 EB016422 that funded the work.

% Show results of strain mapping after completion?
showStrains = false;

% Apply 'virtual blebbistatin' unwarping to images?
unwarp = true;


% ---------------------
% housekeeping
% ---------------------
% opengl software % option may be required in some cases for compatibility
% Delete waitbars if they do not close properly
F = findall(0,'type','figure','tag','TMWWaitbar');
delete(F);

% ---------------------------
% load the file to process
% ---------------------------
% Use video selection dialog or process an array from the workspace
[file,inputType] = videoSelectionDialog;
% file = input('Name of array to process? : ');



% ---------------------------
% initialize the video
% ---------------------------
getFrameTimes = false;

% file = array2rgb(file); % convert to rgb
% inputType = 'mat'; % if we are giving the program an array
% inputType = 'tif';
video = initializeVideo(inputType,getFrameTimes,file);

% ---------------------------
% set options for processing the video
% ---------------------------
boxSize = 50;    % size of mesh boxes in pixels
ARP = 0.90;     % Analysis Region Percentage [fraction 0-1]
options = setLKoptions('WarpType'        ,'affine2d',    ...
    'ImageProcessing.InterpolantWarnings',false,         ...
    'CameraCalibration'                  ,'off',         ...
    'Meshing.mode'                       ,'centerBoxes', ...
    'Meshing.AnalysisRegionPrecentage'   , [ARP ARP],    ...
    'Meshing.boxSize'                    , [boxSize boxSize],      ...
    'Meshing.spacing'                    , [boxSize boxSize],      ...
    'ImageProcessing.FrameResize.Ratio'  , 1,            ...
    'ImageProcessing.Filter.Function'    , @(x)adapthisteq(x));

% ---------------------------
% process the data
% ---------------------------
[mechanics,stats,preComp] = lkInverseCompositional(video,options);

% ---------------------------
% show the output
% ---------------------------
if showStrains
    showResults(mechanics,stats,video,options);
end

%% virtual blebbistatin
if unwarp
    disp('Unwarping frames...')
    % Do not prefilter images to be unwarped
    options.ImageProcessing.Filter.on = false;
    
    % Run virtual blebbistatin unwarping, convert to uint8 for size
    unwarped = im2uint8(vBlebb(video,mechanics,options,preComp));
    unwarped = squeeze(unwarped);
    
    disp('Making direct comparison array...')
    % get the original video for comparison
    orig = zeros(size(unwarped),'uint8');
    for f = 1:1:numel(video.Frames)
        [~,RGBImage] = getVideoFrame(video,video.Frames(f),options);
        orig(:,:,f) = im2uint8(RGBImage);
    end
    side_by_side = [orig, unwarped];
    % array2video(side_by_side) % to make a video from array
end
disp('Done.')