function PC = preComputation(gradients,regions,template,options)
%% precomputation function
% goes through each region and computes everything
% check if regions are of consistent size
consistentDimensions = options.Meshing.ConsistentDimensions; % check if consistent dimensions
warpType = options.WarpType; % get the warp type
numberOfRegions = numel(regions); % check number of regions

if consistentDimensions % if we have consistent dimensions compute a single Jacobian
    x = regions(1); % get the first region
    [~,x] = normalizeCoordinateSystem(x); % center it's coordinates x
    % compute it's jacobian. use this for all other precomputations
    dWdP = computeJacobians(x,warpType);
end
nRstr = num2str(numberOfRegions); % going to need this string a lot, just save it
% go through each region and perform precomputation, saving the result
h = waitbar(0,['1 /' nRstr],'Name',['Precomputing ' nRstr ...
    ' regions...'], 'CreateCancelBtn','setappdata(gcbf,''canceling'',1)');
for idx = 1:numberOfRegions
    % Check for Cancel button press
    if getappdata(h,'canceling')
        break
    end
    if consistentDimensions % check if all regions are consistent sizes
        PC(idx) = preComputeRegion(gradients,template,regions(idx),options.is3d,dWdP); % if they are the jacobian was calculated above, pass it along
    else % if regions are not same size, jacobians have to be calculated for each region, don't pass a jacobian
        PC(idx) = preComputeRegion(gradients,template,regions(idx),options.is3d);
    end
    waitbar(idx/numberOfRegions,h,[num2str(idx) '/' nRstr]) % update waitbar
end
delete(h)
end

function r = preComputeRegion(gradients,template,X,is3d,jacobian)
%%
% ------------------------------------------------------------------------
% check number of inputs to determine if we need to calculate a jacobian for this region
% ------------------------------------------------------------------------
if nargin<3 % jacobians are not specified, so we need to calculate them
    computeAllJacobians = true;
else
    computeAllJacobians = false;
    dWdP = jacobian;
end
% ------------------------------------------------------------------------
% center and compute coordinate system of X
% ------------------------------------------------------------------------
[N,x] = normalizeCoordinateSystem(X);

% ------------------------------------------------------------------------
% if we need to compute a jacobian for the region compute it
% ------------------------------------------------------------------------
if computeAllJacobians % if jacobians are not given they must be computed!
    dWdP = computeJacobians(warp,x); % NOTE will need to UPDATE this if we recompute a region
end

% ------------------------------------------------------------------------
% perform precomputation
% ------------------------------------------------------------------------
% get the gradient pixels corresponding to the region


VTx = gradients.x(X.x,X.y); VTx = VTx(:);
VTy = gradients.y(X.x,X.y); VTy = VTy(:);

% compute del gradient * jacobian (VTdWdP)
xn = numel(VTx); % get number of x elements
nP = size(dWdP,2); % get number of parameters
VTdWdP = zeros(xn,nP);

for j = 1:xn % VT*dW/dp in equations 35 and 36
    VTdWdP(j,:) = [VTx(j) VTy(j)] * [dWdP(j,:,1) ; dWdP(j,:,2)];
end

% compute hessian
H = VTdWdP'*VTdWdP;
HLM = diag(sum(VTdWdP.^2));
% compute inverse hessian
Hinv = inv(H);
% grab the template image

r.template = template(X.x,X.y);

%% save outputs
r.N = N; % save conversion matrix for the specfic region
% r.dWdP = dWdP; % save jacobian ***DISABLED FOR NOW***
r.VTdWdP = VTdWdP; % save del template * jacobian
r.H = H; % save hessian matrix
r.HLM = HLM; % save Levenberg-Marquadt Hessian matrix
r.Hinv = Hinv; % save inverted Hessian
r.X.x = X.x; % save the x coordinates
r.X.y = X.y; % save the y coordinates
end