function [vidArrayOut] = plotSomeQuantity(mechanics, Q)
%plotSomeQuantity - plot a quantity with a value at each region location
%
% inputs:
%   mechanics - mechanics file from Boyle DDE code
%   Q - a quantity array with the same format as the mechanics.x array
% outputs:
%   vidOutArray - video array interpolation of quantity Q

% center of warped box(x)
x = mechanics.x;

[IMheight, IMwidth, ~] = size(unwarped);
[Xim, Yim] = meshgrid(1:IMwidth, 1:IMheight);
X1 = unique(x(1,:,1));
Y1 = unique(x(2,:,1));
vidArrayOut = zeros(size(unwarped));

% create an interpolant for each frame, evaluate it at all pixel locations
for frame = 1:dims(4)
    nQ = reshape(Q(:,frame),[length(Y1) length(X1)]);
    interpQ = griddedInterpolant({X1(:),Y1(:)},nQ','cubic','none');
    frameQ = interpQ(Xim,Yim);
    frameQ(isnan(frameQ)) = 1;
    vidArrayOut(:,:,frame) = frameQ;
end