% function plotE1vsFluo(mechanics,unwarped)

%%
[ht, wd, frames] = size(unwarped);
regions = length(preComp);
E2 = squeeze(mechanics.DDE.EI(1,1,:,:));

% Q = quantity to plot
Q = E2;

Ca2 = zeros(regions,frames);

% this loop is time consuming - speed it up?
w = waitbar(0,'working...');
tic
for r = 1:regions
    waitbar(r/regions,w);
    x = preComp(r).X.x;
    y = preComp(r).X.y;
    % x,y seem funny here...investigate
    xIm = uint16((0.5+x)*ht);
    yIm = uint16((0.5+y)*wd);
    rIm1 = im2double(unwarped(xIm,yIm,1));
    meanIm = mean(rIm1(:));
    parfor f = 2:frames
        rIm = im2double(unwarped(xIm,yIm,f));
        Ca2(r,f) = mean(rIm(:)) - meanIm;
    end
end
toc
%% plot results
xn = round(linspace(1,regions,9));
Q = -(J-1);
for n = 1:9
    figure(1)
    subplot(3,3,n)
    plot(1:frames,Ca2(xn(n),:), 1:frames,Q(xn(n),:))
    figure(2)
    subplot(3,3,n)
    plot(Ca2(xn(n),:), Q(xn(n),:))
    xlabel('Ca2+')
    ylabel('contraction')
end
