%% Update this with map, etc.....from matlab figures file!!!


%% get calcium above baseline
%CaVid = aboveBaseline(unwarped);
CaVid = aboveBaseline(orig);

%% get calcium intensity at regions
Ca2 = getIntensity(CaVid,preComp);

%% get dilation
J = getJ(mechanics);
[regions, frames] = size(J);
J = 1-J; % turn into contraction

%% apply smoothing

J = sgolayfilt(J',3,11)';


%% plot results
xn = round(linspace(1,regions,9));
num = numel(xn);
rc = ceil(sqrt(num));
for n = 1:num
    figure(1)
    subplot(rc,rc,n)
    plot(1:frames,Ca2(xn(n),:), 1:frames,J(xn(n),:))
    grid
     if n == 1, legend('Ca2 signal','contraction'), end
    figure(2)
    subplot(rc,rc,n)
    plot(Ca2(xn(n),:), J(xn(n),:))
    xlabel('Ca2+')
    ylabel('contraction')
    %grid
end

figure(3)
subplot(2,1,1)
Javg = mean(J,1);
Cavg = mean(Ca2,1);
plot(Cavg(:),Javg(:))
xlabel('calcium')
ylabel('contraction')
subplot(2,1,2)
plot(Cavg), hold on
plot(Javg), hold off
legend('Ca','Contraction')
