close all

% deformation gradient tensor (F)
F = mechanics.DDE.F;
% center of warped box(x)
x = mechanics.x;

dims = size(F);
J = zeros(dims([3 4]));
tic
% for each frame and each region (box) take the determinant of the DGT
for frame = 1:dims(4)
    for bx = 1:dims(3)
        J(bx,frame)=det(F(:,:,bx,frame));
    end
end
disp('time to get J')
toc
%%
[IMheight, IMwidth, ~] = size(unwarped);
[Xim, Yim] = meshgrid(1:IMwidth, 1:IMheight);
X1 = unique(x(1,:,1));
Y1 = unique(x(2,:,1));
rx = length(Y1); 
cx = length(X1);
rowIndex = 1:rx*cx;
rowIndex = reshape(rowIndex,[rx,cx]);
rowIndex = rowIndex.';
fig(1) = figure(1);
fig(1).Name = 'dilatation';
for i = 1:rx*cx
    subplot(rx,cx,rowIndex(i))
    plot(J(i,:))
    ylim([0.8 1.2])
end
fig(2) = figure(2);
fig(2).Name = 'covariance';
for i = 1:dims(3)
    covec = xcov(J(1,:),J(i,:),'normalized');
%    f = (1- abs((1:427) - 214)/213);
%     cor = cor./f;
    [cMax(i),cInd(i)] = max(abs(covec));
    subplot(rx,cx,rowIndex(i))
    plot(1:427,covec)
    ylim([-1 1])
    line([214 214],[-1, 1],'color','red')
end

%%
cMax = reshape(cMax,[length(Y1) length(X1)]);
cInd = reshape(cInd-214,[length(Y1) length(X1)]);
figure(3)
imagesc(cMax)
title('max covariance')
colorbar

figure(4)
imagesc(cInd)
colorbar
title('frame delay')
% create an interpolant for each frame, evaluate it at all pixel locations
% for frame = 1:dims(4)
%     nJ = reshape(J(:,frame),[length(Y1) length(X1)]);
%     interpJ = griddedInterpolant({X1(:),Y1(:)},nJ','linear','none');
%     frameJ = interpJ(Xim,Yim);
%     frameJ(isnan(frameJ)) = 1;
%     dilation(:,:,frame) = frameJ;
% end
% disp('time to interpolate')
