close all

E2 = squeeze(mechanics.DDE.EI(2,2,:,:));
%%
[IMheight, IMwidth, ~] = size(unwarped);
[Xim, Yim] = meshgrid(1:IMwidth, 1:IMheight);
X1 = unique(x(1,:,1));
Y1 = unique(x(2,:,1));
rx = length(Y1); 
cx = length(X1);
rowIndex = 1:rx*cx;
rowIndex = reshape(rowIndex,[rx,cx]);
rowIndex = rowIndex.';
fig(1) = figure(1);
fig(1).Name = '2nd principal strain';
E2 = E2 - min(E2,[],2);
for i = 1:rx*cx
    subplot(rx,cx,rowIndex(i))
    plot(E2(i,:))
    ylim([0 .08])
end
fig(2) = figure(2);
fig(2).Name = 'covariance';
for i = 1:dims(3)
    covec = xcov(E2(1,:),E2(i,:),'normalized');
%    f = (1- abs((1:427) - 214)/213);
%     cor = cor./f;
    [cMax(i),cInd(i)] = max(covec);
    c0(i) = covec(214);
    subplot(rx,cx,rowIndex(i))
    plot(1:427,covec)
    ylim([-1 1])
    line([214 214],[-1, 1],'color','red')
end

%%
c0 = reshape(c0,[length(Y1) length(X1)]);
cMax = reshape(cMax,[length(Y1) length(X1)]);
cInd = reshape(cInd-214,[length(Y1) length(X1)]);
figure(3)
imagesc(cMax)
title('max covariance')
colorbar

figure(4)
imagesc(cInd)
colorbar
title('frame delay')

figure(5)
imagesc(c0)
colorbar
title('covariance at zero delay')
% create an interpolant for each frame, evaluate it at all pixel locations
% for frame = 1:dims(4)
%     nJ = reshape(J(:,frame),[length(Y1) length(X1)]);
%     interpJ = griddedInterpolant({X1(:),Y1(:)},nJ','linear','none');
%     frameJ = interpJ(Xim,Yim);
%     frameJ(isnan(frameJ)) = 1;
%     dilation(:,:,frame) = frameJ;
% end
% disp('time to interpolate')
