function convStats = getStatsDDE(stats, nPix)
%GETSTATSDDE - get DDE convergence statistics data into a compact structure form
% convStats = getStatsDDE(stats)

% Louis Woodhams 02/2020

n = length (stats);
mIterPerFrame = zeros(n,1);
mConvergedPerFrame = zeros(n,1);
mConvergedPerFrame(1) = 1;
mImageErrPerFrame = zeros(n,1);

for frame = 2:n
    mIterPerFrame(frame) = mean(stats(frame).iterations);
    mConvergedPerFrame(frame) = mean(stats(frame).converged);
    mImageErrPerFrame(frame) = sum(stats(frame).imageError)/nPix;
end

mIter = mean(mIterPerFrame);
mConverged = mean(mConvergedPerFrame);
mImageErr = mean(mImageErrPerFrame);

convStats.mIterPerFrame = mIterPerFrame;
convStats.mConvergedPerFrame = mConvergedPerFrame;
convStats.mImageErrPerFrame = mImageErrPerFrame;

convStats.mIter = mIter;
convStats.mConverged = mConverged;
convStats.mImageErr = mImageErr;