function J = getJ(mechanics)

% deformation gradient tensor (F)
F = mechanics.DDE.F;
% center of warped box(x)
x = mechanics.x;

dims = size(F);
J = zeros(dims([3 4]));

% for each frame and each region (box) take the determinant of the DGT
for frame = 1:dims(4)
    for bx = 1:dims(3)
        J(bx,frame)=det(F(:,:,bx,frame));
    end
end