function [Ca2] = getIntensity (unwarped, preComp)
%getIntensity - get calcium intensity from regions in DDE code
% used by other plotting functions
%
% [Ca2] = getIntensity (unwarped, preComp)
%
% input:
%   unwarped - stabilized fluorescence video
%   preComp - from DDE software
%
% output:
%   Ca2 - average intensities by region
% Louis Woodhams 03/2020

% to save memory, break chunks into a cell array before sending to parfor
% loop


[ht, wd, frames] = size(unwarped);
regions = length(preComp);

Ca2 = zeros(regions,frames);

% this loop is time consuming - speed it up?
% vectorize this code?
%w = waitbar(0,'working...');
%tic
cellRegion{regions} = [];
for r = 1:regions
    %tic
    %waitbar(r/regions,w);
    x = preComp(r).X.x(:,1);
    y = preComp(r).X.y(1,:)';
    
    xIm = uint16((0.5+x)*ht);
    yIm = uint16((0.5+y)*wd);
%     disp('time to get coordinates')
%     toc
%     tic
    %     for f = 1:frames
    %         rIm = unwarped(xIm,yIm,f);
    %         Ca2(r,f) = mean(rIm(:))/255;
    %     end
    cellRegion{r} = unwarped(xIm,yIm,:); % get region for all frames
end

parfor r = 1:regions
    rI = cellRegion{r};
    m1 = mean(rI,1);          % average values for each frame
    m2 = mean(m1,2);
    Ca2(r,:) = m2(:)'/255;      % assign row of frame values for region
    
%     disp('time to get averages')
%     toc
end
%toc
%delete(w)