function corrVals = corrToFirst(videoArray)
%CORRTOFIRST plot correlation of each subsequent frame to first frame
%

% Louis Woodhams 02/2020
dim = size(videoArray);
ndims = length(dim);
if ndims == 3
    [ht,wd, frames] = size(videoArray);
    img1 = videoArray(:,:,1);
    isColor = 0;
elseif ndims == 4
    [ht,wd,~, frames] = size(videoArray);
    img1 = videoArray(:,:,:,1);
    isColor = 1;
else
    error('wrong format array')
end

corrVals = zeros(frames,1);
corrVals(1) = 1;
for f = 2:frames
    if isColor
        Rc = corr2(img1,videoArray(:,:,1,f));
        Gc = corr2(img1,videoArray(:,:,2,f));
        Bc = corr2(img1,videoArray(:,:,3,f));
        corrVals(f) = mean([Rc, Gc, Bc]);
    else
        corrVals(f) = corr2(img1,videoArray(:,:,f));
    end
end

if nargout == 0
    plot(1:frames,corrVals)
    xlabel('frame #')
    ylabel('correlation coefficient')
end