function [dilation, contraction, colorVid] = calcDilation(mechanics,unwarped)
%CALCDILATION calculate and interpolate dilations into video format
%
% inputs: 
%   mechanics - mechanics structure from Boyle DDE code
%   unwarped - unwarped video from virtual blebbistatin code
% outputs:
%   dilation - relative change in area interpolated to video format
%   contraction - positive elements of 1-dilation
%   calcium - calcium signal to overlay on blue channel if wanted

% Louie Woodhams 02/20
if nargin < 2, unwarped = 0; end

% deformation gradient tensor (F)
F = mechanics.DDE.F;
% center of warped box(x)
x = mechanics.x;

dims = size(F);
J = zeros(dims([3 4]));
tic
% for each frame and each region (box) take the determinant of the DGT
for frame = 1:dims(4)
    for bx = 1:dims(3)
        J(bx,frame)=det(F(:,:,bx,frame));
    end
end
disp('time to get J')
toc
%%
[IMheight, IMwidth, ~] = size(unwarped);
[Xim, Yim] = meshgrid(1:IMwidth, 1:IMheight);
X1 = unique(x(1,:,1));
Y1 = unique(x(2,:,1));
dilation = zeros(size(unwarped));
tic
% create an interpolant for each frame, evaluate it at all pixel locations
for frame = 1:dims(4)
    nJ = reshape(J(:,frame),[length(Y1) length(X1)]);
    interpJ = griddedInterpolant({X1(:),Y1(:)},nJ','linear','none');
    frameJ = interpJ(Xim,Yim);
    frameJ(isnan(frameJ)) = 1;
    dilation(:,:,frame) = frameJ;
end
disp('time to interpolate')
toc

if nargout > 1
    contraction = 1 - dilation;
    contraction(contraction < 0) = 0;
    contraction = contraction / prctile(contraction(:),99.9);
    contraction = uint8(255*contraction.^2);
end

if nargout > 2
    calcium = aboveBaseline(unwarped);
    colorVid = .5*repmat(unwarped(:,:,1),[1,1,214,3]);
    colorVid(:,:,:,1) = colorVid(:,:,:,1)+contraction;
    colorVid(:,:,:,3) = colorVid(:,:,:,3)+2*calcium;
    colorVid = permute(colorVid,[1,2,4,3]);
end
