function [] = array2video(arrayIn, qual)
% array2video -- Takes a three or four dimensional array and saves it as a
% video
% Louis Woodhams 2016

if nargin < 2 || isempty(qual)
    qual = 75;
end

%establish number of dimensions and frames of matrix
dim = size(arrayIn);
numdim = size(dim,2);
total_frames = dim(numdim);

%get the user inputs
fprintf('\nTotal number of frames is %u.\n',total_frames);
start_frame = input('Starting frame[1]: ');
end_frame = input('Ending frame[end]: ');
name_of_file = input('Name of file to save: ','s');
frame_rate = input('Frames per second: ');
%color_map = input('Colormap [jet(256)]: ','s');

%set the defaults
if isempty(start_frame)
    start_frame = 1;
end
if isempty(end_frame)
    end_frame = total_frames;
end
if isempty(name_of_file)
    name_of_file = 'video.avi';
end
if isempty(frame_rate)
    frame_rate = 30;
end
%if isempty(color_map)
%   color_map = 'jet(256)';
%end

str = ['Writing ' name_of_file ' at ' num2str(frame_rate) ' fps...'];
disp(str);

writerObj = VideoWriter(name_of_file);
writerObj.FrameRate = frame_rate;
writerObj.Quality = qual;
%colormap(color_map);
open(writerObj);

if (numdim == 3)
    monoArray(:,:,1,:) = arrayIn(:,:,:);
    writeVideo(writerObj,monoArray(:,:,:,start_frame:end_frame));
elseif (numdim == 4)
    writeVideo(writerObj,arrayIn(:,:,:,start_frame:end_frame));
else
    printf('Unsupported format!  Array must be 3 or 4 dimensional.');
end
close(writerObj)
disp('Done!');
end

