close all

nn = 10; % sub-pixel resolution (4 means 1/4 pixel)
fps = 50;


% deformation gradient tensor (F)
F = mechanics.DDE.F;
% center of warped box(x)
x = mechanics.x;

dims = size(F);
%J = zeros(dims([3 4]));
CA = getIntensity(aboveBaseline(unwarped),preComp);
CA = interp1(CA',1:(1/nn):dims(4),'makima');
CA = CA';
%%
[IMheight, IMwidth, ~] = size(unwarped);
[Xim, Yim] = meshgrid(1:IMwidth, 1:IMheight);
X1 = unique(x(1,:,1));
Y1 = unique(x(2,:,1));
rx = length(Y1); 
cx = length(X1);
rowIndex = 1:rx*cx;
rowIndex = reshape(rowIndex,[rx,cx]);
rowIndex = rowIndex.';
fig(1) = figure(1);
fig(1).Name = 'Ca signal';
CaCell{rx*cx} = [];
for i = 1:rx*cx
    subplot(rx,cx,rowIndex(i))
    CaCell{i} = CA(i,:);
    plot(CaCell{i})
    ylim([0 0.3])
end
fig(2) = figure(2);
fig(2).Name = 'covariance';
maxlag = nn*fps/2;
CAref = CA(6,:);

parfor i = 1:dims(3)
    nCA = CaCell{i};
    covec = xcov(CAref,nCA,maxlag,'normalized');
%    f = (1- abs((1:427) - 214)/213);
%     cor = cor./f;
    [cMax(i),cInd(i)] = max(covec);
    subplot(rx,cx,rowIndex(i))
    plot(covec)
    ylim([-1 1])
    line([maxlag+1, maxlag+1],[-1, 1],'color','red')
    drawnow('limitrate')
end

%%
cMax = reshape(cMax,[length(Y1) length(X1)]);
cInd = reshape(cInd-maxlag-1,[length(Y1) length(X1)])/nn/fps;
% figure(3)
% imagesc(cMax)
% title('max covariance')
% colorbar
% 
figure(4)
imagesc(cInd)
colorbar
title('time delay (s)')

% create an interpolant for each frame, evaluate it at all pixel locations
interpC = griddedInterpolant({X1(:),Y1(:)},cInd','linear','linear');
frameC = interpC(Xim,Yim);
frameC = imgaussfilt(frameC,25);
frameC = frameC-max(frameC(:));

figure(5)
imagesc(frameC), hold on
colorbar
contour(frameC,0:-.05:-1,'-k','LineWidth',2), hold off

%disp('time to interpolate')
