function [aboveBase, refImage] = aboveBaseline(video, p)
%ABOVEBASELINE removes a baseline value from each pixel in a timeseries
% 
%[aboveBase, refImage] = aboveBaseline(video, percentile)
%
% input:
%   video - height x width x frames format (mono only currently)
%   p - percentile value to use as baseline
%
% output:
%   aboveBase - same format as input video with baseline subtracted
%   refImage - reference image that is subtracted from each frame

% Louie Woodhams - 02/2020

if nargin == 1, p = 1; end
refImage = prctile(video,p,3); 

aboveBase = bsxfun(@minus, video, refImage);