import org.locationtech.jts.geom.util.GeometryCombiner
import org.locationtech.jts.operation.union.UnaryUnionOp

// variables necessàries per al funcionament intern del programa
int z = 0
int t = 0
def plane = ImagePlane.getPlane(z, t)
def objects = getAnnotationObjects()

// amplada dels patch's i nombre de píxels que es solapen
def amplada = 1024
def alcada = 1024
def solapament = 100
def th_interseccio = 0.5

// generació dels patch's
def original_ann = []
def new_anns = []
for (annotation in objects) {

    print "Processing annotation " + annotation
    roi = annotation.getROI() // farem servir la roi per calcular la bounding box i la interseccio amb els quadrats. Primer extreiem la bb
    if (roi.getClass() == qupath.lib.roi.RectangleROI){
        continue // Ignore squares
    } else {
        // Save for later use
        original_ann.add(annotation)
    }
    // paràmetres de la Bounding Box
    x = roi.getBoundsX()
    y = roi.getBoundsY()
    h = roi.getBoundsHeight()
    w = roi.getBoundsWidth()
   
    geom = roi.getGeometry() // la geometria caldra per a calcular la unio

    // calculem el num. de quadrats que caben a la bb
    nh = Math.floor(w/(amplada-solapament)) 
    nv = Math.floor(h/(alcada-solapament))
    def count = 0
    
    // generem els quadrats d'un en un
    for(int itx=0; itx <=nh; itx++){
        xc = x + itx*(amplada-solapament) - solapament/2
        for(int ity=0; ity <=nv; ity++){
            yc = y + ity*(alcada-solapament) - solapament/2
            def newroi = ROIs.createRectangleROI(xc, yc, amplada, alcada, plane)
            def newannotation = PathObjects.createAnnotationObject(newroi) // creem l'anotacio del nou quadrat però no la afegim encara

            // calcul de l'area de la interseccio entre el nou quadrat i la regió original per a veure quant solapen
            def newgeom = newroi.getGeometry() // la geometria caldra per a calcular la unio
            combined=GeometryCombiner.combine([geom, newgeom])
            merged= UnaryUnionOp.union(combined)
            mergedRois=GeometryTools.geometryToROI(merged, roi.getImagePlane()) //roi de la unio del quadrat amb la area gran
            def intarea = (roi.getArea()+newroi.getArea() - mergedRois.getArea())/(amplada*alcada) // area de la interseccio

            // si la nova regió intersecta prou amb la regio que estem segmentant, la guardem
            if(intarea > th_interseccio){
               addObject(newannotation)
               new_anns.add(newannotation)
               count ++
            }
        }
    }
    print 'Finnished processing annotation ' + annotation + ', ' + count + ' patchs generated.'
}

// eliminem les regions originals, deixant només els patch's
removeObjects(original_ann, true)

// per a guardar les imatges necessitem el nom de la imatge original. segurament hi ha una manera facil de treure'l, pero he acabat fent aixo
def imageData = getCurrentImageData().toString()
i = imageData.length()-6;
blanks=0;
name = ''
while (blanks<2 && i>=0) {
    name = imageData[i] + name
    i--
    if(imageData[i]==' '){
        blanks++
    }
}

// guardem les imatges noves
def path = "SET PATH HERE"

imageData = getCurrentImageData()
def server = imageData.getServer()

int i = 0
aux = name
for (annotation in new_anns) {

    roi = annotation.getROI()
    x = roi.getBoundsX() //en el nom de cada imatge posarem les coordenades d'on ha sortit i el seu tamany
    y = roi.getBoundsY()
    h = roi.getBoundsHeight()
    w = roi.getBoundsWidth()
   
    def request = RegionRequest.createInstance(imageData.getServerPath(), 1, roi)
   
    name = aux + ' (x=' + x + ', y=' + y + ', w=' + w + ', h=' + h + ').png'
   
    writeImageRegion(server, request, path + name)

    i++
}
	
	


