import qupath.lib.images.servers.LabeledImageServer

def imageData = getCurrentImageData()

// Define output path (relative to project)
def name = GeneralTools.getNameWithoutExtension(imageData.getServer().getMetadata().getName())

// Define output resolution
double augmentation = 5
String set = "val"
def pathOutput = "SET PATH HERE"+String.valueOf(augmentation)+"/"+set
mkdirs(pathOutput)

// Convert to downsample
// double downsample = requestedPixelSize / imageData.getServer().getPixelCalibration().getAveragedPixelSize()

// Define output downsample
//    - 20x  --> 1.0
//    - 10x  --> 2.0
//    - 5x   --> 4.0
//    - 2.5x --> 8.0
double downsample = 20/augmentation

// Create an ImageServer where the pixels are derived from annotations
def labelServer = new LabeledImageServer.Builder(imageData)
    .backgroundLabel(0, ColorTools.BLACK)                           // Specify background label
    .downsample(downsample)                                         // Choose server resolution; this should match the resolution at which tiles are exported
    .addLabel('Other', 1, ColorTools.makeRGB(85, 85, 85))           // Classes labels (the order matters!)
    .addLabel('Tumor', 2, ColorTools.makeRGB(170, 170, 170))
    .addLabel('In situ', 3, ColorTools.makeRGB(255, 255, 255))
    .multichannelOutput(false)                                      // If true, each label is a different channel (required for multiclass probability)
    .build()

// Create an exporter that requests corresponding tiles from the original & labeled image servers
new TileExporter(imageData)
    .downsample(downsample)                                         // Define export resolution
    .imageExtension('.png')                                         // Define file extension for original pixels (often .tif, .jpg, '.png' or '.ome.tif')
    .imageSubDir('Images')                                          // Subdirectory to save the original images
    // .labeledImageExtension('.png')
    .labeledImageSubDir('Masks')                                    // Subdirectory to save the masks
    .tileSize(512)                                                  // Define size of each tile, in pixels
    .labeledServer(labelServer)                                     // Define the labeled image server to use (i.e. the one we just built)
    // .annotatedTilesOnly(true)                                    // If true, only export tiles if there is a (labeled) annotation present
    .annotatedCentroidTilesOnly(true)                               // If true, only export tiles if the centroid pixels has an annotation
    .overlap(0)                                                     // Define overlap, in pixel units at the EXPORT resolution
    .writeTiles(pathOutput)                                         // Write tiles to the specified directory

print 'Done!'

// Bounds de la WSI (offset que s'ha d'aplicar per aconseguir les coordenades correctes amb OpenSlide)
double dx = -getCurrentServer().boundsX
double dy = -getCurrentServer().boundsY

print dx
print dy

print imageData.getServer().getPixelCalibration().getAveragedPixelSize()
