---
license: cc-by-nc-4.0
---

# Combining graph neural networks and computer vision methods for cell nuclei classification in lung tissue

This is the dataset of the article in the title. It contains 85 patches of 1024x1024 pixels from H&E stained WSIs of 9 different patients. It contains two main classes: tumoural (2) and non tumoural (1). Due to the difficulty of the problem, 153 cells were labelled as uncertain. For technical reasons, we decided to eliminate them in the train and validation set and we carefully chose the test set so that it included no uncertain cell. In total there are 21255 cells in the train set, 4114 in the validation set and 5533 in the test set. We manually reviewed that no patient is in two splits at the same time, ensuring that the split has no data leakage in any way.

## Structure

The data is provided in several ways. In the orig folder you have the images without any annotation. Later in overlay the same images with the cells overlayed on top are provided for visualization purposes being red healthy cells and green the tumoural ones. Annotations were made using a software called QuPath, the raw geojson files extracted from the application are in raw_geojson. However, bear in mind that it may contain duplicated cells and uncertain cells. We are releasing it together with the scripts in the scripts folder so that any interested researcher can load the annotations back into QuPath and review the labels. If you, as an expert, believe we have incorrectly labelled some cells, please, feel free to contact us. The rest of the folders (train, test, validation) contain the data ready to use and with the same structure as specified in the [tumourkit package documentation](https://lung-tumour-study.readthedocs.io/en/latest/usage.html#make-dirs). Just move them into the data folder. Notice you will need to move the orig folder too. 

Any pred or hov folder is provided as an example. They contain predictions from one of our models. If you were to train your own models, you should delete them. Also, the npy folders are crops of the original images of size 518x518. You can train Hovernet with other shapes if you want by modifying the code provided by the [Tumourkit library](https://github.com/Jerry-Master/lung-tumour-study).