/* This file was automatically generated by CasADi.
   The CasADi copyright holders make no ownership claim of its contents. */
#ifdef __cplusplus
extern "C" {
#endif

#ifdef CODEGEN_PREFIX
  #define NAMESPACE_CONCAT(NS, ID) _NAMESPACE_CONCAT(NS, ID)
  #define _NAMESPACE_CONCAT(NS, ID) NS ## ID
  #define CASADI_PREFIX(ID) NAMESPACE_CONCAT(CODEGEN_PREFIX, ID)
#else /* CODEGEN_PREFIX */
  #define CASADI_PREFIX(ID) expl_ode_ ## ID
#endif /* CODEGEN_PREFIX */

#include <math.h>

#ifndef real_t
#define real_t double
#endif /* real_t */

#define to_double(x) (double) x
#define to_int(x) (int) x
#define CASADI_CAST(x,y) (x) y
/* Pre-c99 compatibility */
#if __STDC_VERSION__ < 199901L
real_t CASADI_PREFIX(fmin)(real_t x, real_t y) { return x<y ? x : y;}
#define fmin(x,y) CASADI_PREFIX(fmin)(x,y)
real_t CASADI_PREFIX(fmax)(real_t x, real_t y) { return x>y ? x : y;}
#define fmax(x,y) CASADI_PREFIX(fmax)(x,y)
#endif

#define PRINTF printf
#ifndef CASADI_SYMBOL_EXPORT
#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#if defined(STATIC_LINKED)
#define CASADI_SYMBOL_EXPORT
#else /* defined(STATIC_LINKED) */
#define CASADI_SYMBOL_EXPORT __declspec(dllexport)
#endif /* defined(STATIC_LINKED) */
#elif defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#define CASADI_SYMBOL_EXPORT __attribute__ ((visibility ("default")))
#else /* defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__) */
#define CASADI_SYMBOL_EXPORT
#endif /* defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__) */
#endif /* CASADI_SYMBOL_EXPORT */
real_t CASADI_PREFIX(sq)(real_t x) { return x*x;}
#define sq(x) CASADI_PREFIX(sq)(x)

real_t CASADI_PREFIX(sign)(real_t x) { return x<0 ? -1 : x>0 ? 1 : x;}
#define sign(x) CASADI_PREFIX(sign)(x)

void CASADI_PREFIX(de_boor)(real_t x, const real_t* knots, int n_knots, int degree, real_t* boor) {
  for (int d=1;d<degree+1;++d) {
    for (int i=0;i<n_knots-d-1;++i) {
      real_t b = 0;
      real_t bottom = knots[i + d] - knots[i];
      if (bottom) b = (x - knots[i]) * boor[i] / bottom;
      bottom = knots[i + d + 1] - knots[i + 1];
      if (bottom) b += (knots[i + d + 1] - x) * boor[i + 1] / bottom;
      boor[i] = b;
    }
  }
}
#define de_boor(x, knots, n_knots, degree, boor) CASADI_PREFIX(de_boor)(x, knots, n_knots, degree, boor)

void CASADI_PREFIX(fill)(real_t* x, int n, real_t alpha) {
  int i;
  if (x) {
    for (i=0; i<n; ++i) *x++ = alpha;
  }
}
#define fill(x, n, alpha) CASADI_PREFIX(fill)(x, n, alpha)

void CASADI_PREFIX(fill_int)(int* x, int n, int alpha) {
  int i;
  if (x) {
    for (i=0; i<n; ++i) *x++ = alpha;
  }
}
#define fill_int(x, n, alpha) CASADI_PREFIX(fill_int)(x, n, alpha)

int CASADI_PREFIX(low)(real_t x, const double* grid, int ng, int lookup_mode) {
  if (lookup_mode) {
    double g0 = grid[0];
    int ret = (int) ((x-g0)*(ng-1)/(grid[ng-1]-g0));
    if (ret<0) ret=0;
    if (ret>ng-2) ret=ng-2;
    return ret;
  } else {
    int i;
    for (i=0; i<ng-2; ++i) {
      if (x < grid[i+1]) break;
    }
    return i;
  }
}
#define low(x, grid, ng, lookup_mode) CASADI_PREFIX(low)(x, grid, ng, lookup_mode)

void CASADI_PREFIX(nd_boor_eval)(real_t* ret, int n_dims, const real_t* all_knots, const int* offset, const int* all_degree, const int* strides, const real_t* c, int m, const real_t* all_x, const int* lookup_mode, int reverse, int* iw, real_t* w) {
  int* boor_offset = iw; iw+=n_dims+1;
  int* starts = iw; iw+=n_dims;
  int* index = iw; iw+=n_dims;
  int* coeff_offset = iw;
  real_t* cumprod = w; w+= n_dims+1;
  real_t* all_boor = w;
  boor_offset[0] = 0;
  cumprod[n_dims] = 1;
  coeff_offset[n_dims] = 0;
  int n_iter = 1;
  for (int k=0;k<n_dims;++k) {
    real_t* boor = all_boor+boor_offset[k];
    int degree = all_degree[k];
    const real_t* knots = all_knots + offset[k];
    int n_knots = offset[k+1]-offset[k];
    int n_b = n_knots-degree-1;
    real_t x = all_x[k];
    int L = CASADI_PREFIX(low)(x, knots+degree, n_knots-2*degree, lookup_mode[k]);
    int start = L;
    if (start>n_b-degree-1) start = n_b-degree-1;
    starts[k] = start;
    CASADI_PREFIX(fill)(boor, 2*degree+1, 0.0);
    if (x>=knots[0] && x<=knots[n_knots-1]) {
      if (x==knots[1]) {
        CASADI_PREFIX(fill)(boor, degree+1, 1.0);
      } else if (x==knots[n_knots-1]) {
        boor[degree] = 1;
      } else if (knots[L+degree]==x) {
        boor[degree-1] = 1;
      } else {
        boor[degree] = 1;
      }
    }
    CASADI_PREFIX(de_boor)(x, knots+start, 2*degree+2, degree, boor);
    boor+= degree+1;
    n_iter*= degree+1;
    boor_offset[k+1] = boor_offset[k] + degree+1;
  }
  CASADI_PREFIX(fill_int)(index, n_dims, 0);
  for (int pivot=n_dims-1;pivot>=0;--pivot) {
    cumprod[pivot] = (*(all_boor+boor_offset[pivot]))*cumprod[pivot+1];
    coeff_offset[pivot] = starts[pivot]*strides[pivot]+coeff_offset[pivot+1];
  }
  for (int k=0;k<n_iter;++k) {
    for (int i=0;i<m;++i) {
      if (reverse) {
        ret[coeff_offset[0]+i] += c[i]*cumprod[0];
      } else {
        ret[i] += c[coeff_offset[0]+i]*cumprod[0];
      }
    }
    index[0]++;
    int pivot = 0;
    {
      while (index[pivot]==boor_offset[pivot+1]-boor_offset[pivot]) {
        index[pivot] = 0;
        if (pivot==n_dims-1) break;
        index[++pivot]++;
      }
      while (pivot>0) {
        cumprod[pivot] = (*(all_boor+boor_offset[pivot]+index[pivot]))*cumprod[pivot+1];
        coeff_offset[pivot] = (starts[pivot]+index[pivot])*strides[pivot]+coeff_offset[pivot+1];
        pivot--;
      }
    }
    cumprod[0] = (*(all_boor+index[0]))*cumprod[1];
    coeff_offset[0] = (starts[0]+index[0])*m+coeff_offset[1];
  }
}
#define nd_boor_eval(ret, n_dims, all_knots, offset, all_degree, strides, c, m, all_x, lookup_mode, reverse, iw, w) CASADI_PREFIX(nd_boor_eval)(ret, n_dims, all_knots, offset, all_degree, strides, c, m, all_x, lookup_mode, reverse, iw, w)

void CASADI_PREFIX(copy)(const real_t* x, int n, real_t* y) {
  int i;
  if (y) {
    if (x) {
      for (i=0; i<n; ++i) *y++ = *x++;
    } else {
      for (i=0; i<n; ++i) *y++ = 0.;
    }
  }
}
#define copy(x, n, y) CASADI_PREFIX(copy)(x, n, y)

static const int CASADI_PREFIX(s0)[2] = {0, 0};
#define s0 CASADI_PREFIX(s0)
static const int CASADI_PREFIX(s1)[2] = {1, 55};
#define s1 CASADI_PREFIX(s1)
static const int CASADI_PREFIX(s2)[2] = {3, 3};
#define s2 CASADI_PREFIX(s2)
static const int CASADI_PREFIX(s3)[3] = {0, 59, 131};
#define s3 CASADI_PREFIX(s3)
static const int CASADI_PREFIX(s4)[10] = {6, 1, 0, 6, 0, 1, 2, 3, 4, 5};
#define s4 CASADI_PREFIX(s4)
static const int CASADI_PREFIX(s5)[7] = {3, 1, 0, 3, 0, 1, 2};
#define s5 CASADI_PREFIX(s5)
static const real_t CASADI_PREFIX(c0)[3740] = {1.8184086601773187e-03, 1.0904223423495404e-03, 2.1284991539426783e-03, 2.4183297386224383e-03, 2.9292756796894717e-03, 3.2948060866679267e-03, 3.7315668141347912e-03, 4.1343263986859313e-03, 4.5563053496223867e-03, 4.9713728384279347e-03, 5.3907646264113500e-03, 5.8073290007822527e-03, 6.2231609676950267e-03, 6.6378402735228553e-03, 7.0511163999661258e-03, 7.4616134713547328e-03, 7.8714853236313033e-03, 8.2809581949205308e-03, 8.6874696441523493e-03, 9.0923302948452567e-03, 9.4955165822850594e-03, 9.8936956957241251e-03, 1.0289518246109745e-02, 1.0679678042924228e-02, 1.1071326415580255e-02, 1.1458679274212335e-02, 1.1844285428821743e-02, 1.2225826669718144e-02, 1.2599696779551962e-02, 1.2969225412061020e-02, 1.3335272827729425e-02, 1.3698516866381271e-02, 1.4060708568523475e-02, 1.4413909439722985e-02, 1.4764406279404703e-02, 1.5111627753613547e-02, 1.5449419489704604e-02, 1.5779118407517112e-02, 1.6105920324379467e-02, 1.6435191584132119e-02, 1.6750196790189940e-02, 1.7069047253462508e-02, 1.7362301504420041e-02, 1.7688279675615693e-02, 1.7933284783715350e-02, 1.8382805036747767e-02, 1.8215306098602762e-02, 1.8262857646411765e-02, 1.8232271944510312e-02, 1.8249189624503084e-02, 1.8239674629467205e-02, 1.8251039072585646e-02, 1.8220269373502820e-02, 1.8267428421928512e-02, 1.8132711378110813e-02, 8.3085952623944013e-04, 1.8359830088230124e-03, 1.7956821082281470e-03, 2.5333472147936438e-03, 2.8738841151270508e-03, 3.3237144634793848e-03, 3.7197847610549815e-03, 4.1429966739586748e-03, 4.5553330041380215e-03, 4.9752663564854634e-03, 5.3924894384507057e-03, 5.8102875766167256e-03, 6.2260437237284111e-03, 6.6410016435829479e-03, 7.0541333913303481e-03, 7.4651429546108558e-03, 7.8751585801590685e-03, 8.2840970319735495e-03, 8.6908520800561100e-03, 9.0957081511521803e-03, 9.4980722455570432e-03, 9.8966972647818782e-03, 1.0291164636052709e-02, 1.0682748342503514e-02, 1.1072297530362858e-02, 1.1459981765592023e-02, 1.1844739387864543e-02, 1.2224971523868819e-02, 1.2598762336953444e-02, 1.2967445583110299e-02, 1.3332723435120234e-02, 1.3695559712480985e-02, 1.4055067374954183e-02, 1.4408825736522173e-02, 1.4758153541920109e-02, 1.5103242399836347e-02, 1.5440071090258989e-02, 1.5769308696990020e-02, 1.6096807816507453e-02, 1.6420630908989122e-02, 1.6740894403525112e-02, 1.7049346259408335e-02, 1.7361510283680583e-02, 1.7654267568851918e-02, 1.7989278130116016e-02, 1.8251978448535558e-02, 1.8273132606509819e-02, 1.8228099098711200e-02, 1.8233584900392442e-02, 1.8227120832387450e-02, 1.8232741798215126e-02, 1.8229194641150269e-02, 1.8227725197522422e-02, 1.8232732494755037e-02, 1.8084198674117806e-02, 1.4260148873143791e-03, 1.3774451961144035e-03, 1.9855018454883466e-03, 2.4524310347448326e-03, 2.8948805932027784e-03, 3.2906510565985725e-03, 3.7102710166742412e-03, 4.1189141288687650e-03, 4.5352236439490179e-03, 4.9499870802985017e-03, 5.3664718747950986e-03, 5.7814612134081287e-03, 6.1954938190694952e-03, 6.6082825456011138e-03, 7.0196429130457184e-03, 7.4295474841089794e-03, 7.8389510782056887e-03, 8.2482172620348508e-03, 8.6560965679520711e-03, 9.0625191584863141e-03, 9.4670574687036636e-03, 9.8685636903891403e-03, 1.0267149703944876e-02, 1.0662666896616881e-02, 1.1058688731478802e-02, 1.1452491421781752e-02, 1.1844039222776990e-02, 1.2232051753501713e-02, 1.2614590938931868e-02, 1.2992897781685248e-02, 1.3368214423737451e-02, 1.3741955929623384e-02, 1.4113282307222223e-02, 1.4478985272299010e-02, 1.4841110041514999e-02, 1.5198764441702723e-02, 1.5549019315604143e-02, 1.5891472275106400e-02, 1.6230171757868693e-02, 1.6566644833444413e-02, 1.6893510944815896e-02, 1.7214976220536273e-02, 1.7526518746467882e-02, 1.7843126375422964e-02, 1.8146853800514239e-02, 1.8422984907889736e-02, 1.8429506204680215e-02, 1.8417439573032844e-02, 1.8401886545152606e-02, 1.8402803658265000e-02, 1.8402948942210940e-02, 1.8403358308662472e-02, 1.8415752477090774e-02, 1.8418095689239748e-02, 1.8581211756580639e-02, 1.1890863167041061e-03, 1.5720948087278349e-03, 1.9151102539217656e-03, 2.4917493155122432e-03, 2.8943588825649544e-03, 3.3132153534572721e-03, 3.7244461203582639e-03, 4.1403101187719596e-03, 4.5560982967091492e-03, 4.9740853112396526e-03, 5.3919347025508475e-03, 5.8091894770553407e-03, 6.2250130433831796e-03, 6.6396786864199508e-03, 7.0526497473931624e-03, 7.4636452663832311e-03, 7.8735715667087643e-03, 8.2824707338611282e-03, 8.6893309770602924e-03, 9.0942499521325330e-03, 9.4967104387622455e-03, 9.8954114589935339e-03, 1.0290462245976555e-02, 1.0682192098683076e-02, 1.1072509482788645e-02, 1.1460484708642546e-02, 1.1845658434027045e-02, 1.2226390944019521e-02, 1.2600948119477135e-02, 1.2970593508390020e-02, 1.3336747743493296e-02, 1.3700283716929357e-02, 1.4060713569719998e-02, 1.4415474912679218e-02, 1.4765946732377954e-02, 1.5111712964162447e-02, 1.5449749392942380e-02, 1.5780739497112683e-02, 1.6108818914085159e-02, 1.6434302767421527e-02, 1.6753608194343596e-02, 1.7066572259807424e-02, 1.7375928916857984e-02, 1.7685213906389718e-02, 1.7994365959108315e-02, 1.8261760927701362e-02, 1.8278585036349996e-02, 1.8260218857540894e-02, 1.8249091229132167e-02, 1.8247142416302799e-02, 1.8247686951102432e-02, 1.8249048622869756e-02, 1.8243057244703827e-02, 1.8254356106326187e-02, 1.8220771557418265e-02, 1.2917423945598358e-03, 1.5095105130214245e-03, 1.9510852388274779e-03, 2.4877392763556268e-03, 2.9071413110243961e-03, 3.3191483639899849e-03, 3.7355232633908175e-03, 4.1505847663347644e-03, 4.5685077902003959e-03, 4.9871702362239093e-03, 5.4064140501891870e-03, 5.8247306551549999e-03, 6.2417718448860710e-03, 6.6575390384948051e-03, 7.0715653432949039e-03, 7.4833133376064984e-03, 7.8936892314475197e-03, 8.3025739352116674e-03, 8.7090587335081609e-03, 9.1133543668436810e-03, 9.5149369193859232e-03, 9.9122913360103343e-03, 1.0305772078411872e-02, 1.0695611722214454e-02, 1.1083221060468300e-02, 1.1468274962358541e-02, 1.1850360242752385e-02, 1.2227493058795069e-02, 1.2598030605910571e-02, 1.2963328978634656e-02, 1.3324864536191810e-02, 1.3683182959038509e-02, 1.4038103091063396e-02, 1.4387220399640297e-02, 1.4731747076910889e-02, 1.5071366266783195e-02, 1.5403030227062088e-02, 1.5728176574727328e-02, 1.6050514066639116e-02, 1.6370740527450738e-02, 1.6685356786855818e-02, 1.6995126294834243e-02, 1.7300890146081990e-02, 1.7610154836838289e-02, 1.7916670960234606e-02, 1.8187323442709642e-02, 1.8201853263940377e-02, 1.8185789829218778e-02, 1.8173202523590688e-02, 1.8171531073365971e-02, 1.8171886027759775e-02, 1.8168525477880025e-02, 1.8163967015769399e-02, 1.8102683185725603e-02, 1.8066001072359360e-02, 1.2425869394019681e-03, 1.5325730445849830e-03, 1.9235544607098085e-03, 2.4771719030035710e-03, 2.8860422382735841e-03, 3.2993812193301028e-03, 3.7111932144932780e-03, 4.1247671177941474e-03, 4.5398092902077507e-03, 4.9564272851261295e-03, 5.3733511113113995e-03, 5.7896141343461707e-03, 6.2046488496964904e-03, 6.6186506134176763e-03, 7.0312415203207940e-03, 7.4421782969762065e-03, 7.8525054030219137e-03, 8.2622623634228485e-03, 8.6704441816139281e-03, 9.0771042755716947e-03, 9.4817586190490133e-03, 9.8830894013814900e-03, 1.0281305725069642e-02, 1.0676834704567300e-02, 1.1071497162366353e-02, 1.1464402744525896e-02, 1.1854976632445778e-02, 1.2241540142361234e-02, 1.2622404463562780e-02, 1.2998799244091922e-02, 1.3372213043611473e-02, 1.3743430537548456e-02, 1.4111954188859127e-02, 1.4475091957640383e-02, 1.4834086030291904e-02, 1.5188481803609259e-02, 1.5534958943294061e-02, 1.5874168004316423e-02, 1.6209849585064273e-02, 1.6542182188449012e-02, 1.6867017441704268e-02, 1.7184472837268712e-02, 1.7496106479415068e-02, 1.7807647781488047e-02, 1.8115432350818524e-02, 1.8383903624808118e-02, 1.8398681607861792e-02, 1.8381519204316989e-02, 1.8369371526665158e-02, 1.8367190465370161e-02, 1.8366377702969647e-02, 1.8363592063642992e-02, 1.8360988646817292e-02, 1.8360613916913737e-02, 1.8216704212256615e-02, 1.2282669296476197e-03, 1.4872997150881396e-03, 1.9065758804584936e-03, 2.4444128654649445e-03, 2.8522736022403594e-03, 3.2587026934209644e-03, 3.6668457559830459e-03, 4.0754749880262372e-03, 4.4866029278565565e-03, 4.8991739715189197e-03, 5.3124649029557608e-03, 5.7251749007184109e-03, 6.1369441221706591e-03, 6.5479561322170279e-03, 6.9579194868595647e-03, 7.3672404428532469e-03, 7.7768544965928490e-03, 8.1873593772466020e-03, 8.5973671265676677e-03, 9.0065958702651664e-03, 9.4146003520117795e-03, 9.8206689174303152e-03, 1.0224525725063629e-02, 1.0626282346191590e-02, 1.1030110152503190e-02, 1.1432476352027456e-02, 1.1833136992854876e-02, 1.2231319544984848e-02, 1.2624965277891621e-02, 1.3015186535134247e-02, 1.3403156428088465e-02, 1.3790770204469087e-02, 1.4176614422930531e-02, 1.4557215652880554e-02, 1.4934530360368627e-02, 1.5307368993610043e-02, 1.5672801911175260e-02, 1.6029109166279150e-02, 1.6380727320290351e-02, 1.6728004524298512e-02, 1.7063612057960875e-02, 1.7389132855767396e-02, 1.7705226740628004e-02, 1.8017730848859943e-02, 1.8323125895087066e-02, 1.8586305536984832e-02, 1.8598835946331615e-02, 1.8580578185940312e-02, 1.8567669315557516e-02, 1.8565724923683323e-02, 1.8564590421932821e-02, 1.8567707410792961e-02, 1.8586394084643187e-02, 1.8792224283614253e-02, 1.8944753437773517e-02, 1.2119266560927317e-03, 1.5047211746179155e-03, 1.9238363084110568e-03, 2.4728948519911207e-03, 2.8833177421891043e-03, 3.2953076784660021e-03, 3.7079142091405747e-03, 4.1219359311165001e-03, 4.5381119193306993e-03, 4.9559085453083681e-03, 5.3743477036397235e-03, 5.7922224946934707e-03, 6.2088950357154921e-03, 6.6243013924924612e-03, 7.0375369595456934e-03, 7.4481168815136870e-03, 7.8564064627978502e-03, 8.2624777957852735e-03, 8.6651799004236734e-03, 9.0647597208410712e-03, 9.4606030010681054e-03, 9.8514307868616362e-03, 1.0237223746387128e-02, 1.0617398668452337e-02, 1.0994777685174524e-02, 1.1367771283735348e-02, 1.1736735906798738e-02, 1.2100014275964893e-02, 1.2455814450432716e-02, 1.2805635758676321e-02, 1.3150419401325475e-02, 1.3491527140446788e-02, 1.3828522502096792e-02, 1.4158753250462506e-02, 1.4483968494648570e-02, 1.4803300166904881e-02, 1.5114901291594787e-02, 1.5419104666249428e-02, 1.5720541294821637e-02, 1.6020539824009739e-02, 1.6314994832450094e-02, 1.6605380250889010e-02, 1.6893611748031626e-02, 1.7187525466994508e-02, 1.7484911404577523e-02, 1.7746543339095609e-02, 1.7756422474392086e-02, 1.7735093735471670e-02, 1.7720845607780283e-02, 1.7719403633114465e-02, 1.7720662592150348e-02, 1.7729425455305869e-02, 1.7754714025328598e-02, 1.7970502230074920e-02, 1.8624335254012248e-02, 1.3023863147950446e-03, 1.5929110084396605e-03, 2.0343114034508843e-03, 2.6087480815437133e-03, 3.0401392920669764e-03, 3.4712714815803829e-03, 3.9028789348848195e-03, 4.3344547457094713e-03, 4.7665348129183180e-03, 5.1984203718174748e-03, 5.6294702178170562e-03, 6.0585410062087000e-03, 6.4846681375881491e-03, 6.9073828630842301e-03, 7.3252207662726793e-03, 7.7349762660350345e-03, 8.1373306250337001e-03, 8.5300502036194520e-03, 8.9134293774004343e-03, 9.2893443592322635e-03, 9.6571617619951727e-03, 1.0012922003524882e-02, 1.0357840991346869e-02, 1.0691654221944203e-02, 1.1008228779733349e-02, 1.1316935231250363e-02, 1.1617512329165143e-02, 1.1905165822648231e-02, 1.2180354007892713e-02, 1.2444461400035724e-02, 1.2698269674923291e-02, 1.2939774173428382e-02, 1.3172943531782956e-02, 1.3398209413583719e-02, 1.3614985110986102e-02, 1.3825995308929955e-02, 1.4028584856334346e-02, 1.4232191602114919e-02, 1.4438012975975332e-02, 1.4649337543825284e-02, 1.4876083833069145e-02, 1.5115027929406865e-02, 1.5370880758873920e-02, 1.5657939049477210e-02, 1.5970115898758300e-02, 1.6260869389137116e-02, 1.6273423375169030e-02, 1.6249183076808896e-02, 1.6232829756560877e-02, 1.6230810028726492e-02, 1.6237612742648216e-02, 1.6241469780266537e-02, 1.6230951360564797e-02, 1.5942361100025140e-02, 1.5792991990867006e-02, 1.4180538917131071e-03, 1.7180860005641238e-03, 2.1786525576628695e-03, 2.7897685529608899e-03, 3.2444765877902562e-03, 3.6952095055639276e-03, 4.1415946115584993e-03, 4.5837079750838550e-03, 5.0203173922150563e-03, 5.4515107974211349e-03, 5.8774509753408396e-03, 6.2972473853384718e-03, 6.7107971354271731e-03, 7.1187035474830403e-03, 7.5209118906097465e-03, 7.9166991946869152e-03, 8.3089367982247930e-03, 8.6964514184589090e-03, 9.0789893715712087e-03, 9.4590126601451618e-03, 9.8372236460460595e-03, 1.0210110635581389e-02, 1.0575647443951362e-02, 1.0934812122334256e-02, 1.1283591040471313e-02, 1.1630703812680717e-02, 1.1974104313424565e-02, 1.2310665773362796e-02, 1.2645356663972859e-02, 1.2975535885506559e-02, 1.3294378357561872e-02, 1.3607109457951875e-02, 1.3917527296092498e-02, 1.4223916687815308e-02, 1.4528963083353002e-02, 1.4837564269039342e-02, 1.5146859352894065e-02, 1.5458779904736436e-02, 1.5773195966931778e-02, 1.6093325278169673e-02, 1.6439152850656984e-02, 1.6799544713308388e-02, 1.7178974361309891e-02, 1.7596844300948673e-02, 1.8030767098456007e-02, 1.8420534848264659e-02, 1.8452265538236177e-02, 1.8430138623947698e-02, 1.8411849198328622e-02, 1.8409000460294579e-02, 1.8415774810156289e-02, 1.8418473605647086e-02, 1.8360417426155264e-02, 1.7781529152783408e-02, 1.6395720146299513e-02, 1.4669618551833609e-03, 1.7751320405316783e-03, 2.2655203685333202e-03, 2.9194480539389001e-03, 3.4010295896935001e-03, 3.8710520635108071e-03, 4.3312982346951920e-03, 4.7830473195374281e-03, 5.2241942131977829e-03, 5.6560581257435599e-03, 6.0806821537055548e-03, 6.4975855644801312e-03, 6.9089158950036396e-03, 7.3181985565135173e-03, 7.7284367032145413e-03, 8.1486196510134924e-03, 8.5811987537448859e-03, 9.0321082093089509e-03, 9.4963981821967070e-03, 9.9767578347494355e-03, 1.0476654235795146e-02, 1.1000085596665083e-02, 1.1534525332877158e-02, 1.2082011950962077e-02, 1.2668499802984406e-02, 1.3272966706282835e-02, 1.3889209438536053e-02, 1.4520065653605186e-02, 1.5177383072221877e-02, 1.5852839574517663e-02, 1.6516724689748626e-02, 1.7201789220629555e-02, 1.7900093236384081e-02, 1.8597758830083157e-02, 1.9310861811011808e-02, 2.0038193281537268e-02, 2.0784000504253504e-02, 2.1514404337394183e-02, 2.2234971859882206e-02, 2.2944187805244175e-02, 2.3653223595060235e-02, 2.4351041964644254e-02, 2.5030789132324694e-02, 2.5716241487146907e-02, 2.6353801646642482e-02, 2.6884542050079726e-02, 2.6942639703299211e-02, 2.6935038687647021e-02, 2.6918256305866011e-02, 2.6914011522858518e-02, 2.6916228637326713e-02, 2.6916594973306646e-02, 2.6907791643286074e-02, 2.6741464314398788e-02, 2.6647756238251191e-02, 1.3658539230676332e-03, 1.6615718282394539e-03, 2.2605954188217774e-03, 3.0285271540821564e-03, 3.5938141975989748e-03, 4.1514007076943679e-03, 4.7060045071285915e-03, 5.2618321974679579e-03, 5.8233256699621941e-03, 6.3900301839001717e-03, 6.9648089009768316e-03, 7.5529211750612465e-03, 8.1522821889670003e-03, 8.7675949047644457e-03, 9.4070095690792065e-03, 1.0073075500578423e-02, 1.0757107768656059e-02, 1.1463248140624738e-02, 1.2186055645084157e-02, 1.2935896941828517e-02, 1.3719123565040733e-02, 1.4536938702963811e-02, 1.5377985336106731e-02, 1.6247526896858450e-02, 1.7196259111608641e-02, 1.8183155807882941e-02, 1.9191006754169602e-02, 2.0191638760322945e-02, 2.1223347118324444e-02, 2.2277866240622422e-02, 2.3304419767152220e-02, 2.4343417463348536e-02, 2.5384023551472536e-02, 2.6403508209179759e-02, 2.7417222463598179e-02, 2.8419230310831670e-02, 2.9414792786865037e-02, 3.0377443171901438e-02, 3.1306965114834648e-02, 3.2179800808154489e-02, 3.3009674234101706e-02, 3.3797806069681538e-02, 3.4531216851747974e-02, 3.5215449337989910e-02, 3.5805125819103098e-02, 3.6279187853690276e-02, 3.6345320895770056e-02, 3.6362818616279415e-02, 3.6356053483721854e-02, 3.6352760535180328e-02, 3.6346703404870402e-02, 3.6346334183116745e-02, 3.6381525573196231e-02, 3.6765387194715941e-02, 3.7730421174586248e-02, 1.0087434984848889e-03, 1.5355401205010470e-03, 2.4104930500987473e-03, 3.4610006792987467e-03, 4.2541736435168925e-03, 5.0634421967802323e-03, 5.8971189164786940e-03, 6.7554693746128651e-03, 7.6600480566105531e-03, 8.6008992635640720e-03, 9.5799452363459249e-03, 1.0616413031967229e-02, 1.1690837693851057e-02, 1.2804648622710331e-02, 1.3976852891107184e-02, 1.5175044401354875e-02, 1.6375253266181958e-02, 1.7561233967007372e-02, 1.8734042894310163e-02, 1.9916977173527101e-02, 2.1115217156040929e-02, 2.2298056467923134e-02, 2.3483860281425090e-02, 2.4681518102823395e-02, 2.5926311836217280e-02, 2.7204507099772544e-02, 2.8494221163470612e-02, 2.9677089659710179e-02, 3.0852459852365042e-02, 3.2012057409211959e-02, 3.3106633069392759e-02, 3.4129561335359750e-02, 3.5090173584401300e-02, 3.5971193136393076e-02, 3.6753167598430538e-02, 3.7456119013737403e-02, 3.8046222122737117e-02, 3.8606019178719572e-02, 3.9088517973190247e-02, 3.9459258710753356e-02, 3.9751377231423669e-02, 4.0002988269798680e-02, 4.0192037871232329e-02, 4.0263143293533067e-02, 4.0259414105762503e-02, 4.0237672011263485e-02, 4.0265500902563298e-02, 4.0307620830701649e-02, 4.0323776098776166e-02, 4.0323673867069296e-02, 4.0313689489204774e-02, 4.0306139246369846e-02, 4.0323639667291043e-02, 4.0712799577125924e-02, 4.0928142996292348e-02, 1.3953716510723873e-03, 2.3213364489006487e-03, 3.6092884471297030e-03, 5.2238942660468770e-03, 6.4682025619017093e-03, 7.7693112941337140e-03, 9.1132364869456750e-03, 1.0489732191411012e-02, 1.1913595154280646e-02, 1.3370679822669727e-02, 1.4866055755428306e-02, 1.6424848461315950e-02, 1.8006948007774370e-02, 1.9615248320012584e-02, 2.1273085409359741e-02, 2.2939465443746150e-02, 2.4602282043301837e-02, 2.6239540331096562e-02, 2.7834008350339605e-02, 2.9400878508452456e-02, 3.0930534785717098e-02, 3.2345413953099068e-02, 3.3699840411618359e-02, 3.4999768378426305e-02, 3.6229769250710434e-02, 3.7433070480167183e-02, 3.8607144100178535e-02, 3.9620697603104452e-02, 4.0590728946511626e-02, 4.1504757938432474e-02, 4.2314123083984509e-02, 4.2976478619587886e-02, 4.3504585913212955e-02, 4.3855344737156028e-02, 4.4020535641171782e-02, 4.4060143190908667e-02, 4.3922090919569758e-02, 4.3671448147239660e-02, 4.3296851018665941e-02, 4.2774568940880463e-02, 4.2191114596812102e-02, 4.1570879970585797e-02, 4.0888266326750841e-02, 3.9969966022581759e-02, 3.8941404777045108e-02, 3.8003711969431322e-02, 3.7925859307364869e-02, 3.7988740682824526e-02, 3.8032844858700614e-02, 3.8039977929645398e-02, 3.8030453667692754e-02, 3.8017311411764544e-02, 3.8018545266536932e-02, 3.8171535930902521e-02, 3.8180059571682794e-02, 3.7045073163119594e-03, 4.9583561955433919e-03, 6.8035509740745860e-03, 9.2399071558422283e-03, 1.1141503170500227e-02, 1.3119665441967169e-02, 1.5120821240315272e-02, 1.7123893657704104e-02, 1.9091691203716312e-02, 2.1025886613588708e-02, 2.2943889348515514e-02, 2.4857111713052042e-02, 2.6713548638957387e-02, 2.8529779841110693e-02, 3.0305953328970299e-02, 3.2056146452236145e-02, 3.3814729609827406e-02, 3.5594440050510878e-02, 3.7320125693917378e-02, 3.8974841468478280e-02, 4.0530703830860437e-02, 4.1874677057482310e-02, 4.3073926236833732e-02, 4.4119999274864138e-02, 4.4923056340356704e-02, 4.5591950122551288e-02, 4.6141490717972876e-02, 4.6610451359711355e-02, 4.7025334195150342e-02, 4.7383505561354948e-02, 4.7605258877286477e-02, 4.7693121098920099e-02, 4.7617997647244587e-02, 4.7251666574667617e-02, 4.6694841755925545e-02, 4.6048499534379124e-02, 4.5306928651436450e-02, 4.4238210617503257e-02, 4.2978207625985192e-02, 4.1605300132640195e-02, 4.0172109708502574e-02, 3.8696658769648638e-02, 3.7103225630918973e-02, 3.5151077741478326e-02, 3.3026012112785157e-02, 3.0963704281593049e-02, 3.0800761706203415e-02, 3.0860029502545742e-02, 3.0934815585175184e-02, 3.0945576002055605e-02, 3.0942630656261721e-02, 3.0930670205316989e-02, 3.0945121723808235e-02, 3.1063810635903185e-02, 3.1180100111323644e-02, 8.0942375003881951e-03, 9.8622524407957855e-03, 1.2228165611482756e-02, 1.5481872558265627e-02, 1.7965038138659812e-02, 2.0467494711988495e-02, 2.2937800699000289e-02, 2.5362110352856401e-02, 2.7661055947225576e-02, 2.9862975192984861e-02, 3.1997702677767338e-02, 3.4063304449161301e-02, 3.6015057410878154e-02, 3.7868588334858913e-02, 3.9581287003386180e-02, 4.1194070251655550e-02, 4.2767301199691694e-02, 4.4325045032075870e-02, 4.5777060062717354e-02, 4.7122785513898473e-02, 4.8345113988126090e-02, 4.9367825562183026e-02, 5.0204979792981844e-02, 5.0822895363357538e-02, 5.1078088872829795e-02, 5.1121214316367417e-02, 5.0951847845638248e-02, 5.0661780648542508e-02, 5.0307405664711403e-02, 4.9901566930492254e-02, 4.9310334757132916e-02, 4.8626843902565470e-02, 4.7792924127779274e-02, 4.6606658548044161e-02, 4.5292667866430263e-02, 4.3936129645665171e-02, 4.2620459324842097e-02, 4.0813641724793445e-02, 3.8803732875938600e-02, 3.6576078758004713e-02, 3.4237207114536490e-02, 3.1723018051109296e-02, 2.9083339276986236e-02, 2.6122908161554572e-02, 2.3203141936542708e-02, 2.0627482208033305e-02, 2.0440852674436599e-02, 2.0506021288214240e-02, 2.0590128732435587e-02, 2.0607072754082020e-02, 2.0601768030491945e-02, 2.0612467413164734e-02, 2.0593666164722153e-02, 2.0749201333180253e-02, 2.0990297806968046e-02, 1.4877167359098753e-02, 1.6733215046879042e-02, 1.9492815577270586e-02, 2.3241247517050031e-02, 2.5992731041510144e-02, 2.8597010732117154e-02, 3.1113831223423209e-02, 3.3547243683113917e-02, 3.5841555766171124e-02, 3.8045200830013122e-02, 4.0184290309004216e-02, 4.2249802934638925e-02, 4.4229849968077634e-02, 4.6108754202350527e-02, 4.7811368968590361e-02, 4.9303173966178705e-02, 5.0617452097454156e-02, 5.1702733157925014e-02, 5.2547205791301198e-02, 5.3261386959161244e-02, 5.3860457381250601e-02, 5.4410552047044758e-02, 5.4789551643937590e-02, 5.4956235940311481e-02, 5.4777316636451953e-02, 5.4394622511746808e-02, 5.3779368047151353e-02, 5.2679460935495671e-02, 5.1501418177485797e-02, 5.0242421174516119e-02, 4.8717354124878876e-02, 4.7106824449854430e-02, 4.5366700398375738e-02, 4.3346512056533559e-02, 4.1211467190138691e-02, 3.9069766544844890e-02, 3.6891286866201495e-02, 3.4391936701486131e-02, 3.1583652715330417e-02, 2.8628231170981785e-02, 2.5225505789372819e-02, 2.1671551783652945e-02, 1.7853757200601499e-02, 1.4145776581031822e-02, 1.1230823836340295e-02, 9.2602713757120609e-03, 9.1594352078656384e-03, 9.2352144944411914e-03, 9.3128110578447852e-03, 9.3195995458490929e-03, 9.3324631420855075e-03, 9.3149917946095031e-03, 9.3536045810567823e-03, 8.9596949695477622e-03, 9.0413125458370051e-03, 2.2434492108769400e-02, 2.4222075629071572e-02, 2.7169030098467686e-02, 3.1071537576123669e-02, 3.3852363542404833e-02, 3.6359282077284519e-02, 3.8745858073917901e-02, 4.1038115765271797e-02, 4.3227778733895959e-02, 4.5369832274320072e-02, 4.7455512975934040e-02, 4.9423557634778063e-02, 5.1292590813711125e-02, 5.3054939570915942e-02, 5.4644908955350076e-02, 5.5960315703123709e-02, 5.7012540412723127e-02, 5.7678966677475463e-02, 5.7934365978109879e-02, 5.8019000618800901e-02, 5.7967671457523143e-02, 5.7843907135675929e-02, 5.7540715591266375e-02, 5.7051916304612517e-02, 5.6286921068346485e-02, 5.5383924446491054e-02, 5.4288313038346490e-02, 5.2429725414849006e-02, 5.0459088643765478e-02, 4.8373202817770258e-02, 4.5983706412338357e-02, 4.3505422577757927e-02, 4.0937685769748211e-02, 3.8175125356060310e-02, 3.5346620112422698e-02, 3.2308078407002477e-02, 2.9049468844954653e-02, 2.5539780540796943e-02, 2.2075222877811822e-02, 1.8393944426024055e-02, 1.4836444291482754e-02, 1.1103499301441409e-02, 7.4721939010366769e-03, 4.1504804903980353e-03, 1.9202415230840206e-03, 1.3284489450061127e-03, 1.2888803242727838e-03, 1.4061183199858053e-03, 1.4342902466962140e-03, 1.4504691731703811e-03, 1.4383033360572928e-03, 1.4717939695711147e-03, 1.3428346299969814e-03, 1.1179744071399881e-03, -3.0193847036068559e-04, 2.9083324793687040e-02, 3.0997861335946938e-02, 3.3942114384628748e-02, 3.7779500841157776e-02, 4.0521083415307767e-02, 4.3037576966512475e-02, 4.5439336195880815e-02, 4.7763602650766603e-02, 5.0012054405711610e-02, 5.2221445648094972e-02, 5.4331277429605349e-02, 5.6157180778936597e-02, 5.7712223876391237e-02, 5.9072616973316845e-02, 6.0234828988696927e-02, 6.1151594698259107e-02, 6.1875342336864592e-02, 6.2323694060970672e-02, 6.2217462043073220e-02, 6.1874241143109993e-02, 6.1334882089175209e-02, 6.0296057303730312e-02, 5.9017040033342689e-02, 5.7538134702773649e-02, 5.5807080620396930e-02, 5.4005955259603625e-02, 5.2071611777444855e-02, 4.9565107261403223e-02, 4.6893388363689816e-02, 4.4088209773631176e-02, 4.1070366305725525e-02, 3.7961636192376219e-02, 3.4756831362672026e-02, 3.1466556816752096e-02, 2.7943844450109431e-02, 2.4279273296788053e-02, 1.9919453051670265e-02, 1.5522451671456959e-02, 1.1122205161355071e-02, 7.9856717680884797e-03, 5.3992948673711304e-03, 3.4299088286501573e-03, 1.2902179756261755e-03, -2.1577843266077802e-04, -5.6508473346164893e-04, -4.1621052732359123e-04, -2.1836406202003423e-04, -1.8584882814037961e-04, -1.6192453222248462e-04, -1.7811441150084601e-04, -1.5767305200527242e-04, -1.9684109428007120e-04, -8.4684228336506269e-05, -5.3534704625950939e-04, -2.8973608089161007e-05, 3.4895713808106882e-02, 3.6801240432538990e-02, 3.9743298629226757e-02, 4.3505606509406429e-02, 4.6252537529505082e-02, 4.8906748007476505e-02, 5.1501002455493293e-02, 5.4044710587191111e-02, 5.6475146703838679e-02, 5.8772384378893046e-02, 6.0883399615200520e-02, 6.2572017800530330e-02, 6.3760877027399368e-02, 6.4582553349157135e-02, 6.5057334588607338e-02, 6.5308876117584833e-02, 6.5452183567599437e-02, 6.5464791917216006e-02, 6.4874270078740567e-02, 6.4012449626284829e-02, 6.2912292314665400e-02, 6.0955845450556295e-02, 5.8709047004302663e-02, 5.6243379745591279e-02, 5.3530490334166007e-02, 5.0786136973361373e-02, 4.7966590562096324e-02, 4.4922776825913446e-02, 4.1676888008740663e-02, 3.8313977333385298e-02, 3.4827327462871219e-02, 3.1239077327578458e-02, 2.7477177161222235e-02, 2.3366839286298333e-02, 1.9325195645700399e-02, 1.4994825509169214e-02, 1.0852411272792878e-02, 6.5046323300230954e-03, 3.2947355390252593e-03, 1.2035942919900322e-04, -5.1148180080685284e-04, -9.7249025009558065e-04, -3.0524602790263659e-04, 7.1208669342534818e-06, 1.7435531348676132e-04, 1.2978288986617917e-03, 1.3496380448905813e-03, 1.4264991528793185e-03, 1.3814065887823022e-03, 1.3876082027965701e-03, 1.3669263493281405e-03, 1.4029780836680558e-03, 1.3422761432565025e-03, 1.7937006127085903e-03, 2.0281381374611346e-03, 3.9819954430654975e-02, 4.1797194645922020e-02, 4.4886684879804031e-02, 4.8832155064098048e-02, 5.1740473790565684e-02, 5.4626155076778857e-02, 5.7497093698906009e-02, 6.0292298595276031e-02, 6.2807898883821267e-02, 6.4959553150052043e-02, 6.6826154782930719e-02, 6.8327146445403011e-02, 6.9191871511790001e-02, 6.9517784491618217e-02, 6.9200461694126358e-02, 6.8596354827847206e-02, 6.7833804850272642e-02, 6.6867946628950806e-02, 6.5377773156907515e-02, 6.3652913279714701e-02, 6.1713551813821023e-02, 5.9086465265672440e-02, 5.6187221371625642e-02, 5.3095146415858156e-02, 4.9797165635666718e-02, 4.6462732071605971e-02, 4.3089443289097709e-02, 3.9591146338554345e-02, 3.5928301575232489e-02, 3.2087706227787789e-02, 2.8190967179084505e-02, 2.4066372732624994e-02, 1.9678647638501561e-02, 1.4875938037270596e-02, 9.7193630873781411e-03, 6.0170875571396417e-03, 3.5115017342070404e-03, 1.3995334487824534e-03, -1.0316198027935540e-03, 1.0861302931493577e-05, 1.3991155930992378e-04, 2.7547114813294038e-04, 7.8868693754156598e-05, -8.2618363054884388e-05, 1.3160779706079769e-03, 2.0101826915411144e-03, 2.2728371835150133e-03, 2.2052497899138143e-03, 2.1937349791427371e-03, 2.1698226777017741e-03, 2.1780130140102594e-03, 2.1599082911256092e-03, 2.2241994425461382e-03, 2.2907261540652084e-03, 2.6323119248148280e-03, 4.3953402557334091e-02, 4.6151705031116631e-02, 4.9607732208337009e-02, 5.4173781070783307e-02, 5.7571051026831029e-02, 6.0826982034545438e-02, 6.3931794702092246e-02, 6.6755080820539200e-02, 6.8898138295286973e-02, 7.0423529419261180e-02, 7.1590393507492078e-02, 7.2530101696614363e-02, 7.2895560102807372e-02, 7.2692635190157270e-02, 7.1659022236769482e-02, 7.0215943267637651e-02, 6.8519322639273017e-02, 6.6516273511363952e-02, 6.4071981759832031e-02, 6.1456183976449669e-02, 5.8704869229184421e-02, 5.5614164680318788e-02, 5.2316140574470850e-02, 4.8872451188041774e-02, 4.5284772528722886e-02, 4.1646427511183512e-02, 3.7928275927520308e-02, 3.4048443413880358e-02, 2.9965924872324426e-02, 2.5727341894008500e-02, 2.1113338269668373e-02, 1.6524128275418038e-02, 1.1881148862613202e-02, 6.8534235054311587e-03, 3.1555963791100915e-03, -7.0300695925442562e-04, -8.9556084918617222e-04, -3.8657198203876866e-04, 2.8669633398090079e-04, -1.3739378258486716e-05, -9.2581564910926794e-05, -9.7243076447410228e-05, -8.8331571365795854e-05, 6.1811934936478166e-04, 1.0122978792137867e-03, 2.0227888732309140e-03, 2.0375731515810879e-03, 2.0379677383552670e-03, 1.9816938654960833e-03, 1.9804549814208842e-03, 1.9718765640160643e-03, 1.9798211840043696e-03, 1.9503779310249708e-03, 2.0070364453516989e-03, 1.7573949215246949e-03, 4.7617385624547259e-02, 5.0402511473758606e-02, 5.4402777348478676e-02, 5.9859192941428621e-02, 6.3949900856900901e-02, 6.7538720109797362e-02, 7.0607344320492274e-02, 7.3022194901345427e-02, 7.4157638855232355e-02, 7.4579449962084113e-02, 7.4625315421932473e-02, 7.4492947564983827e-02, 7.4050719948888316e-02, 7.3193492436136542e-02, 7.1647569281631601e-02, 6.9559307092995404e-02, 6.7212146324244756e-02, 6.4643278993212080e-02, 6.1619332239900959e-02, 5.8465381611757246e-02, 5.5247531268926973e-02, 5.1797138194362394e-02, 4.8191517819783390e-02, 4.4453130818895369e-02, 4.0641687946100791e-02, 3.6723196025153178e-02, 3.2695883164325118e-02, 2.8326779120278089e-02, 2.3857206792622005e-02, 1.9014398869753119e-02, 1.3882551680733617e-02, 8.7406553542897867e-03, 4.5850938186864677e-03, 2.2327149832805501e-03, -1.0735899459979636e-03, 2.5315389839554778e-04, 2.3782238487298965e-04, 1.1222603478124992e-04, -1.0493490368364832e-04, 4.7503025138358147e-05, 2.1650518414109623e-04, 1.9386064568110233e-04, 2.7154758016668533e-04, 3.6803816064890228e-04, 1.0961471201867104e-03, 1.7911906559614915e-03, 1.9025240380842283e-03, 1.8418358197472904e-03, 1.8124648055769801e-03, 1.7996146659472344e-03, 1.8045086195579562e-03, 1.7975875686403922e-03, 1.8054145028745222e-03, 1.7286169137242507e-03, 1.7397441650733824e-03, 5.2608107981922933e-02, 5.5999436174418056e-02, 6.0362848655236175e-02, 6.6083422973100520e-02, 7.0122555868523520e-02, 7.3305770763075401e-02, 7.5686174317334889e-02, 7.7205666320705024e-02, 7.7206521086194344e-02, 7.6618021407543063e-02, 7.5717407541262299e-02, 7.4619648420774329e-02, 7.3397168541695076e-02, 7.1918063566213830e-02, 6.9985601126165295e-02, 6.7465562308993074e-02, 6.4726450183033302e-02, 6.1881618423437514e-02, 5.8596530944066527e-02, 5.5193142264664291e-02, 5.1728077455486000e-02, 4.7997596365692473e-02, 4.4121350474521780e-02, 4.0117787292762698e-02, 3.6020308553738993e-02, 3.1789116681495241e-02, 2.7299298883047281e-02, 2.2477798903969642e-02, 1.7258041479753045e-02, 1.2331703009580310e-02, 6.8218780984747058e-03, 3.1993397379852652e-03, -2.8753170901208331e-04, -8.1617485270230386e-04, 3.5298781369430039e-04, -9.6347657522047176e-05, -1.1541290486870951e-04, -3.0972946643098044e-05, 7.6352896901556120e-05, 8.8898187686247296e-05, 3.4971085836255219e-05, 6.1318727531186714e-05, 9.9097787179706703e-05, 4.9007718013142096e-04, 1.0423675449409478e-03, 1.8659221765417776e-03, 1.9147682098499131e-03, 1.8858884038295864e-03, 1.8442486596359916e-03, 1.8405368982459965e-03, 1.8400418298830381e-03, 1.8446145658341786e-03, 1.8366587229818119e-03, 1.8525374252783258e-03, 1.8604748561122340e-03, 6.0730483811722191e-02, 6.3206456856778545e-02, 6.7459514279905278e-02, 7.2132675377848884e-02, 7.4786152946421755e-02, 7.6504652199477149e-02, 7.7508006453249179e-02, 7.7840560862007468e-02, 7.7180734039375282e-02, 7.6202601136484277e-02, 7.5038359087486378e-02, 7.3641403520523938e-02, 7.1998501284721017e-02, 7.0099399521957859e-02, 6.7809287146682107e-02, 6.5025669501687686e-02, 6.2021912441727840e-02, 5.8867035262550542e-02, 5.5428795163616304e-02, 5.1854714636072552e-02, 4.8156002081217550e-02, 4.4192706335117550e-02, 4.0091935219396156e-02, 3.5845965580703833e-02, 3.1417619789076832e-02, 2.6700718901403200e-02, 2.1778158068506158e-02, 1.6259721817597363e-02, 1.0871547610705508e-02, 5.2290018919169262e-03, 2.6837874709602491e-03, -5.5006912290169136e-04, -6.0505525668434070e-06, 2.5664380999077728e-04, -1.2757675171722418e-04, 8.1342465523520456e-05, 2.2795686855935153e-04, 1.1114862387857046e-04, 4.8283337307770452e-05, 4.0956682247553637e-05, 5.4429336928823278e-05, 3.5020309160267584e-05, 1.0727841984376183e-04, 4.3410128840586337e-04, 1.0938491273205144e-03, 1.8748139187070795e-03, 1.9565699084126359e-03, 1.9156232154687043e-03, 1.8821509967073822e-03, 1.8747840591061275e-03, 1.8777018090907439e-03, 1.8784602953050304e-03, 1.8835044640333053e-03, 1.8848613130378331e-03, 1.9091215740505271e-03, 6.7433386632592907e-02, 6.8579470460255490e-02, 7.2159419747161238e-02, 7.5223136867830553e-02, 7.6335483114856550e-02, 7.6645069406082025e-02, 7.6518236422572286e-02, 7.6070026801633092e-02, 7.5317681659827690e-02, 7.4425157374531647e-02, 7.3388495935441944e-02, 7.2025326195785541e-02, 7.0193404018271288e-02, 6.8026592016286136e-02, 6.5456943167811948e-02, 6.2512985198904428e-02, 5.9323349484447355e-02, 5.5874399957793752e-02, 5.2286912785770030e-02, 4.8537164155113929e-02, 4.4586588786099043e-02, 4.0401343026453942e-02, 3.6061568417785447e-02, 3.1578648616828402e-02, 2.6677135873875792e-02, 2.1486928474934580e-02, 1.5815799994412971e-02, 1.0380905613496628e-02, 4.8206184492747030e-03, 1.1625143398337901e-03, -9.7793331213542152e-04, 2.1895095060960900e-04, -1.5876888433094754e-05, -1.0078514601939612e-04, 5.6597641643485720e-05, 9.1406525868604777e-05, 3.2154184178854735e-05, 6.0132188788961101e-05, 5.7042545082310824e-05, 5.4502162264537833e-05, 4.0100905747345234e-05, 5.1482238181874003e-05, 1.0762167431252638e-04, 4.5165435323452123e-04, 1.0677799892103987e-03, 1.8689518923297810e-03, 1.9390712371529473e-03, 1.9051488880305299e-03, 1.8685043242487388e-03, 1.8629897858891903e-03, 1.8641229841945064e-03, 1.8666423037945463e-03, 1.8659162748897976e-03, 1.8695095934832091e-03, 1.8554842981294592e-03, 6.7852153823607111e-02, 6.8969667274845076e-02, 7.1403309586536359e-02, 7.3354573989914504e-02, 7.4027297062926434e-02, 7.4092460638636587e-02, 7.3918472862651144e-02, 7.3599121228103415e-02, 7.3174001210120396e-02, 7.2483390344990295e-02, 7.1511133906783306e-02, 7.0047054378388526e-02, 6.8035593427113572e-02, 6.5668900674530906e-02, 6.2951903865956629e-02, 5.9904801311744110e-02, 5.6600232675139438e-02, 5.2994106852845370e-02, 4.9234861134097314e-02, 4.5286536713750609e-02, 4.1101578574685931e-02, 3.6658286659455579e-02, 3.2051857416444209e-02, 2.7167849251654639e-02, 2.1841190782616347e-02, 1.5902670599198216e-02, 1.0078790056839730e-02, 4.5562734233897837e-03, 1.5278355173613421e-03, -1.0312805910202825e-03, 4.5981701670163346e-04, -1.1322154508007395e-04, 2.0636846363542930e-05, 1.4616578124022474e-04, 4.5473263417457514e-05, 4.4982249387994275e-05, 6.6578953171180275e-05, 5.3565258799131024e-05, 5.2235555627851275e-05, 5.7957067481872609e-05, 5.3364146054986525e-05, 5.9822864929258617e-05, 1.2143997309060813e-04, 4.4396636413411545e-04, 1.0684162314805467e-03, 1.8571341574240734e-03, 1.9323100264037002e-03, 1.8952900735088782e-03, 1.8601542538617215e-03, 1.8535746242126895e-03, 1.8553966348545147e-03, 1.8566063407040000e-03, 1.8578351242153522e-03, 1.8531193670475806e-03, 1.8540201734560616e-03, 6.4327931022366683e-02, 6.5400347771114503e-02, 6.7003706475805447e-02, 6.8590943095732201e-02, 6.9604334846362678e-02, 7.0247615311034017e-02, 7.0714842196772709e-02, 7.1002561821278537e-02, 7.0997251198168090e-02, 7.0459372424878083e-02, 6.9454391868376361e-02, 6.7823248349837939e-02, 6.5670294132336521e-02, 6.3192232528840195e-02, 6.0418572503402018e-02, 5.7298303768491876e-02, 5.3911273551561979e-02, 5.0213767584295715e-02, 4.6254550404295540e-02, 4.2089937210168467e-02, 3.7676434215433270e-02, 3.2969177538547056e-02, 2.7974499212380446e-02, 2.2674804381322192e-02, 1.6602957996214873e-02, 1.0687880412876142e-02, 4.5526493008899056e-03, 1.2996774725842378e-03, -1.0375998560417418e-03, 4.4972721583418464e-04, -1.7837285029271706e-04, 2.8723306088593784e-05, 8.8558515790808530e-05, 3.5316216826421833e-05, 6.1960287350163070e-05, 5.6375749824208144e-05, 4.9064341258267829e-05, 5.2282083161904363e-05, 5.2985331947205809e-05, 5.1256938627592228e-05, 4.4946538392146857e-05, 5.4350684319896301e-05, 1.1525064743559129e-04, 4.4809593293619653e-04, 1.0691285491356826e-03, 1.8628849482062713e-03, 1.9354864759300119e-03, 1.8998079382796125e-03, 1.8638614270931179e-03, 1.8577135403878109e-03, 1.8590950668967094e-03, 1.8609021708466871e-03, 1.8609874779088793e-03, 1.8617167553181071e-03, 1.8633624869058554e-03, 5.9240101154865721e-02, 6.0284120631743071e-02, 6.1897693623136650e-02, 6.3755559673071727e-02, 6.5148845767154781e-02, 6.6452183519357513e-02, 6.7535787434169950e-02, 6.8335417061156103e-02, 6.8558830835188947e-02, 6.8107951208761786e-02, 6.7100611634022977e-02, 6.5440174689407493e-02, 6.3279916078307089e-02, 6.0801876976136565e-02, 5.8003848557121263e-02, 5.4808481001274105e-02, 5.1321538573504022e-02, 4.7502482467257898e-02, 4.3314139849143236e-02, 3.8911459326689858e-02, 3.4281980751170504e-02, 2.9242330761128834e-02, 2.3834938242929198e-02, 1.7892379150351845e-02, 1.1504309516620933e-02, 5.4116131178702249e-03, 1.6611306668538662e-03, -1.0564967700785780e-03, 4.7439477755938949e-04, -1.8560134328914036e-04, 9.2304076720891117e-05, 7.7275731517352980e-05, 3.7310702334837884e-05, 6.5492285019406679e-05, 5.0908857052658994e-05, 6.2101044314414233e-05, 6.0403173065487205e-05, 5.5900036531728865e-05, 5.2383873835260000e-05, 5.0875733661935867e-05, 4.4857282116331179e-05, 5.1806974040954391e-05, 1.1404071512436092e-04, 4.4705737124639956e-04, 1.0718194562040052e-03, 1.8646309118401992e-03, 1.9384435956423883e-03, 1.9021794496978056e-03, 1.8665674723578659e-03, 1.8601976684363163e-03, 1.8617813971124764e-03, 1.8633532738907990e-03, 1.8641548602402350e-03, 1.8640862336733782e-03, 1.8661373194051752e-03, 5.3869908018851553e-02, 5.5202189078640336e-02, 5.7199271790378044e-02, 5.9547948211065890e-02, 6.1212620650411761e-02, 6.2951271299896763e-02, 6.4405863886966522e-02, 6.5504157292660029e-02, 6.5858819796913215e-02, 6.5508661770887433e-02, 6.4589040231995923e-02, 6.3034923334207626e-02, 6.0954453102996464e-02, 5.8514606893189734e-02, 5.5676900288258481e-02, 5.2388763895047902e-02, 4.8775934022611156e-02, 4.4799734234623828e-02, 4.0390356994087315e-02, 3.5762503871527920e-02, 3.0868920837969108e-02, 2.5451177368640266e-02, 1.9412451395211288e-02, 1.3107988521203252e-02, 6.4047125551153043e-03, 2.4277144654836990e-03, -1.1719916795828722e-03, 4.8106505342189991e-04, -1.8824885108503409e-04, 6.9743357688481305e-05, 6.1716090840334593e-05, 4.4206387023144479e-05, 6.3541432391100647e-05, 4.9246753211723301e-05, 5.4190250235131167e-05, 5.2818577752197085e-05, 5.2980109272843504e-05, 5.3098146681066204e-05, 5.2858942984552403e-05, 5.0809952379692709e-05, 4.4492223151656225e-05, 5.3444485900746510e-05, 1.1498499050107945e-04, 4.4732162438413005e-04, 1.0706143801644001e-03, 1.8638203745213492e-03, 1.9372157596978315e-03, 1.9011989867418785e-03, 1.8654384637755840e-03, 1.8591704205084018e-03, 1.8606685372695659e-03, 1.8623524098760329e-03, 1.8628342871268562e-03, 1.8627100501788999e-03, 1.8624387364861263e-03, 4.9535216669018015e-02, 5.0909474747443138e-02, 5.3097248680463602e-02, 5.5784131508176245e-02, 5.7683923956238774e-02, 5.9587635696861874e-02, 6.1191917035033162e-02, 6.2439250960782927e-02, 6.3002796162075020e-02, 6.2840183897736560e-02, 6.2097707941487564e-02, 6.0711878556626735e-02, 5.8712124288775702e-02, 5.6280439934833740e-02, 5.3361630237296370e-02, 4.9964447517922755e-02, 4.6215311176361136e-02, 4.2060432801489897e-02, 3.7481940410608337e-02, 3.2633820773139977e-02, 2.7429564184170308e-02, 2.1469484744920466e-02, 1.4918086546182568e-02, 8.0017617713880832e-03, 3.1186764868375038e-03, -2.9993625311767580e-04, 2.2215528083939444e-04, -1.0543075034140019e-04, 5.1631809981590914e-05, 6.7162090578179267e-05, 4.3049895849769042e-05, 6.2287058733047893e-05, 5.6154370615261812e-05, 5.7808543987413437e-05, 5.2221175851676625e-05, 5.2847029157410926e-05, 5.2889216250521960e-05, 5.2902975069293390e-05, 5.2696217883926692e-05, 5.1519124942597154e-05, 4.5261759796539621e-05, 5.3987459902299793e-05, 1.1564440401746347e-04, 4.4714010014632787e-04, 1.0703176398796290e-03, 1.8630472381919105e-03, 1.9365750969430784e-03, 1.9004380209809079e-03, 1.8647453943590492e-03, 1.8584321890776391e-03, 1.8599760676863682e-03, 1.8615939087620406e-03, 1.8621876888900441e-03, 1.8615970256823597e-03, 1.8622382966736910e-03, 4.5689250858039862e-02, 4.7131266881281476e-02, 4.9372017997089727e-02, 5.2296707926287121e-02, 5.4399446651398710e-02, 5.6280157315148911e-02, 5.7880752061464043e-02, 5.9197152626284305e-02, 6.0020524891930452e-02, 6.0114693744376557e-02, 5.9603064638966030e-02, 5.8394892253607784e-02, 5.6484583649617073e-02, 5.4068987968536590e-02, 5.1071604279080876e-02, 4.7558312618668358e-02, 4.3671666029380288e-02, 3.9345353731472563e-02, 3.4599277740205554e-02, 2.9483865033550313e-02, 2.3893231004640626e-02, 1.7341642447961374e-02, 1.0522182986007326e-02, 3.7097272391973151e-03, 6.8000829832140280e-04, -3.2010325574892905e-04, 5.4538525886331923e-05, -2.1956946681740131e-05, 7.6294825387762869e-05, 4.2137350058108341e-05, 6.2061017616971766e-05, 5.0299430946734333e-05, 5.4188500643247348e-05, 5.2415649834680809e-05, 5.2962236183745405e-05, 5.2580606987222849e-05, 5.2705665794397029e-05, 5.2888365570279146e-05, 5.2768762683947187e-05, 5.0937490127691990e-05, 4.4732506869614136e-05, 5.3603989261699130e-05, 1.1530015950766642e-04, 4.4725087758041340e-04, 1.0704631081353319e-03, 1.8633723418335201e-03, 1.9368173686121716e-03, 1.9007331031643130e-03, 1.8650095105683989e-03, 1.8587195612347431e-03, 1.8602417207748731e-03, 1.8618955496164072e-03, 1.8624329995137888e-03, 1.8621871633587388e-03, 1.8629718942048932e-03, 4.1820710713252614e-02, 4.3408319148066789e-02, 4.5806629497781998e-02, 4.8984839724223905e-02, 5.1265280095748392e-02, 5.3029840785177404e-02, 5.4559581136383768e-02, 5.5902335252985949e-02, 5.6957351046497039e-02, 5.7318120871804462e-02, 5.7054496255638111e-02, 5.6002535269667496e-02, 5.4219010991395110e-02, 5.1871941923359949e-02, 4.8842123003849582e-02, 4.5215987644257258e-02, 4.1188893319078719e-02, 3.6721909936433803e-02, 3.1733258490053533e-02, 2.6296094465095024e-02, 2.0174737746883321e-02, 1.3248278285213435e-02, 6.3711934227910702e-03, 1.2051093100398525e-03, -7.0566133215480464e-04, 2.3204181001824274e-04, -6.7998125956952966e-05, 7.3335474610858184e-05, 4.1334700677131422e-05, 6.4536289355067013e-05, 5.3725701107413782e-05, 5.4570151276219478e-05, 5.2405812854649961e-05, 5.2864055780351496e-05, 5.2604625561988149e-05, 5.3456343452463739e-05, 5.3285736040770368e-05, 5.3161016944513651e-05, 5.2733704676915627e-05, 5.0937054438822479e-05, 4.4702211648424406e-05, 5.3416653651992821e-05, 1.1516519666157029e-04, 4.4723543538056692e-04, 1.0706059809141705e-03, 1.8635270215511983e-03, 1.9370183899096304e-03, 1.9009161745788647e-03, 1.8652070420122166e-03, 1.8589070116175742e-03, 1.8604394015583334e-03, 1.8620803936152455e-03, 1.8626576750414938e-03, 1.8623815926303309e-03, 1.8631506579471285e-03, 3.8003675588820854e-02, 3.9726196421844981e-02, 4.2328325071556407e-02, 4.5737827757547339e-02, 4.8155475668268513e-02, 4.9880676233630773e-02, 5.1377999060753250e-02, 5.2734163977196290e-02, 5.3959965605582361e-02, 5.4553144566294530e-02, 5.4526161448268752e-02, 5.3629228290405652e-02, 5.1974286051094200e-02, 4.9702693739650236e-02, 4.6657197523395540e-02, 4.2927898389066597e-02, 3.8766281230420120e-02, 3.4131172646978833e-02, 2.8879162290248128e-02, 2.3001687804851203e-02, 1.6479760441764687e-02, 9.0481248084097448e-03, 3.4791767604902680e-03, -9.9184150436144370e-04, 3.7106098942591521e-04, -1.1884541938624630e-04, 5.7151133028968424e-05, 5.1153783001115839e-05, 5.6777383755638746e-05, 5.3096824912782689e-05, 5.3522990508956072e-05, 5.2629433779456549e-05, 5.2700381863606091e-05, 5.2661375655929062e-05, 5.2786417166233794e-05, 5.2757183026070316e-05, 5.2851041985704490e-05, 5.2958995261766532e-05, 5.2758092446430365e-05, 5.0920937356361225e-05, 4.4680845670066342e-05, 5.3533634680276993e-05, 1.1524903460382295e-04, 4.4723132734207096e-04, 1.0705414577592558e-03, 1.8634598967900344e-03, 1.9369406339088935e-03, 1.9008465810385147e-03, 1.8651317618483452e-03, 1.8588359471173727e-03, 1.8603635997823428e-03, 1.8620096129501455e-03, 1.8625685892270914e-03, 1.8622745412042972e-03, 1.8628960589343083e-03, 3.4354584802722597e-02, 3.6160554296162363e-02, 3.8937209414941852e-02, 4.2495683257078531e-02, 4.4978832963940334e-02, 4.6857274759042160e-02, 4.8418081754380733e-02, 4.9805320845713354e-02, 5.1132435778180170e-02, 5.1908487834101909e-02, 5.2095014538899476e-02, 5.1376929608937486e-02, 4.9813103181553249e-02, 4.7573642482101039e-02, 4.4490588103573141e-02, 4.0675000586900566e-02, 3.6377715709177430e-02, 3.1527765283519457e-02, 2.5956106406235507e-02, 1.9655624974620881e-02, 1.2647252803443294e-02, 5.4832503486942344e-03, 7.9484453384560309e-04, -1.9473480944564371e-04, 2.7755235275812997e-05, -1.1221457529240641e-05, 7.3166326139345996e-05, 4.7608918070587376e-05, 5.9822906241222755e-05, 5.2358065126158199e-05, 5.3024265607951824e-05, 5.2579340294811304e-05, 5.3203237286948396e-05, 5.2994175582765234e-05, 5.2750424505564315e-05, 5.2780666006076304e-05, 5.2817874880580212e-05, 5.2940320902928753e-05, 5.2746174681282540e-05, 5.0973102026311886e-05, 4.4734026672117730e-05, 5.3573135067942904e-05, 1.1529104972263709e-04, 4.4722851631593996e-04, 1.0705132936755263e-03, 1.8634106977488735e-03, 1.9368928664032792e-03, 1.9007944337088285e-03, 1.8650819715328650e-03, 1.8587840174983643e-03, 1.8603137832664935e-03, 1.8619560580725206e-03, 1.8625201117268421e-03, 1.8621985176105454e-03, 1.8628756896190951e-03, 3.0788491480175723e-02, 3.2678947724648168e-02, 3.5640989818266931e-02, 3.9328433709457752e-02, 4.1847247351092763e-02, 4.3882977444641619e-02, 4.5550808965360373e-02, 4.7010668068468819e-02, 4.8382811650447680e-02, 4.9315692277235236e-02, 4.9716840279937724e-02, 4.9183387150759872e-02, 4.7698151326939733e-02, 4.5475108734761113e-02, 4.2355989116405236e-02, 3.8455281725773942e-02, 3.4022285625060662e-02, 2.8928023796083054e-02, 2.2958751044745124e-02, 1.6129954715071768e-02, 8.6550834759552588e-03, 2.7071080177450148e-03, -8.6949131921294559e-04, 2.3280380311900304e-04, -7.1261240728675079e-05, 6.9693514045922079e-05, 4.5250582250993468e-05, 5.8617004223435232e-05, 5.2275962315226545e-05, 5.3207797875422213e-05, 5.2563010378932846e-05, 5.2756728262873334e-05, 5.2735884370131491e-05, 5.2780091702927274e-05, 5.2774285716758419e-05, 5.2754822728553027e-05, 5.2808455935614905e-05, 5.2938257745328390e-05, 5.2750198844194916e-05, 5.0930824849157566e-05, 4.4696769228170311e-05, 5.3545471142248692e-05, 1.1526872194257996e-04, 4.4723308883371930e-04, 1.0705270965934558e-03, 1.8634319396308512e-03, 1.9369114669714202e-03, 1.9008147841798903e-03, 1.8651010891667795e-03, 1.8588041456408914e-03, 1.8603328211751870e-03, 1.8619770974386603e-03, 1.8625384406072932e-03, 1.8622385084503500e-03, 1.8629307253119590e-03, 2.7214987955934637e-02, 2.9212492284657866e-02, 3.2419330923553334e-02, 3.6287761546394737e-02, 3.8871825237951206e-02, 4.0894091141848783e-02, 4.2656700543543001e-02, 4.4249542261346891e-02, 4.5626028086205611e-02, 4.6707540203828966e-02, 4.7330881348013547e-02, 4.6966268206405606e-02, 4.5582648176832989e-02, 4.3401566333960175e-02, 4.0270034155715013e-02, 3.6274314219303549e-02, 3.1685250219703052e-02, 2.6364763159915618e-02, 1.9883186561510401e-02, 1.2499376241910391e-02, 4.6532587018159053e-03, 6.2541933472598716e-04, -1.2669726388866490e-04, 3.4397427305476928e-05, -3.0278137199602228e-06, 6.5198591694882213e-05, 5.4488618440735557e-05, 5.4810864405356767e-05, 5.2707080237357003e-05, 5.3018812015082981e-05, 5.2867082973790389e-05, 5.2796598064444804e-05, 5.2768394112974074e-05, 5.2768712119231917e-05, 5.2753547721227281e-05, 5.2816381820984366e-05, 5.2846677342528096e-05, 5.2957450811188619e-05, 5.2747932388233117e-05, 5.0931030263162043e-05, 4.4694464421978511e-05, 5.3532191977547400e-05, 1.1525821728598020e-04, 4.4723332125605621e-04, 1.0705359879766045e-03, 1.8634438196531683e-03, 1.9369251898576671e-03, 1.9008280462705751e-03, 1.8651149026371111e-03, 1.8588175372043420e-03, 1.8603467374986031e-03, 1.8619904127511974e-03, 1.8625540136021892e-03, 1.8622534293089191e-03, 1.8629423614949297e-03, 2.3630642246556345e-02, 2.5748043123561208e-02, 2.9182415274958379e-02, 3.3268433010207238e-02, 3.5961125201497732e-02, 3.7970492524705766e-02, 3.9849539810440204e-02, 4.1609968368396963e-02, 4.2999542521044265e-02, 4.4175335829075006e-02, 4.4953508948345836e-02, 4.4753848488348298e-02, 4.3498829575943310e-02, 4.1379163387963679e-02, 3.8222619699366002e-02, 3.4109221979076926e-02, 2.9351475379143361e-02, 2.3722531173120152e-02, 1.6825263938363838e-02, 9.0556049991372348e-03, 1.7358628663038712e-03, -5.9683853620117518e-04, 1.5396631248263255e-04, -5.6779346267236455e-05, 6.9547289933492555e-05, 4.7648025991522785e-05, 5.6700728991044351e-05, 5.2723750521257464e-05, 5.2907401142596245e-05, 5.2636640472289416e-05, 5.2760620481824222e-05, 5.2761344160533072e-05, 5.2762862948316423e-05, 5.2759962832324633e-05, 5.2763434995071298e-05, 5.2764293206990607e-05, 5.2816157932941041e-05, 5.2942978717466564e-05, 5.2749711743014107e-05, 5.0929880929287301e-05, 4.4693007279308497e-05, 5.3540530251209300e-05, 1.1526452673011543e-04, 4.4723246015010583e-04, 1.0705318212053383e-03, 1.8634385672902528e-03, 1.9369197813279419e-03, 1.9008228559514542e-03, 1.8651095276808935e-03, 1.8588123392386611e-03, 1.8603413230645132e-03, 1.8619852294191554e-03, 1.8625478445696213e-03, 1.8622452793244505e-03, 1.8629246845760124e-03, 2.0052873382876063e-02, 2.2274625090535190e-02, 2.5876546694223203e-02, 3.0171922225834129e-02, 3.3026143287628193e-02, 3.5205237404993713e-02, 3.7265545441224728e-02, 3.9184821303877460e-02, 4.0634859256633016e-02, 4.1816722757538713e-02, 4.2624411206091686e-02, 4.2594288248961380e-02, 4.1474346999764267e-02, 3.9424949459052470e-02, 3.6186374935230615e-02, 3.1957366284416304e-02, 2.6952802451584622e-02, 2.0990628928372369e-02, 1.3605686424393438e-02, 6.4543809552081999e-03, -4.5594044403834265e-05, 4.9927432049852063e-05, -1.3623219485823970e-05, 1.7319890799002262e-05, 5.8518664840399366e-05, 5.4012912826779101e-05, 5.4517565159872596e-05, 5.2679181127670813e-05, 5.2967994696895844e-05, 5.2694278495752996e-05, 5.2765812411753932e-05, 5.2758046743519752e-05, 5.2799315383886867e-05, 5.2781110899871455e-05, 5.2759420432781926e-05, 5.2766321167487627e-05, 5.2813533482008729e-05, 5.2941740889181399e-05, 5.2748909085955416e-05, 5.0933649477882745e-05, 4.4696805450734565e-05, 5.3543390062162405e-05, 1.1526741806440266e-04, 4.4723245276737404e-04, 1.0705295838468647e-03, 1.8634351840014795e-03, 1.9369162485214553e-03, 1.9008191735299512e-03, 1.8651059214476184e-03, 1.8588086450717447e-03, 1.8603377286873137e-03, 1.8619814362768254e-03, 1.8625442656282144e-03, 1.8622400664488939e-03, 1.8629229598739598e-03, 1.6444299014758863e-02, 1.8812689747126937e-02, 2.2570048872566521e-02, 2.7103193413506498e-02, 3.0138345255189842e-02, 3.2601500407270688e-02, 3.4855223795559949e-02, 3.6884522659063002e-02, 3.8400240998225116e-02, 3.9572150548897692e-02, 4.0373313804331394e-02, 4.0465231950393227e-02, 3.9452251923694913e-02, 3.7465790755389784e-02, 3.4174930238512084e-02, 2.9796446491839254e-02, 2.4524873958197260e-02, 1.8075213857759575e-02, 1.0432117402210860e-02, 3.8707202865657557e-03, -2.6077804403231168e-04, 6.3128662680312164e-05, -2.8459918129432822e-05, 5.5719401154675463e-05, 5.2016485593647329e-05, 5.5461383633429911e-05, 5.2884832073259175e-05, 5.2858008187491485e-05, 5.2664344827243856e-05, 5.2759459559578259e-05, 5.2754905844412904e-05, 5.2767835202233211e-05, 5.2764140899099156e-05, 5.2764414752369525e-05, 5.2761218283702710e-05, 5.2764338611292642e-05, 5.2813024859925530e-05, 5.2941618214068723e-05, 5.2749202745395192e-05, 5.0930611218844257e-05, 4.4694135788875603e-05, 5.3541391042832482e-05, 1.1526585855862323e-04, 4.4723270280384246e-04, 1.0705306598889979e-03, 1.8634366495194734e-03, 1.9369176335276494e-03, 1.9008206161973786e-03, 1.8651073193175736e-03, 1.8588100864035653e-03, 1.8603391165677948e-03, 1.8619829333296396e-03, 1.8625456392235610e-03, 1.8622428295121435e-03, 1.8629270410138168e-03, 1.2876248122036920e-02, 1.5326759677370717e-02, 1.9378555420750378e-02, 2.4171903204155534e-02, 2.7380120550006753e-02, 3.0116250411609230e-02, 3.2509167802371300e-02, 3.4578842420240959e-02, 3.6131930612612773e-02, 3.7346451171858280e-02, 3.8200645697781685e-02, 3.8331479057278454e-02, 3.7376574272406891e-02, 3.5444752525357365e-02, 3.2185448397999999e-02, 2.7648611011933250e-02, 2.2021988438300871e-02, 1.5197803870814817e-02, 7.1522667375836547e-03, 1.6382485459320358e-03, -5.6504882011109477e-04, 1.5582745254012127e-04, -4.3383189652588530e-05, 7.4091541261184750e-05, 4.9173703109169253e-05, 5.5747355482662200e-05, 5.2543291706740355e-05, 5.2848147626159391e-05, 5.2688291972412774e-05, 5.2781801779690588e-05, 5.2775576686546337e-05, 5.2769301013936578e-05, 5.2765137156563464e-05, 5.2763359475384988e-05, 5.2759679163287100e-05, 5.2768866087193188e-05, 5.2815775879460453e-05, 5.2943005379174161e-05, 5.2749041460321063e-05, 5.0930624657343180e-05, 4.4693967091367607e-05, 5.3540441933625544e-05, 1.1526508782998363e-04, 4.4723275154276356e-04, 1.0705312674858926e-03, 1.8634375317656555e-03, 1.9369186035922039e-03, 1.9008215830571935e-03, 1.8651083064263644e-03, 1.8588110561307577e-03, 1.8603401111402622e-03, 1.8619839002959621e-03, 1.8625467317582552e-03, 1.8622439538834752e-03, 1.8629278126879945e-03, 9.3587214365224401e-03, 1.2065054360087825e-02, 1.6226562587134473e-02, 2.1340779730302142e-02, 2.4732062685539145e-02, 2.7653447319475871e-02, 3.0143563464002106e-02, 3.2267777856104858e-02, 3.3853435510542082e-02, 3.5128346769555827e-02, 3.6051845955633752e-02, 3.6202482663008906e-02, 3.5297426905627718e-02, 3.3417554107802047e-02, 3.0201279325358408e-02, 2.5467400811192979e-02, 1.9531476238454866e-02, 1.2306173719667307e-02, 4.6855912625121902e-03, -3.2209155888084638e-04, 1.2328178195647964e-04, -4.1560284413268492e-05, 4.2557541117190077e-05, 5.4770723135043693e-05, 5.4390178536568240e-05, 5.3460862563253211e-05, 5.2696599902952873e-05, 5.2737134146187356e-05, 5.2732828955216410e-05, 5.2763875628504806e-05, 5.2765360473757554e-05, 5.2765961757691506e-05, 5.2764041802506855e-05, 5.2762742797907066e-05, 5.2760439764399832e-05, 5.2765155364469107e-05, 5.2813598770335069e-05, 5.2941966826742899e-05, 5.2749166470385693e-05, 5.0930541020800570e-05, 4.4693862898143442e-05, 5.3541038695748843e-05, 1.1526554760332040e-04, 4.4723267825265005e-04, 1.0705309820014919e-03, 1.8634371441783721e-03, 1.9369182233728692e-03, 1.9008212055216006e-03, 1.8651079239747964e-03, 1.8588106799928559e-03, 1.8603397253595707e-03, 1.8619835227585474e-03, 1.8625463015521813e-03, 1.8622433406702459e-03, 1.8629265746231498e-03, 6.4141322510607585e-03, 8.9321228821969412e-03, 1.3220128254233411e-02, 1.8482646149513428e-02, 2.2170467615760046e-02, 2.5125601957230698e-02, 2.7738078728830655e-02, 3.0007297391148050e-02, 3.1652908126856283e-02, 3.2960139354450080e-02, 3.3905398256117596e-02, 3.4113082783765729e-02, 3.3282999434211660e-02, 3.1457483197822676e-02, 2.8187145827618460e-02, 2.3236550288755098e-02, 1.6981267018146944e-02, 9.5302434913135444e-03, 3.0510766057878112e-03, -6.0490864307457442e-04, 1.5628584577655696e-04, -5.2249101880281854e-05, 7.5807159947313519e-05, 4.7443663053774205e-05, 5.6447004942634860e-05, 5.2285603315219294e-05, 5.2934480915948928e-05, 5.2663189741896661e-05, 5.2786216264936785e-05, 5.2758884945181945e-05, 5.2767462997127282e-05, 5.2764038851598023e-05, 5.2766774824629373e-05, 5.2764220783568218e-05, 5.2760205380409914e-05, 5.2765310397459594e-05, 5.2813411560974805e-05, 5.2941875812292189e-05, 5.2749108195285392e-05, 5.0930811242631206e-05, 4.4694135294550299e-05, 5.3541244801507598e-05, 1.1526575273414978e-04, 4.4723268236196862e-04, 1.0705308160228592e-03, 1.8634369056156528e-03, 1.9369179661827892e-03, 1.9008209430719538e-03, 1.8651076630577218e-03, 1.8588104158757616e-03, 1.8603394650446238e-03, 1.8619832531586117e-03, 1.8625460362608774e-03, 1.8622429829827144e-03, 1.8629264315256002e-03, 3.5621865794431655e-03, 6.5984118917273701e-03, 1.0280824841520484e-02, 1.5693480505953435e-02, 1.9562920360964586e-02, 2.2623737140062928e-02, 2.5376337213146142e-02, 2.7824871100433027e-02, 2.9589006927442076e-02, 3.0920105557044619e-02, 3.1846560495130398e-02, 3.2109831455504272e-02, 3.1342445879596739e-02, 2.9542757506956861e-02, 2.6143750182106108e-02, 2.0922732612060561e-02, 1.4276216072204461e-02, 6.6608656778629370e-03, 1.8510195918972447e-03, -4.0160776468086182e-04, 1.0510749492450052e-04, -1.0886040530306735e-05, 6.9598085640890125e-05, 5.0275392945029910e-05, 5.4798662690386493e-05, 5.2368563572536421e-05, 5.2831430348099458e-05, 5.2706804631570120e-05, 5.2770201150462008e-05, 5.2763159107990573e-05, 5.2765602966968795e-05, 5.2764422579637439e-05, 5.2764231268321678e-05, 5.2763057609678756e-05, 5.2760354176267412e-05, 5.2765170709441294e-05, 5.2813374483528338e-05, 5.2941866010266923e-05, 5.2749128823902588e-05, 5.0930593050370980e-05, 4.4693943753570180e-05, 5.3541101008860592e-05, 1.1526564173025100e-04, 4.4723269845406524e-04, 1.0705308952937355e-03, 1.8634370088490952e-03, 1.9369180669041822e-03, 1.9008210454204177e-03, 1.8651077642046284e-03, 1.8588105181394522e-03, 1.8603395662262032e-03, 1.8619833577300981e-03, 1.8625461424868935e-03, 1.8622431655831093e-03, 1.8629267426555731e-03, 2.3514368911920786e-03, 4.1142661839193339e-03, 7.9487405360018464e-03, 1.2895832106606619e-02, 1.6905431728487692e-02, 2.0200318784988111e-02, 2.3147829850116756e-02, 2.5698741410456759e-02, 2.7659050794639595e-02, 2.9029639409889563e-02, 2.9933181341264808e-02, 3.0209069073738347e-02, 2.9453806196929232e-02, 2.7617830500819961e-02, 2.4093550625824151e-02, 1.8500081111279671e-02, 1.1527072700577639e-02, 3.6075719219049555e-03, 6.7213420362941575e-04, -1.8092014324151196e-04, 4.4213790690973049e-05, 4.0668901462938013e-05, 6.0168700567404412e-05, 5.3025112169161920e-05, 5.3280782018158215e-05, 5.2609023395609977e-05, 5.2763202836968741e-05, 5.2746844763419359e-05, 5.2766945676425314e-05, 5.2765912512062820e-05, 5.2765868343043954e-05, 5.2764577350369226e-05, 5.2764272656085465e-05, 5.2763021663991764e-05, 5.2760246546339310e-05, 5.2765497291993690e-05, 5.2813570544974977e-05, 5.2941965211560180e-05, 5.2749117148885596e-05, 5.0930594057515726e-05, 4.4693931629215668e-05, 5.3541032994143788e-05, 1.1526558602797810e-04, 4.4723270262555734e-04, 1.0705309380649364e-03, 1.8634370729343312e-03, 1.9369181358554084e-03, 1.9008211154740624e-03, 1.8651078342265149e-03, 1.8588105890860684e-03, 1.8603396352917904e-03, 1.8619834314280927e-03, 1.8625462093546793e-03, 1.8622432703839394e-03, 1.8629267706187444e-03, -3.2600115372295583e-04, 3.0859865393329518e-03, 5.3730983336219207e-03, 1.0391756033021010e-02, 1.4149086283142270e-02, 1.7847250517553721e-02, 2.0967709804752856e-02, 2.3603913700291759e-02, 2.5710603305254983e-02, 2.7157397662398653e-02, 2.8087404859481288e-02, 2.8352249167706050e-02, 2.7566267727520796e-02, 2.5682298385986502e-02, 2.1988718440689843e-02, 1.6147898358690720e-02, 8.8993291877930772e-03, 1.5631715987407054e-03, -5.6870816941074868e-04, 1.5609464409325748e-04, -3.6309431804258522e-05, 9.2414585476419096e-05, 4.8215035336777617e-05, 5.5845498475801548e-05, 5.1840464074166172e-05, 5.2892426980978014e-05, 5.2677811335715602e-05, 5.2783411851776132e-05, 5.2760725688035010e-05, 5.2766515905909175e-05, 5.2764035422020018e-05, 5.2764510505359196e-05, 5.2764162428050615e-05, 5.2763006547304409e-05, 5.2760299523281879e-05, 5.2765231293654152e-05, 5.2813413348528227e-05, 5.2941890560378954e-05, 5.2749126099288305e-05, 5.0930588083918384e-05, 4.4693924170699082e-05, 5.3541075806947689e-05, 1.1526561915318161e-04, 4.4723269713666810e-04, 1.0705309178453970e-03, 1.8634370448003430e-03, 1.9369181089640367e-03, 1.9008210877154144e-03, 1.8651078080108685e-03, 1.8588105597620974e-03, 1.8603396119994480e-03, 1.8619833961917060e-03, 1.8625462007591941e-03, 1.8622431800595456e-03, 1.8629267347091730e-03, 9.1350645308890468e-05, 4.1590821205380837e-04, 3.6719426365278062e-03, 7.8646966191331571e-03, 1.1539872465489803e-02, 1.5449910516954605e-02, 1.8789722849115877e-02, 2.1531083041494731e-02, 2.3662960009186822e-02, 2.5214240428104325e-02, 2.6255886816436633e-02, 2.6492685989032299e-02, 2.5683096291677501e-02, 2.3715593953941894e-02, 1.9897748242363442e-02, 1.3748399719187692e-02, 6.9876030525545278e-03, 4.2743832853209864e-04, -6.3993734944040883e-05, 2.6497473734547991e-06, 4.8138413352444557e-05, 8.3186770502814477e-05, 5.2580869559467686e-05, 5.3749691076648865e-05, 5.2025249165993696e-05, 5.2783768404967326e-05, 5.2728604532747199e-05, 5.2780245980791284e-05, 5.2764964989734962e-05, 5.2765302768973101e-05, 5.2764062626595551e-05, 5.2764356640703723e-05, 5.2764383170459932e-05, 5.2763118494429312e-05, 5.2760283519000503e-05, 5.2765241669758248e-05, 5.2813399619658759e-05, 5.2941883965096495e-05, 5.2749121942838293e-05, 5.0930607497204466e-05, 4.4693943732465019e-05, 5.3541090599345613e-05, 1.1526563389027601e-04, 4.4723269739734700e-04, 1.0705309059690620e-03, 1.8634370277325833e-03, 1.9369180901403300e-03, 1.9008210699044651e-03, 1.8651077869810267e-03, 1.8588105454536974e-03, 1.8603395843709665e-03, 1.8619833935622633e-03, 1.8625461358193149e-03, 1.8622432499497377e-03, 1.8629266149160237e-03, -2.3769360111293381e-05, -1.2652511744191350e-03, 2.1522749050061538e-03, 5.5566013857502152e-03, 9.1144240519332679e-03, 1.3078463353656079e-02, 1.6614393956855496e-02, 1.9554901653094890e-02, 2.1713260348362445e-02, 2.3354074007106946e-02, 2.4490003727703689e-02, 2.4705908468046888e-02, 2.3849154309144478e-02, 2.1787294003132847e-02, 1.7744140324907891e-02, 1.1389523776162742e-02, 5.0194197610703775e-03, 4.6942967316568264e-04, -1.2761300737156150e-04, 1.9809934077933832e-05, 9.4332069833077611e-05, 7.4068725359107722e-05, 5.5406158114280957e-05, 5.1827847765927490e-05, 5.2339409713165638e-05, 5.2668763021634304e-05, 5.2782444976376801e-05, 5.2772573021637771e-05, 5.2766996491915720e-05, 5.2764050379587931e-05, 5.2764146878292472e-05, 5.2764310665246707e-05, 5.2764239005291197e-05, 5.2763031735223576e-05, 5.2760295851373466e-05, 5.2765230657474593e-05, 5.2813396949217702e-05, 5.2941883223201539e-05, 5.2749123446801229e-05, 5.0930591841233237e-05, 4.4693929967835731e-05, 5.3541080323871775e-05, 1.1526562578644633e-04, 4.4723269889804099e-04, 1.0705309112436934e-03, 1.8634370354106244e-03, 1.9369180978042033e-03, 1.9008210753876089e-03, 1.8651077988396476e-03, 1.8588105432407844e-03, 1.8603396102113998e-03, 1.8619833661447217e-03, 1.8625462395280693e-03, 1.8622430625704126e-03, 1.8629268674248477e-03, 6.9095880844109798e-06, -7.4063965346394557e-04, 6.0912396975306479e-04, 3.5937946915799734e-03, 6.9028054906128018e-03, 1.0734371080522418e-02, 1.4398172429012287e-02, 1.7639542337432836e-02, 1.9936729299725363e-02, 2.1621266711033583e-02, 2.2751890023548018e-02, 2.2968192358214842e-02, 2.2045231284567583e-02, 1.9824393275868643e-02, 1.5551775877570140e-02, 8.8696807360748448e-03, 2.9973466449009678e-03, 2.2940430631783761e-04, -3.5056943960912601e-05, 5.8602449550069797e-05, 1.0411358270917113e-04, 7.6193134222308568e-05, 5.3300225022502193e-05, 5.1744904481105381e-05, 5.2194226294149959e-05, 5.2728600085381858e-05, 5.2784951200110385e-05, 5.2777398510279199e-05, 5.2765716224265450e-05, 5.2764019326631873e-05, 5.2764099193360751e-05, 5.2764346084001224e-05, 5.2764249515124686e-05, 5.2763031354739947e-05, 5.2760287559061852e-05, 5.2765253837316144e-05, 5.2813410946677197e-05, 5.2941890352068663e-05, 5.2749122622637582e-05, 5.0930591902376127e-05, 4.4693929141902944e-05, 5.3541075330718857e-05, 1.1526562223037745e-04, 4.4723269833425744e-04, 1.0705309156799942e-03, 1.8634370390692232e-03, 1.9369181023893419e-03, 1.9008210839472745e-03, 1.8651077946203328e-03, 1.8588105680834067e-03, 1.8603395764497730e-03, 1.8619834445812611e-03, 1.8625460425249392e-03, 1.8622434920417673e-03, 1.8629263839489377e-03, 2.7331214967874488e-07, 2.0192086287269419e-05, -2.1787077095657178e-04, 1.9061846087818327e-03, 4.7924713434149583e-03, 8.3017121854689936e-03, 1.1997546295253080e-02, 1.5447018199111697e-02, 1.7913110562711266e-02, 1.9635659583485114e-02, 2.0751966854619310e-02, 2.1003703320238817e-02, 2.0028850655385608e-02, 1.7638782871263654e-02, 1.3153516995650103e-02, 6.4753985929355082e-03, 1.3178822534362876e-03, -1.3138651150929336e-04, 4.9450817206175982e-05, 7.0287389808526915e-05, 1.2409060050508184e-04, 7.0869755821701316e-05, 5.3719170143855661e-05, 5.1037218881354460e-05, 5.2323577339432806e-05, 5.2716885879209671e-05, 5.2802329897231664e-05, 5.2775321219804379e-05, 5.2765863758743926e-05, 5.2763509402447588e-05, 5.2764049273006206e-05, 5.2764332808801634e-05, 5.2764254595856060e-05, 5.2763029153948301e-05, 5.2760291448775456e-05, 5.2765234448221437e-05, 5.2813399691107750e-05, 5.2941885027890790e-05, 5.2749123296027162e-05, 5.0930591543779877e-05, 4.4693928558340652e-05, 5.3541078743298274e-05, 1.1526562381084715e-04, 4.4723270036563570e-04, 1.0705309108111111e-03, 1.8634370401985508e-03, 1.9369181003984516e-03, 1.9008210756142293e-03, 1.8651078114489594e-03, 1.8588105253058637e-03, 1.8603396555145098e-03, 1.8619832889099081e-03, 1.8625464657690831e-03, 1.8622425972135725e-03, 1.8629274058832082e-03, 5.3251831562486276e-06, 2.6518215019901017e-04, -4.7525742258846724e-04, 7.6908620278350634e-04, 2.6784586084535114e-03, 5.9634080815459843e-03, 9.5108165758733751e-03, 1.2950393442033060e-02, 1.5504570211868435e-02, 1.7297694219991111e-02, 1.8477346642551008e-02, 1.8806923003462487e-02, 1.7816693675488562e-02, 1.5327483752132815e-02, 1.0610990918492762e-02, 4.6655947447623251e-03, 3.6579678787058658e-04, -7.9469364798056259e-05, 3.1850854943397837e-05, 1.2500464757788122e-04, 1.2001690419878705e-04, 7.2705626617073377e-05, 5.2057001107275445e-05, 5.1154730098971912e-05, 5.2266544563788164e-05, 5.2758663878183633e-05, 5.2801617488712911e-05, 5.2776735618158588e-05, 5.2765029222053055e-05, 5.2763458504906266e-05, 5.2764013483838556e-05, 5.2764347169229438e-05, 5.2764271254703952e-05, 5.2763038060229287e-05, 5.2760289689528926e-05, 5.2765235091371487e-05, 5.2813398649798093e-05, 5.2941884532601800e-05, 5.2749122998177181e-05, 5.0930592851058978e-05, 4.4693930169107835e-05, 5.3541079150005012e-05, 1.1526562661991397e-04, 4.4723269427552877e-04, 1.0705309188139387e-03, 1.8634370300456983e-03, 1.9369181015882512e-03, 1.9008210855770628e-03, 1.8651077726930807e-03, 1.8588106081386534e-03, 1.8603394856881021e-03, 1.8619836092225862e-03, 1.8625455715935563e-03, 1.8622444717330501e-03, 1.8629252354345550e-03, 1.3615158910612867e-04, 2.8058963459953150e-05, -9.8110807208620808e-06, 6.3269146264529710e-05, 1.3175644516926102e-03, 4.3737388547403742e-03, 7.8073855463542995e-03, 1.1127586337124523e-02, 1.3712021571862864e-02, 1.5564817401103798e-02, 1.6826784500024963e-02, 1.7228500014352863e-02, 1.6246540650133253e-02, 1.3700493823120817e-02, 8.8521069593147511e-03, 3.6471308481739778e-03, 1.2633055804409993e-04, -1.0095021373831257e-05, 5.3840499631806332e-05, 1.5835794535960953e-04, 1.1767981861732323e-04, 7.2981119018859436e-05, 5.1078927222048925e-05, 5.1223445446756758e-05, 5.2247203276143181e-05, 5.2786078059834149e-05, 5.2800338004488177e-05, 5.2777438682398959e-05, 5.2764222084951014e-05, 5.2763468641307235e-05, 5.2763986709954685e-05, 5.2764367567797710e-05, 5.2764259569053492e-05, 5.2763032747030161e-05, 5.2760290111290388e-05, 5.2765234409042301e-05, 5.2813398545223994e-05, 5.2941884621334905e-05, 5.2749123178609632e-05, 5.0930591998080198e-05, 4.4693928652373398e-05, 5.3541079244003538e-05, 1.1526562079694239e-04, 4.4723270683467997e-04, 1.0705308942748364e-03, 1.8634370532158574e-03, 1.9369180900049307e-03, 1.9008210668933984e-03, 1.8651078469112173e-03, 1.8588104358043239e-03, 1.8603398361545325e-03, 1.8619829378311160e-03, 1.8625474443899072e-03, 1.8622405269194185e-03, 1.8629298144775181e-03, 2.1309862210177325e-04, 7.3340824207033636e-05, -1.0443795465811051e-05, 3.0701045528532783e-05, 1.0457045817005644e-03, 4.0824154802626966e-03, 7.4801109291369478e-03, 1.0781265503998407e-02, 1.3362646178040269e-02, 1.5233068614453747e-02, 1.6518124345977329e-02, 1.6939880191718597e-02, 1.5960210175048971e-02, 1.3376150695173998e-02, 8.5238310517141650e-03, 3.4752843395803646e-03, 1.7220730456272770e-04, -9.2140022645489273e-06, 1.0185899328129094e-04, 1.5834604815672166e-04, 1.2070752129241481e-04, 7.0863054916419464e-05, 5.1169912870656959e-05, 5.1081949642904882e-05, 5.2308070134652163e-05, 5.2783804403273720e-05, 5.2804865074196540e-05, 5.2775914355633738e-05, 5.2764240680107766e-05, 5.2763343116302382e-05, 5.2764025612058032e-05, 5.2764367998507336e-05, 5.2764262262770615e-05, 5.2763030469914999e-05, 5.2760288173664757e-05, 5.2765234689573169e-05, 5.2813398283352808e-05, 5.2941883810319235e-05, 5.2749121866410984e-05, 5.0930590114169195e-05, 4.4693927909531391e-05, 5.3541075321773403e-05, 1.1526562339336738e-04, 4.4723267092396497e-04, 1.0705309516072189e-03, 1.8634369878532103e-03, 1.9369181258426875e-03, 1.9008210925261760e-03, 1.8651077012956272e-03, 1.8588107881339442e-03, 1.8603391102788552e-03, 1.8619843393351352e-03, 1.8625435238083853e-03, 1.8622488199928164e-03, 1.8629201614182593e-03, 2.0631554834897906e-04, 1.5540130697500070e-04, -7.3548853570355708e-05, 1.8062565059967316e-04, 1.3482555745856994e-03, 4.4107758850341220e-03, 7.8542201927243975e-03, 1.1182113353279460e-02, 1.3761909113086640e-02, 1.5622070676136010e-02, 1.6894169068627559e-02, 1.7304810322983703e-02, 1.6319661624211047e-02, 1.3720524471862703e-02, 8.8838969754267156e-03, 3.6926915878159640e-03, 2.5870337499224515e-04, 8.3424234956791757e-06, 1.0775161008810631e-04, 1.5934455154797446e-04, 1.1899630043441791e-04, 7.0421265556620959e-05, 5.0997215976883811e-05, 5.1111341487952925e-05, 5.2320859555520294e-05, 5.2790065847770651e-05, 5.2804505119429815e-05, 5.2775562733123854e-05, 5.2764047348413837e-05, 5.2763332272438076e-05, 5.2764031860738750e-05, 5.2764374715886051e-05, 5.2764264479214156e-05, 5.2763032033525398e-05, 5.2760290272188003e-05, 5.2765235274558171e-05, 5.2813399446429036e-05, 5.2941885390228812e-05, 5.2749123370382689e-05, 5.0930592276637560e-05, 4.4693926996285777e-05, 5.3541077446982442e-05, 1.1526562178472489e-04, 4.4723275384495867e-04, 1.0705308049568491e-03, 1.8634371561802442e-03, 1.9369180154716374e-03, 1.9008210661862794e-03, 1.8651079796402231e-03, 1.8588100684415179e-03, 1.8603406085388947e-03, 1.8619814186722494e-03, 1.8625517230520053e-03, 1.8622314068233268e-03, 1.8629405151884236e-03, 2.0023108075173081e-04, 1.6637180300153523e-04, -9.4905481594792013e-05, 2.5597941733080347e-04, 1.4778051290801984e-03, 4.5771415245807311e-03, 8.0358959013343487e-03, 1.1376758734670350e-02, 1.3956335130667815e-02, 1.5811197065465115e-02, 1.7076021243249900e-02, 1.7481595007189342e-02, 1.6493706659765465e-02, 1.3894162013420619e-02, 9.0451001645560115e-03, 3.7961768133754968e-03, 3.0198984045560465e-04, 8.9289173951627962e-06, 1.0835655372328037e-04, 1.5648571787669878e-04, 1.1829836527153153e-04, 7.0078427342618027e-05, 5.1011960411820978e-05, 5.1128531913433617e-05, 5.2333094836231291e-05, 5.2791735179802456e-05, 5.2804150553586584e-05, 5.2775224295525650e-05, 5.2763959163032619e-05, 5.2763331709799896e-05, 5.2764034988345464e-05, 5.2764372448274965e-05, 5.2764260292674565e-05, 5.2763027188090662e-05, 5.2760284870275646e-05, 5.2765230108222360e-05, 5.2813394059423375e-05, 5.2941879501117260e-05, 5.2749117733786979e-05, 5.0930584458407617e-05, 4.4693926442339863e-05, 5.3541091406693454e-05, 1.1526563397311098e-04, 4.4723261304716798e-04, 1.0705312141960775e-03, 1.8634367522833157e-03, 1.9369183442251943e-03, 1.9008210598114410e-03, 1.8651074579541776e-03, 1.8588115265197021e-03, 1.8603375151969473e-03, 1.8619874828233380e-03, 1.8625345925813966e-03, 1.8622679287181700e-03, 1.8628976058279948e-03, 1.9466549882315578e-04, 1.5444295409185237e-04, -8.7146698556321778e-05, 2.3537008427414223e-04, 1.4342510796700888e-03, 4.5322128876275451e-03, 7.9865983624649237e-03, 1.1320894651002861e-02, 1.3900978037067585e-02, 1.5756925056936603e-02, 1.7024176869062609e-02, 1.7432394489867092e-02, 1.6445769589980064e-02, 1.3848193860749983e-02, 8.9887113698740636e-03, 3.7694206789713218e-03, 2.9606095768049394e-04, 7.8987740063329522e-06, 1.0576453856615951e-04, 1.5561569172697510e-04, 1.1781546331450412e-04, 7.0081671362521046e-05, 5.1029109779258467e-05, 5.1148730598635910e-05, 5.2337486103714001e-05, 5.2792038171353223e-05, 5.2803736009684794e-05, 5.2775081476559530e-05, 5.2763984466304426e-05, 5.2763399895895020e-05, 5.2764100852580449e-05, 5.2764433419266539e-05, 5.2764318809236855e-05, 5.2763086086868539e-05, 5.2760344381791418e-05, 5.2765289333700208e-05, 5.2813452773309531e-05, 5.2941938173023792e-05, 5.2749175573307892e-05, 5.0930647241222059e-05, 4.4693989094793950e-05, 5.3541103948892796e-05, 1.1526589397098353e-04, 4.4723309064916927e-04, 1.0705303437382680e-03, 1.8634378938459778e-03, 1.9369175268645865e-03, 1.9008212847339563e-03, 1.8651084472300614e-03, 1.8588086132491255e-03, 1.8603438927163837e-03, 1.8619749113735560e-03, 1.8625702967677898e-03, 1.8621913805655145e-03, 1.8629880132574473e-03, 1.9537204632818155e-04, 1.4790308908609216e-04, -8.1921186502615561e-05, 2.1799590482966688e-04, 1.4038888095982247e-03, 4.4951320184327855e-03, 7.9451385380633621e-03, 1.1276332513874100e-02, 1.3855732183150086e-02, 1.5712651613441726e-02, 1.6981441605358197e-02, 1.7391150348523367e-02, 1.6405787944745343e-02, 1.3808638847571067e-02, 8.9518523149521596e-03, 3.7459022404196943e-03, 2.8600804034936852e-04, 6.5930276491204159e-06, 1.0464028127439970e-04, 1.5544220270695676e-04, 1.1776860112114971e-04, 7.0133575550177952e-05, 5.1048568120548845e-05, 5.1158443691040465e-05, 5.2337864428565319e-05, 5.2791642851391819e-05, 5.2803256851966863e-05, 5.2774911782523750e-05, 5.2763883362294069e-05, 5.2763314506730388e-05, 5.2764008583700968e-05, 5.2764338017969712e-05, 5.2764222685227840e-05, 5.2762990003139249e-05, 5.2760248043990536e-05, 5.2765192404920691e-05, 5.2813354879746626e-05, 5.2941839145751638e-05, 5.2749081673905024e-05, 5.0930563195696204e-05, 4.4693909529584894e-05, 5.3541282489353017e-05, 1.1526518591392340e-04, 4.4723217779127480e-04, 1.0705326609380516e-03, 1.8634351117689134e-03, 1.9369197647807381e-03, 1.9008204501638740e-03, 1.8651067429387752e-03, 1.8588145188517396e-03, 1.8603308976940019e-03, 1.8620009775472681e-03, 1.8624960205930882e-03, 1.8623515723028470e-03, 1.8627975040808968e-03, 1.9628456441416785e-04, 1.5013939056360550e-04, -8.3898729380565523e-05, 2.2089610092934463e-04, 1.4137223379101472e-03, 4.5038708916654560e-03, 7.9549962660120481e-03, 1.1287317970490216e-02, 1.3866444321218745e-02, 1.5722898196163373e-02, 1.6991037618115885e-02, 1.7400187795763900e-02, 1.6414860371094148e-02, 1.3817735038463338e-02, 8.9642366296498500e-03, 3.7509258553851594e-03, 2.8542346346133635e-04, 6.3037318996790706e-06, 1.0453103182820601e-04, 1.5548764093818094e-04, 1.1783607579632478e-04, 7.0163111694987676e-05, 5.1059851567874945e-05, 5.1159827105919700e-05, 5.2337756431267826e-05, 5.2791413824268462e-05, 5.2803384064690332e-05, 5.2775168163011750e-05, 5.2764171952212768e-05, 5.2763597688793311e-05, 5.2764287252769400e-05, 5.2764615443031443e-05, 5.2764500067409497e-05, 5.2763267103777121e-05, 5.2760524055670146e-05, 5.2765466478416435e-05, 5.2813628578728365e-05, 5.2942122416501173e-05, 5.2749383987956509e-05, 5.0930873113348990e-05, 4.4694271338535770e-05, 5.3540517919883330e-05, 1.1526707125953422e-04, 4.4723316973362543e-04, 1.0705261678579589e-03, 1.8634416214446229e-03, 1.9369136438738867e-03, 1.9008229841337579e-03, 1.8651094999164487e-03, 1.8588028237882246e-03, 1.8603576012097272e-03, 1.8619473851588144e-03, 1.8626503252349956e-03, 1.8620168924328555e-03, 1.8631987785806376e-03, 1.9625115107014884e-04, 1.5156254139121135e-04, -8.5130119594981372e-05, 2.2463421146762973e-04, 1.4201123626850966e-03, 4.5118319264165502e-03, 7.9636968535816612e-03, 1.1296723910432523e-02, 1.3875972006098029e-02, 1.5732157531493630e-02, 1.6999928196910024e-02, 1.7408721287572686e-02, 1.6423180794006877e-02, 1.3826186734757866e-02, 8.9722180088903404e-03, 3.7558479910672288e-03, 2.8707806557569854e-04, 6.4169919645957697e-06, 1.0471048303137356e-04, 1.5552006638919297e-04, 1.1787708166468982e-04, 7.0166555429418826e-05, 5.1059514837784343e-05, 5.1155950773334284e-05, 5.2334515740002731e-05, 5.2788539776472749e-05, 5.2800777556973909e-05, 5.2772604941861099e-05, 5.2761608556632589e-05, 5.2761024070279378e-05, 5.2761710552233241e-05, 5.2762038227833436e-05, 5.2761922769552988e-05, 5.2760688509558133e-05, 5.2757942881146271e-05, 5.2762884853908265e-05, 5.2811055013295195e-05, 5.2939567985073466e-05, 5.2746847439457793e-05, 5.0928490818046970e-05, 4.4691496586062834e-05, 5.3540751024712281e-05, 1.1525468869921089e-04, 4.4722711986667352e-04, 1.0705389659023221e-03, 1.8634233088402291e-03, 1.9369282480450670e-03, 1.9008146146979237e-03, 1.8651047547292620e-03, 1.8588254223509014e-03, 1.8603031471337273e-03, 1.8620577716116223e-03, 1.8623311534076996e-03, 1.8627153298827383e-03, 1.8623542610319605e-03, 1.9611550732548272e-04, 1.5107566516646786e-04, -8.4570005158461845e-05, 2.2371275756758645e-04, 1.4170926744066731e-03, 4.5091145659180085e-03, 7.9604844286351832e-03, 1.1293327064522529e-02, 1.3872559294719138e-02, 1.5728974842161774e-02, 1.6996868186409955e-02, 1.7405864280444883e-02, 1.6420305479934613e-02, 1.3823252779814960e-02, 8.9686462820687401e-03, 3.7539938323407282e-03, 2.8731330395008524e-04, 6.3926402253905399e-06, 1.0481010087430904e-04, 1.5555601057755137e-04, 1.1790083948938788e-04, 7.0173898757218720e-05, 5.1061375485392105e-05, 5.1158680118191800e-05, 5.2338069327497945e-05, 5.2792656989905416e-05, 5.2805060386584757e-05, 5.2776921608626875e-05, 5.2765910945846296e-05, 5.2765317255649364e-05, 5.2766000670176624e-05, 5.2766328110932300e-05, 5.2766211551856188e-05, 5.2764974043510154e-05, 5.2762226293800546e-05, 5.2767177570961114e-05, 5.2815390070647042e-05, 5.2943983257378185e-05, 5.2751380355121670e-05, 5.0932310464500225e-05, 4.4696215259885465e-05, 5.3534698339883051e-05, 1.1528346749835803e-04, 4.4723339564110137e-04, 1.0705018220245807e-03, 1.8634671681241107e-03, 1.9368908582460822e-03, 1.9008375554042222e-03, 1.8651093328970472e-03, 1.8587792478137054e-03, 1.8604118190256322e-03, 1.8618308240938703e-03, 1.8629898541439904e-03, 1.8612625682059157e-03, 1.8641322272451215e-03, 1.9610707531240366e-04, 1.5058303615274850e-04, -8.4067805266670301e-05, 2.2253933029472327e-04, 1.4157128282870698e-03, 4.5067593056803525e-03, 7.9584800031851245e-03, 1.1290755614007731e-02, 1.3870284400722965e-02, 1.5726576390553602e-02, 1.6994758154556786e-02, 1.7403718618363873e-02, 1.6418238653312097e-02, 1.3821252798971411e-02, 8.9662603993714701e-03, 3.7532717416709585e-03, 2.8626606446908130e-04, 6.6789975678500104e-06, 1.0467277193721873e-04, 1.5558959024970838e-04, 1.1787730092738426e-04, 7.0172369458947951e-05, 5.1053107050268051e-05, 5.1146166710383875e-05, 5.2324228223123846e-05, 5.2779136233167973e-05, 5.2791869346012627e-05, 5.2763826031508889e-05, 5.2752819008624882e-05, 5.2752212048235293e-05, 5.2752889633130895e-05, 5.2753215396933892e-05, 5.2753095901527958e-05, 5.2751855567218394e-05, 5.2749118450079395e-05, 5.2754124185948719e-05, 5.2802437237716438e-05, 5.2931065886866348e-05, 5.2737805954207534e-05, 5.0919566820754495e-05, 4.4678384860871587e-05, 5.3551166603920285e-05, 1.1520149231418367e-04, 4.4723416472041853e-04, 1.0706051904259364e-03, 1.8633673473945165e-03, 1.9369946467446752e-03, 1.9007816585855247e-03, 1.8651092052186491e-03, 1.8588640388256918e-03, 1.8601868669473063e-03, 1.8622897626809499e-03, 1.8616349791235659e-03, 1.8642765051889094e-03, 1.8603976150981395e-03, 1.9624322970958357e-04, 1.5121509639586444e-04, -8.4721907411234820e-05, 2.2355749813669806e-04, 1.4158595464564010e-03, 4.5083739142886348e-03, 7.9588537805281925e-03, 1.1292225407059965e-02, 1.3871099733433784e-02, 1.5727927902791747e-02, 1.6995682992643930e-02, 1.7404883348270551e-02, 1.6419153731365977e-02, 1.3821838073186758e-02, 8.9680842033749639e-03, 3.7525706655277178e-03, 2.8802195232347123e-04, 5.9208135099351827e-06, 1.0502135100411906e-04, 1.5564162894928941e-04, 1.1812720785273671e-04, 7.0320907287401463e-05, 5.1166818287595348e-05, 5.1251584864584600e-05, 5.2428122420170443e-05, 5.2882854872602638e-05, 5.2895746564733219e-05, 5.2867909431307287e-05, 5.2856927645051340e-05, 5.2856309595311420e-05, 5.2856975105361097e-05, 5.2857295823136697e-05, 5.2857172509930534e-05, 5.2855936014257674e-05, 5.2853244613128293e-05, 5.2858382413562094e-05, 5.2906925420373678e-05, 5.3035421722203006e-05, 5.2842095083087176e-05, 5.1013809138885845e-05, 4.4781861610246038e-05, 5.3569359972599507e-05, 1.1558363770647684e-04, 4.4732803042613609e-04, 1.0704106764419445e-03, 1.8636478789978816e-03, 1.9367526162861965e-03, 1.9009539390940065e-03, 1.8651052474931225e-03, 1.8587049664626550e-03, 1.8606288187216404e-03, 1.8613481310944448e-03, 1.8644011478630813e-03, 1.8580504260927327e-03, 1.8682311716762099e-03, 1.9577367064361253e-04, 1.5007320059376425e-04, -8.3715583851212528e-05, 2.2246846088224472e-04, 1.4186558008384953e-03, 4.5073914144638039e-03, 7.9608868930535343e-03, 1.1291872153452467e-02, 1.3872469086173997e-02, 1.5728227687356950e-02, 1.6996882884507840e-02, 1.7404975578750835e-02, 1.6419505821311093e-02, 1.3822675591997614e-02, 8.9671678852767805e-03, 3.7565972788827884e-03, 2.8463684611570685e-04, 8.0314789168827407e-06, 1.0407067294076454e-04, 1.5550485183893323e-04, 1.1760734069329081e-04, 7.0159994299975041e-05, 5.1039120245453477e-05, 5.1112998018413227e-05, 5.2269300480828408e-05, 5.2720211724489208e-05, 5.2733388089249117e-05, 5.2706082235617194e-05, 5.2695286288027142e-05, 5.2694650275828783e-05, 5.2695289052735797e-05, 5.2695596242445949e-05, 5.2695471274043034e-05, 5.2694270028503058e-05, 5.2691719540277961e-05, 5.2697103050948600e-05, 5.2745335032541217e-05, 5.2872436432448399e-05, 5.2671382557614545e-05, 5.0861660286712825e-05, 4.4592293840664463e-05, 5.3643868330416462e-05, 1.1483042652833558e-04, 4.4734912830160262e-04, 1.0710440390515258e-03, 1.8629156405211992e-03, 1.9373208288020870e-03, 1.9005332288359101e-03, 1.8652294811978146e-03, 1.8590467052944928e-03, 1.8597561933999692e-03, 1.8632376676476648e-03, 1.8587814055436274e-03, 1.8708264804527571e-03, 1.8518746940862792e-03, 1.9703743469857743e-04, 1.5391516727099073e-04, -8.6928981693821535e-05, 2.2749185499742057e-04, 1.4147299679886888e-03, 4.5120985619730245e-03, 7.9568901218600822e-03, 1.1293037822380385e-02, 1.3870045653160622e-02, 1.5728901156734997e-02, 1.6995055064417935e-02, 1.7404440035685361e-02, 1.6416376840201523e-02, 1.3819403999342351e-02, 8.9700360618342866e-03, 3.7510308377225196e-03, 2.9736470622287488e-04, 3.7232577762038628e-06, 1.0628507818845596e-04, 1.5447672036298009e-04, 1.1820929704809061e-04, 7.0460193717259356e-05, 5.1505454366100722e-05, 5.1598115485828118e-05, 5.2764155482800590e-05, 5.3205740825419730e-05, 5.3217368626375602e-05, 5.3190734524828457e-05, 5.3180310272645842e-05, 5.3179745548062367e-05, 5.3180346756555147e-05, 5.3180633885761917e-05, 5.3180516104464865e-05, 5.3179395293292125e-05, 5.3177035080441952e-05, 5.3182352591529636e-05, 5.3229714583286845e-05, 5.3350810631864330e-05, 5.3156018604730052e-05, 5.1292304931319354e-05, 4.5172619075345661e-05, 5.3556875587384186e-05, 1.1707535465051319e-04, 4.4755039417781307e-04, 1.0693216134612677e-03, 1.8642905554100623e-03, 1.9354142541229420e-03, 1.9015407985447656e-03, 1.8650452422018199e-03, 1.8586247707123862e-03, 1.8615671278678623e-03, 1.8594707142496176e-03, 1.8700877875612695e-03, 1.8448926003095047e-03, 1.8857642269393758e-03, 1.9188804163353923e-04, 1.4306946401739683e-04, -8.1205287607640346e-05, 2.1685633001839195e-04, 1.4266739172027357e-03, 4.5018813439188761e-03, 7.9652001319269264e-03, 1.1287016283397013e-02, 1.3872420799327944e-02, 1.5724579928094805e-02, 1.6995564088640176e-02, 1.7398101046751331e-02, 1.6415568300793847e-02, 1.3819441733730621e-02, 8.9639373418017500e-03, 3.7669314883747615e-03, 2.7447238816255521e-04, 1.5149150089701472e-05, 9.9721476653303880e-05, 1.5090306163229064e-04, 1.1067868235150748e-04, 6.5952820793956275e-05, 4.7902349142068158e-05, 4.8153588035569319e-05, 4.9206320033902837e-05, 4.9622607426933317e-05, 4.9631707088836125e-05, 4.9608427746471879e-05, 4.9599336753756286e-05, 4.9598921660961718e-05, 4.9599447690851822e-05, 4.9599690391576696e-05, 4.9599591490273580e-05, 4.9598676543681986e-05, 4.9596564296812746e-05, 4.9601614757236363e-05, 4.9640676165722513e-05, 4.9751539003275205e-05, 4.9514879252767139e-05, 4.7898452774396719e-05, 4.1730155139124382e-05, 5.1709058978545723e-05, 1.0879258207222810e-04, 4.4546838873662961e-04, 1.0727548824916991e-03, 1.8596343455541502e-03, 1.9391675641376208e-03, 1.8982773194423520e-03, 1.8658599054137196e-03, 1.8597745517944251e-03, 1.8583289245480130e-03, 1.8669743264165906e-03, 1.8476561370842283e-03, 1.8967543650224056e-03, 1.8166886857155877e-03, 2.1742067349690160e-04, 1.6711142629718048e-04, -9.9301176013844061e-05, 2.4275836154964676e-04, 1.3788147168192313e-03, 4.5360467165383774e-03, 7.9447730645893291e-03, 1.1309546741329932e-02, 1.3862732594325423e-02, 1.5730395536483793e-02, 1.6982811153783684e-02, 1.7407751056816009e-02, 1.6409785310140017e-02, 1.3837190761710631e-02, 8.9848564926752542e-03, 3.7106164973131645e-03, 3.2005689915016354e-04, -1.1762862343107751e-05, 1.2387637068527800e-04, 1.5162318296586892e-04, 1.1924726511060740e-04, 6.9735149215390527e-05, 5.2513789151763810e-05, 5.2505081597446159e-05, 5.3829208190670530e-05, 5.4184664316397866e-05, 5.4197338333152025e-05, 5.4171798720878560e-05, 5.4165014712169201e-05, 5.4164855184991539e-05, 5.4165424947554312e-05, 5.4165600563286975e-05, 5.4165603674824010e-05, 5.4164653923223112e-05, 5.4163290890551748e-05, 5.4163537426693889e-05, 5.4205904862127338e-05, 5.4266083895239136e-05, 5.4170698302366375e-05, 5.2044797351721106e-05, 4.7533599990288261e-05, 5.3279645985170171e-05, 1.2355694582788041e-04, 4.4439349044291025e-04, 1.0566345089074332e-03, 1.8807181402187105e-03, 1.9259865025535797e-03, 1.9053506673771879e-03, 1.8614146664119274e-03, 1.8580889611362872e-03, 1.8671653089793465e-03, 1.8478428853693368e-03, 1.9048999582283563e-03, 1.7627304172439801e-03, 1.9982757146222289e-03, 1.3808548940662225e-04, 1.1889197488242184e-04, -1.3567593910239986e-06, 1.0570149155238674e-04, 1.3811013124063059e-03, 4.4131643786810022e-03, 8.0698133157557621e-03, 1.1304822143497407e-02, 1.3916550061472552e-02, 1.5679469050270182e-02, 1.6998024518489582e-02, 1.7379199925778032e-02, 1.6534144336195992e-02, 1.3975520200079194e-02, 9.0386974994914396e-03, 3.6269101933658547e-03, -5.0560803478998216e-05, 7.6819181082594934e-05, 1.6404575298761636e-04, 1.8020044480094417e-04, 1.0204299851629968e-04, 5.8403540211684606e-05, 4.0774896755148416e-05, 4.2594018045917048e-05, 4.3257441755387427e-05, 4.3498483806038684e-05, 4.3440476284975202e-05, 4.3423123494165219e-05, 4.3418464069983149e-05, 4.3419511600935483e-05, 4.3419911970858801e-05, 4.3420077745129563e-05, 4.3419989113551608e-05, 4.3419966908692983e-05, 4.3416395620321394e-05, 4.3420305121574092e-05, 4.3419548113501281e-05, 4.3597251996345750e-05, 4.3395814012748863e-05, 4.3601637981375463e-05, 3.6805589906743039e-05, 5.5506970632529267e-05, 7.8082982079777136e-05, 3.9547712965752970e-04, 1.1007128604764817e-03, 1.8820906361242803e-03, 1.9869342085540205e-03, 1.8559641234666209e-03, 1.8670084980000120e-03, 1.8592493260250682e-03, 1.8476353205674721e-03, 1.8951862240662260e-03, 1.7641968394625774e-03, 2.0824381648996940e-03, 1.5588916170893128e-03, 6.9587131646531070e-04, 2.6326630672536755e-04, -2.4933992602606605e-05, 4.1623822535381279e-04, 6.8103339204867125e-04, 4.8736123319618229e-03, 7.8361209751231491e-03, 1.1529210160859891e-02, 1.3864069894643637e-02, 1.5668359181618338e-02, 1.6895052633848478e-02, 1.7548942494628603e-02, 1.6294333874716314e-02, 1.4505991099787584e-02, 9.0051153825949377e-03, 3.5072316073699759e-03, -5.6739795462399680e-04, 4.8661510935222668e-04, 2.3689225387805310e-04, 2.7321810728572505e-04, 1.9539659214778556e-04, 1.5584424506735081e-04, 1.3533083854941030e-04, 1.3900988180806534e-04, 1.3924655062716177e-04, 1.3937053162467987e-04, 1.3929820502113822e-04, 1.3928477260582422e-04, 1.3928258219787383e-04, 1.3928392579334642e-04, 1.3928423606520939e-04, 1.3928433385494742e-04, 1.3928432378418839e-04, 1.3928438010658549e-04, 1.3928165757548931e-04, 1.3928145430925948e-04, 1.3927801542673482e-04, 1.3941672548600640e-04, 1.3941032950292963e-04, 1.4008195470501845e-04, 1.3371982406971183e-04, 1.5494609264068423e-04, 1.8600506633100595e-04, 4.3145516751200272e-04, 8.4315012019652621e-04, 2.2826371041625962e-03, 1.7704628202846915e-03, 1.9217844160657224e-03, 1.8316369379314970e-03, 1.8616806018752939e-03, 1.8794531227876192e-03, 1.8196718222934500e-03, 1.9956284473911742e-03, 1.5607165638406521e-03, 2.2535623208596572e-03};
#define c0 CASADI_PREFIX(c0)
static const real_t CASADI_PREFIX(c1)[131] = {-5.6818181818181817e+00, -5.6818181818181817e+00, -5.6818181818181817e+00, -5.6818181818181817e+00, -4.3181818181818183e+00, -3.6363636363636367e+00, -2.9545454545454550e+00, -2.2727272727272734e+00, -1.5909090909090917e+00, -9.0909090909091006e-01, -2.2727272727272840e-01, 4.5454545454545325e-01, 1.1363636363636349e+00, 1.8181818181818166e+00, 2.4999999999999982e+00, 3.1818181818181799e+00, 3.8636363636363615e+00, 4.5454545454545432e+00, 5.2272727272727249e+00, 5.9090909090909065e+00, 6.5909090909090882e+00, 7.2727272727272698e+00, 7.9545454545454515e+00, 8.6363636363636331e+00, 9.3181818181818148e+00, 9.9999999999999964e+00, 1.0681818181818178e+01, 1.1363636363636358e+01, 1.2045454545454541e+01, 1.2727272727272727e+01, 1.3409090909090910e+01, 1.4090909090909093e+01, 1.4772727272727273e+01, 1.5454545454545455e+01, 1.6136363636363637e+01, 1.6818181818181820e+01, 1.7500000000000000e+01, 1.8181818181818180e+01, 1.8863636363636363e+01, 1.9545454545454547e+01, 2.0227272727272727e+01, 2.0909090909090907e+01, 2.1590909090909090e+01, 2.2272727272727273e+01, 2.2954545454545453e+01, 2.3636363636363633e+01, 2.4318181818181817e+01, 25., 2.5681818181818180e+01, 2.6363636363636360e+01, 2.7045454545454543e+01, 2.7727272727272727e+01, 2.8409090909090907e+01, 2.9090909090909086e+01, 2.9772727272727270e+01, 3.1136363636363633e+01, 3.1136363636363633e+01, 3.1136363636363633e+01, 3.1136363636363633e+01, -2.3747727272727275e+00, -2.3747727272727275e+00, -2.3747727272727275e+00, -2.3747727272727275e+00, -1.6934090909090913e+00, -1.3527272727272732e+00, -1.0120454545454551e+00, -6.7136363636363705e-01, -3.3068181818181897e-01, 9.9999999999988987e-03, 3.5068181818181721e-01, 6.9136363636363551e-01, 1.0320454545454534e+00, 1.3727272727272712e+00, 1.7134090909090895e+00, 2.0540909090909079e+00, 2.3947727272727253e+00, 2.7354545454545436e+00, 3.0761363636363619e+00, 3.4168181818181802e+00, 3.7574999999999985e+00, 4.0981818181818159e+00, 4.4388636363636342e+00, 4.7795454545454525e+00, 5.1202272727272700e+00, 5.4609090909090883e+00, 5.8015909090909066e+00, 6.1422727272727240e+00, 6.4829545454545432e+00, 6.8236363636363606e+00, 7.1643181818181780e+00, 7.5049999999999972e+00, 7.8456818181818146e+00, 8.1863636363636338e+00, 8.5270454545454513e+00, 8.8677272727272687e+00, 9.2084090909090932e+00, 9.5490909090909106e+00, 9.8897727272727280e+00, 1.0230454545454547e+01, 1.0571136363636365e+01, 1.0911818181818184e+01, 1.1252500000000001e+01, 1.1593181818181819e+01, 1.1933863636363638e+01, 1.2274545454545455e+01, 1.2615227272727275e+01, 1.2955909090909092e+01, 1.3296590909090909e+01, 1.3637272727272727e+01, 1.3977954545454546e+01, 1.4318636363636363e+01, 1.4659318181818183e+01, 15., 1.5340681818181817e+01, 1.5681363636363637e+01, 1.6022045454545456e+01, 1.6362727272727273e+01, 1.6703409090909091e+01, 1.7044090909090908e+01, 1.7384772727272725e+01, 1.7725454545454546e+01, 1.8066136363636364e+01, 1.8406818181818181e+01, 1.8747499999999999e+01, 1.9088181818181816e+01, 1.9428863636363634e+01, 1.9769545454545455e+01, 2.0450909090909089e+01, 2.0450909090909089e+01, 2.0450909090909089e+01, 2.0450909090909089e+01};
#define c1 CASADI_PREFIX(c1)
/* Spline */
static int CASADI_PREFIX(f0)(const real_t** arg, real_t** res, int* iw, real_t* w, int mem) {
    if (res[0]) fill(res[0], 1, 0.0);
    if (res[0]) CASADI_PREFIX(nd_boor_eval)(res[0],2,c1,s3,s2,s1,c0,1,arg[0],s0, 0, iw, w);
  return 0;
}

#define f0(arg, res, iw, w, mem) CASADI_PREFIX(f0)(arg, res, iw, w, mem)

/* expl_ode */
CASADI_SYMBOL_EXPORT int expl_ode(const real_t** arg, real_t** res, int* iw, real_t* w, int mem) {
  const real_t **arg1=arg+2;
  real_t **res1=res+1, *rr, *ss;
  real_t *w0=w+14, w1, w2, w3, w4, w5, w6, *w7=w+26, w8, w9, w10, w11, *w12=w+33, w13, w14;
  /* #0: @0 = input[0][0] */
  copy(arg[0], 6, w0);
  /* #1: @1 = @0[3] */
  for (rr=(&w1), ss=w0+3; ss!=w0+4; ss+=1) *rr++ = *ss;
  /* #2: @2 = 867637000 */
  w2 = 867637000.;
  /* #3: @2 = (@2*@1) */
  w2 *= w1;
  /* #4: @3 = @0[1] */
  for (rr=(&w3), ss=w0+1; ss!=w0+2; ss+=1) *rr++ = *ss;
  /* #5: @4 = 62150000 */
  w4 = 62150000.;
  /* #6: @4 = (@4*@3) */
  w4 *= w3;
  /* #7: @2 = (@2+@4) */
  w2 += w4;
  /* #8: @4 = @0[5] */
  for (rr=(&w4), ss=w0+5; ss!=w0+6; ss+=1) *rr++ = *ss;
  /* #9: @5 = 970000 */
  w5 = 970000.;
  /* #10: @5 = (@5*@4) */
  w5 *= w4;
  /* #11: @2 = (@2-@5) */
  w2 -= w5;
  /* #12: @5 = 40589300 */
  w5 = 40589300.;
  /* #13: @2 = (@2/@5) */
  w2 /= w5;
  /* #14: output[0][0] = @2 */
  if (res[0]) res[0][0] = w2;
  /* #15: @2 = @0[2] */
  for (rr=(&w2), ss=w0+2; ss!=w0+3; ss+=1) *rr++ = *ss;
  /* #16: @5 = (@1+@2) */
  w5  = (w1+w2);
  /* #17: @5 = cos(@5) */
  w5 = cos( w5 );
  /* #18: @6 = 0.35 */
  w6 = 3.4999999999999998e-01;
  /* #19: @6 = (@6*@5) */
  w6 *= w5;
  /* #20: @5 = 1 */
  w5 = 1.;
  /* #21: @5 = (@5+@6) */
  w5 += w6;
  /* #22: @6 = 0.2 */
  w6 = 2.0000000000000001e-01;
  /* #23: @5 = pow(@5,@6) */
  w5  = pow(w5,w6);
  /* #24: @7 = input[1][0] */
  copy(arg[1], 3, w7);
  /* #25: @6 = @7[2] */
  for (rr=(&w6), ss=w7+2; ss!=w7+3; ss+=1) *rr++ = *ss;
  /* #26: @5 = (@5*@6) */
  w5 *= w6;
  /* #27: @8 = sq(@5) */
  w8 = sq( w5 );
  /* #28: @9 = 5091.5 */
  w9 = 5.0915000000000000e+03;
  /* #29: @9 = (@9*@8) */
  w9 *= w8;
  /* #30: @8 = @0[0] */
  for (rr=(&w8), ss=w0+0; ss!=w0+1; ss+=1) *rr++ = *ss;
  /* #31: @10 = (@3+@8) */
  w10  = (w3+w8);
  /* #32: @11 = 63 */
  w11 = 63.;
  /* #33: @11 = (@11*@10) */
  w11 *= w10;
  /* #34: @11 = (@11/@5) */
  w11 /= w5;
  /* #35: @5 = @0[4] */
  for (rr=(&w5), ss=w0+4; ss!=w0+5; ss+=1) *rr++ = *ss;
  /* #36: @12 = horzcat(@5, @11) */
  rr=w12;
  *rr++ = w5;
  *rr++ = w11;
  /* #37: @12 = @12' */
  /* #38: @11 = Spline(@12) */
  arg1[0]=w12;
  res1[0]=(&w11);
  if (f0(arg1, res1, iw, w, 0)) return 1;
  /* #39: @9 = (@9*@11) */
  w9 *= w11;
  /* #40: @11 = 31.5 */
  w11 = 3.1500000000000000e+01;
  /* #41: @11 = (@11*@9) */
  w11 *= w9;
  /* #42: @9 = 2.0944 */
  w9 = 2.0943999999999998e+00;
  /* #43: @9 = (@9+@1) */
  w9 += w1;
  /* #44: @9 = (@9+@2) */
  w9 += w2;
  /* #45: @9 = cos(@9) */
  w9 = cos( w9 );
  /* #46: @10 = 0.35 */
  w10 = 3.4999999999999998e-01;
  /* #47: @10 = (@10*@9) */
  w10 *= w9;
  /* #48: @9 = 1 */
  w9 = 1.;
  /* #49: @9 = (@9+@10) */
  w9 += w10;
  /* #50: @10 = 0.2 */
  w10 = 2.0000000000000001e-01;
  /* #51: @9 = pow(@9,@10) */
  w9  = pow(w9,w10);
  /* #52: @9 = (@9*@6) */
  w9 *= w6;
  /* #53: @10 = sq(@9) */
  w10 = sq( w9 );
  /* #54: @13 = 5091.5 */
  w13 = 5.0915000000000000e+03;
  /* #55: @13 = (@13*@10) */
  w13 *= w10;
  /* #56: @10 = (@3+@8) */
  w10  = (w3+w8);
  /* #57: @14 = 63 */
  w14 = 63.;
  /* #58: @14 = (@14*@10) */
  w14 *= w10;
  /* #59: @14 = (@14/@9) */
  w14 /= w9;
  /* #60: @12 = horzcat(@5, @14) */
  rr=w12;
  *rr++ = w5;
  *rr++ = w14;
  /* #61: @12 = @12' */
  /* #62: @14 = Spline(@12) */
  arg1[0]=w12;
  res1[0]=(&w14);
  if (f0(arg1, res1, iw, w, 0)) return 1;
  /* #63: @13 = (@13*@14) */
  w13 *= w14;
  /* #64: @14 = 31.5 */
  w14 = 3.1500000000000000e+01;
  /* #65: @14 = (@14*@13) */
  w14 *= w13;
  /* #66: @14 = (-@14) */
  w14 = (- w14 );
  /* #67: @14 = (@14-@11) */
  w14 -= w11;
  /* #68: @11 = 4.1888 */
  w11 = 4.1887999999999996e+00;
  /* #69: @11 = (@11+@1) */
  w11 += w1;
  /* #70: @11 = (@11+@2) */
  w11 += w2;
  /* #71: @11 = cos(@11) */
  w11 = cos( w11 );
  /* #72: @2 = 0.35 */
  w2 = 3.4999999999999998e-01;
  /* #73: @2 = (@2*@11) */
  w2 *= w11;
  /* #74: @11 = 1 */
  w11 = 1.;
  /* #75: @11 = (@11+@2) */
  w11 += w2;
  /* #76: @2 = 0.2 */
  w2 = 2.0000000000000001e-01;
  /* #77: @11 = pow(@11,@2) */
  w11  = pow(w11,w2);
  /* #78: @11 = (@11*@6) */
  w11 *= w6;
  /* #79: @6 = sq(@11) */
  w6 = sq( w11 );
  /* #80: @2 = 5091.5 */
  w2 = 5.0915000000000000e+03;
  /* #81: @2 = (@2*@6) */
  w2 *= w6;
  /* #82: @6 = (@3+@8) */
  w6  = (w3+w8);
  /* #83: @13 = 63 */
  w13 = 63.;
  /* #84: @13 = (@13*@6) */
  w13 *= w6;
  /* #85: @13 = (@13/@11) */
  w13 /= w11;
  /* #86: @12 = horzcat(@5, @13) */
  rr=w12;
  *rr++ = w5;
  *rr++ = w13;
  /* #87: @12 = @12' */
  /* #88: @13 = Spline(@12) */
  arg1[0]=w12;
  res1[0]=(&w13);
  if (f0(arg1, res1, iw, w, 0)) return 1;
  /* #89: @2 = (@2*@13) */
  w2 *= w13;
  /* #90: @13 = 31.5 */
  w13 = 3.1500000000000000e+01;
  /* #91: @13 = (@13*@2) */
  w13 *= w2;
  /* #92: @14 = (@14-@13) */
  w14 -= w13;
  /* #93: @13 = 867637000 */
  w13 = 867637000.;
  /* #94: @13 = (@13*@1) */
  w13 *= w1;
  /* #95: @14 = (@14+@13) */
  w14 += w13;
  /* #96: @13 = 62150000 */
  w13 = 62150000.;
  /* #97: @13 = (@13*@3) */
  w13 *= w3;
  /* #98: @14 = (@14+@13) */
  w14 += w13;
  /* #99: @13 = 35563800 */
  w13 = 35563800.;
  /* #100: @14 = (@14/@13) */
  w14 /= w13;
  /* #101: @14 = (-@14) */
  w14 = (- w14 );
  /* #102: output[0][1] = @14 */
  if (res[0]) res[0][1] = w14;
  /* #103: output[0][2] = @8 */
  if (res[0]) res[0][2] = w8;
  /* #104: output[0][3] = @3 */
  if (res[0]) res[0][3] = w3;
  /* #105: @3 = @7[0] */
  for (rr=(&w3), ss=w7+0; ss!=w7+1; ss+=1) *rr++ = *ss;
  /* #106: @3 = (@3-@5) */
  w3 -= w5;
  /* #107: @5 = 2.5 */
  w5 = 2.5000000000000000e+00;
  /* #108: @5 = (@5*@3) */
  w5 *= w3;
  /* #109: output[0][4] = @5 */
  if (res[0]) res[0][4] = w5;
  /* #110: @5 = @7[1] */
  for (rr=(&w5), ss=w7+1; ss!=w7+2; ss+=1) *rr++ = *ss;
  /* #111: @5 = (@5-@4) */
  w5 -= w4;
  /* #112: @4 = 50 */
  w4 = 50.;
  /* #113: @4 = (@4*@5) */
  w4 *= w5;
  /* #114: output[0][5] = @4 */
  if (res[0]) res[0][5] = w4;
  return 0;
}

CASADI_SYMBOL_EXPORT void expl_ode_incref(void) {
}

CASADI_SYMBOL_EXPORT void expl_ode_decref(void) {
}

CASADI_SYMBOL_EXPORT int expl_ode_n_in(void) { return 2;}

CASADI_SYMBOL_EXPORT int expl_ode_n_out(void) { return 1;}

CASADI_SYMBOL_EXPORT const char* expl_ode_name_in(int i){
  switch (i) {
    case 0: return "i0";
    case 1: return "i1";
    default: return 0;
  }
}

CASADI_SYMBOL_EXPORT const char* expl_ode_name_out(int i){
  switch (i) {
    case 0: return "o0";
    default: return 0;
  }
}

CASADI_SYMBOL_EXPORT const int* expl_ode_sparsity_in(int i) {
  switch (i) {
    case 0: return s4;
    case 1: return s5;
    default: return 0;
  }
}

CASADI_SYMBOL_EXPORT const int* expl_ode_sparsity_out(int i) {
  switch (i) {
    case 0: return s4;
    default: return 0;
  }
}

CASADI_SYMBOL_EXPORT int expl_ode_work(int *sz_arg, int* sz_res, int *sz_iw, int *sz_w) {
  if (sz_arg) *sz_arg = 4;
  if (sz_res) *sz_res = 2;
  if (sz_iw) *sz_iw = 10;
  if (sz_w) *sz_w = 37;
  return 0;
}


#ifdef __cplusplus
} /* extern "C" */
#endif
