%
% Copyright (c) The acados authors.
%
% This file is part of acados.
%
% The 2-Clause BSD License
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
% 1. Redistributions of source code must retain the above copyright notice,
% this list of conditions and the following disclaimer.
%
% 2. Redistributions in binary form must reproduce the above copyright notice,
% this list of conditions and the following disclaimer in the documentation
% and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.;

%


% Dialog with which the user selects the folder where the acados libs
% reside.
if(~ exist('acados_lib_path', 'var'))
    acados_path = uigetdir('', 'Please select folder with acados libraries for dSpace');
    acados_lib_path = fullfile(acados_path, 'lib');
    acados_include_path = fullfile(acados_path, 'include');
    blasfeo_include_path = fullfile(acados_path, 'include', 'blasfeo', 'include');
end

% Compile S function and link with acados
mex(['-I', acados_include_path], ...
    ['-I', blasfeo_include_path], ...
    ['-I', '.'], ...
    ['-I', '/Users/robin/acados/'], ...
    ['-L', acados_lib_path], ...
    ['-D', 'ACADOS_WITH_HPMPC'], ...
    ['-D', 'ACADOS_WITH_QPDUNES'], ...
    ['-D', 'ACADOS_WITH_OSQP'], ...
    ['-D', 'ACADOS_WITH_QPOASES'], ...
    '-lacados', ...
    '-lhpmpc', ...
    '-lhpipm', ...
    '-lblasfeo', ...
    '-lqpOASES_e', ...
    '-lqpdunes', ...
    'engine_nmpc.c', ...
    'engine_impl_dae_fun.c', ...
    'engine_impl_dae_jac_x_xdot_u_z.c', ...
    'engine_impl_dae_fun_jac_x_xdot_z.c', ...
    'engine_ls_cost.c', ...
    'engine_ls_cost_N.c');
