SET(CMAKE_SYSTEM_NAME "dSpaceDS1403")
list(APPEND CMAKE_MODULE_PATH ${CMAKE_CURRENT_LIST_DIR})
SET(CMAKE_SYSTEM_PROCESSOR "ppc")

file(TO_CMAKE_PATH "C:/dSPACE_RCPHIL_2020A/" DSPACE_TOOLS)
set(DSPACE_RTLIB "C:/dSPACE_RCPHIL_2020A/DS1401/RTLib")
set(DSPACE_COMPILER "${DSPACE_TOOLS}/Compiler/Linux440_550/target/arm-linux-gnueabihf")

# C Compiler
find_program(CMAKE_C_COMPILER NAMES ${DSPACE_COMPILER}/bin/arm-linux-gnueabihf-gcc.exe)
# C++ Compiler -- not used
find_program(CMAKE_CXX_COMPILER NAMES ${DSPACE_COMPILER}/bin/arm-linux-gnueabihf-gcc.exe)
# Assembler
find_program(CMAKE_ASM_COMPILER NAMES ${DSPACE_COMPILER}/bin/arm-linux-gnueabihf-as.exe)
set(CMAKE_RANLIB ":")

find_program(CMAKE_MAKE_PROGRAM NAMES "C:/dSPACE_RCPHIL_2020A/Exe/DSMAKE.exe")

SET(CMAKE_FIND_ROOT_PATH ${DSPACE_COMPILER}) 
SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)


# Compiler flags
set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -H -J{DSPACE_RTLIB}")
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -H -J{DSPACE_RTLIB}")
set(CMAKE_C_FLAGS "-D_INLINE" CACHE STRING "" FORCE)

# acados flags
set(BLASFEO_TARGET "GENERIC" CACHE STRING "BLASFEO Target architecture")
set(HPIPM_TARGET "GENERIC" CACHE STRING "HPIPM Target architecture")
set(BUILD_SHARED_LIBS OFF CACHE STRING "Build shared libraries")
set(BLASFEO_EXAMPLES OFF CACHE BOOL "Examples disabled")
set(EXT_DEP OFF CACHE BOOL "Compile external dependencies in BLASFEO")
set(ACADOS_INSTALL_DIR "install" CACHE PATH  "Installation path to ACADOS_INSTALL_DIR")


# import from platform folder
set(CMAKE_IMPORT_LIBRARY_PREFIX "")
set(CMAKE_SHARED_LIBRARY_PREFIX "")
set(CMAKE_SHARED_MODULE_PREFIX  "")
set(CMAKE_STATIC_LIBRARY_PREFIX "")

set(CMAKE_EXECUTABLE_SUFFIX     ".exe")
set(CMAKE_IMPORT_LIBRARY_SUFFIX ".lib")
set(CMAKE_SHARED_LIBRARY_SUFFIX ".lib")
set(CMAKE_SHARED_MODULE_SUFFIX  ".lib")
set(CMAKE_STATIC_LIBRARY_SUFFIX ".lib")

# set(CMAKE_C_FLAGS "\"-J${DSPACE_RTLIB}\"")

set(CMAKE_INCLUDE_FLAG_C "-J")
set(CMAKE_INCLUDE_FLAG_CXX "-J")

# add_definitions(-D__MABX2__)
remove_definitions(-DLINUX)
remove_definitions(-DOS_WINDOWS)
remove_definitions(-D__LINUX__)
