
options(stringsAsFactors = FALSE)

# ------------------------------------------------------------------------------------
# load data

dir <- "file-path-to-data"
setwd(dir)

dat <- read.csv("MHH_data.csv")
str(dat)
                           
                           
# ------------------------------------------------------------------------------------
# load and install binary packages

ipak <- function(pkg){
    new.pkg <- pkg[!(pkg %in% installed.packages()[, "Package"])]
    if(length(new.pkg)) install.packages(new.pkg, dependencies = TRUE)
    sapply(pkg, require, character.only = TRUE)
}

packages <- c("ggplot2", "scales", "grid", "gridExtra", "reshape2", "plyr", 
                        "car", "rms", "lsmeans", "RColorBrewer", "effects", "xtable", )
ipak(packages)

# devtools::install_github("lionel-/ggstance")
library(ggstance)

 
# ------------------------------------------------------------------------------------
# set global ggplot theme
    
theme_nice <- theme_set(theme_bw())
theme_nice <- theme_update(
    axis.title.x = element_text(size = 10, margin = margin(t=10)),
    axis.title.y = element_text(size = 10, angle = 90, margin = margin(r=10)),
    axis.text.x = element_text(size = 8, angle = 0, margin = margin(t=2), color = "black"),
    axis.text.y = element_text(size = 8, hjust = 1, margin = margin(r=2), color = "black"),
    # strip.background = element_rect(color = "grey", fill = "white"),
    strip.text = element_text(size = 10),
    strip.background = element_blank(),
    panel.border = element_rect(color = "grey20"),
    panel.spacing.x = unit(0.2, "lines"),
    panel.spacing.y = unit(0.05,"lines"),
    panel.grid.minor = element_blank(),
    panel.grid.major.y = element_blank(),
    # explicitly set the horizontal lines (or they will disappear too)
    panel.grid.major.x = element_line(size=.5, color="#f0f0f0"),
    legend.title = element_text(size = 8, face = "plain"),
    legend.key.size = unit(.8, units = "line"),
    legend.text = element_text(size = 8),
    legend.background = element_rect(fill = "gray95", color = "gray20",
                                     size = 0.5, linetype = "dotted"))
                                     
                                     
                                     
####################################################################################
####################################################################################
####################################################################################
# MPP max 15km OLS models for figure 2 split by warm climate and combined warm/cold climate

# -------------------------------------------
# MODEL 1: OLS

model_wc15c1 <- lm(npp_max_15km ~ subsistence + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             latitude_abs,
              data = dat)
summary(model_wc15c1)
Anova(model_wc15c1, type = "III")
#confint(model_wc15c1)

model_wc15c2 <- lm(npp_max_15km ~ subsistence + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             latitude_abs +
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             subsistence:climate,
              data = dat)
summary(model_wc15c2)
Anova(model_wc15c2, type = "III")
#confint(model_wc15c2)


# -------------------------------------------
model_wc15b1 <- lm(npp_max_15km ~ subsistence_ternary + 
                                  climate +
                                  ET + 
                                  mean_annual_precip_mm + 
                                  #marine_dist +
                                  #mobility_bin +
                                  #fishing_bin +
                                  latitude_abs,
              data = dat)
summary(model_wc15b1)
Anova(model_wc15b1, type = "III")
#confint(model_wc15b1)

model_wc15b2 <- lm(npp_max_15km ~ subsistence_ternary + 
                                  climate +
                                  ET + 
                                  mean_annual_precip_mm + 
                                  latitude_abs +
                                  #marine_dist +
                                  #mobility_bin +
                                  #fishing_bin +
                                  subsistence_ternary:climate,
              data = dat)
summary(model_wc15b2)
Anova(model_wc15b2, type = "III")
#confint(model_wc15b2)


# -------------------------------------------
model_wc15a1 <- lm(npp_max_15km ~ subsistence_binary + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             latitude_abs,
              data = dat)
summary(model_wc15a1)
Anova(model_wc15a1, type = "III")
#confint(model_wc15a1)

model_wc15a2 <- lm(npp_max_15km ~ subsistence_binary + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             latitude_abs +
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             subsistence_binary:climate,
              data = dat)
summary(model_wc15a2)
Anova(model_wc15a2, type = "III")
#confint(model_wc15a2)


# -------------------------------------------
# effects all

eff_wc15c1 <- allEffects(model_wc15c1)
eff_df_wc15c1 <- as.data.frame(eff_wc15c1[["subsistence"]])
#
eff_wc15c2 <- allEffects(model_wc15c2)
eff_df_wc15c2 <- as.data.frame(eff_wc15c2[["subsistence:climate"]])
eff_df_wc15c2$climate <- as.character(eff_df_wc15c2$climate)
#
# combine effects into warm and total
eff_df_wc15c2[eff_df_wc15c2$climate %in% "cold", c("fit", "se", "lower", "upper")] <- eff_df_wc15c1[, c("fit", "se", "lower", "upper")]
eff_df_wc15c2[eff_df_wc15c2$climate %in% "cold", "climate"] <- "combined"


# -------------------------------------------
# effects ternary

eff_wc15b1 <- allEffects(model_wc15b1)
eff_df_wc15b1 <- as.data.frame(eff_wc15b1[["subsistence_ternary"]])
#
eff_wc15b2 <- allEffects(model_wc15b2)
eff_df_wc15b2 <- as.data.frame(eff_wc15b2[["subsistence_ternary:climate"]])
eff_df_wc15b2$climate <- as.character(eff_df_wc15b2$climate)
#
# combine effects into warm and total
eff_df_wc15b2[eff_df_wc15b2$climate %in% "cold", c("fit", "se", "lower", "upper")] <- eff_df_wc15b1[, c("fit", "se", "lower", "upper")]
eff_df_wc15b2[eff_df_wc15b2$climate %in% "cold", "climate"] <- "combined"


# -------------------------------------------
# effects binary

eff_wc15a1 <- allEffects(model_wc15a1)
eff_df_wc15a1 <- as.data.frame(eff_wc15a1[["subsistence_binary"]])
#
eff_wc15a2 <- allEffects(model_wc15a2)
eff_df_wc15a2 <- as.data.frame(eff_wc15a2[["subsistence_binary:climate"]])
eff_df_wc15a2$climate <- as.character(eff_df_wc15a2$climate)
#
# combine effects into warm and total
eff_df_wc15a2[eff_df_wc15a2$climate %in% "cold", c("fit", "se", "lower", "upper")] <- eff_df_wc15a1[, c("fit", "se", "lower", "upper")]
eff_df_wc15a2[eff_df_wc15a2$climate %in% "cold", "climate"] <- "combined"


# -------------------------------------------
# effects combined

eff_df_wc15a2$model <- "A"
eff_df_wc15b2$model <- "B"
eff_df_wc15c2$model <- "C"
colnames(eff_df_wc15a2)[1] <- "subsistence"
colnames(eff_df_wc15b2)[1] <- "subsistence"

eff_df_comb_15 <- rbind(eff_df_wc15a2, eff_df_wc15b2, eff_df_wc15c2)
colnames(eff_df_comb_15)[2] <- "Climate"

eff_df_comb_15$model <- factor(eff_df_comb_15$model, levels = c("A", "B", "C"))

eff_df_comb_15$subsistence <- factor(eff_df_comb_15$subsistence,
    levels = rev(c("Foraging", "Agriculture", "Horticulture", "Intensive agriculture", "Pastoralism")))
    
    
# -------------------------------------------
# plot all

# NPP max
npp15km_comb <- ggplot(eff_df_comb_15, aes(x = fit,
        y = subsistence, group = Climate, linetype = Climate)) +
    geom_point(shape = 16, size = 2.5, position = position_dodgev(height = 0.4)) +
    geom_linerangeh(aes(xmin = lower, xmax = upper), size = 0.7, position = position_dodgev(height = 0.4)) +
    scale_x_continuous(breaks = seq(0, 1600, by = 100)) +
    facet_grid(model ~ ., scales = "free", space = "free") +
    labs(x = bquote(NPP[max]~~15~km~radius~(g~C/m^{2}/year)), y = "") +
    #labs(x = expression(NPP[mean]~~15~km~radius~(g~~C/m^{2}/year)), y = "") +
    guides(linetype = guide_legend(title = "Climate", reverse = TRUE)) +
    theme(legend.position = c(0.16, 0.89),
          strip.text.y = element_text(angle = 0))
ggsave(npp15km_comb, file = "figure_S2a.pdf", height = 4, width = 5.2)




####################################################################################
####################################################################################
####################################################################################
# MPP mean 15km OLS models for figure 2 split by warm climate and combined warm/cold climate

# -------------------------------------------
# MODEL 1: OLS

model_wc15c1_mean <- lm(npp_mean_15km ~ subsistence + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             latitude_abs,
              data = dat)
summary(model_wc15c1_mean)
Anova(model_wc15c1_mean, type = "III")
#confint(model_wc15c1_mean)

model_wc15c2_mean <- lm(npp_mean_15km ~ subsistence + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             latitude_abs +
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             subsistence:climate,
              data = dat)
summary(model_wc15c2_mean)
Anova(model_wc15c2_mean, type = "III")
#confint(model_wc15c2_mean)


# -------------------------------------------
model_wc15b1_mean <- lm(npp_mean_15km ~ subsistence_ternary + 
                                  climate +
                                  ET + 
                                  mean_annual_precip_mm + 
                                  #marine_dist +
                                  #mobility_bin +
                                  #fishing_bin +
                                  latitude_abs,
              data = dat)
summary(model_wc15b1_mean)
Anova(model_wc15b1_mean, type = "III")
#confint(model_wc15b1_mean)

model_wc15b2_mean <- lm(npp_mean_15km ~ subsistence_ternary + 
                                  climate +
                                  ET + 
                                  mean_annual_precip_mm + 
                                  latitude_abs +
                                  #marine_dist +
                                  #mobility_bin +
                                  #fishing_bin +
                                  subsistence_ternary:climate,
              data = dat)
summary(model_wc15b2_mean)
Anova(model_wc15b2_mean, type = "III")
#confint(model_wc15b2_mean)


# -------------------------------------------
model_wc15a1_mean <- lm(npp_mean_15km ~ subsistence_binary + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             latitude_abs,
              data = dat)
summary(model_wc15a1_mean)
Anova(model_wc15a1_mean, type = "III")
#confint(model_wc15a1_mean)

model_wc15a2_mean <- lm(npp_mean_15km ~ subsistence_binary + 
                             climate +
                             ET + 
                             mean_annual_precip_mm + 
                             latitude_abs +
                             #marine_dist +
                             #mobility_bin +
                             #fishing_bin +
                             subsistence_binary:climate,
              data = dat)
summary(model_wc15a2_mean)
Anova(model_wc15a2_mean, type = "III")
#confint(model_wc15a2_mean)


# -------------------------------------------
# effects all

eff_wc15c1_mean <- allEffects(model_wc15c1_mean)
eff_df_wc15c1_mean <- as.data.frame(eff_wc15c1_mean[["subsistence"]])
#
eff_wc15c2_mean <- allEffects(model_wc15c2_mean)
eff_df_wc15c2_mean <- as.data.frame(eff_wc15c2_mean[["subsistence:climate"]])
eff_df_wc15c2_mean$climate <- as.character(eff_df_wc15c2_mean$climate)
#
# combine effects into warm and total
eff_df_wc15c2_mean[eff_df_wc15c2_mean$climate %in% "cold", c("fit", "se", "lower", "upper")] <- eff_df_wc15c1_mean[, c("fit", "se", "lower", "upper")]
eff_df_wc15c2_mean[eff_df_wc15c2_mean$climate %in% "cold", "climate"] <- "combined"


# -------------------------------------------
# effects ternary

eff_wc15b1_mean <- allEffects(model_wc15b1_mean)
eff_df_wc15b1_mean <- as.data.frame(eff_wc15b1_mean[["subsistence_ternary"]])
#
eff_wc15b2_mean <- allEffects(model_wc15b2_mean)
eff_df_wc15b2_mean <- as.data.frame(eff_wc15b2_mean[["subsistence_ternary:climate"]])
eff_df_wc15b2_mean$climate <- as.character(eff_df_wc15b2_mean$climate)
#
# combine effects into warm and total
eff_df_wc15b2_mean[eff_df_wc15b2_mean$climate %in% "cold", c("fit", "se", "lower", "upper")] <- eff_df_wc15b1_mean[, c("fit", "se", "lower", "upper")]
eff_df_wc15b2_mean[eff_df_wc15b2_mean$climate %in% "cold", "climate"] <- "combined"


# -------------------------------------------
# effects binary

eff_wc15a1_mean <- allEffects(model_wc15a1_mean)
eff_df_wc15a1_mean <- as.data.frame(eff_wc15a1_mean[["subsistence_binary"]])
#
eff_wc15a2_mean <- allEffects(model_wc15a2_mean)
eff_df_wc15a2_mean <- as.data.frame(eff_wc15a2_mean[["subsistence_binary:climate"]])
eff_df_wc15a2_mean$climate <- as.character(eff_df_wc15a2_mean$climate)
#
# combine effects into warm and total
eff_df_wc15a2_mean[eff_df_wc15a2_mean$climate %in% "cold", c("fit", "se", "lower", "upper")] <- eff_df_wc15a1_mean[, c("fit", "se", "lower", "upper")]
eff_df_wc15a2_mean[eff_df_wc15a2_mean$climate %in% "cold", "climate"] <- "combined"


# -------------------------------------------
# effects combined

eff_df_wc15a2_mean$model <- "A"
eff_df_wc15b2_mean$model <- "B"
eff_df_wc15c2_mean$model <- "C"
colnames(eff_df_wc15a2_mean)[1] <- "subsistence"
colnames(eff_df_wc15b2_mean)[1] <- "subsistence"

eff_df_comb_15_mean <- rbind(eff_df_wc15a2_mean, eff_df_wc15b2_mean, eff_df_wc15c2_mean)
colnames(eff_df_comb_15_mean)[2] <- "Climate"

eff_df_comb_15_mean$model <- factor(eff_df_comb_15_mean$model, levels = c("A", "B", "C"))

eff_df_comb_15_mean$subsistence <- factor(eff_df_comb_15_mean$subsistence,
    levels = rev(c("Foraging", "Agriculture", "Horticulture", "Intensive agriculture", "Pastoralism")))
    
    
# -------------------------------------------
# plot all

# NPP mean
npp15km_comb_mean <- ggplot(eff_df_comb_15_mean, aes(x = fit,
        y = subsistence, group = Climate, linetype = Climate)) +
    geom_point(shape = 16, size = 2.5, position = position_dodgev(height = 0.4)) +
    geom_linerangeh(aes(xmin = lower, xmax = upper), size = 0.7, position = position_dodgev(height = 0.4)) +
    scale_x_continuous(breaks = seq(0, 1600, by = 100)) +
    facet_grid(model ~ ., scales = "free", space = "free") +
    labs(x = bquote(NPP[mean]~~15~km~radius~(g~C/m^{2}/year)), y = "") +
    guides(linetype = guide_legend(title = "Climate", reverse = TRUE)) +
    theme(legend.position = c(0.16, 0.89),
          strip.text.y = element_text(angle = 0))
ggsave(npp15km_comb_mean, file = "figure_S2b.pdf", height = 4, width = 5.2)



