
options(stringsAsFactors = FALSE)

# ------------------------------------------------------------------------------------
# load data

dir <- "file-path-to-data"
setwd(dir)

dat <- read.csv("MHH_data.csv")
str(dat)

# re-label PD factor
dat$pop_density_tern <- factor(dat$pop_density_tern, 
    levels = rev(c("low", "medium", "high")),
    labels = rev(c("Low", "Medium", "High")))

dat <- dat[!is.na(dat$pop_density_tern), ]


# ---------------------------------------------
# color blind palette

cbbPalette <- c("#E69F00", "#555555", "#56B4E9", "#009E73",
                           "#F0E442", "#0072B2", "#D55E00", "#CC79A7")

# ------------------------------------------------------------------------------------
# load and install binary packages

ipak <- function(pkg){
    new.pkg <- pkg[!(pkg %in% installed.packages()[, "Package"])]
    if(length(new.pkg)) install.packages(new.pkg, dependencies = TRUE)
    sapply(pkg, require, character.only = TRUE)
}

packages <- c("ggplot2", "scales", "grid", "gridExtra", "reshape2", "plyr", 
                        "car", "texreg", "lsmeans", "RColorBrewer",  "effects", "xtable")
ipak(packages)

# devtools::install_github("lionel-/ggstance")
library(ggstance)

 
# ------------------------------------------------------------------------------------
# set global ggplot theme

    
theme_nice <- theme_set(theme_bw())
theme_nice <- theme_update(
    axis.title.x = element_text(size = 10, margin = margin(t=10)),
    axis.title.y = element_text(size = 10, angle = 90, margin = margin(r=10)),
    axis.text.x = element_text(size = 8, angle = 0, margin = margin(t=2), color = "black"),
    axis.text.y = element_text(size = 8, hjust = 1, margin = margin(r=2), color = "black"),
    # strip.background = element_rect(color = "grey", fill = "white"),
    strip.text = element_text(size = 10),
    strip.background = element_blank(),
    panel.border = element_rect(color = "grey20"),
    panel.spacing.x = unit(0.2, "lines"),
    panel.spacing.y = unit(0.05,"lines"),
    panel.grid.minor = element_blank(),
    panel.grid.major.y = element_blank(),
    # explicitly set the horizontal lines (or they will disappear too)
    panel.grid.major.x = element_line(size=.5, color="#f0f0f0"),
    legend.title = element_text(size = 8, face = "italic"),
    legend.key.size = unit(.8, units = "line"),
    legend.text = element_text(size = 8),
    legend.background = element_rect(fill = "gray95", color = "gray20",
                                     size = 0.5, linetype = "dotted"))
                


########################################################################################################
########################################################################################################
########################################################################################################
# ------------------------------------------------------------------------------------------------------ 
# predictions of NPP max 15km by subsistence and latitude


preds_lat_15_sub <- ggplot(dat, aes(x = latitude_abs, y = npp_max_15km, 
        color = pop_density_tern, shape = pop_density_tern)) +
    geom_point() +
    geom_smooth(aes(group = 1), method = "lm", formula = y ~ poly(x, 2), color = "grey30") +
    scale_color_manual(values = cbbPalette[c(1, 8, 3)], name = "Pop. Density") +
    scale_shape_manual(values = 17:15, name = "Pop. Density") +
    scale_y_continuous(breaks = seq(0, 2400, by = 200)) +
    scale_x_continuous(breaks = seq(0, 70, by = 10)) +
    facet_wrap(~ subsistence) +
    labs(x = "Absolute Latitude", y = bquote(NPP[max]~~~15~~km~~radius~~(g~~C/m^{2}/year))) +
    theme(legend.position = c(0.91, 0.91),
               legend.title = element_text(size = 7, face = "plain"),
               legend.key.size = unit(.7, units = "line"),
               legend.text = element_text(size = 7))
ggsave(preds_lat_15_sub, file = "figure_3.pdf", height = 5, width = 5)



preds_lat_120_sub <- ggplot(dat, aes(x = latitude_abs, y = npp_max_120km, 
        color = pop_density_tern, shape = pop_density_tern)) +
    geom_point() +
    geom_smooth(aes(group = 1), method = "lm", formula = y ~ poly(x, 2), color = "grey30") +
    scale_color_manual(values = cbbPalette[c(1, 8, 3)], name = "Pop. Density") +
    scale_shape_manual(values = 17:15, name = "Pop. Density") +
    scale_y_continuous(breaks = seq(0, 2400, by = 200)) +
    scale_x_continuous(breaks = seq(0, 70, by = 10)) +
    facet_wrap(~ subsistence) +
    labs(x = "Absolute Latitude", y = bquote(NPP[max]~~~120~~km~~radius~~(g~~C/m^{2}/year))) +
    theme(legend.position = c(0.91, 0.91),
               legend.title = element_text(size = 7, face = "plain"),
               legend.key.size = unit(.7, units = "line"),
               legend.text = element_text(size = 7))
ggsave(preds_lat_120_sub, file = "figure_S3.pdf", height = 5, width = 5)



