function [indices] = class2indices(ds,classname,classdim)
% Extracts indices of the corresponding class name 'classname' from the
% classdim among dataset PLS_Toolbox dataset object
% dataset = datasetobject
% classname = name of the dataset to extract 
% classdim = dimension of the class to extract 
% Eg. class2indices(DryUrine_A,'Experimental',[1,1])
class_code = ds.classlookup{classdim(1),classdim(2)}(strcmp(ds.classlookup{classdim(1),classdim(2)}(:,2),classname));
indices = find(ds.class{classdim(1),classdim(2)} == class_code{:});
end