function [indices,closestval] = axrange2indices(axisscale,minmax)
% Extract linear indice(s) of variables/samples from an axiscale value or
% between a min-max range including edges.
%   axisscale = axisscale form plstoolbox eg. DS.axisscale{2,1}
%   minmax = [value] or {[min1 max1],[min2 max2],...[minn maxn]} range to extract indices

indices = []; closestval = [];
for i=1:size(minmax,2)
    mx = minmax(i);
    indices = [indices find(axisscale>=mx{1,1}(1) & axisscale<=mx{1,1}(2))];
    closestval = [closestval [axisscale(indices(1)) axisscale(indices(end))]];
    indices = unique(indices);
end
end
