#6. Create final figures

source('5_Create_meta_analysis_table.R')

metafor_N_pooled<- rma(yi= Pdiff_pooled, vi= Var_Pdiff_pooled, 
                       data=Nutrient_meta_table, slab=Trait, method="REML", measure="GEN") 
forest_plot_nutrient <- forest(metafor_N_pooled, xlim=c(-13.5,11.5), alim=c(-4,4), mlab="Random Effects Model", xlab="Plasticity Difference")
forest_plot_nutrient



### Final forest plot for water

metafor_W_pooled<- rma(yi= Pdiff_pooled, vi= Var_Pdiff_pooled, data=Water_meta_table, slab=Trait, method="REML", measure="GEN") 
forest_plot_water <- forest(metafor_W_pooled, xlim=c(-13.5,11.5), alim=c(-4,4), mlab="Random Effects Model", xlab="Plasticity Difference")
forest_plot_water



### create panel of treatment * range interaction

# Nutrients


#### Nutrient Diagram 3x5

#par(mfrow=c(4, 4), mar=c(2,4,1,1)+0.4) bonferoni adjust
par(mfrow=c(5, 3), mar=c(2,4,1,2)+0.4)
# leaf shape
Ndata %>%
lineplot.CI(Treatment, Shape, group=Range, ylab='Leaf Shape', xlab='Nutrient Treatment', 
            data=., legend=FALSE, leg.lab=NULL, cex=1)
text(1.95,5.7,'***', cex=2)
# leaf area
lineplot.CI(Treatment, Area, group=Range, ylab=expression(Leaf ~ Area ~ (mm^{2})), xlab='Nutrient Treatment',
            data=Ndata, log='y', legend=FALSE, leg.lab=NULL, cex=1)
text(1.95,3000,'*', cex=2)
# SLA
lineplot.CI(Treatment, SLA, group=Range, ylab=expression(SLA ~ (mm^{2} ~ mg^{-1})), xlab='Nutrient Treatment', 
            data=Ndata, legend=FALSE, leg.lab=NULL)
#leaf % N
lineplot.CI(Treatment, Leaf_percent_N, group=Range, ylab='Leaf % N', xlab='Nutrient Treatment', 
            data=Ndata, legend=FALSE, leg.lab=NULL)
#d13C
lineplot.CI(Treatment, D13c, group=Range, ylab=expression(paste(delta,'13C (WUE)')), xlab='Nutrient Treatment',
            data=Ndata, legend=FALSE, leg.lab=NULL)
#Fv/FM
Ndata %>%
  filter(Maternal_line != "L7-D") %>%
  lineplot.CI(Treatment, Fv_Fm, group=Range,
              ylab=expression('F'[v]*' / F'[m]), xlab='Nutrient Treatment', data=., legend=FALSE, cex=1)
text(1.95,0.79,'*', cex=2)
# leaf senesence
lineplot.CI(Treatment, percent_dead_leaves, group=Range, ylab='% of Senesced Leaves', xlab='Nutrient Treatment',
            data=Ndata, legend=FALSE)
#stretch height
Ndata %>%
  filter(Maternal_line != "N22-B") %>%
  lineplot.CI(Treatment, (Stretch_height), group=Range, log='y', 
            ylab='Stretch Height (mm)', xlab='Nutrient Treatment', data=., legend=FALSE)
text(1.05, 270, '***', cex=2)
# Internode length
lineplot.CI(Treatment, (Internode_length), group=Range, log='y', 
            ylab='Internode Length (mm)', xlab='Nutrient Treatment', data=Ndata, legend=FALSE)
# SSD
lineplot.CI(Treatment, SSD, group=Range, 
            ylab=expression(SSD ~ (mm^{3} ~ mg^{-1})), xlab='Nutrient Treatment', data=Ndata, legend=FALSE)
# RMF
lineplot.CI(Treatment, RMF, group=Range, ylab='RMF',
            xlab='Nutrient Treatment', data=Ndata, legend=FALSE, leg.lab=NULL)
text(1.05, 0.125, '*', cex=2)
#LMF
lineplot.CI(Treatment, LMF, group=Range, ylab='LMF',
            xlab='Nutrient Treatment', data=Ndata, legend=FALSE, leg.lab=NULL)
# Total biomass
lineplot.CI(Treatment, Total_Biomass, group=Range, log='y', 
            ylab='Total Biomass (g)', xlab='Nutrient Treatment', data=Ndata, legend=FALSE)


#dev.print( device = png, 
#           filename = "final_figures/nutrient_reaction_norms.png",  
#           width = 549,  height = 693)


########################################################
###### Water Diagram 



#par(mfrow=c(4, 4), mar=c(2,4,1,1)+0.4) bonferoni adjust
par(mfrow=c(5, 3), mar=c(2,4,1,2)+0.4)
# leaf shape
Wdata %>%
  lineplot.CI(Treatment, Shape, group=Range, ylab='Leaf Shape', xlab='Nutrient Treatment', 
              data=., legend=FALSE, leg.lab=NULL, cex=1)

# leaf area
lineplot.CI(Treatment, Area, group=Range, ylab=expression(Leaf ~ Area ~ (mm^{2})), xlab='Nutrient Treatment',
            data=Wdata, log='y', legend=FALSE, leg.lab=NULL, cex=1)
# SLA
lineplot.CI(Treatment, SLA, group=Range, ylab=expression(SLA ~ (mm^{2} ~ mg^{-1})), xlab='Nutrient Treatment', 
            data=Wdata, legend=FALSE, leg.lab=NULL)
text(1.95,13.8,'*', cex=2)
#leaf % N
lineplot.CI(Treatment, Leaf_percent_N, group=Range, ylab='Leaf % N', xlab='Nutrient Treatment', 
            data=Wdata, legend=FALSE, leg.lab=NULL)
#d13C
lineplot.CI(Treatment, D13c, group=Range, ylab=expression(paste(delta,'13C (WUE)')), xlab='Nutrient Treatment',
            data=Wdata, legend=FALSE, leg.lab=NULL)
#Fv/FM
Wdata %>%
  lineplot.CI(Treatment, Fv_Fm, group=Range,
              ylab=expression('F'[v]*' / F'[m]), xlab='Nutrient Treatment', data=., legend=FALSE, cex=1)
# leaf senesence
lineplot.CI(Treatment, percent_dead_leaves, group=Range, ylab='% of Senesced Leaves', xlab='Nutrient Treatment',
            data=Wdata, legend=FALSE)
text(1.05,58,'***', cex=2)
#stretch height
Wdata %>%
  filter(Maternal_line != "N22-B") %>%
  lineplot.CI(Treatment, (Stretch_height), group=Range, log='y', 
              ylab='Stretch Height (mm)', xlab='Nutrient Treatment', data=., legend=FALSE)
#text(1.05, 270, '***', cex=2)
# Internode length
lineplot.CI(Treatment, (Internode_length), group=Range, log='y', 
            ylab='Internode Length (mm)', xlab='Nutrient Treatment', data=Wdata, legend=FALSE)
text(1.95, 270, '**', cex=2)
# SSD
lineplot.CI(Treatment, SSD, group=Range, 
            ylab=expression(SSD ~ (mm^{3} ~ mg^{-1})), xlab='Nutrient Treatment', data=Wdata, legend=FALSE)
# RMF
lineplot.CI(Treatment, RMF, group=Range, ylab='RMF',
            xlab='Nutrient Treatment', data=Wdata, legend=FALSE, leg.lab=NULL)
#LMF
lineplot.CI(Treatment, LMF, group=Range, ylab='LMF',
            xlab='Nutrient Treatment', data=Wdata, legend=FALSE, leg.lab=NULL)
text(1.05, 0.76, '*', cex=2)
# Total biomass
lineplot.CI(Treatment, Total_Biomass, group=Range, log='y', 
            ylab='Total Biomass (g)', xlab='Nutrient Treatment', data=Wdata, legend=FALSE)

#dev.print( device = png, 
#           filename = "final_figures/water_reaction_norms.png",  
#           width = 549,  height = 693)
