# 5. Create table for input into meta analysis

###  table of beta coefficients, standard error and variance 
###  for the effect of treatment in each raange


source('4_1_Calculate_reaction_norms_Nutrients.R')
source('4_2_Calculate_reaction_norms_Water.R')

### 5.1  nutrient treatment


Nutrient_meta_table <- as_tibble(summary(N_LME_Shape_AU)$coefficients) %>%
  mutate(trait = "Leaf Shape") %>%
  slice(-c(1)) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_Area_AU)$coefficients) %>%
              mutate(trait = "Leaf Area") %>%
              slice(-c(1))      
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_SLA_AU)$coefficients) %>%
              mutate(trait = "Specific Leaf Area") %>%
              slice(-c(1))  
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_LN_AU)$coefficients) %>%
              mutate(trait = "Leaf Nitrogen (%)") %>%
              slice(-c(1))  
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_D13c_AU)$coefficients) %>%
              mutate(trait = "d13C") %>%
              slice(-c(1)) 
            ) %>%
  bind_rows(.,
           # as_tibble(summary(N_LME_Fv_Fm_AU)$coefficients) %>%
           # use bootstrap results
              as_tibble(N_FV_FM_boot_results_table_AU) %>%
              rename(Estimate = boot_B,
                     `Std. Error` = boot_SE) %>%
              mutate(trait = "Fv / Fm") %>%
              slice(-c(1))
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_percent_dead_leaves_AU)$coefficients) %>%
              mutate(trait = "Senesced leaves (%)") %>%
              slice(-c(1)) 
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_Internode_length_AU)$coefficients) %>%
              mutate(trait = "Internode length") %>%
              slice(-c(1))  
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_stretch_height_AU)$coefficients) %>%
              mutate(trait = "Stretch height") %>%
              slice(-c(1))  
            ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_SSD_AU)$coefficients) %>%
              mutate(trait = "Specific Stem Density") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_LMF_AU)$coefficients) %>%
              mutate(trait = "Leaf Mass Fraction") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_RMF_AU)$coefficients) %>%
              mutate(trait = "Root Mass Fraction") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(N_LME_Total_Biomass_AU)$coefficients) %>%
              mutate(trait = "Total Biomass") %>%
              slice(-c(1))      
  ) %>%
  transmute(Trait = trait,
            B_AU_pooled = abs(Estimate),
            SE_AU_pooled  = `Std. Error`) %>%
  left_join(.,
            (
              as_tibble(summary(N_LM_Shape_SA)$coefficients) %>%
                mutate(trait = "Leaf Shape") %>%
                slice(-c(1)) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_Area_SA)$coefficients) %>%
                            mutate(trait = "Leaf Area") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_SLA_SA)$coefficients) %>%
                            mutate(trait = "Specific Leaf Area") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_LN_SA)$coefficients) %>%
                            mutate(trait = "Leaf Nitrogen (%)") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_D13c_SA)$coefficients) %>%
                            mutate(trait = "d13C") %>%
                            slice(-c(1)) 
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_Fv_Fm_SA)$coefficients) %>%
                            mutate(trait = "Fv / Fm") %>%
                            slice(-c(1))
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_percent_dead_leaves_SA)$coefficients) %>%
                            mutate(trait = "Senesced leaves (%)") %>%
                            slice(-c(1)) 
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_Internode_length_SA)$coefficients) %>%
                            mutate(trait = "Internode length") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_stretch_height_SA)$coefficients) %>%
                            mutate(trait = "Stretch height") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_SSD_SA)$coefficients) %>%
                            mutate(trait = "Specific Stem Density") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_LMF_SA)$coefficients) %>%
                            mutate(trait = "Leaf Mass Fraction") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_RMF_SA)$coefficients) %>%
                            mutate(trait = "Root Mass Fraction") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(N_LM_Total_Biomass_SA)$coefficients) %>%
                            mutate(trait = "Total Biomass") %>%
                            slice(-c(1))      
                ) %>%
                transmute(B_SA_pooled = abs(Estimate),
                          SE_SA_pooled  = `Std. Error`,
                          Trait = trait) 
              
            )
            
  ) %>%
  ## calculate the difference in placticity (Pdiff) and Variance
  mutate(Var_AU_pooled = SE_AU_pooled^2,
         Var_SA_pooled = SE_SA_pooled^2) %>%
  mutate(Pdiff_pooled = B_AU_pooled - B_SA_pooled,
         Var_Pdiff_pooled = Var_SA_pooled + Var_AU_pooled)

#######################################################################


### 5.2 Water


Water_meta_table <- as_tibble(summary(W_LME_Shape_AU)$coefficients) %>%
  mutate(trait = "Leaf Shape") %>%
  slice(-c(1)) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_Area_AU)$coefficients) %>%
              mutate(trait = "Leaf Area") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_SLA_AU)$coefficients) %>%
              mutate(trait = "Specific Leaf Area") %>%
              slice(-c(1))  
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_LW_AU)$coefficients) %>%
              mutate(trait = "Leaf Nitrogen (%)") %>%
              slice(-c(1))  
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_D13c_AU)$coefficients) %>%
              mutate(trait = "d13C") %>%
              slice(-c(1)) 
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_Fv_Fm_AU)$coefficients) %>%
              mutate(trait = "Fv / Fm") %>%
              slice(-c(1))
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_percent_dead_leaves_AU)$coefficients) %>%
              mutate(trait = "Senesced leaves (%)") %>%
              slice(-c(1)) 
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_Internode_length_AU)$coefficients) %>%
              mutate(trait = "Internode length") %>%
              slice(-c(1))  
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_stretch_height_AU)$coefficients) %>%
              mutate(trait = "Stretch height") %>%
              slice(-c(1))  
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_SSD_AU)$coefficients) %>%
              mutate(trait = "Specific Stem Density") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_LMF_AU)$coefficients) %>%
              mutate(trait = "Leaf Mass Fraction") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_RMF_AU)$coefficients) %>%
              mutate(trait = "Root Mass Fraction") %>%
              slice(-c(1))      
  ) %>%
  bind_rows(.,
            as_tibble(summary(W_LME_Total_Biomass_AU)$coefficients) %>%
              mutate(trait = "Total Biomass") %>%
              slice(-c(1))      
  ) %>%
  transmute(Trait = trait,
            B_AU_pooled = abs(Estimate),
            SE_AU_pooled  = `Std. Error`) %>%
  left_join(.,
            (
              as_tibble(summary(W_LM_Shape_SA)$coefficients) %>%
                mutate(trait = "Leaf Shape") %>%
                slice(-c(1)) %>%
                bind_rows(.,
                         as_tibble(summary(W_LM_Area_SA)$coefficients) %>%
                            mutate(trait = "Leaf Area") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                        #  as_tibble(summary(W_LM_SLA_SA)$coefficients) %>%
                            as_tibble(W_SLA_boot_results_table_SA) %>%
                            rename(Estimate = boot_B,
                                   `Std. Error` = boot_SE) %>%
                            mutate(trait = "Specific Leaf Area") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_LW_SA)$coefficients) %>%
                            mutate(trait = "Leaf Nitrogen (%)") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_D13c_SA)$coefficients) %>%
                            mutate(trait = "d13C") %>%
                            slice(-c(1)) 
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_Fv_Fm_SA)$coefficients) %>%
                            mutate(trait = "Fv / Fm") %>%
                            slice(-c(1))
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_percent_dead_leaves_SA)$coefficients) %>%
                            mutate(trait = "Senesced leaves (%)") %>%
                            slice(-c(1)) 
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_Internode_length_SA)$coefficients) %>%
                            mutate(trait = "Internode length") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_stretch_height_SA)$coefficients) %>%
                            mutate(trait = "Stretch height") %>%
                            slice(-c(1))  
                ) %>%
                bind_rows(.,
                      #    as_tibble(summary(W_LM_SSD_SA)$coefficients) %>%
                            as_tibble(W_SSD_boot_results_table_SA) %>%
                            rename(Estimate = boot_B,
                                   `Std. Error` = boot_SE) %>%
                            mutate(trait = "Specific Stem Density") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_LMF_SA)$coefficients) %>%
                            mutate(trait = "Leaf Mass Fraction") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_RMF_SA)$coefficients) %>%
                            mutate(trait = "Root Mass Fraction") %>%
                            slice(-c(1))      
                ) %>%
                bind_rows(.,
                          as_tibble(summary(W_LM_Total_Biomass_SA)$coefficients) %>%
                            mutate(trait = "Total Biomass") %>%
                            slice(-c(1))      
                ) %>%
                transmute(B_SA_pooled = abs(Estimate),
                          SE_SA_pooled  = `Std. Error`,
                          Trait = trait) 
              
            )
            
  ) %>%
  ## calculate the difference in placticity (Pdiff) and Variance
  mutate(Var_AU_pooled = SE_AU_pooled^2,
         Var_SA_pooled = SE_SA_pooled^2) %>%
  mutate(Pdiff_pooled = B_AU_pooled - B_SA_pooled,
         Var_Pdiff_pooled = Var_SA_pooled + Var_AU_pooled)



### 5.3  write meta analysis tables to excel
write_xlsx(list(Nutrient_meta_table = Nutrient_meta_table,
                Water_meta_table = Water_meta_table),
           path = 'Datasets/meta_analysis_tables.xlsx')