# 4.2 Reaction norms for water

source('3_Standardise_data_for_meta_analysis.R')

##############################
### Water
##############################

#################
### Australia ###
#################

############
### Area ##
############

W_LME_Area_AU <- Wdata_standardised  %>%
  filter(Range == "AU") %>%
  lmer((Area)~Treatment + (1|Population),  data=., na.action=na.omit)
summary(W_LME_Area_AU)

# model normality
qqnorm(resid(W_LME_Area_AU))
qqline(resid(W_LME_Area_AU))

skewness(resid(W_LME_Area_AU))
kurtosis(resid(W_LME_Area_AU))


############
### Shape ##
############

W_LME_Shape_AU <- Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Shape)~Treatment + (1|Population),
       data=.,  na.action=na.omit)
summary(W_LME_Shape_AU)

# model normality
qqnorm(resid(W_LME_Shape_AU))
qqline(resid(W_LME_Shape_AU))

skewness(resid(W_LME_Shape_AU))
kurtosis(resid(W_LME_Shape_AU))


##########
### SLA ###
##########

hist((Wdata_standardised$SLA))

W_LME_SLA_AU <- Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((SLA)~Treatment + (1|Population),
       data=., na.action=na.omit)
summary(W_LME_SLA_AU)
Anova(W_LME_SLA_AU, type=3)

shapiro.test(residuals(W_LME_SLA_AU))

##test for normaility


qqnorm(resid(W_LME_SLA_AU))
qqline(resid(W_LME_SLA_AU))

skewness(resid(W_LME_SLA_AU))
kurtosis(resid(W_LME_SLA_AU))



#####################
### stretch height ##
#####################

hist((Wdata_standardised$Stretch_height))
hist((Wdata_standardised$Stretch_height))


W_LME_stretch_height_AU <- Wdata_standardised %>%
  filter(Maternal_line != "N22-B") %>%
  filter(Range == "AU") %>%
  lmer((Stretch_height)~Treatment + (1|Population),
       data=., na.action=na.omit)
summary(W_LME_stretch_height_AU)
Anova(W_LME_stretch_height_AU, type=3)

##test for normaility
qqnorm(resid(W_LME_stretch_height_AU))
qqline(resid(W_LME_stretch_height_AU))

skewness(resid(W_LME_stretch_height_AU))
kurtosis(resid(W_LME_stretch_height_AU))

shapiro.test(resid(W_LME_stretch_height_AU))


##############
### Fv/Fm ###
#############

Wdata_standardised %>%
  filter(Maternal_line != "L7-D") %>%
  filter(Range == "AU") %>%
  with(hist(`Fv_Fm`, breaks = 10))
## looks like outlier from maternal_line L7-D

W_LME_Fv_Fm_AU <- Wdata_standardised %>%
  #   mutate(logit_Fv_Fm = log("Fv_Fm"/(1-"Fv_Fm"))) 
  # filter(Maternal_line != "L7-D") %>%
  filter(Range == "AU") %>%
  lmer((Fv_Fm)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_Fv_Fm_AU)
Anova(W_LME_Fv_Fm_AU, type=3)


##test for normaility

qqnorm(resid(W_LME_Fv_Fm_AU))
qqline(resid(W_LME_Fv_Fm_AU))

skewness(resid(W_LME_Fv_Fm_AU))
kurtosis(resid(W_LME_Fv_Fm_AU))


################
### Leaf % N ###
################

hist(Wdata_standardised$Leaf_percent_N)

W_LME_LW_AU <- Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Leaf_percent_N)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_LW_AU)
Anova(W_LME_LW_AU, type=3)

#### test for normality

qqnorm(resid(W_LME_LW_AU))
qqline(resid(W_LME_LW_AU))

skewness(resid(W_LME_LW_AU))
kurtosis(resid(W_LME_LW_AU))

shapiro.test(residuals(W_LME_LW_AU))

########### 
### RMF ###
##########

# lme

W_LME_RMF_AU <-  Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((RMF)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_RMF_AU)
Anova(W_LME_RMF_AU, type=3)



# test for normality
qqnorm(resid(W_LME_RMF_AU))
qqline(resid(W_LME_RMF_AU))

skewness(resid(W_LME_RMF_AU))
kurtosis(resid(W_LME_RMF_AU))


###########
### LMF ###
########### 

W_LME_LMF_AU <-  Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((LMF)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_LMF_AU)
Anova(W_LME_LMF_AU, type=3)

# test for normality
qqnorm(resid(W_LME_LMF_AU))
qqline(resid(W_LME_LMF_AU))

skewness(resid(W_LME_LMF_AU))
kurtosis(resid(W_LME_LMF_AU))



###########
### SSD ###
###########

hist((Wdata_standardised$SSD))


W_LME_SSD_AU <-  Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((SSD)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_SSD_AU)
Anova(W_LME_SSD_AU, type=3)

# test for normality
qqnorm(resid(W_LME_SSD_AU))
qqline(resid(W_LME_SSD_AU))

skewness(resid(W_LME_SSD_AU))
kurtosis(resid(W_LME_SSD_AU))

shapiro.test(resid(W_LME_SSD_AU))

########################
### internode length ###
########################


W_LME_Internode_length_AU <-  Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Internode_length)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_Internode_length_AU)
Anova(W_LME_Internode_length_AU, type=3)

# test for normality
qqnorm(resid(W_LME_Internode_length_AU))
qqline(resid(W_LME_Internode_length_AU))

skewness(resid(W_LME_Internode_length_AU))
kurtosis(resid(W_LME_Internode_length_AU))

shapiro.test(resid(W_LME_Internode_length_AU))
###############
### Biomass ###
###############


W_LME_Total_Biomass_AU <-  Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Total_Biomass)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_Total_Biomass_AU)
Anova(W_LME_Total_Biomass_AU, type=3)

# test for normality
qqnorm(resid(W_LME_Total_Biomass_AU))
qqline(resid(W_LME_Total_Biomass_AU))

skewness(resid(W_LME_Total_Biomass_AU))
kurtosis(resid(W_LME_Total_Biomass_AU))

# lm has same fit:

W_LM_Biomass_AU <- Wdata_standardised %>%
  filter(Range == "AU") %>%
  lm((Total_Biomass)~(Treatment), 
     data=., na.action=na.omit)
summary(W_LM_Biomass_AU)
Anova(W_LM_Biomass_AU, type=3)



######################
### leaf senescence ##
######################
W_LME_percent_dead_leaves_AU <-  Wdata_standardised %>%
  filter(Maternal_line != "L9-2") %>%
  filter(Range == "AU") %>%
  lmer(percent_dead_leaves~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_percent_dead_leaves_AU)
Anova(W_LME_percent_dead_leaves_AU, type=3)

# test for normality
qqnorm(resid(W_LME_percent_dead_leaves_AU))
qqline(resid(W_LME_percent_dead_leaves_AU))

skewness(resid(W_LME_percent_dead_leaves_AU))
kurtosis(resid(W_LME_percent_dead_leaves_AU))

############
### D13c ###
############

W_LME_D13c_AU <- Wdata_standardised %>%
  filter(Range == "AU") %>%
  lmer((D13c) ~ Treatment + (1|Population),
       data = ., na.action=na.omit)

summary(W_LME_D13c_AU)
Anova(W_LME_D13c_AU, type=3)

# model residuals

qqnorm(resid(W_LME_D13c_AU))
qqline(resid(W_LME_D13c_AU))

skewness(resid(W_LME_D13c_AU))
kurtosis(resid(W_LME_D13c_AU))

shapiro.test(resid(W_LME_D13c_AU))

########################
### South Africa
#########################


############
### Area ##
############

W_LM_Area_SA <- Wdata_standardised %>%
  lm((Area)~Treatment ,  data=., 
     subset=Range=="SA", na.action=na.omit)
summary(W_LM_Area_SA)

# model normality
qqnorm(resid(W_LM_Area_SA))
qqline(resid(W_LM_Area_SA))

skewness(resid(W_LM_Area_SA))
kurtosis(resid(W_LM_Area_SA))

shapiro.test(resid(W_LM_Area_SA))

############
### Shape ##
############

W_LM_Shape_SA <- Wdata_standardised %>%
  lm((Shape)~Treatment ,  data=., 
     subset=Range=="SA", na.action=na.omit)
summary(W_LM_Shape_SA)

# model normality
qqnorm(resid(W_LM_Shape_SA))
qqline(resid(W_LM_Shape_SA))

skewness(resid(W_LM_Shape_SA))
kurtosis(resid(W_LM_Shape_SA))


##########
### SLA ###
##########

Wdata_standardised %>%
  filter(Range == "SA") %>%
  with(hist((`SLA`), breaks = 10))

W_LM_SLA_SA <- Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((SLA)~Treatment ,
     data=., na.action=na.omit)
summary(W_LM_SLA_SA)
Anova(W_LM_SLA_SA, type=3)

shapiro.test(residuals(W_LM_SLA_SA))

##test for normaility

qqnorm(resid(W_LM_SLA_SA))
qqline(resid(W_LM_SLA_SA))

skewness(resid(W_LM_SLA_SA))
kurtosis(resid(W_LM_SLA_SA))

#### High kurtosis - apply bootstrap


## bootstrap
# Define the bootstrapping function
boot_func <- function(data, indices) {
  # Fit the linear model to the bootstrapped sample
  model_boot <- lm((SLA)~Treatment, data = data[indices, ])
  
  # Return the coefficient estimates
  return(coef(model_boot))
}

# Apply bootstrapping using boot
Wdata_standardised_SA <- Wdata_standardised %>%
  filter(Range == "SA")

boot_results <- boot(data = Wdata_standardised_SA, statistic = boot_func, R = 1000)

# Extract bootstrapped coefficient estimates
boot_coefficients <- boot_results$t

boot_SE<- summary(boot_results)$bootSE  
boot_B <- summary(boot_results)$original


W_SLA_boot_results_table_SA <- data.frame(boot_B,boot_SE )

# Calculate the kurtosis of the original residuals
kurtosis_original <- kurtosis(resid(W_LM_SLA_SA))

residuals_bootstrap <- boot_results$t

# Calculate the kurtosis of the bootstrap residuals
kurtosis_bootstrap <- apply(residuals_bootstrap, 2, kurtosis)

# Summary statistics
summary(kurtosis_bootstrap)

#####################
### stretch height ##
#####################


Wdata_standardised %>%
  filter(Range == "SA") %>%
  with(hist((`Stretch_height`), breaks = 10))


W_LM_stretch_height_SA <- Wdata_standardised %>%
  #  filter(Maternal_line != "N22-B") %>%
  filter(Range == "SA") %>%
  lm((Stretch_height)~Treatment ,
     data=., na.action=na.omit)
summary(W_LM_stretch_height_SA)
Anova(W_LM_stretch_height_SA, type=3)

#
qqnorm(resid(W_LM_stretch_height_SA))
qqline(resid(W_LM_stretch_height_SA))

skewness(resid(W_LM_stretch_height_SA))
kurtosis(resid(W_LM_stretch_height_SA))
##test for normaility


##############
### Fv/Fm ###
#############
Wdata_standardised %>%
  filter(Maternal_line != "L7-D") %>%
  filter(Range == "SA") %>%
  with(hist((`Fv_Fm`), breaks = 10))
## looks like outlier from maternal_line L7-D

W_LM_Fv_Fm_SA <- Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((Fv_Fm)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_Fv_Fm_SA)
Anova(W_LM_Fv_Fm_SA, type=3)



##test for normaility

qqnorm(resid(W_LM_Fv_Fm_SA))
qqline(resid(W_LM_Fv_Fm_SA))

skewness(resid(W_LM_Fv_Fm_SA))
kurtosis(resid(W_LM_Fv_Fm_SA))

shapiro.test(resid(W_LM_Fv_Fm_SA))


## Apply bootstrap

# Define the bootstrapping function
boot_func <- function(data, indices) {
  # Fit the linear model to the bootstrapped sample
  model_boot <- lm((SSD)~Treatment, data = data[indices, ])
  
  # Return the coefficient estimates
  return(coef(model_boot))
}

# Apply bootstrapping using boot
Wdata_standardised_SA <- Wdata_standardised %>%
  filter(Range == "SA")

boot_results <- boot(data = Wdata_standardised_SA, statistic = boot_func, R = 1000)

# Extract bootstrapped coefficient estimates
boot_coefficients <- boot_results$t

boot_SE<- summary(boot_results)$bootSE  
boot_B <- summary(boot_results)$original


W_SSD_boot_results_table_SA <- data.frame(boot_B,boot_SE )

# Calculate the kurtosis of the original residuals
kurtosis_original <- kurtosis(resid(W_LM_SLA_SA))

residuals_bootstrap <- boot_results$t

# Calculate the kurtosis of the bootstrap residuals
kurtosis_bootstrap <- apply(residuals_bootstrap, 2, kurtosis)

# Summary statistics
summary(kurtosis_bootstrap)

################
### Leaf % N ###
################

W_LM_LW_SA <- Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((Leaf_percent_N)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_LW_SA)
Anova(W_LM_LW_SA, type=3)

#### test for normality

qqnorm(resid(W_LM_LW_SA))
qqline(resid(W_LM_LW_SA))

skewness(resid(W_LM_LW_SA))
kurtosis(resid(W_LM_LW_SA))

shapiro.test(residuals(W_LM_LW_SA))

########### 
### RMF ###
##########

W_LM_RMF_SA <-  Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((RMF)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_RMF_SA)
Anova(W_LM_RMF_SA, type=3)



# test for normality
qqnorm(resid(W_LM_RMF_SA))
qqline(resid(W_LM_RMF_SA))

skewness(resid(W_LM_RMF_SA))
kurtosis(resid(W_LM_RMF_SA))


###########
### LMF ###
########### 

W_LM_LMF_SA <-  Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((LMF)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_LMF_SA)
Anova(W_LM_LMF_SA, type=3)

# test for normality
qqnorm(resid(W_LM_LMF_SA))
qqline(resid(W_LM_LMF_SA))

skewness(resid(W_LM_LMF_SA))
kurtosis(resid(W_LM_LMF_SA))



###########
### SSD ###
###########


W_LM_SSD_SA <-  Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((SSD)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_SSD_SA)
Anova(W_LM_SSD_SA, type=3)

# test for normality
qqnorm(resid(W_LM_SSD_SA))
qqline(resid(W_LM_SSD_SA))

skewness(resid(W_LM_SSD_SA))
kurtosis(resid(W_LM_SSD_SA))

shapiro.test(resid(W_LM_SSD_SA))



########################
### internode length ###
########################


W_LM_Internode_length_SA <-  Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((Internode_length)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_Internode_length_SA)
Anova(W_LM_Internode_length_SA, type=3)

# test for normality
qqnorm(resid(W_LM_Internode_length_SA))
qqline(resid(W_LM_Internode_length_SA))

skewness(resid(W_LM_Internode_length_SA))
kurtosis(resid(W_LM_Internode_length_SA))

###############
### Biomass ###
###############


W_LM_Total_Biomass_SA <-  Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((Total_Biomass)~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_Total_Biomass_SA)
Anova(W_LM_Total_Biomass_SA, type=3)

# test for normality
qqnorm(resid(W_LM_Total_Biomass_SA))
qqline(resid(W_LM_Total_Biomass_SA))

skewness(resid(W_LM_Total_Biomass_SA))
kurtosis(resid(W_LM_Total_Biomass_SA))

shapiro.test(resid(W_LM_Total_Biomass_SA))



######################
### leaf senescence ##
######################
W_LM_percent_dead_leaves_SA <-  Wdata_standardised %>%
  filter(Maternal_line != "L9-2") %>%
  filter(Range == "SA") %>%
  lm(percent_dead_leaves~(Treatment) , 
     data=., na.action=na.omit)
summary(W_LM_percent_dead_leaves_SA)
Anova(W_LM_percent_dead_leaves_SA, type=3)

# test for normality
qqnorm(resid(W_LM_percent_dead_leaves_SA))
qqline(resid(W_LM_percent_dead_leaves_SA))

skewness(resid(W_LM_percent_dead_leaves_SA))
kurtosis(resid(W_LM_percent_dead_leaves_SA))

shapiro.test(resid(W_LM_percent_dead_leaves_SA))

############
### D13c ###
############

W_LM_D13c_SA <- Wdata_standardised %>%
  filter(Range == "SA") %>%
  lm((D13c) ~ Treatment ,
     data = ., na.action=na.omit)

summary(W_LM_D13c_SA)
Anova(W_LM_D13c_SA, type=3)

# model residuals

qqnorm(resid(W_LM_D13c_SA))
qqline(resid(W_LM_D13c_SA))

skewness(resid(W_LM_D13c_SA))
kurtosis(resid(W_LM_D13c_SA))

shapiro.test(resid(W_LM_D13c_SA))


