# 4.1 Reaction norms for nutrients

source('3_Standardise_data_for_meta_analysis.R')

##############################
### Nutrients
##############################

#################
### Australia ###
#################

############
### Area ##
############

N_LME_Area_AU <- Ndata_standardised %>%
  lmer((Area)~Treatment + (1|Population),  data=., 
       subset=Range=="AU", na.action=na.omit)
summary(N_LME_Area_AU)

# model normality
qqnorm(resid(N_LME_Area_AU))
qqline(resid(N_LME_Area_AU))

skewness(resid(N_LME_Area_AU))
kurtosis(resid(N_LME_Area_AU))

shapiro.test(resid(N_LME_Area_AU))


############
### Shape ##
############

N_LME_Shape_AU <- Ndata_standardised %>%
  lmer((Shape)~Treatment + (1|Population),  data=., 
       subset=Range=="AU", na.action=na.omit)
summary(N_LME_Shape_AU)

# model normality
qqnorm(resid(N_LME_Shape_AU))
qqline(resid(N_LME_Shape_AU))

skewness(resid(N_LME_Shape_AU))
kurtosis(resid(N_LME_Shape_AU))

shapiro.test(resid(N_LME_Shape_AU))


##########
### SLA ###
##########

hist((Ndata_standardised$SLA))

N_LME_SLA_AU <- Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((SLA)~Treatment + (1|Population),
       data=., na.action=na.omit)
summary(N_LME_SLA_AU)
Anova(N_LME_SLA_AU, type=3)

shapiro.test(residuals(N_LME_SLA_AU))

##test for normaility


qqnorm(resid(N_LME_SLA_AU))
qqline(resid(N_LME_SLA_AU))

skewness(resid(N_LME_SLA_AU))
kurtosis(resid(N_LME_SLA_AU))



#####################
### stretch height ##
#####################

hist((Ndata_standardised$Stretch_height))
hist((Ndata_standardised$Stretch_height))


N_LME_stretch_height_AU <- Ndata_standardised %>%
  filter(Maternal_line != "N22-B") %>%
  filter(Range == "AU") %>%
  lmer((Stretch_height)~Treatment + (1|Population),
       data=., na.action=na.omit)
summary(N_LME_stretch_height_AU)
Anova(N_LME_stretch_height_AU, type=3)

#
qqnorm(resid(N_LME_stretch_height_AU))
qqline(resid(N_LME_stretch_height_AU))

skewness(resid(N_LME_stretch_height_AU))
kurtosis(resid(N_LME_stretch_height_AU))
##test for normaility


##############
### Fv/Fm ###
#############

Ndata_standardised %>%
  filter(Maternal_line != "L7-D") %>%
  filter(Range == "AU") %>%
  with(hist(exp(`Fv_Fm`), breaks = 10))
## looks like outlier from maternal_line L7-D

N_LME_Fv_Fm_AU <- Ndata_standardised %>%
  #   mutate(logit_Fv_Fm = log("Fv_Fm"/(1-"Fv_Fm"))) 
  filter(Maternal_line != "L7-D") %>%
  filter(Range == "AU") %>%
  lmer((Fv_Fm)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_Fv_Fm_AU)
Anova(N_LME_Fv_Fm_AU, type=3)


##test for normaility

qqnorm(resid(N_LME_Fv_Fm_AU))
qqline(resid(N_LME_Fv_Fm_AU))

skewness(resid(N_LME_Fv_Fm_AU))
kurtosis(resid(N_LME_Fv_Fm_AU))

## bootstrap

boot_results <- bootMer(N_LME_Fv_Fm_AU, fixef, nsim = 1000,
                        seed = 123)

# summarize bootstrap results

boot_SE<- summary(boot_results)$bootSE  
boot_B <- summary(boot_results)$original


N_FV_FM_boot_results_table_AU <- data.frame(boot_B,boot_SE)

# Calculate the kurtosis of the original residuals
kurtosis_original <- kurtosis(resid(N_LME_Fv_Fm_AU))

residuals_bootstrap <- boot_results$t

# Calculate the kurtosis of the bootstrap residuals
kurtosis_bootstrap <- apply(residuals_bootstrap, 2, kurtosis)

# Summary statistics
summary(kurtosis_bootstrap)


################
### Leaf % N ###
################



N_LME_LN_AU <- Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Leaf_percent_N)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_LN_AU)
Anova(N_LME_LN_AU, type=3)

#### test for normality

qqnorm(resid(N_LME_LN_AU))
qqline(resid(N_LME_LN_AU))

skewness(resid(N_LME_LN_AU))
kurtosis(resid(N_LME_LN_AU))

shapiro.test(residuals(N_LME_LN_AU))

########### 
### RMF ###
##########


# lme

N_LME_RMF_AU <-  Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((RMF)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_RMF_AU)
Anova(N_LME_RMF_AU, type=3)



# test for normality
qqnorm(resid(N_LME_RMF_AU))
qqline(resid(N_LME_RMF_AU))

skewness(resid(N_LME_RMF_AU))
kurtosis(resid(N_LME_RMF_AU))


###########
### LMF ###
########### 

N_LME_LMF_AU <-  Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((LMF)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_LMF_AU)
Anova(N_LME_LMF_AU, type=3)

# test for normality
qqnorm(resid(N_LME_LMF_AU))
qqline(resid(N_LME_LMF_AU))

skewness(resid(N_LME_LMF_AU))
kurtosis(resid(N_LME_LMF_AU))



###########
### SSD ###
###########

hist((Ndata_standardised$SSD))


N_LME_SSD_AU <-  Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((SSD)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_SSD_AU)
Anova(N_LME_SSD_AU, type=3)

# test for normality
qqnorm(resid(N_LME_SSD_AU))
qqline(resid(N_LME_SSD_AU))

skewness(resid(N_LME_SSD_AU))
kurtosis(resid(N_LME_SSD_AU))


########################
### internode length ###
########################


N_LME_Internode_length_AU <-  Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Internode_length)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_Internode_length_AU)
Anova(N_LME_Internode_length_AU, type=3)

# test for normality
qqnorm(resid(N_LME_Internode_length_AU))
qqline(resid(N_LME_Internode_length_AU))

skewness(resid(N_LME_Internode_length_AU))
kurtosis(resid(N_LME_Internode_length_AU))

###############
### Biomass ###
###############


N_LME_Total_Biomass_AU <-  Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((Total_Biomass)~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_Total_Biomass_AU)
Anova(N_LME_Total_Biomass_AU, type=3)

# test for normality
qqnorm(resid(N_LME_Total_Biomass_AU))
qqline(resid(N_LME_Total_Biomass_AU))

skewness(resid(N_LME_Total_Biomass_AU))
kurtosis(resid(N_LME_Total_Biomass_AU))

# lm has same fit:

N_LM_Biomass_AU <- Ndata_standardised %>%
  filter(Range == "AU") %>%
  lm((Total_Biomass)~(Treatment), 
     data=., na.action=na.omit)
summary(N_LM_Biomass_AU)
Anova(N_LM_Biomass_AU, type=3)



######################
### leaf senescence ##
######################
N_LME_percent_dead_leaves_AU <-  Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer(percent_dead_leaves~(Treatment) + (1|Population), 
       data=., na.action=na.omit)
summary(N_LME_percent_dead_leaves_AU)
Anova(N_LME_percent_dead_leaves_AU, type=3)

# test for normality
qqnorm(resid(N_LME_percent_dead_leaves_AU))
qqline(resid(N_LME_percent_dead_leaves_AU))

skewness(resid(N_LME_percent_dead_leaves_AU))
kurtosis(resid(N_LME_percent_dead_leaves_AU))

##

###############
### D13C ###
###############


N_LME_D13c_AU <- Ndata_standardised %>%
  filter(Range == "AU") %>%
  lmer((D13c) ~ Treatment + (1|Population),
       data = ., na.action=na.omit)

summary(N_LME_D13c_AU)
Anova(N_LME_D13c_AU, type=3)

# model residuals

qqnorm(resid(N_LME_D13c_AU))
qqline(resid(N_LME_D13c_AU))

skewness(resid(N_LME_D13c_AU))
kurtosis(resid(N_LME_D13c_AU))

####################
### South Africa ###
####################


############
### Area ##
############

N_LM_Area_SA <- Ndata_standardised %>%
  lm((Area)~Treatment ,  data=., 
     subset=Range=="SA", na.action=na.omit)
summary(N_LM_Area_SA)

# model normality
qqnorm(resid(N_LM_Area_SA))
qqline(resid(N_LM_Area_SA))

skewness(resid(N_LM_Area_SA))
kurtosis(resid(N_LM_Area_SA))


############
### Shape ##
############

N_LM_Shape_SA <- Ndata_standardised %>%
  lm((Shape)~Treatment ,  data=., 
     subset=Range=="SA", na.action=na.omit)
summary(N_LM_Shape_SA)

# model normality
qqnorm(resid(N_LM_Shape_SA))
qqline(resid(N_LM_Shape_SA))

skewness(resid(N_LM_Shape_SA))
kurtosis(resid(N_LM_Shape_SA))

shapiro.test(resid(N_LM_Shape_SA))

##########
### SLA ###
##########


N_LM_SLA_SA <- Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((SLA)~Treatment ,
     data=., na.action=na.omit)
summary(N_LM_SLA_SA)
Anova(N_LM_SLA_SA, type=3)

shapiro.test(residuals(N_LM_SLA_SA))

##test for normaility


qqnorm(resid(N_LM_SLA_SA))
qqline(resid(N_LM_SLA_SA))

skewness(resid(N_LM_SLA_SA))
kurtosis(resid(N_LM_SLA_SA))

shapiro.test(resid(N_LM_SLA_SA))

#####################
### stretch height ##
#####################

hist((Ndata_standardised$Stretch_height))
hist((Ndata_standardised$Stretch_height))


N_LM_stretch_height_SA <- Ndata_standardised %>%
  #Height value for N22-B to low
  filter(Maternal_line != "N22-B") %>%
  filter(Range == "SA") %>%
  lm((Stretch_height)~Treatment ,
     data=., na.action=na.omit)
summary(N_LM_stretch_height_SA)
Anova(N_LM_stretch_height_SA, type=3)

#
qqnorm(resid(N_LM_stretch_height_SA))
qqline(resid(N_LM_stretch_height_SA))

skewness(resid(N_LM_stretch_height_SA))
kurtosis(resid(N_LM_stretch_height_SA))
##test for normaility


##############
### Fv/Fm ###
#############

Ndata_standardised %>%
  filter(Maternal_line != "L7-D") %>%
  filter(Range == "SA") %>%
  with(hist((`Fv_Fm`), breaks = 10))
## looks like outlier from maternal_line L7-D

N_LM_Fv_Fm_SA <- Ndata_standardised %>%
  #   mutate(logit_Fv_Fm = log("Fv_Fm"/(1-"Fv_Fm"))) 
  filter(Maternal_line != "L7-D") %>%
  filter(Range == "SA") %>%
  lm((Fv_Fm)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_Fv_Fm_SA)
Anova(N_LM_Fv_Fm_SA, type=3)


##test for normaility

qqnorm(resid(N_LM_Fv_Fm_SA))
qqline(resid(N_LM_Fv_Fm_SA))

skewness(resid(N_LM_Fv_Fm_SA))
kurtosis(resid(N_LM_Fv_Fm_SA))

################
### Leaf % N ###
################

hist(Ndata_standardised$Leaf_percent_N)

N_LM_LN_SA <- Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((Leaf_percent_N)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_LN_SA)
Anova(N_LM_LN_SA, type=3)

#### test for normality

qqnorm(resid(N_LM_LN_SA))
qqline(resid(N_LM_LN_SA))

skewness(resid(N_LM_LN_SA))
kurtosis(resid(N_LM_LN_SA))

shapiro.test(residuals(N_LM_LN_SA))

########### 
### RMF ###
##########

# lme

N_LM_RMF_SA <-  Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((RMF)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_RMF_SA)
Anova(N_LM_RMF_SA, type=3)



# test for normality
qqnorm(resid(N_LM_RMF_SA))
qqline(resid(N_LM_RMF_SA))

skewness(resid(N_LM_RMF_SA))
kurtosis(resid(N_LM_RMF_SA))

shapiro.test(residuals(N_LM_RMF_SA))

###########
### LMF ###
########### 

N_LM_LMF_SA <-  Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((LMF)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_LMF_SA)
Anova(N_LM_LMF_SA, type=3)

# test for normality
qqnorm(resid(N_LM_LMF_SA))
qqline(resid(N_LM_LMF_SA))

skewness(resid(N_LM_LMF_SA))
kurtosis(resid(N_LM_LMF_SA))

shapiro.test(resid(N_LM_LMF_SA))

###########
### SSD ###
###########

hist((Ndata_standardised$SSD))


N_LM_SSD_SA <-  Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((SSD)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_SSD_SA)
Anova(N_LM_SSD_SA, type=3)

# test for normality
qqnorm(resid(N_LM_SSD_SA))
qqline(resid(N_LM_SSD_SA))

skewness(resid(N_LM_SSD_SA))
kurtosis(resid(N_LM_SSD_SA))

shapiro.test(resid(N_LM_SSD_SA))
########################
### internode length ###
########################


N_LM_Internode_length_SA <-  Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((Internode_length)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_Internode_length_SA)
Anova(N_LM_Internode_length_SA, type=3)

# test for normality
qqnorm(resid(N_LM_Internode_length_SA))
qqline(resid(N_LM_Internode_length_SA))

skewness(resid(N_LM_Internode_length_SA))
kurtosis(resid(N_LM_Internode_length_SA))

###############
### Biomass ###
###############


N_LM_Total_Biomass_SA <-  Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((Total_Biomass)~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_Total_Biomass_SA)
Anova(N_LM_Total_Biomass_SA, type=3)

# test for normality
qqnorm(resid(N_LM_Total_Biomass_SA))
qqline(resid(N_LM_Total_Biomass_SA))

skewness(resid(N_LM_Total_Biomass_SA))
kurtosis(resid(N_LM_Total_Biomass_SA))

###############
### D13C ###
###############


N_LM_D13c_SA <- Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm((D13c) ~ Treatment ,
     data = ., na.action=na.omit)

summary(N_LM_D13c_SA)
Anova(N_LM_D13c_SA, type=3)

# model residuals

qqnorm(resid(N_LM_D13c_SA))
qqline(resid(N_LM_D13c_SA))

skewness(resid(N_LM_D13c_SA))
kurtosis(resid(N_LM_D13c_SA))


######################
### leaf senescence ##
######################
N_LM_percent_dead_leaves_SA <-  Ndata_standardised %>%
  filter(Range == "SA") %>%
  lm(percent_dead_leaves~(Treatment) , 
     data=., na.action=na.omit)
summary(N_LM_percent_dead_leaves_SA)
Anova(N_LM_percent_dead_leaves_SA, type=3)

# test for normality
qqnorm(resid(N_LM_percent_dead_leaves_SA))
qqline(resid(N_LM_percent_dead_leaves_SA))

skewness(resid(N_LM_percent_dead_leaves_SA))
kurtosis(resid(N_LM_percent_dead_leaves_SA))

##