
# 2.2 Calculate linear mixed effects models for water treatment 


# 1. source 1_Setup Script

source('1_Setup.R')

# 2. LME of Treatment x Range interaction for each trait

##################
### Leaf area ####
##################

hist(log10(Wdata$Area))

W_LME_Area<-lmer(log10(Area)~(Treatment+Range)^2 +(1|Population),
                 data=Wdata, na.action=na.omit)
summary(W_LME_Area)
Anova(W_LME_Area, type=3)

# model normality
qqnorm(resid(W_LME_Area))
qqline(resid(W_LME_Area))

skewness(resid(W_LME_Area))
kurtosis(resid(W_LME_Area))

#shapiro wilk test
shapiro.test(residuals(W_LME_Area))


##################
### Leaf shape ####
##################

hist(log10(Wdata$Shape))

W_LME_Shape<-lmer(log10((Shape))~(Treatment+Range)^2 +(1|Population),
                 data=Wdata, na.action=na.omit)
summary(W_LME_Shape)
Anova(W_LME_Shape, type=3)

# model normality
qqnorm(resid(W_LME_Shape))
qqline(resid(W_LME_Shape))

skewness(resid(W_LME_Shape))
kurtosis(resid(W_LME_Shape))

#shapiro wilk test
shapiro.test(residuals(W_LME_Shape))

##########
### SLA ##
##########

hist((Wdata$SLA))

W_LME_SLA <- lmer(log10
  (SLA)~(Range+Treatment)^2 + (1|Population),
  data=Wdata, na.action=na.omit)
summary(W_LME_SLA)
Anova(W_LME_SLA, type=3)

##test for normaility


qqnorm(resid(W_LME_SLA))
qqline(resid(W_LME_SLA))

skewness(resid(W_LME_SLA))
kurtosis(resid(W_LME_SLA))



#####################
### stretch height ##
#####################

hist((Wdata$Stretch_height))
hist(log10(Wdata$Stretch_height))


W_LME_stretch_height <- lmer(log10(Stretch_height)~(Range+Treatment)^2
                             + (1|Population),
                             data=Wdata, na.action=na.omit)
summary(W_LME_stretch_height)
Anova(W_LME_stretch_height, type=3)

##test for normaility

qqnorm(resid(W_LME_stretch_height))
qqline(resid(W_LME_stretch_height))

skewness(resid(W_LME_stretch_height))
kurtosis(resid(W_LME_stretch_height))

###########
### SSD ###
###########

hist(log10(Wdata$SSD))

W_lme_SSD <- Wdata %>%
  lmer(log10
       (SSD)~(Range+Treatment)^2 +(1|Population),
    data=., na.action=na.omit)
summary(W_lme_SSD)
Anova(W_lme_SSD, type=3)

#test for normaility


qqnorm(resid(W_lme_SSD))
qqline(resid(W_lme_SSD))

skewness(resid(W_lme_SSD))
kurtosis(resid(W_lme_SSD))

##############
### Fv/Fm ###
#############

hist(Wdata$Fv_Fm)

## looks like outlier from maternal_line L7-D

W_LME_Fv_Fm <- Wdata %>%
  lmer(Fv_Fm~(Range+Treatment)^2 + (1|Population), 
       data=., na.action=na.omit)
summary(W_LME_Fv_Fm)
Anova(W_LME_Fv_Fm, type=3)


##test for normaility

qqnorm(resid(W_LME_Fv_Fm))
qqline(resid(W_LME_Fv_Fm))

skewness(resid(W_LME_Fv_Fm))
kurtosis(resid(W_LME_Fv_Fm))



################
### Leaf % N ###
################

hist(Wdata$Leaf_percent_N)

W_LME_LN <-lmer(Leaf_percent_N~(Range+Treatment)^2 + (1|Population),
                data=Wdata, na.action=na.omit)
summary(W_LME_LN)
Anova(W_LME_LN, type=3)

#### test for normality

qqnorm(resid(W_LME_LN))
qqline(resid(W_LME_LN))

skewness(resid(W_LME_LN))
kurtosis(resid(W_LME_LN))

shapiro.test(residuals(W_LME_LN))




########### 
### RMF ###
##########

hist(Wdata$RMF)

# lme

W_LME_RMF<-lmer( RMF ~(Range+Treatment)^2 + (1|Population),
                 data=Wdata, na.action=na.omit)
summary(W_LME_RMF)
Anova(W_LME_RMF, type=3)


# test for normality
qqnorm(resid(W_LME_RMF))
qqline(resid(W_LME_RMF))

skewness(resid(W_LME_RMF))
kurtosis(resid(W_LME_RMF))


###########
### LMF ###
########### 

W_LME_LMF<-lmer(RMF ~(Range+Treatment)^2 + (1|Population),
                data=Wdata, na.action=na.omit)
summary(W_LME_LMF)
Anova(W_LME_LMF, type=3)

qqnorm(resid(W_LME_LMF))
qqline(resid(W_LME_LMF))

skewness(resid(W_LME_LMF))
kurtosis(resid(W_LME_LMF))


########################
### internode length ###
########################

W_LME_Internode_length<-lmer(log10(Internode_length)~(Range+Treatment)^2 
                             + (1|Population),
                             data=Wdata, na.action=na.omit)

summary(W_LME_Internode_length)
Anova(W_LME_Internode_length, type=3)

# model residuals

qqnorm(resid(W_LME_Internode_length))
qqline(resid(W_LME_Internode_length))

skewness(resid(W_LME_Internode_length))
kurtosis(resid(W_LME_Internode_length))

shapiro.test(resid(W_LME_Internode_length))

###############
### Biomass ###
###############

W_LME_Biomass <- lmer(log10(Total_Biomass) ~ (Range+Treatment)^2
                      + (1|Population),
                      data = Wdata, na.action=na.omit)

summary(W_LME_Biomass)
Anova(W_LME_Biomass, type=3)

# model residuals

qqnorm(resid(W_LME_Biomass))
qqline(resid(W_LME_Biomass))

skewness(resid(W_LME_Biomass))
kurtosis(resid(W_LME_Biomass))

######################
### leaf senescence ##
######################

W_LME_leaf_senesc <-  Wdata %>%
  filter(Maternal_line != "L9-2") %>%
  lmer(percent_dead_leaves~(Range+Treatment)^2 + (1|Population),
                          data=., na.action=na.omit)
summary(W_LME_leaf_senesc)
Anova(W_LME_leaf_senesc, type=3)

qqnorm(resid(W_LME_leaf_senesc))
qqline(resid(W_LME_leaf_senesc))

skewness(resid(W_LME_leaf_senesc))
kurtosis(resid(W_LME_leaf_senesc))


###############
### D13C ###
###############


W_LME_D13c <- lmer((D13c) ~ (Range+Treatment)^2
                      + (1|Population),
                      data = Wdata, na.action=na.omit)

summary(W_LME_D13c)
Anova(W_LME_D13c, type=3)

# model residuals

qqnorm(resid(W_LME_D13c))
qqline(resid(W_LME_D13c))

skewness(resid(W_LME_D13c))
kurtosis(resid(W_LME_D13c))