
# 2.1 Calculate linear mixed effects models for nutrient treatment 


# 1. source 1_Setup Script

source('1_Setup.R')

# 2. LME of Treatment x Range interaction for each trait

############
### AREA ###
############

hist(log10(Ndata$Area))

N_LME_Area<-lmer(log10(Area)~(Treatment+Range)^2 + (1|Population), data=Ndata, na.action=na.omit)
summary(N_LME_Area)
Anova(N_LME_Area, type=3)

N_LM_Area<-lm(log10(Area)~(Treatment+Range)^2, data=Ndata, na.action=na.omit)
summary(N_LM_Area)
Anova(N_LM_Area, type=3)

# model normality
qqnorm(resid(N_LME_Area))
qqline(resid(N_LME_Area))

skewness(resid(N_LME_Area))
kurtosis(resid(N_LME_Area))


#############
### Shape ###
#############

hist(Ndata$Shape)
hist(log10(Ndata$Shape))
hist(sqrt(Ndata$Shape))


N_LME_Shape <- Ndata %>%
  lmer(log10(Shape)~(Range+Treatment)^2 + (1|Population),
                    data=., na.action=na.omit)
# mode summary
summary(N_LME_Shape)
Anova(N_LME_Shape, type=3)


# model normality
qqnorm(resid(N_LME_Shape))
qqline(resid(N_LME_Shape))

skewness(resid(N_LME_Shape))
kurtosis(resid(N_LME_Shape))

### model residuals not normal due to high kurtosis
## apply bootstrap


boot_results <- bootMer(N_LME_Shape, fixef, nsim = 1000,
                        seed = 123)

# summarize bootstrap results
df<- (data.frame(summary(N_LME_Shape)$coefficients)) %>%
  select(df) 

boot_SE<- summary(boot_results)$bootSE  
boot_B <- summary(boot_results)$original

# create table of statistics and calculae p-value

N_Shape_boot_results_table <- data.frame(boot_B,boot_SE,df ) %>%
  mutate(p = 2 * (1 - pt(abs(boot_B) / boot_SE, df)))

#########################################
## test residuals of boot model:

# Calculate the kurtosis of the original residuals
kurtosis_original <- kurtosis(resid(N_LME_Shape))

residuals_bootstrap <- boot_results$t

# Calculate the kurtosis of the bootstrap residuals
kurtosis_bootstrap <- apply(residuals_bootstrap, 2, kurtosis)

skewness_bootstrap <- apply(residuals_bootstrap, 2, skewness)


# Summary statistics
summary(kurtosis_bootstrap)

summary(skewness_bootstrap)

# Confidence interval
quantile(kurtosis_bootstrap, c(0.025, 0.975))

# Hypothesis test
mean_kurtosis_bootstrap <- mean(kurtosis_bootstrap)
p_value <- mean_kurtosis_bootstrap <= kurtosis_original


##########
### SLA ###
##########

hist(log10(Ndata$SLA))

N_LME_SLA <- lmer(log10(SLA)~(Range+Treatment)^2 + (1|Population),
  data=Ndata, na.action=na.omit)
summary(N_LME_SLA)
Anova(N_LME_SLA, type=3)

shapiro.test(residuals(N_LME_SLA))

##test for normaility


qqnorm(resid(N_LME_SLA))
qqline(resid(N_LME_SLA))

skewness(resid(N_LME_SLA))
kurtosis(resid(N_LME_SLA))



#####################
### stretch height ##
#####################

hist((Ndata$Stretch_height))
hist(log10(Ndata$Stretch_height))

## N22-B is an outlier that looks likely to be incorrect data entry for stretch height

N_LME_stretch_height <- Ndata %>%
  filter(Maternal_line != "N22-B") %>%
           lmer(log10(Stretch_height)~(Range+Treatment)^2
                             + (1|Population),
                             data=., na.action=na.omit)
summary(N_LME_stretch_height)
Anova(N_LME_stretch_height, type=3)

#

##test for normaility

qqnorm(resid(N_LME_stretch_height))
qqline(resid(N_LME_stretch_height))

skewness(resid(N_LME_stretch_height))
kurtosis(resid(N_LME_stretch_height))


### model is not normal due to high kurtosis
# apply bootstrap


boot_results <- bootMer(N_LME_stretch_height, fixef, nsim = 1000,
                        seed = 123)

# summarize bootstrap results
df<- (data.frame(summary(N_LME_stretch_height)$coefficients)) %>%
  select(df) 

boot_SE<- summary(boot_results)$bootSE  
boot_B <- summary(boot_results)$original


#P-value formula:
#2 * (1 - pt(abs(beta) / se, df))

# create table of statistics and calculae p-value

N_height_boot_results_table <- data.frame(boot_B,boot_SE,df ) %>%
  mutate(p = 2 * (1 - pt(abs(boot_B) / boot_SE, df)))

#########################################
## test residuals of boot model:

# Calculate the kurtosis of the original residuals
kurtosis_original <- kurtosis(resid(N_LME_stretch_height))

residuals_bootstrap <- boot_results$t

# Calculate the kurtosis of the bootstrap residuals
kurtosis_bootstrap <- apply(residuals_bootstrap, 2, kurtosis)

# Summary statistics
summary(kurtosis_bootstrap)

# Confidence interval
quantile(kurtosis_bootstrap, c(0.025, 0.975))

# Hypothesis test
mean_kurtosis_bootstrap <- mean(kurtosis_bootstrap)
p_value <- mean_kurtosis_bootstrap <= kurtosis_original


##############
### Fv/Fm ###
#############

hist(Ndata$Fv_Fm)

## looks like outlier from maternal_line L7-D

N_LME_Fv_Fm <- Ndata %>%
  #   mutate(logit_Fv_Fm = log("Fv_Fm"/(1-"Fv_Fm"))) 
  filter(Maternal_line != "L7-D") %>%
  lmer(Fv_Fm~(Range+Treatment)^2 + (1|Population), 
    data=., na.action=na.omit)
summary(N_LME_Fv_Fm)
Anova(N_LME_Fv_Fm, type=3)


##test for normaility

qqnorm(resid(N_LME_Fv_Fm))
qqline(resid(N_LME_Fv_Fm))

skewness(resid(N_LME_Fv_Fm))
kurtosis(resid(N_LME_Fv_Fm))



################
### Leaf % N ###
################

hist(Ndata$Leaf_percent_N)

N_LME_LN <-lmer(Leaf_percent_N~(Range+Treatment)^2 + (1|Population),
               data=Ndata, na.action=na.omit)
summary(N_LME_LN)
Anova(N_LME_LN, type=3)

#### test for normality

qqnorm(resid(N_LME_LN))
qqline(resid(N_LME_LN))

skewness(resid(N_LME_LN))
kurtosis(resid(N_LME_LN))

shapiro.test(residuals(N_LME_LN))




########### 
### RMF ###
##########

hist(Ndata$RMF)

# lme

N_LME_RMF<-lmer( RMF ~(Range+Treatment)^2 + (1|Population),
  data=Ndata, na.action=na.omit)
summary(N_LME_RMF)
Anova(N_LME_RMF, type=3)

# test for normality
qqnorm(resid(N_LME_RMF))
qqline(resid(N_LME_RMF))

skewness(resid(N_LME_RMF))
kurtosis(resid(N_LME_RMF))


###########
### LMF ###
########### 
N_LME_LMF<-lmer(RMF ~(Range+Treatment)^2 + (1|Population),
  data=Ndata, na.action=na.omit)
summary(N_LME_LMF)
Anova(N_LME_LMF, type=3)

qqnorm(resid(N_LME_LMF))
qqline(resid(N_LME_LMF))

skewness(resid(N_LME_LMF))
kurtosis(resid(N_LME_LMF))



###########
### SSD ###
###########

hist(log10(Ndata$SSD))

N_LME_SSD<-lmer(log10(SSD)~(Range+Treatment)^2 + (1|Population),
               data=Ndata, na.action=na.omit)
summary(N_LME_SSD)
Anova(N_LME_SSD, type=3)

qqnorm(resid(N_LME_SSD))
qqline(resid(N_LME_SSD))

skewness(resid(N_LME_SSD))
kurtosis(resid(N_LME_SSD))


########################
### internode length ###
########################

N_LME_Internode_length<-lmer(log10(Internode_length)~(Range+Treatment)^2 
                             + (1|Population),
                            data=Ndata, na.action=na.omit)

summary(N_LME_Internode_length)
Anova(N_LME_Internode_length, type=3)

# model residuals

qqnorm(resid(N_LME_Internode_length))
qqline(resid(N_LME_Internode_length))

skewness(resid(N_LME_Internode_length))
kurtosis(resid(N_LME_Internode_length))

###############
### Biomass ###
###############

N_LME_Biomass <- lmer(log10(Total_Biomass) ~ (Range+Treatment)^2
                      + (1|Population),
                     data = Ndata, na.action=na.omit)

summary(N_LME_Biomass)
Anova(N_LME_Biomass, type=3)

# lm
N_LM_Biomass <- lm(log10(Total_Biomass) ~ (Range+Treatment)^2,
                   data = Ndata, na.action=na.omit)

summary(N_LM_Biomass)
Anova(N_LM_Biomass, type=3)

# model residuals

qqnorm(resid(N_LME_Biomass))
qqline(resid(N_LME_Biomass))

skewness(resid(N_LME_Biomass))
kurtosis(resid(N_LME_Biomass))


######################
### leaf senescence ##
######################

N_LME_leaf_senesc <- lmer(percent_dead_leaves~(Range+Treatment)^2
                          + (1|Population),
                         data=Ndata, na.action=na.omit)
summary(N_LME_leaf_senesc)
Anova(N_LME_leaf_senesc, type=3)

qqnorm(resid(N_LME_leaf_senesc))
qqline(resid(N_LME_leaf_senesc))

skewness(resid(N_LME_leaf_senesc))
kurtosis(resid(N_LME_leaf_senesc))



###############
### D13C ###
###############


N_LME_D13c <- lmer((D13c) ~ (Range+Treatment)^2
                   + (1|Population),
                   data = Ndata, na.action=na.omit)

summary(N_LME_D13c)
Anova(N_LME_D13c, type=3)

# model residuals

qqnorm(resid(N_LME_D13c))
qqline(resid(N_LME_D13c))

skewness(resid(N_LME_D13c))
kurtosis(resid(N_LME_D13c))